/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DspRapidMark {
    private static String CLASSNAME = "DspRapidMark";
    public static final String VALUE_PROPERTY = "value";
    private String name;
    private String value;
    private List callbackList;
    private static final String sccs_id = "@(#)DspRapidMark.java    1.6    04/11/23     SMI";

    public synchronized String getName() {
        return this.name;
    }

    public synchronized void setValue(String newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, VALUE_PROPERTY, this.value, newValue);
        this.value = newValue;
        this.notifyValueListeners(event);
    }

    public synchronized String getValue() {
        return this.value;
    }

    public DspRapidMark(String name, String value) {
        this.name = name == null ? new String("noName") : name;
        this.value = value == null ? new String("") : value;
        this.callbackList = new ArrayList();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.addPropertyChangeListener(VALUE_PROPERTY, listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        int index;
        if (propertyName.equals(VALUE_PROPERTY) && (index = this.callbackList.indexOf(listener)) == -1) {
            this.callbackList.add(listener);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.removePropertyChangeListener(VALUE_PROPERTY, listener);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        int index;
        if (propertyName.equals(VALUE_PROPERTY) && (index = this.callbackList.indexOf(listener)) != -1) {
            this.callbackList.remove(index);
        }
    }

    public synchronized void removeAllPropertyChangeListeners() {
        this.removeAllPropertyChangeListeners(VALUE_PROPERTY);
    }

    public synchronized void removeAllPropertyChangeListeners(String propertyName) {
        if (propertyName.equals(VALUE_PROPERTY)) {
            this.callbackList = new ArrayList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyValueListeners(PropertyChangeEvent event) {
        String METHOD = "notifyValueListeners";
        Trace.info((Object)this, (String)"notifyValueListeners", (String)(" RapidMark " + this.name + " entered."));
        ArrayList cbList = null;
        List list = this.callbackList;
        synchronized (list) {
            cbList = new ArrayList(this.callbackList);
        }
        Trace.info((Object)this, (String)"notifyValueListeners", (String)(" RapidMark " + this.name + " has " + cbList.size() + " listeners"));
        Iterator it = cbList.iterator();
        int i = 0;
        while (it.hasNext()) {
            PropertyChangeListener listener = (PropertyChangeListener)it.next();
            PropertyChangeThread pclThread = new PropertyChangeThread(listener, event, i);
            Trace.info((Object)this, (String)"notifyValueListeners", (String)(" RapidMark " + this.name + " starting thread " + i));
            new Thread((Runnable)pclThread, "PropertyChangeListener " + i).start();
            ++i;
        }
        Trace.info((Object)this, (String)"notifyValueListeners", (String)(" RapidMark " + this.name + " done."));
    }

    public String toDebugString() {
        StringBuffer work = new StringBuffer("DspRapidMark <" + this.name + "> has a value of <" + this.value + "> and has <" + this.callbackList.size() + "> callbacks:\n");
        ArrayList cbList = new ArrayList(this.callbackList);
        Iterator it = cbList.iterator();
        while (it.hasNext()) {
            PropertyChangeListener listener = (PropertyChangeListener)it.next();
            work.append("\t" + listener.toString() + "\n");
        }
        return work.toString();
    }

    public synchronized PropertyChangeListener[] getListeners() {
        PropertyChangeListener[] pclArray = new PropertyChangeListener[]{null, null};
        return this.callbackList.toArray(pclArray);
    }

    public static void main(String[] argv) throws Exception {
        PropertyChangeListener propertyChangeListener1 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                DspRapidMark rm = (DspRapidMark)e.getSource();
                System.out.println("\n\tpropertyChangeListener1 got a PropertyChangeEvent from " + rm.getName());
                System.out.println("\t\tOld value:  " + e.getOldValue());
                System.out.println("\t\tNew value:  " + e.getNewValue());
            }

            public String toString() {
                return "propertyChangeListener1";
            }
        };
        PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                DspRapidMark rm = (DspRapidMark)e.getSource();
                System.out.println("\n\tpropertyChangeListener2 got a PropertyChangeEvent from " + rm.getName());
                System.out.println("\t\tOld value:  " + e.getOldValue());
                System.out.println("\t\tNew value:  " + e.getNewValue());
            }

            public String toString() {
                return "propertyChangeListener2";
            }
        };
        PropertyChangeListener propertyChangeListener3 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                DspRapidMark rm = (DspRapidMark)e.getSource();
                System.out.println("\n\tpropertyChangeListener3 got a PropertyChangeEvent from " + rm.getName());
                System.out.println("\t\tOld value:  " + e.getOldValue());
                System.out.println("\t\tNew value:  " + e.getNewValue());
            }

            public String toString() {
                return "propertyChangeListener3";
            }
        };
        DspRapidMark rm1 = new DspRapidMark("rm1", "");
        System.out.println("Created new DspRapidMark:\n" + rm1.toDebugString());
        DspRapidMark rm2 = new DspRapidMark("rm2", null);
        System.out.println("Created new DspRapidMark:\n" + rm2.toDebugString());
        DspRapidMark rm3 = new DspRapidMark(null, null);
        System.out.println("Created new DspRapidMark:\n" + rm3.toDebugString());
        rm1.addPropertyChangeListener(propertyChangeListener1);
        System.out.println("Added PCL1 to rm1:\n" + rm1.toDebugString());
        rm1.addPropertyChangeListener(VALUE_PROPERTY, propertyChangeListener2);
        System.out.println("Added PCL2 to rm1 for <value> property :\n" + rm1.toDebugString());
        rm1.addPropertyChangeListener("bullshit", propertyChangeListener3);
        System.out.println("Tried to add PCL3 to rm1 for <bullshit> property :\n" + rm1.toDebugString());
        rm1.addPropertyChangeListener(propertyChangeListener3);
        System.out.println("Added PCL3 to rm1:\n" + rm1.toDebugString());
        rm2.addPropertyChangeListener(propertyChangeListener1);
        System.out.println("Added PCL1 to rm2:\n" + rm2.toDebugString());
        rm2.addPropertyChangeListener(propertyChangeListener1);
        System.out.println("Added PCL1 to rm2 again:\n" + rm2.toDebugString());
        rm2.addPropertyChangeListener(propertyChangeListener3);
        System.out.println("Added PCL3 to rm2:\n" + rm2.toDebugString());
        System.out.println("Updating some values:\n");
        rm1.setValue("new value");
        rm2.setValue("another RM changed value");
        System.out.println("\nRemoving listeners:\n");
        rm1.removePropertyChangeListener("bullshit", propertyChangeListener3);
        System.out.println("Tried to remove PCL3 from rm1 for <bullshit> property :\n" + rm1.toDebugString());
        rm1.removePropertyChangeListener(VALUE_PROPERTY, propertyChangeListener2);
        System.out.println("Removed PCL2 from rm1 for <value> property :\n" + rm1.toDebugString());
        rm1.removePropertyChangeListener(propertyChangeListener1);
        System.out.println("Removed PCL1 from rm1:\n" + rm1.toDebugString());
        rm2.removeAllPropertyChangeListeners("bullshit");
        System.out.println("Tried to remove all listeners from rm2 for <bullshit> property :\n" + rm2.toDebugString());
        rm2.removeAllPropertyChangeListeners();
        System.out.println("Removed all listeners from rm2:\n" + rm2.toDebugString());
        System.out.println("Done!\n\n");
    }

    private class PropertyChangeThread
    implements Runnable {
        private static final String CLASSNAME = "DspRapidMark.PropertyChangeThread";
        private static final int SLEEP_INCREMENT = 1;
        private static final int MILLI_SECS = 1000;
        PropertyChangeListener listener;
        PropertyChangeEvent event;
        int listenerNumber = 0;

        PropertyChangeThread(PropertyChangeListener listener, PropertyChangeEvent event, int listenerNumber) {
            String METHOD = "Constructor";
            Trace.info((Object)this, (String)"Constructor", (String)(" Created thread " + listenerNumber));
            this.listener = listener;
            this.event = event;
            this.listenerNumber = listenerNumber;
        }

        public void run() {
            String METHOD = "run";
            Trace.info((Object)this, (String)"run", (String)(" RapidMark " + DspRapidMark.this.name + " listener " + this.listenerNumber + " Begin "));
            int sleepInterval = this.listenerNumber * 1 * 1000;
            try {
                Trace.info((Object)this, (String)"run", (String)(" RapidMark " + DspRapidMark.this.name + " listener " + this.listenerNumber + " Sleeping for " + sleepInterval / 1000 + " seconds before running"));
                Thread.sleep(sleepInterval);
            }
            catch (InterruptedException e) {
                Trace.info((Object)this, (String)"run", (String)(" RapidMark " + DspRapidMark.this.name + " listener " + this.listenerNumber + " Received InterruptedException - running"));
            }
            try {
                Trace.info((Object)this, (String)"run", (String)(" RapidMark " + DspRapidMark.this.name + " listener " + this.listenerNumber + " firing listener "));
                this.listener.propertyChange(this.event);
            }
            catch (Exception e) {
                Trace.info((Object)this, (String)(" RapidMark " + DspRapidMark.this.name + " listener " + this.listenerNumber + " took an exception:"), (Throwable)e);
            }
        }
    }
}

