/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.DspPropertyVolumeModified;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyBroker;
import com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPConcreteJob;
import com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStoragePool;
import com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStorageVolume;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import com.sun.netstorage.dsp.mgmt.se6920.utils.DspUtil;
import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.UnsignedInt16;

public class DspPropertyVolumeStateChange
extends DspPropertyVolumeModified {
    private static final String CLASSNAME = "DspPropertyVolumeStateChange";
    private static final String LABEL = "VolumeStateChangeListener";
    private static final String RAPID_MARK = "asynchVolumeStateChange";
    private String STATE_CHANGE = new String("stateChange");
    private static final String CRM_ASSOC_SYNC = "SunStorEdge_DSPSynchronizedComponent";
    private static final String CRM_ASSOC_SYNC_ANT = "Antecedent";
    private static final String CRM_ASSOC_SYNC_DEP = "Dependent";
    private static final String VOL_WWN_PROP = "DeviceID";
    private static final String VOLSTAT_PAGE_REQUEST = "volstat.xml?samVolume_SetByWwn=";
    private static final String VOLUME_PAGE_REQUEST = "volume.xml?samVolume_SetByWwn=";
    private static final String LMCREATE_PAGE_REQUEST = "lmcreate.xml?samVolume_SetByWwn=";
    private static String SYSTEM_CLASS = "SunStorEdge_DSPStorageSystem";
    private static String VOLUME_CLASS = "SunStorEdge_DSPStorageVolume";
    private static String OBJECT_TYPE = "ObjectType";
    private static String OPERATIONAL_STATUS = "OperationalStatus";
    private static String CREATION_CLASS_NAME = "CreationClassName";
    private static String SYSTEM_CREATION_CLASS_NAME = "SystemCreationClassName";
    private static String SYSTEM_NAME = "SystemName";
    private static String NAME = "Name";
    private int MIRROR_OBJECT_TYPE = 2;
    private int MIRROR_DEGRADED = 3;
    private int MIRROR_OK = 2;
    private int MIRROR_LOG_DEGRADED = 32782;
    private int LOST_COMMUNICATION = 13;
    private static final String JOB_MODIFY_MODULE = "ModifySunStorEdge_DSPConcreteJob";
    private static final String sccs_id = "@(#)DspPropertyVolumeStateChange.java    1.13    05/07/22     SMI";

    public DspPropertyVolumeStateChange(ArrayObject dsp) {
        super(dsp, LABEL);
        this.setOperation(this.STATE_CHANGE);
        this.setRapidMark(RAPID_MARK);
    }

    public String toDebugString() {
        if (this.getName() == null || this.getName().equals("")) {
            return new String(LABEL);
        }
        return new String(LABEL + this.getName());
    }

    protected void doPropertyChangeAction(PropertyChangeEvent e) {
        String METHOD = "doPropertyChangeAction";
        Trace.methodBegin((Object)this, (String)METHOD);
        boolean wasMirror = false;
        boolean wasDegraded = false;
        boolean isMirror = false;
        boolean wasBadLog = false;
        CIMInstance vol = null;
        CIMObjectPath volPath = null;
        if (!this.getOperation().equals(this.getNotifiedOperation())) {
            Trace.info((Object)this, (String)METHOD, (String)(" We are listening for " + this.getOperation() + " not " + this.getNotifiedOperation() + " - nothing to do"));
            return;
        }
        Trace.info((Object)this, (String)METHOD, (String)(" Processing " + this.getOperation() + " notification"));
        try {
            vol = this.findVolume(this.getAffectedWwn());
            if (vol != null) {
                int objtyp = ((UnsignedInt16)vol.getProperty("ObjectType").getValue().getValue()).intValue();
                if (objtyp == 2) {
                    Trace.info((Object)this, (String)METHOD, (String)" Volume is a mirror (before)");
                    wasMirror = true;
                } else {
                    Trace.info((Object)this, (String)METHOD, (String)" Volume is not a mirror (before)");
                }
            } else {
                Trace.error((Object)this, (String)METHOD, (String)"Notified volume not found in cache (yet).");
                return;
            }
            if (wasMirror) {
                Vector volState = (Vector)vol.getProperty("OperationalStatus").getValue().getValue();
                int opState = this.MIRROR_OK;
                Iterator stateItr = volState.iterator();
                while (stateItr.hasNext()) {
                    opState = ((UnsignedInt16)stateItr.next()).intValue();
                    Trace.info((Object)this, (String)METHOD, (String)(" Volume state: " + opState));
                    if (opState == this.MIRROR_DEGRADED) {
                        Trace.info((Object)this, (String)METHOD, (String)" Volume was degraded");
                        wasDegraded = true;
                    }
                    if (opState != this.MIRROR_LOG_DEGRADED) continue;
                    Trace.info((Object)this, (String)METHOD, (String)" Mirror log was degraded");
                    wasDegraded = true;
                    wasBadLog = true;
                }
            }
            volPath = vol.getObjectPath();
            Trace.info((Object)this, (String)METHOD, (String)(" Reloading the cache page for " + this.getAffectedWwn()));
            String volPage = new String(VOLSTAT_PAGE_REQUEST + this.getAffectedWwn());
            RequestBroker.getInstance().reloadCachePage(this.getDsp(), volPage);
            Trace.info((Object)this, (String)METHOD, (String)" Checking to see if the state is OK now");
            vol = RequestBroker.getInstance().findInstance(volPath);
            if (vol == null) {
                Trace.error((Object)this, (String)METHOD, (String)"Could not find volume that was loaded!!");
                return;
            }
            Vector volState = (Vector)vol.getProperty("OperationalStatus").getValue().getValue();
            int opState = ((UnsignedInt16)volState.get(0)).intValue();
            int objtyp = ((UnsignedInt16)vol.getProperty("ObjectType").getValue().getValue()).intValue();
            if (objtyp == 2) {
                Trace.info((Object)this, (String)METHOD, (String)" Volume is a mirror (after)");
                isMirror = true;
            } else {
                Trace.info((Object)this, (String)METHOD, (String)" Volume is not a mirror (after)");
            }
            if (wasMirror) {
                CIMInstance[] syncComps;
                if (wasDegraded && opState == this.MIRROR_OK) {
                    if (wasBadLog) {
                        boolean logOk = true;
                        Iterator stateItr = volState.iterator();
                        while (stateItr.hasNext()) {
                            opState = ((UnsignedInt16)stateItr.next()).intValue();
                            if (opState != this.MIRROR_LOG_DEGRADED) continue;
                            logOk = false;
                            break;
                        }
                        if (logOk) {
                            Trace.info((Object)this, (String)METHOD, (String)(" Reloading the cache page for " + this.getAffectedWwn()));
                            volPage = new String(VOLSTAT_PAGE_REQUEST + this.getAffectedWwn());
                            RequestBroker.getInstance().reloadCachePage(this.getDsp(), volPage);
                        }
                    } else {
                        Trace.info((Object)this, (String)METHOD, (String)" Mirror volume no longer resilvering - reloading its components to clear component status");
                        CIMObjectPath syncComp = new CIMObjectPath(CRM_ASSOC_SYNC);
                        volPath.setNameSpace("\\root\\se6x20\\");
                        syncComps = RequestBroker.getInstance().references(syncComp, volPath, CRM_ASSOC_SYNC_DEP, true, true, null);
                        if (syncComps != null) {
                            Vector componentWwn = new Vector();
                            for (int j = 0; j < syncComps.length; ++j) {
                                CIMObjectPath compVolPath = (CIMObjectPath)syncComps[j].getProperty(CRM_ASSOC_SYNC_ANT).getValue().getValue();
                                CIMInstance compVol = RequestBroker.getInstance().findInstance(compVolPath);
                                String compVolWwnName = DspUtil.unquote((String)compVol.getProperty(VOL_WWN_PROP).getValue().getValue());
                                volPage = new String(VOLSTAT_PAGE_REQUEST + compVolWwnName);
                                RequestBroker.getInstance().reloadCachePage(this.getDsp(), volPage);
                            }
                        }
                    }
                }
                if (opState == this.LOST_COMMUNICATION) {
                    Trace.debug((Object)this, (String)METHOD, (String)"Mirror transitioning to LC");
                    CIMObjectPath syncCompPath = new CIMObjectPath(CRM_ASSOC_SYNC);
                    syncCompPath.setNameSpace("\\root\\se6x20\\");
                    volPath.setNameSpace("\\root\\se6x20\\");
                    syncComps = RequestBroker.getInstance().references(syncCompPath, volPath, CRM_ASSOC_SYNC_DEP, true, true, null);
                    if (syncComps != null) {
                        for (int y = 0; y < syncComps.length; ++y) {
                            CIMInstance compAcc = syncComps[y];
                            CIMObjectPath compPath = (CIMObjectPath)compAcc.getProperty(CRM_ASSOC_SYNC_ANT).getValue().getValue();
                            if (compPath != null) {
                                ModifySunStorEdge_DSPStorageVolume.deleteVolumeModel(this.getDsp(), compPath);
                            }
                            RequestBroker.getInstance().deleteInstance(syncComps[y].getObjectPath());
                        }
                    }
                    CIMObjectPath basedOnAssocPath = new CIMObjectPath("SunStorEdge_DSPBasedOn");
                    CIMObjectPath[] extents = RequestBroker.getInstance().associatorNames(basedOnAssocPath, volPath, "SunStorEdge_DSPStorageExtent", CRM_ASSOC_SYNC_DEP, CRM_ASSOC_SYNC_ANT);
                    CIMObjectPath[] basedOnPath = RequestBroker.getInstance().referenceNames(basedOnAssocPath, volPath, CRM_ASSOC_SYNC_DEP);
                    if (basedOnPath != null) {
                        for (int i = 0; i < basedOnPath.length; ++i) {
                            RequestBroker.getInstance().deleteInstance(basedOnPath[i]);
                        }
                    }
                    ModifySunStorEdge_DSPStoragePool.updatePoolSizes();
                }
            } else if (!wasMirror && isMirror) {
                Trace.info((Object)this, (String)METHOD, (String)(" Reloading the cache page for " + this.getAffectedWwn()));
                volPage = new String(LMCREATE_PAGE_REQUEST + this.getAffectedWwn());
                RequestBroker.getInstance().reloadCachePage(this.getDsp(), volPage);
                ModifySunStorEdge_DSPStorageVolume.healVolumePoolAssocs();
            }
        }
        catch (Exception ex1) {
            Trace.error((Object)this, (String)METHOD, (String)"Exception taken in mirror state change monitor");
            Trace.error((Object)this, (String)METHOD, (Throwable)ex1);
        }
        String wwn = this.getAffectedWwn();
        Trace.info((Object)this, (String)METHOD, (String)(" Checking outstanding vol modified jobs using WWN = " + wwn));
        ModifySunStorEdge_DSPConcreteJob jobMod = (ModifySunStorEdge_DSPConcreteJob)ModifyBroker.getInstance().getModule(this.getDsp().getHost(), JOB_MODIFY_MODULE);
        jobMod.checkOutstandingVolumeModificationJobs(wwn);
    }

    private CIMInstance findVolume(String volWwn) {
        String METHOD = "findVolume";
        Trace.info((Object)this, (String)"findVolume", (String)" entered");
        Trace.info((Object)this, (String)"findVolume", (String)(" Searching for volume with WWN = " + volWwn));
        String searchWwn = volWwn.replaceAll(":", "");
        Object curVolPath = null;
        CIMInstance curVol = null;
        try {
            curVol = ModifySunStorEdge_DSPStorageVolume.getStorageVolume(searchWwn);
        }
        catch (CIMException e1) {
            Trace.error((Object)this, (String)"findVolume", (String)(" Exception searching for volume with WWN = " + volWwn));
        }
        if (curVol != null) {
            Trace.info((Object)this, (String)"findVolume", (String)" Found the volume");
        } else {
            Trace.info((Object)this, (String)"findVolume", (String)" Cound not find the volume");
        }
        return curVol;
    }
}

