/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.DspDebounceTimer;
import com.sun.netstorage.dsp.mgmt.se6920.DspPropertyChangeListener;
import com.sun.netstorage.dsp.mgmt.se6920.DspRapidMark;
import com.sun.netstorage.dsp.mgmt.se6920.DspTimedActionListener;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.StringTokenizer;

public class DspPropertyModifiedChassis
extends DspPropertyChangeListener
implements DspTimedActionListener {
    private static final String CLASSNAME = "DspPropertyModifiedChassis";
    private static final int STATE_NORMAL = 0;
    private static final int STATE_STANDBY = 1;
    private static final int STATE_WARNING = 2;
    private static final int STATE_FAULT = 3;
    private static final int STATE_FAIL = 4;
    private static final int STATE_POWERED_OFF = 5;
    private static final int STATE_REBOOTING = 6;
    private static final int STATE_ACTIVE_DEGRADED = 7;
    private static final int DELAY_TIME = 60;
    private DspDebounceTimer timer;
    private static final String sccs_id = "@(#)DspPropertyModifiedChassis.java    1.6    05/04/10   SMI";

    public DspPropertyModifiedChassis(ArrayObject dsp, String name, boolean debugEnabled) {
        super(dsp, name, debugEnabled);
    }

    public DspPropertyModifiedChassis(ArrayObject dsp, boolean debugEnabled) {
        this(dsp, "ModifiedChassisListener", debugEnabled);
    }

    public DspPropertyModifiedChassis(ArrayObject dsp) {
        this(dsp, false);
    }

    public String toDebugString() {
        if (this.getName() == null || this.getName().equals("")) {
            return new String(CLASSNAME);
        }
        return new String("DspPropertyModifiedChassis " + this.getName());
    }

    public void propertyChange(PropertyChangeEvent e) {
        DspRapidMark rm = (DspRapidMark)e.getSource();
        String newValue = e.getNewValue().toString();
        ArrayObject dsp = this.getDsp();
        int slot = -1;
        int cpu = -1;
        int state = -1;
        String logMsg = new String();
        String METHOD = "propertyChange";
        Trace.info((Object)this, (String)METHOD, (String)" Begin ");
        Trace.warn((Object)this, (String)METHOD, (String)(" Property changed.  RM = " + rm.getName() + ", new value = " + newValue));
        if (dsp == null) {
            Trace.warn((Object)this, (String)METHOD, (String)" No Dsp associated with change - done");
            return;
        }
        if (rm.getName().equals("asynchModifiedChassis")) {
            try {
                StringTokenizer st = new StringTokenizer(newValue);
                if (st.hasMoreTokens()) {
                    slot = new Integer(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    cpu = new Integer(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    state = new Integer(st.nextToken());
                }
            }
            catch (NumberFormatException nfe) {
                Trace.warn((Object)this, (String)METHOD, (String)(" Invalid DspPropertyModifiedChassis RM value: " + newValue));
                return;
            }
            if (state == -1) {
                Trace.warn((Object)this, (String)METHOD, (String)(" Invalid DspPropertyModifiedChassis RM value: " + newValue));
                return;
            }
            logMsg = new String("DSP_CHASSIS_MODIFIED");
            Trace.info((Object)this, (String)METHOD, (String)(" Modified chassis RM processing  slot = " + slot + ", cpu = " + cpu + ", state = " + state));
        } else if (rm.getName().equals("asynchNewBoard")) {
            slot = new Integer(newValue);
            logMsg = new String("DSP_CHASSIS_BOARD_ADDED");
            Trace.info((Object)this, (String)METHOD, (String)(" Board added in slot = " + slot));
        } else if (rm.getName().equals("asynchRemovedBoard")) {
            slot = new Integer(newValue);
            logMsg = new String("DSP_CHASSIS_BOARD_REMOVED");
            Trace.info((Object)this, (String)METHOD, (String)(" Board removed from slot = " + slot));
        } else {
            Trace.error((Object)this, (String)METHOD, (String)(" RM not handled: " + rm.getName()));
            return;
        }
        try {
            String[] logArgs = new String[]{new String(new Integer(slot).toString()), this.getDsp().getHost()};
            LogAPI.staticLog((String)logMsg, (String[])logArgs, null);
        }
        catch (Exception logEx) {
            // empty catch block
        }
        this.setTimer(60);
    }

    protected synchronized void setTimer(int minimumDelay) {
        String METHOD = "setTimer";
        if (this.timer == null) {
            Trace.info((Object)this, (String)METHOD, (String)(" Creating timer to start in " + minimumDelay + " ms"));
            this.timer = new DspDebounceTimer(minimumDelay, this, null, "ModifiedChassisTimer");
            this.timer.startTimer();
        } else {
            Trace.info((Object)this, (String)METHOD, (String)(" Resetting timer to sleep for at least " + minimumDelay + " ms"));
            this.timer.notifyTimer();
        }
    }

    protected synchronized void clearTimer() {
        String METHOD = "clearTimer";
        if (this.timer == null) {
            Trace.error((Object)this, (String)METHOD, (String)" No timer exists.  Done.");
        } else {
            this.timer.disableAction();
            this.timer = null;
            Trace.error((Object)this, (String)METHOD, (String)" Cleared timer.");
        }
    }

    public synchronized void doTimedAction(DspDebounceTimer timer, Object parms) {
        String METHOD = "runTimedAction";
        Trace.error((Object)this, (String)METHOD, (String)" Flushing cache ");
        RequestBroker.getInstance().invalidateCache(this.getDsp());
        this.clearTimer();
    }

    String buildPageNameWithParam(PropertyChangeEvent e) {
        return new String("Bogus");
    }

    void processNewInstances(List deviceList) {
    }
}

