/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.DspRapidMark;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

abstract class DspPropertyChangeListener
implements PropertyChangeListener {
    private boolean debug = false;
    private ArrayObject dsp;
    private String name = new String("");
    public static final int DEFAULT_DELAY = 1000;
    private int delay = 1000;
    private static final String sccs_id = "@(#)DspPropertyChangeListener.java    1.11    05/03/11     SMI";

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean flag) {
        this.debug = flag;
    }

    public ArrayObject getDsp() {
        return this.dsp;
    }

    public void setDsp(ArrayObject newDsp) {
        this.dsp = newDsp;
    }

    public String getName() {
        return this.name;
    }

    public void setDelay(int newDelay) {
        this.delay = newDelay;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public DspPropertyChangeListener(ArrayObject dsp, String name, boolean debugEnabled) {
        this.setDsp(dsp);
        this.setName(name);
        this.setDebug(debugEnabled);
    }

    public DspPropertyChangeListener(ArrayObject dsp, boolean debugEnabled) {
        this(dsp, "PropertyChangeListener", debugEnabled);
    }

    public DspPropertyChangeListener(ArrayObject dsp) {
        this(dsp, false);
    }

    public String toDebugString() {
        if (this.getName() == null || this.getName().equals("")) {
            return new String("DspPropertyChangeListener");
        }
        return new String("DspPropertyChangeListener " + this.getName());
    }

    public void propertyChange(PropertyChangeEvent e) {
        String METHOD = "propertyChange";
        DspRapidMark rm = (DspRapidMark)e.getSource();
        String newValue = e.getNewValue().toString();
        ArrayObject dsp = this.getDsp();
        if (this.getDebug()) {
            System.out.println("\n\tDspPropertyChangeListener " + this.getName() + " " + "got a PropertyChangeEvent from " + rm.getName());
            System.out.println("\t\tOld value:  " + e.getOldValue());
            System.out.println("\t\tNew value:  " + e.getNewValue());
        }
        Trace.warn((Object)this, (String)"propertyChange", (String)("DspPropertyChangeListener " + this.getName() + " received property changed event.  RM = " + rm.getName() + ", new value = " + newValue));
        if (dsp == null) {
            Trace.warn((Object)this, (String)"propertyChange", (String)"No Dsp associated with change - done");
            return;
        }
        try {
            List deviceList = RequestBroker.getInstance().reloadCachePage(dsp, this.buildPageNameWithParam(e));
            Trace.warn((Object)this, (String)"propertyChange", (String)"Added updated device info to cache");
            this.processNewInstances(deviceList);
        }
        catch (Exception ex1) {
            Trace.error((Object)this, (String)"Can not get CIMInstances.", (Throwable)ex1);
        }
    }

    abstract void processNewInstances(List var1);

    abstract String buildPageNameWithParam(PropertyChangeEvent var1);
}

