/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayException;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.DevComm;
import com.sun.netstorage.dsp.mgmt.se6920.DspEventTarget;
import com.sun.netstorage.dsp.mgmt.se6920.DspEventTargetReplicationSync;
import com.sun.netstorage.dsp.mgmt.se6920.DspJobVolumeModification;
import com.sun.netstorage.dsp.mgmt.se6920.DspPropertyVolumeModified;
import com.sun.netstorage.dsp.mgmt.se6920.DspPropertyVolumeReplicationSync;
import com.sun.netstorage.dsp.mgmt.se6920.DspResults;
import com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStorageVolume;
import com.sun.netstorage.dsp.mgmt.se6920.StorEdgeIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;

public class DspJobVolumeReplicationResync
extends DspJobVolumeModification {
    private static final String CLASSNAME = "DspJobVolumeReplicationResync";
    private static final String VOLUME_REPLICATION_RESYNC_DESCRIPTION = "RemoteMirrorResync";
    private static final String VOLUME_REPLICATION_RESYNC_JOBNAME = "RemoteMirrorResync";
    private static final String RR_SCRBRD_PAGE = "RRScrbrd.htm";
    private static final String VOL_CR_NAME = "Name";
    private static final String RR_SETIDX = "Index";
    private static final String RR_FASTSTART = "FastStart";
    private static final int HASH_MAP_SIZE = 10;
    private DspPropertyVolumeReplicationSync pcl = null;
    protected Date changeTime = null;
    private Map repSetMap = Collections.synchronizedMap(new HashMap(10));
    private static final String sccs_id = "@(#)DspJobVolumeReplicationResync.java    1.17    05/04/22     SMI";

    private void setPcl(DspPropertyVolumeReplicationSync newPcl) {
        this.pcl = newPcl;
    }

    private DspPropertyVolumeReplicationSync getPcl() {
        return this.pcl;
    }

    private void setChangeTime(Date newTime) {
        this.changeTime = newTime;
    }

    private Date getChangeTime() {
        return this.changeTime;
    }

    private Map getRepSetMap() {
        return this.repSetMap;
    }

    DspJobVolumeReplicationResync(ArrayObject dsp, Date actionTime) {
        super(dsp);
        String METHOD = "Constructor";
        Trace.methodBegin((Object)this, (String)"Constructor");
        this.setCimDescription("RemoteMirrorResync");
        this.setCimJobName("RemoteMirrorResync");
        this.setChangeTime(actionTime);
        this.setPcl(DspPropertyVolumeReplicationSync.getInstance(this.getDsp()));
        Trace.methodEnd((Object)this, (String)"Constructor");
    }

    public synchronized DspPropertyVolumeModified createPropertyChangeListener(ArrayObject dsp) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setPercentComplete(int percent) {
        String METHOD = "setPercentComplete";
        Trace.methodBegin((Object)this, (String)"setPercentComplete");
        int avg = 0;
        int total = 0;
        int counter = 0;
        DspEventTargetReplicationSync avgTarget = null;
        Map map = this.getRepSetMap();
        synchronized (map) {
            Collection targetCollection = this.getRepSetMap().values();
            Iterator it = targetCollection.iterator();
            while (it.hasNext()) {
                avgTarget = (DspEventTargetReplicationSync)it.next();
                int targetPercent = avgTarget.getPercentComplete();
                total += targetPercent;
                Trace.info((Object)this, (String)"setPercentComplete", (String)(" Target " + counter + " percentComplete = " + targetPercent));
                ++counter;
            }
        }
        if (counter != 0) {
            avg = total / counter;
            Trace.info((Object)this, (String)"setPercentComplete", (String)(" Average of " + counter + " entries = " + avg));
        } else {
            Trace.info((Object)this, (String)"setPercentComplete", (String)" No targets, so average remains = 0");
        }
        Trace.info((Object)this, (String)"setPercentComplete", (String)(" Calling superclass setPercentComplete for CIM job " + this.getCimJobId() + " to set percentComplete to " + avg));
        super.setPercentComplete(avg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void kill() {
        block18: {
            String METHOD = "kill";
            Trace.methodBegin((Object)this, (String)"kill");
            Trace.info((Object)this, (String)"kill", (String)(" Killing job " + this.getCimJobId()));
            if (this.getPercentComplete() != 100) {
                DspEventTargetReplicationSync killTarget = null;
                Map map = this.getRepSetMap();
                synchronized (map) {
                    Collection targetCollection = this.getRepSetMap().values();
                    Iterator it = targetCollection.iterator();
                    while (it.hasNext()) {
                        killTarget = (DspEventTargetReplicationSync)it.next();
                    }
                }
                if (killTarget != null) {
                    String vName = null;
                    Vector<String> nvPairs = new Vector<String>();
                    try {
                        String tmprwwn = Convert.wwnToString((String)killTarget.getTargetVolumeWwn());
                        CIMInstance vInst = ModifySunStorEdge_DSPStorageVolume.getStorageVolume(tmprwwn);
                        if (vInst != null) {
                            vName = (String)vInst.getProperty("ElementName").getValue().getValue();
                        }
                    }
                    catch (CIMException cme) {
                        Trace.error((Object)this, (String)"kill", (Throwable)cme);
                    }
                    if (vName == null) {
                        Trace.error((Object)this, (String)"kill", (String)("No volume found for wwn: " + killTarget.getTargetVolumeWwn()));
                        return;
                    }
                    nvPairs.add(new String("Name=" + vName));
                    nvPairs.add(new String("Index=" + killTarget.getSetIndex()));
                    nvPairs.add(new String("FastStart=false"));
                    Trace.info((Object)this, (String)"kill", (String)(" " + this.getCimJobId() + " Sending scoreboard request to the DSP for volume" + killTarget.getTargetVolumeWwn()));
                    try {
                        DspResults results = DevComm.getInstance().postWithDspResults(this.getDsp(), RR_SCRBRD_PAGE, nvPairs);
                        if (results.requestSucceeded()) {
                            Trace.info((Object)this, (String)"kill", (String)(" " + this.getCimJobId() + " Resync Remote abort request succeeded"));
                            try {
                                String[] logArgs = new String[]{this.getTarget().getTargetVolumeWwn(), this.getDsp().getHost()};
                                String mirrorMsg = new String("DSP_VOLUME_REPLICATION_RESYNC_ABORT_OK");
                                LogAPI.staticLog((String)mirrorMsg, (String[])logArgs, null);
                            }
                            catch (Exception logEx) {}
                            break block18;
                        }
                        Trace.info((Object)this, (String)"kill", (String)(" " + this.getCimJobId() + " Resync Remote abort request failed - RC = " + results.getReturnCode()));
                    }
                    catch (ArrayException arre) {
                        Trace.error((Object)this, (String)(" " + this.getCimJobId() + " Resync Remote abort request took an exception"), (Throwable)arre);
                    }
                    catch (StorEdgeIOException stre) {
                        Trace.error((Object)this, (String)(" " + this.getCimJobId() + " Resync Remote abort request took an exception"), (Throwable)stre);
                    }
                } else {
                    Trace.info((Object)this, (String)"kill", (String)(" " + this.getCimJobId() + " No need to send a scoreboard request to the DSP - no eventTargets"));
                }
            } else {
                Trace.info((Object)this, (String)"kill", (String)(" " + this.getCimJobId() + " No repsets to put into scoreboard mode"));
            }
        }
        Trace.info((Object)this, (String)"kill", (String)(" " + this.getCimJobId() + " Calling superclass kill()"));
        super.kill();
        Trace.info((Object)this, (String)"kill", (String)(" " + this.getCimJobId() + " Complete"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void cleanUpJob() {
        String METHOD = "cleanUpJob";
        Trace.methodBegin((Object)this, (String)"cleanUpJob");
        Trace.info((Object)this, (String)"cleanUpJob", (String)(" " + this.getCimJobId() + " Job complete - Deleting the event target(s)"));
        DspPropertyVolumeReplicationSync cleanPcl = this.getPcl();
        DspEventTargetReplicationSync cleanTarget = null;
        Map map = this.getRepSetMap();
        synchronized (map) {
            Collection targetCollection = this.getRepSetMap().values();
            Iterator it = targetCollection.iterator();
            while (it.hasNext()) {
                cleanTarget = (DspEventTargetReplicationSync)it.next();
                cleanPcl.deleteTarget(cleanTarget);
            }
        }
        super.cleanUpJob();
    }

    public synchronized DspEventTarget findOrAddTarget(String targetWwn) {
        String METHOD = "findOrAddTarget";
        Trace.methodBegin((Object)this, (String)"findOrAddTarget");
        DspEventTarget target = (DspEventTarget)this.getRepSetMap().get(targetWwn);
        if (target != null) {
            Trace.info((Object)this, (String)"findOrAddTarget", (String)(" " + this.getCimJobId() + " Target = " + targetWwn + " already exists for this job"));
            return target;
        }
        Trace.info((Object)this, (String)"findOrAddTarget", (String)(" " + this.getCimJobId() + " Creating a target = " + targetWwn + " for this job"));
        target = DspPropertyVolumeReplicationSync.getInstance(this.getDsp()).findOrAddTarget(targetWwn, this.getChangeTime());
        target.setJob(this);
        this.getRepSetMap().put(targetWwn, target);
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTargetNames() {
        String METHOD = "getTargetNames";
        Trace.methodBegin((Object)this, (String)"getTargetNames");
        ArrayList<String> targetList = new ArrayList<String>();
        DspEventTargetReplicationSync currentTarget = null;
        Map map = this.getRepSetMap();
        synchronized (map) {
            Collection targetCollection = this.getRepSetMap().values();
            Iterator it = targetCollection.iterator();
            while (it.hasNext()) {
                currentTarget = (DspEventTargetReplicationSync)it.next();
                String curTargetName = currentTarget.getTargetVolumeWwn();
                Trace.debug((Object)this, (String)"getTargetNames", (String)(" " + this.getCimJobId() + " Adding target " + curTargetName + " to target name list"));
                targetList.add(curTargetName);
            }
        }
        Trace.info((Object)this, (String)"getTargetNames", (String)(" " + this.getCimJobId() + " Returning list of " + targetList.size() + " elements"));
        Trace.methodEnd((Object)this, (String)"getTargetNames");
        return targetList;
    }

    public void checkForJobCompletion() {
        String METHOD = "checkForJobCompletion";
        Trace.methodBegin((Object)this, (String)"checkForJobCompletion");
        Collection targets = this.getRepSetMap().values();
        Iterator it = targets.iterator();
        while (it.hasNext()) {
            DspEventTarget currentTarget = (DspEventTarget)it.next();
            this.checkTarget(currentTarget);
        }
    }

    public void checkTargetStateChange(String volWwn) {
        String METHOD = "checkTargetStateChange";
        Trace.methodBegin((Object)this, (String)"checkTargetStateChange");
        Collection targets = this.getRepSetMap().values();
        Iterator it = targets.iterator();
        while (it.hasNext()) {
            DspEventTarget currentTarget = (DspEventTarget)it.next();
            if (currentTarget == null) {
                Trace.info((Object)this, (String)"checkTargetStateChange", (String)(" " + this.getCimJobId() + " Nothing to do - no target set"));
                continue;
            }
            if (currentTarget.getTargetVolumeWwn().equals(volWwn) || currentTarget.getNotificationWwns().containsKey(volWwn)) {
                Trace.info((Object)this, (String)"checkTargetStateChange", (String)(" " + this.getCimJobId() + " Found target for wwn =" + volWwn));
                currentTarget.checkForTargetCompletion(false);
                continue;
            }
            Trace.info((Object)this, (String)"checkTargetStateChange", (String)(" " + this.getCimJobId() + " No target for wwn = " + volWwn));
        }
        Trace.methodEnd((Object)this, (String)"checkTargetStateChange");
    }
}

