/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.DevComm;
import com.sun.netstorage.dsp.mgmt.se6920.DspEventTarget;
import com.sun.netstorage.dsp.mgmt.se6920.DspEventTargetPitRollback;
import com.sun.netstorage.dsp.mgmt.se6920.DspJobVolumeModification;
import com.sun.netstorage.dsp.mgmt.se6920.DspPropertyVolumeModified;
import com.sun.netstorage.dsp.mgmt.se6920.DspPropertyVolumePitRollback;
import com.sun.netstorage.dsp.mgmt.se6920.DspResults;
import java.util.Vector;

public class DspJobVolumePitRollback
extends DspJobVolumeModification {
    private static final String CLASSNAME = "DspJobVolumePitRollback";
    private static final String VOLUME_PIT_ROLLBACK_DESCRIPTION = "PITRollback";
    private static final String VOLUME_PIT_ROLLBACK_JOBNAME = "PITRollback";
    private String rollbackAbortPage = null;
    private Vector rollbackAbortPageParms = null;
    private static final String sccs_id = "@(#)DspJobVolumePitRollback.java    1.11    05/04/22   SMI";

    public String getRollbackAbortPage() {
        return this.rollbackAbortPage;
    }

    public void setRollbackAbortPage(String rollbackPage) {
        this.rollbackAbortPage = rollbackPage;
    }

    public Vector getRollbackAbortPageParms() {
        return this.rollbackAbortPageParms;
    }

    public void setRollbackAbortPageParms(Vector rollbackPageParms) {
        this.rollbackAbortPageParms = rollbackPageParms;
    }

    DspJobVolumePitRollback(ArrayObject dsp) {
        super(dsp);
        String METHOD = "Constructor";
        Trace.methodBegin((Object)this, (String)"Constructor");
        this.setCimDescription("PITRollback");
        this.setCimJobName("PITRollback");
        Trace.methodEnd((Object)this, (String)"Constructor");
    }

    public synchronized DspPropertyVolumeModified createPropertyChangeListener(ArrayObject dsp) {
        String METHOD = "createPropertyChangeListener";
        Trace.methodBegin((Object)this, (String)"createPropertyChangeListener");
        if (this.getTarget() == null) {
            Trace.error((Object)this, (String)"createPropertyChangeListener", (String)" Event target not set - unable to create a change listener");
            return null;
        }
        return new DspPropertyVolumePitRollback(dsp, this.getTarget());
    }

    public synchronized void setAbortParms(String page, Vector abortTokens) {
        String METHOD = "setAbortParms";
        Trace.methodBegin((Object)this, (String)"setAbortParms");
        this.setRollbackAbortPage(page);
        this.setRollbackAbortPageParms(abortTokens);
    }

    public synchronized void disableAbortRequest() {
        String METHOD = "disableAbortParms";
        Trace.methodBegin((Object)this, (String)"disableAbortParms");
        this.setRollbackAbortPage(null);
        this.setRollbackAbortPageParms(null);
    }

    public synchronized void kill() {
        String METHOD = "kill";
        Trace.methodBegin((Object)this, (String)"kill");
        Trace.info((Object)this, (String)"kill", (String)(" Killing job " + this.getCimJobId()));
        if (this.getRollbackAbortPage() != null && this.getRollbackAbortPageParms() != null && this.getPercentComplete() != 100) {
            Trace.info((Object)this, (String)"kill", (String)(" " + this.getCimJobId() + " Sending PIT Rollback abort request "));
            try {
                DspResults results = DevComm.getInstance().postWithDspResults(this.getDsp(), this.getRollbackAbortPage(), this.getRollbackAbortPageParms());
                if (results.requestSucceeded()) {
                    Trace.info((Object)this, (String)"kill", (String)(" " + this.getCimJobId() + " PIT Rollback abort request succeeded"));
                } else {
                    Trace.info((Object)this, (String)"kill", (String)(" " + this.getCimJobId() + " PIT Rollback abort request failed - RC = " + results.getReturnCode()));
                }
                try {
                    String[] logArgs = new String[]{this.getTarget().getTargetVolumeWwn(), this.getDsp().getHost()};
                    String pitResetMsg = results.requestSucceeded() ? new String("DSP_VOLUME_PIT_ROLLBACK_ABORT_OK") : new String("DSP_VOLUME_PIT_ROLLBACK_ABORT_FAILED");
                    LogAPI.staticLog((String)pitResetMsg, (String[])logArgs, null);
                }
                catch (Exception exception) {
                }
            }
            catch (Exception e) {
                Trace.error((Object)this, (String)(" " + this.getCimJobId() + " PIT Rollback abort request took an exception"), (Throwable)e);
            }
        } else {
            Trace.info((Object)this, (String)"kill", (String)(" " + this.getCimJobId() + " Rollback already complete and/or abort parms not set.  Skipping PIT Rollback abort request "));
        }
        Trace.info((Object)this, (String)"kill", (String)(" " + this.getCimJobId() + " Calling superclass kill()"));
        super.kill();
        Trace.info((Object)this, (String)"kill", (String)(" " + this.getCimJobId() + " complete"));
    }

    public synchronized DspEventTarget findOrAddTarget(String targetWwn) {
        String METHOD = "findOrAddTarget";
        Trace.methodBegin((Object)this, (String)"findOrAddTarget");
        Trace.info((Object)this, (String)"findOrAddTarget", (String)(" " + this.getCimJobId() + " Creating a target using " + targetWwn + " for this job"));
        DspEventTargetPitRollback target = new DspEventTargetPitRollback(this.getDsp(), targetWwn);
        target.setJob(this);
        this.setTarget(target);
        return target;
    }
}

