/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.DspEventTarget;
import com.sun.netstorage.dsp.mgmt.se6920.DspJob;
import com.sun.netstorage.dsp.mgmt.se6920.DspPropertyVolumeModified;
import java.util.Vector;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMObjectPath;

public abstract class DspJobVolumeModification
extends DspJob {
    private static final String CLASSNAME = "DspJobVolumeModification";
    private static final String VOLUME_MODIFIED_DESCRIPTION = "VolumeModificationJob";
    private static final String JOB_CLASS = "SunStorEdge_DspConcreteJob";
    private static final String AFFECTED_JOB_ELEMENT_CLASS = "SunStorEdge_DSPAffectedJobElement";
    private static final String AFFECTED = "AffectedElement";
    private static final String AFFECTING = "AffectingElement";
    DspEventTarget target = null;
    DspPropertyVolumeModified listener;
    private static final String sccs_id = "@(#)DspJobVolumeModification.java    1.16    05/04/21   SMI";

    protected void setTarget(DspEventTarget newTarget) {
        this.target = newTarget;
    }

    protected DspEventTarget getTarget() {
        return this.target;
    }

    protected void setListener(DspPropertyVolumeModified newListener) {
        if (this.listener == null) {
            this.listener = newListener;
        }
    }

    protected DspPropertyVolumeModified getListener() {
        return this.listener;
    }

    DspJobVolumeModification(ArrayObject dsp) {
        super(dsp);
        String METHOD = "Constructor";
        Trace.methodBegin((Object)this, (String)"Constructor");
        this.setCimConcreteJobSubclass(JOB_CLASS);
        this.setCimDescription(VOLUME_MODIFIED_DESCRIPTION);
        this.setCimJobName(VOLUME_MODIFIED_DESCRIPTION);
        Trace.info((Object)this, (String)"Constructor", (String)" End ");
    }

    public abstract DspEventTarget findOrAddTarget(String var1);

    public abstract DspPropertyVolumeModified createPropertyChangeListener(ArrayObject var1);

    public synchronized CIMObjectPath createCimJob(String nameSpace, CIMObjectPath configurationService, Vector affectedElements) throws CIMException {
        String METHOD = "createCimJob";
        Trace.methodBegin((Object)this, (String)"createCimJob");
        CIMObjectPath newJobPath = super.createCimJob(nameSpace, configurationService, affectedElements);
        Trace.info((Object)this, (String)"createCimJob", (String)" CIM job created ");
        ArrayObject dsp = this.getDsp();
        DspPropertyVolumeModified pcl = this.createPropertyChangeListener(dsp);
        if (pcl != null) {
            Trace.info((Object)this, (String)"createCimJob", (String)" Registering property change listener");
            dsp.getDspChangeListener().addPropertyChangeListener(pcl, pcl.getRapidMark());
            this.setListener(pcl);
            DspEventTarget jobTarget = this.getTarget();
            if (jobTarget != null) {
                pcl.setTarget(this.getTarget());
            }
        }
        return newJobPath;
    }

    public void kill() {
        String METHOD = "kill";
        Trace.methodBegin((Object)this, (String)"kill");
        Trace.info((Object)this, (String)"kill", (String)(" Killing CIM job " + this.getCimJobId()));
        super.kill();
        this.cleanUpJob();
    }

    public synchronized void setPercentComplete(int percent) {
        String METHOD = "setPercentComplete";
        Trace.methodBegin((Object)this, (String)"setPercentComplete");
        Trace.info((Object)this, (String)"setPercentComplete", (String)(" Percent = " + percent));
        int currentPercentComplete = this.getPercentComplete();
        if (percent < 0 || percent > 100) {
            Trace.error((Object)this, (String)"setPercentComplete", (String)(" Invalid percent:  " + percent));
            return;
        }
        if (currentPercentComplete != 100) {
            if (percent > currentPercentComplete) {
                Trace.info((Object)this, (String)"setPercentComplete", (String)(" Updating percent complete from " + currentPercentComplete + " to " + percent + " percent"));
                super.setPercentComplete(percent);
                if (percent == 100) {
                    this.cleanUpJob();
                }
            } else {
                Trace.info((Object)this, (String)"setPercentComplete", (String)(" Obsolete notification.  Percent complete already " + currentPercentComplete + " percent"));
            }
        } else {
            Trace.info((Object)this, (String)"setPercentComplete", (String)" Obsolete notification.  Job already 100% complete");
        }
        Trace.methodEnd((Object)this, (String)"setPercentComplete");
    }

    protected synchronized void cleanUpJob() {
        String METHOD = "cleanUpJob";
        Trace.methodBegin((Object)this, (String)"cleanUpJob");
        Trace.info((Object)this, (String)"cleanUpJob", (String)(" " + this.getCimJobId() + " Marking job complete."));
        this.setCompletion(3, null, true);
        DspPropertyVolumeModified listener = this.getListener();
        if (listener != null) {
            Trace.info((Object)this, (String)"cleanUpJob", (String)(" " + this.getCimJobId() + " Job complete - unregistering the change listener"));
            this.getDsp().getDspChangeListener().removePropertyChangeListener(listener, listener.getRapidMark());
            this.setListener(null);
        } else {
            Trace.info((Object)this, (String)"cleanUpJob", (String)(" " + this.getCimJobId() + " Job complete - no change listener to unregister"));
        }
        if (this.getDeleteOnCompletion()) {
            this.deleteJob();
        }
    }

    public void checkForJobCompletion() {
        String METHOD = "checkForJobCompletion";
        Trace.methodBegin((Object)this, (String)"checkForJobCompletion");
        this.checkTarget(this.getTarget());
    }

    public void checkTarget(DspEventTarget target) {
        String METHOD = "checkTarget";
        Trace.methodBegin((Object)this, (String)"checkTarget");
        target.checkForTargetCompletion(true);
    }

    public void checkTargetStateChange(String volWwn) {
        String METHOD = "checkTargetStateChange";
        Trace.methodBegin((Object)this, (String)"checkTargetStateChange");
        DspEventTarget currentTarget = this.getTarget();
        if (currentTarget == null) {
            Trace.info((Object)this, (String)"checkTargetStateChange", (String)(" " + this.getCimJobId() + " Nothing to do - no target set"));
        } else if (currentTarget.getTargetVolumeWwn().equals(volWwn) || currentTarget.getNotificationWwns().containsKey(volWwn)) {
            Trace.info((Object)this, (String)"checkTargetStateChange", (String)(" " + this.getCimJobId() + " Found target for wwn =" + volWwn));
            currentTarget.checkForTargetCompletion(false);
        } else {
            Trace.info((Object)this, (String)"checkTargetStateChange", (String)(" " + this.getCimJobId() + " No target for wwn = " + volWwn));
        }
        Trace.methodEnd((Object)this, (String)"checkTargetStateChange");
    }
}

