/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.DspJob;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import com.sun.netstorage.dsp.mgmt.se6920.SunStorEdge_DSPProvider;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;

public class DspJobResilver
extends DspJob
implements Runnable {
    private static final String CLASSNAME = "DspJobResilver";
    private static final String VOLUME_RESILVER_DESCRIPTION = "Volume resilver";
    private static final String VOLUME_RESILVER_JOBNAME = "Volume resilver";
    private static final int SLEEP_INTERVAL = 60000;
    private int percentComplete = 0;
    private int mirrorType = 0;
    private String mirrorWwn = new String();
    private String remoteWwn = new String();
    private ArrayObject dspObj;
    private static final String sccs_id = "@(#)DspJobResilver.java    1.9    05/04/22     SMI";

    public int getPercentComplete() {
        return this.percentComplete;
    }

    public synchronized void setPercentComplete(int pC) {
        this.percentComplete = pC;
    }

    DspJobResilver(ArrayObject dsp, String mirrorWwn, String remoteWwn, int type) {
        super(dsp);
        this.mirrorWwn = mirrorWwn;
        this.dspObj = dsp;
        this.mirrorType = type;
        this.remoteWwn = remoteWwn;
        String METHOD = "Constructor";
        Trace.info((Object)this, (String)"Constructor", (String)" Begin ");
        this.setCimDescription("Volume resilver");
        this.setCimJobName("Volume resilver");
        Trace.info((Object)this, (String)"Constructor", (String)" End ");
    }

    protected synchronized void updatePercentComplete() {
        block15: {
            String METHOD = "updatePercentComplete";
            Trace.info((Object)this, (String)"updatePercentComplete", (String)" Begin ");
            int currentPercentComplete = this.getPercentComplete();
            if (this.mirrorType == 0) {
                try {
                    String volPage = new String("volumes.xml");
                    RequestBroker.getInstance().reloadCachePage(this.dspObj, volPage);
                    CIMObjectPath curVolPath = null;
                    CIMObjectPath volPath = new CIMObjectPath("SunStorEdge_DSPStorageVolume");
                    volPath.setNameSpace("\\root\\se6x20\\");
                    CIMClass volClass = SunStorEdge_DSPProvider.cimom.getClass(volPath, false, true, true, null);
                    CIMInstance[] vols = RequestBroker.getInstance().enumerateInstances(volPath, false, true, true, null, volClass);
                    CIMInstance curVol = null;
                    if (vols != null) {
                        for (int j = 0; j < vols.length; ++j) {
                            curVol = vols[j];
                            if (!curVol.getProperty("DeviceID").getValue().getValue().equals(this.mirrorWwn)) continue;
                            curVolPath = curVol.getObjectPath();
                            break;
                        }
                    }
                    if (curVol == null) break block15;
                    CIMObjectPath syncComp = new CIMObjectPath("SunStorEdge_DSPSynchronizedComponent");
                    curVolPath.setNameSpace("\\root\\se6x20\\");
                    CIMInstance[] SyncComps = RequestBroker.getInstance().references(syncComp, curVolPath, "Dependent", true, true, null);
                    int tempPercent = 0;
                    if (SyncComps != null) {
                        for (int j = 0; j < SyncComps.length; ++j) {
                            CIMValue percent = SyncComps[j].getProperty("ResyncPercent").getValue();
                            if (percent == null) continue;
                            UnsignedInt16 percentVal = (UnsignedInt16)percent.getValue();
                            tempPercent += percentVal.intValue();
                        }
                        Trace.info((Object)this, (String)"updatePercentComplete", (String)("Setting percent complete to: " + tempPercent / SyncComps.length));
                        this.setPercentComplete(tempPercent / SyncComps.length);
                    }
                }
                catch (CIMException ce) {
                    Trace.info((Object)this, (String)(" " + this.mirrorWwn + " Took exception calculating percentComplete "), (Throwable)ce);
                }
            } else {
                try {
                    String volPage = new String("volume.xml?samVolume_SetByWwn=" + this.mirrorWwn);
                    RequestBroker.getInstance().reloadCachePage(this.dspObj, volPage);
                    CIMObjectPath curRsPath = null;
                    CIMObjectPath rsPath = new CIMObjectPath("SunStorEdge_DSPReplicationSet");
                    rsPath.setNameSpace("\\root\\se6x20\\");
                    CIMClass rsClass = SunStorEdge_DSPProvider.cimom.getClass(rsPath, false, true, true, null);
                    CIMInstance[] repSets = RequestBroker.getInstance().enumerateInstances(rsPath, false, true, true, null, rsClass);
                    CIMInstance curRs = null;
                    if (repSets != null) {
                        for (int j = 0; j < repSets.length; ++j) {
                            curRs = repSets[j];
                            if (!curRs.getProperty("DeviceID").getValue().getValue().equals(this.remoteWwn)) continue;
                            curRsPath = curRs.getObjectPath();
                            break;
                        }
                    }
                    if (curRs != null) {
                        CIMObjectPath storSync = new CIMObjectPath("SunStorEdge_DSPRemoteStorageSynchronized");
                        curRsPath.setNameSpace("\\root\\se6x20\\");
                        CIMInstance[] storSyncs = RequestBroker.getInstance().references(storSync, curRsPath, "SyncedElement", true, true, null);
                        int tempPercent = 0;
                        if (storSync != null) {
                            CIMValue percent = storSyncs[0].getProperty("ResyncPercent").getValue();
                            if (percent != null) {
                                UnsignedInt16 percentVal = (UnsignedInt16)percent.getValue();
                                tempPercent = percentVal.intValue();
                                this.setPercentComplete(percentVal.intValue());
                            }
                            Trace.info((Object)this, (String)"updatePercentComplete", (String)("Setting percent complete to: " + tempPercent));
                        }
                    }
                }
                catch (CIMException ce) {
                    Trace.info((Object)this, (String)(" " + this.mirrorWwn + " Took exception calculating percentComplete "), (Throwable)ce);
                }
            }
        }
    }

    public void startPolling() {
        String METHOD = "startPolling";
        Trace.info((Object)this, (String)"startPolling", (String)" Begin ");
        new Thread(this).start();
    }

    public void run() {
        String METHOD = "run";
        Trace.info((Object)this, (String)"run", (String)" Begin ");
        boolean percentComplete = false;
        while (this.getPercentComplete() != 100) {
            try {
                Trace.info((Object)this, (String)"run", (String)(" " + this.mirrorWwn + " Updating percent complete for jobs"));
                this.updatePercentComplete();
            }
            catch (Exception percentException) {
                Trace.info((Object)this, (String)(" " + this.mirrorWwn + " Took exception calculating percentComplete "), (Throwable)percentException);
                this.setPercentComplete(100);
            }
            try {
                Trace.info((Object)this, (String)"run", (String)(" " + this.mirrorWwn + " Sleeping for " + 60 + " seconds"));
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                Trace.info((Object)this, (String)"run", (String)(" " + this.mirrorWwn + " Received InterruptedException"));
            }
        }
        Trace.info((Object)this, (String)"run", (String)(" " + this.mirrorWwn + " Polling complete "));
        Trace.info((Object)this, (String)"run", (String)(" " + this.mirrorWwn + " End "));
    }

    public void checkForJobCompletion() {
        String METHOD = "checkForJobCompletion";
        Trace.methodBegin((Object)this, (String)"checkForJobCompletion");
    }
}

