/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobInterface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.mr3.JobManager;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import com.sun.netstorage.array.mgmt.se6120.internal.ProviderToBOLConnection;
import com.sun.netstorage.array.mgmt.util.RaidSetExistenceListener;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.DevComm;
import com.sun.netstorage.dsp.mgmt.se6920.DspJob;
import com.sun.netstorage.dsp.mgmt.se6920.DspPropertyNewDisk;
import com.sun.netstorage.dsp.mgmt.se6920.DspRapidMark;
import com.sun.netstorage.dsp.mgmt.se6920.DspResults;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyBroker;
import com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStorageConfigurationService;
import com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStorageExtent;
import com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStoragePool;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import com.sun.netstorage.dsp.mgmt.se6920.SunStorEdge_DSPPersistenceManager;
import com.sun.netstorage.dsp.mgmt.se6920.SunStorEdge_DSPProvider;
import com.sun.netstorage.dsp.mgmt.se6920.utils.DspUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;

public class DspJobCreateLuns
extends DspJob
implements RaidSetExistenceListener,
PropertyChangeListener,
Runnable {
    private static final String CLASSNAME = "DspJobCreateLuns";
    private static final String CREATE_DESCRIPTION = "CreatingVdisks";
    private static final String CREATE_BAD_DISK_ERROR_DESCRIPTION = "CreatingVdisksBadDiskError";
    private static final int LOCK_SLEEP_INTERVAL = 10;
    private static final int INIT_SLEEP_INTERVAL = 30;
    private static final int MANUAL_INIT_SLEEP_INTERVAL = 30;
    private static final int JOB_POLLING_SLEEP_INTERVAL = 60;
    private static final String CREATED = "Created ";
    private static final String VDISKS_AND_ENCOUNTERED = " vdisk(s) and encountered ";
    private static final String ARRAY_ERRORS = " array error(s) and ";
    private static final String INIT_ERRORS = " initialization error(s)";
    private static final String CREATE_LUNS_NAME = "CreateDisk";
    private static final int IGNORE_DIGITS = 8;
    private static final String LUN_INIT_NAME = "samDisk_setCurrent";
    private static final String LUN_INIT_PAGE = "/devSlCr.htm";
    private static final String JOB_CLASS = "SunStorEdge_DspConcreteJob";
    private static final String AFFECTED_JOB_ELEMENT_CLASS = "SunStorEdge_DSPAffectedJobElement";
    private static final String AFFECTED = "AffectedElement";
    private static final String AFFECTING = "AffectingElement";
    private int numJobs = 0;
    private int numErrors = 0;
    String nameSpace = null;
    CIMObjectPath configurationService = null;
    CIMObjectPath storagePool = null;
    CIMObjectPath affectedJobElementPath = null;
    private List jobList = Collections.synchronizedList(new ArrayList());
    private List earlyNotifications = Collections.synchronizedList(new ArrayList());
    private static final String sccs_id = "@(#)DspJobCreateLuns.java   1.45   05/12/02   SMI";

    private void setNumJobs(int num) {
        this.numJobs = num;
    }

    private int getNumJobs() {
        return this.numJobs;
    }

    private void setNumErrors(int num) {
        this.numErrors = num;
    }

    private int getNumErrors() {
        return this.numErrors;
    }

    private void setNameSpace(String name) {
        this.nameSpace = name;
    }

    private String getNameSpace() {
        return this.nameSpace;
    }

    private void setConfigurationService(CIMObjectPath service) {
        this.configurationService = service;
    }

    private CIMObjectPath getConfigurationService() {
        return this.configurationService;
    }

    private void setStoragePool(CIMObjectPath pool) {
        this.storagePool = pool;
    }

    private CIMObjectPath getStoragePool() {
        return this.storagePool;
    }

    private void setAffectedJobElementPath(CIMObjectPath path) {
        this.affectedJobElementPath = path;
    }

    private CIMObjectPath getAffectedJobElementPath() {
        return this.affectedJobElementPath;
    }

    private List getJobList() {
        return this.jobList;
    }

    private List getEarlyNotifications() {
        return this.earlyNotifications;
    }

    DspJobCreateLuns(ArrayObject dsp) {
        super(dsp);
        String METHOD = "Constructor";
        Trace.methodBegin((Object)this, (String)"Constructor");
        this.setCimConcreteJobSubclass(JOB_CLASS);
        this.setCimDescription(CREATE_DESCRIPTION);
        this.setCimJobName(CREATE_LUNS_NAME);
        dsp.getDspChangeListener().addPropertyChangeListener(this, "asynchNewDisk");
        Trace.methodEnd((Object)this, (String)"Constructor");
    }

    public synchronized CIMObjectPath createCimJob(String nameSpace, CIMObjectPath configurationService, Vector affectedElements) throws CIMException {
        String METHOD = "createCimJob";
        Trace.methodBegin((Object)this, (String)"createCimJob");
        CIMObjectPath path = super.createCimJob(nameSpace, configurationService, affectedElements);
        Trace.info((Object)this, (String)"createCimJob", (String)" Saving values for vdisks associations");
        this.setNameSpace(nameSpace);
        this.setConfigurationService(configurationService);
        if (affectedElements != null && !affectedElements.isEmpty()) {
            CIMObjectPath pool = (CIMObjectPath)affectedElements.firstElement();
            this.setStoragePool(pool);
        } else {
            Trace.error((Object)this, (String)"createCimJob", (String)" *** NO STORAGE POOL to save ***");
        }
        Trace.methodEnd((Object)this, (String)"createCimJob");
        return path;
    }

    public synchronized void resynchWithCimCache() {
        String METHOD = "resynchWithCimCache";
        Trace.info((Object)this, (String)"resynchWithCimCache", (String)(" " + this.getCimJobId() + " Begin "));
        super.resynchWithCimCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void kill() {
        String METHOD = "kill";
        Trace.info((Object)this, (String)"kill", (String)(" " + this.getCimJobId() + " Begin "));
        super.kill();
        List list = this.getJobList();
        synchronized (list) {
            Iterator it = this.getJobList().iterator();
            while (it.hasNext()) {
                LunCreationJob job = (LunCreationJob)it.next();
                Trace.info((Object)this, (String)"kill", (String)(" " + this.getCimJobId() + " Killing job for LUN " + job.getLunWwn()));
                job.kill();
            }
        }
        this.cleanUpJob();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteJob() {
        String METHOD = "deleteJob";
        Trace.info((Object)this, (String)"deleteJob", (String)(" " + this.getCimJobId() + " Begin "));
        List list = this.getJobList();
        synchronized (list) {
            Iterator it = this.getJobList().iterator();
            while (it.hasNext()) {
                LunCreationJob job = (LunCreationJob)it.next();
                Trace.info((Object)this, (String)"deleteJob", (String)(" " + this.getCimJobId() + " Deleting job for LUN " + job.getLunWwn()));
                job.delete();
            }
        }
        super.deleteJob();
    }

    public void checkForJobCompletion() {
        String METHOD = "checkForJobCompletion";
        Trace.methodBegin((Object)this, (String)"checkForJobCompletion");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveNewLunAssociations() {
        Object it;
        String METHOD = "saveNewLunAssociations";
        Trace.methodBegin((Object)this, (String)"saveNewLunAssociations");
        String nameSpace = this.getNameSpace();
        CIMObjectPath configurationService = this.getConfigurationService();
        CIMObjectPath storagePool = this.getStoragePool();
        boolean canPersistLunConfig = false;
        if (nameSpace == null || configurationService == null || storagePool == null) {
            Trace.info((Object)this, (String)"saveNewLunAssociations", (String)(" " + this.getCimJobId() + " Config not set yet"));
            return;
        }
        String jobId = this.getCimJobId();
        if (jobId == null) {
            jobId = new String(" no job ID");
        }
        boolean done = true;
        Object object = this.getJobList();
        synchronized (object) {
            it = this.getJobList().iterator();
            while (it.hasNext()) {
                LunCreationJob job = (LunCreationJob)it.next();
                if (job.getLunWwn() == null || job.isLunConfigPersisted()) continue;
                Trace.info((Object)this, (String)"saveNewLunAssociations", (String)(" " + this.getCimJobId() + " Need to persist info for T4 jobs for lun " + job.getLunWwn()));
                done = false;
            }
        }
        Trace.info((Object)this, (String)"saveNewLunAssociations", (String)" Getting ModifyBroker lock ");
        object = ModifyBroker.getInstance();
        synchronized (object) {
            Trace.info((Object)this, (String)"saveNewLunAssociations", (String)"     got ModifyBroker lock ");
            while (!done) {
                Trace.info((Object)this, (String)"saveNewLunAssociations", (String)" Trying for cache lock ");
                if (ModifyBroker.setCacheUpdateOwner("Job " + jobId)) {
                    Trace.info((Object)this, (String)"saveNewLunAssociations", (String)"   Got cache lock ");
                    it = this.getJobList();
                    synchronized (it) {
                        Iterator it2 = this.getJobList().iterator();
                        while (it2.hasNext()) {
                            LunCreationJob job = (LunCreationJob)it2.next();
                            if (job.getLunWwn() == null || job.isLunConfigPersisted()) continue;
                            Trace.info((Object)this, (String)"saveNewLunAssociations", (String)(" " + this.getCimJobId() + " Persisting info for T4 jobs for lun " + job.getLunWwn()));
                            try {
                                job.persistLunConfig(this.getNameSpace(), this.getDspName(), this.getConfigurationService(), this.getStoragePool());
                            }
                            catch (Exception e) {}
                        }
                    }
                    ModifyBroker.clearCacheUpdateOwner(false, false);
                    done = true;
                    continue;
                }
                Trace.info((Object)this, (String)"saveNewLunAssociations", (String)"   Didn't get lock.  Sleeping for 10 seconds");
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception lockSleepEx) {
                    Trace.info((Object)this, (String)"saveNewLunAssociations", (String)"   Sleep interrupted - continuing");
                }
            }
            Trace.info((Object)this, (String)"saveNewLunAssociations", (String)" Giving back ModifyBroker lock ");
        }
        Trace.methodEnd((Object)this, (String)"saveNewLunAssociations");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List getExtents() {
        String METHOD = "getExtents";
        Trace.methodBegin((Object)this, (String)"getExtents");
        ArrayList<CIMInstance> list = new ArrayList<CIMInstance>();
        List list2 = this.getJobList();
        synchronized (list2) {
            Iterator it = this.getJobList().iterator();
            while (it.hasNext()) {
                LunCreationJob job = (LunCreationJob)it.next();
                CIMInstance extent = job.getExtent();
                if (extent == null) continue;
                list.add(extent);
            }
        }
        Trace.info((Object)this, (String)"getExtents", (String)(" " + this.getCimJobId() + " Returning list of " + list.size() + " elements "));
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List getLunToPoolAssociations() {
        String METHOD = "getLunToPoolAssociations";
        Trace.methodBegin((Object)this, (String)"getLunToPoolAssociations");
        ArrayList<CIMInstance> list = new ArrayList<CIMInstance>();
        List list2 = this.getJobList();
        synchronized (list2) {
            Iterator it = this.getJobList().iterator();
            while (it.hasNext()) {
                LunCreationJob job = (LunCreationJob)it.next();
                CIMInstance assoc = job.getLunToPoolAssociation();
                if (assoc == null) continue;
                list.add(assoc);
            }
        }
        Trace.info((Object)this, (String)"getLunToPoolAssociations", (String)(" " + this.getCimJobId() + " Returning list of " + list.size() + " elements "));
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void updatePercentComplete() {
        String METHOD = "updatePercentComplete";
        Trace.methodBegin((Object)this, (String)"updatePercentComplete");
        int currentPercentComplete = this.getPercentComplete();
        if (currentPercentComplete != 100) {
            Trace.info((Object)this, (String)"updatePercentComplete", (String)(" " + this.getCimJobId() + " Should have " + this.getNumJobs() + " T4 jobs"));
            Trace.info((Object)this, (String)"updatePercentComplete", (String)(" " + this.getCimJobId() + " Currently have  " + this.getJobList().size() + " T4 jobs"));
            int subjobTotalPercent = 0;
            int subjobTotalErrors = 0;
            int unwiredCount = 0;
            List list = this.getJobList();
            synchronized (list) {
                Iterator it = this.getJobList().iterator();
                while (it.hasNext()) {
                    LunCreationJob job = (LunCreationJob)it.next();
                    Trace.info((Object)this, (String)"updatePercentComplete", (String)(" " + this.getCimJobId() + " Examining LUN " + job.getLunWwn()));
                    if (job.getPercentComplete() != 100) {
                        job.updatePercentComplete();
                    }
                    subjobTotalPercent += job.getPercentComplete();
                    Trace.info((Object)this, (String)"updatePercentComplete", (String)(" " + this.getCimJobId() + "     LUN percent complete =  " + job.getPercentComplete() + "%"));
                    if (job.isJobFailed()) {
                        ++subjobTotalErrors;
                        Trace.info((Object)this, (String)"updatePercentComplete", (String)(" " + this.getCimJobId() + "    Job failed for  LUN " + job.getLunWwn()));
                    }
                    if (job.isJobFailed() || job.isWired()) continue;
                    ++unwiredCount;
                }
            }
            int newPercentComplete = 0;
            if (this.getJobList().size() == 0) {
                Trace.info((Object)this, (String)"updatePercentComplete", (String)(" " + this.getCimJobId() + " No T4 jobs yet - percent complete = 0%"));
            } else {
                newPercentComplete = subjobTotalPercent / this.getNumJobs();
                Trace.info((Object)this, (String)"updatePercentComplete", (String)(" Average percent complete of subjobs = " + newPercentComplete + "%"));
                Trace.info((Object)this, (String)"updatePercentComplete", (String)(" Subtracting " + unwiredCount + "% for unwired jobs"));
                if ((newPercentComplete -= unwiredCount) < 0) {
                    newPercentComplete = 0;
                }
                Trace.info((Object)this, (String)"updatePercentComplete", (String)(" " + this.getCimJobId() + " Percent complete = " + newPercentComplete + "% for " + this.getNumJobs() + " jobs"));
            }
            if (newPercentComplete > currentPercentComplete) {
                this.setPercentComplete(newPercentComplete);
            } else if (currentPercentComplete < 8) {
                this.setPercentComplete(currentPercentComplete + 2);
            }
            this.setNumErrors(subjobTotalErrors);
            Trace.info((Object)this, (String)"updatePercentComplete", (String)(" " + this.getCimJobId() + " Number of failed jobs = " + subjobTotalErrors));
        }
    }

    public void startPolling() {
        String METHOD = "startPolling";
        Trace.methodBegin((Object)this, (String)"startPolling");
        new Thread(this).start();
    }

    public synchronized void setNumRaidSets(int numberOfJobs) throws Exception {
        String METHOD = "setNumRaidSets";
        Trace.methodBegin((Object)this, (String)"setNumRaidSets");
        if (!this.getJobList().isEmpty()) {
            Trace.info((Object)this, (String)"setNumRaidSets", (String)(" Job " + this.getCimJobId() + " *** Error: DspJobCreateLuns.setNumRaidSets - Can't resize after adding jobs"));
            throw new Exception("Can't resize after adding jobs");
        }
        this.setNumJobs(numberOfJobs);
        Trace.info((Object)this, (String)"setNumRaidSets", (String)(" Job " + this.getCimJobId() + " Entering DspJobCreateLuns.setNumRaidSets to " + numberOfJobs));
    }

    public synchronized int getNumRaidSets() {
        return this.getNumJobs();
    }

    public synchronized void addRaidSet(String lunWwn, CIMObjectPath jobPath) throws Exception {
        String METHOD = "addRaidSet";
        String newWwnName = lunWwn.substring(8);
        Trace.methodBegin((Object)this, (String)"addRaidSet");
        Trace.info((Object)this, (String)"addRaidSet", (String)(" " + this.getCimJobId() + " T4 passed in LUN name = " + lunWwn));
        Trace.info((Object)this, (String)"addRaidSet", (String)(" " + this.getCimJobId() + " Actual LUN name = " + newWwnName));
        if (this.getNumJobs() <= this.getJobList().size()) {
            throw new Exception("Max size exceeded");
        }
        LunCreationJob newJob = new LunCreationJob(newWwnName, jobPath);
        this.getJobList().add(newJob);
        if (this.isKilled()) {
            Trace.info((Object)this, (String)"addRaidSet", (String)" Adding raid set to killed job ");
            newJob.kill();
            return;
        }
        String newWwnWithColons = new String(DspUtil.addColonsToWWN(newWwnName));
        if (this.alreadyNotified(newWwnWithColons)) {
            ManualInit initThread = new ManualInit(newWwnWithColons);
            new Thread((Runnable)initThread, "ManualInit for " + newWwnWithColons).start();
        }
        Trace.methodEnd((Object)this, (String)"addRaidSet");
    }

    public synchronized void addFailedRaidSet(int errorCode, Object context) throws Exception {
        String METHOD = "addFailedRaidSet";
        Trace.methodBegin((Object)this, (String)"addFailedRaidSet");
        if (this.getNumJobs() <= this.getJobList().size()) {
            throw new Exception("Max size exceeded");
        }
        if (errorCode == 2) {
            this.setCimDescription(CREATE_BAD_DISK_ERROR_DESCRIPTION);
            if (context != null) {
                List diskList = (List)context;
                StringBuffer diskDesc = new StringBuffer();
                if (diskList != null && diskList.size() > 0) {
                    diskDesc.append(diskList.get(0).toString());
                    if (diskList.size() > 1) {
                        diskDesc.append("-");
                        diskDesc.append(diskList.get(diskList.size() - 1));
                    }
                }
                this.setCimDescription("CreatingVdisksBadDiskError:" + diskDesc.toString());
            }
        }
        LunCreationJob newJob = new LunCreationJob();
        newJob.setPercentComplete(100);
        newJob.setJobFailed(true);
        newJob.setArrayError(true);
        this.getJobList().add(newJob);
        this.setNumErrors(this.getNumErrors() + 1);
        Trace.info((Object)this, (String)"addFailedRaidSet", (String)(" " + this.getCimJobId() + " Failed job added "));
        Trace.methodEnd((Object)this, (String)"addFailedRaidSet");
    }

    private void addLunToEarlyNotifications(String wwn) {
        String METHOD = "addLunToEarlyNotifications";
        Trace.methodBegin((Object)this, (String)"addLunToEarlyNotifications");
        Trace.info((Object)this, (String)"addLunToEarlyNotifications", (String)(" Adding WWN " + wwn + " to list"));
        this.getEarlyNotifications().add(wwn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean alreadyNotified(String wwn) {
        String METHOD = "alreadyNotified";
        Trace.info((Object)this, (String)"alreadyNotified", (String)(" " + this.getCimJobId() + " Checking to see if DSP already notified us about LUN " + wwn));
        List list = this.getEarlyNotifications();
        synchronized (list) {
            Iterator it = this.getEarlyNotifications().iterator();
            while (it.hasNext()) {
                String nextLun = (String)it.next();
                Trace.info((Object)this, (String)"alreadyNotified", (String)(" " + this.getCimJobId() + "     Checking against LUN " + nextLun));
                if (!nextLun.equals(wwn)) continue;
                Trace.info((Object)this, (String)"alreadyNotified", (String)(" " + this.getCimJobId() + " DSP did already notify us about LUN " + wwn));
                return true;
            }
        }
        Trace.info((Object)this, (String)"alreadyNotified", (String)(" " + this.getCimJobId() + " DSP did not already notify us about LUN " + wwn));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String METHOD = "run";
        Trace.methodBegin((Object)this, (String)"run");
        String jobId = this.getCimJobId();
        int percentComplete = 0;
        while (this.getPercentComplete() != 100 && !this.isKilled()) {
            try {
                Trace.info((Object)this, (String)"run", (String)(" " + jobId + " Updating percent complete for jobs"));
                this.updatePercentComplete();
            }
            catch (Exception percentException) {
                Trace.info((Object)this, (String)(" " + jobId + " Took exception calculating percentComplete "), (Throwable)percentException);
                percentComplete = 100;
            }
            try {
                Trace.info((Object)this, (String)"run", (String)(" " + jobId + " Saving new LUN associations "));
                this.saveNewLunAssociations();
            }
            catch (Exception saveException) {
                Trace.info((Object)this, (String)(" " + jobId + " Took exception saving associations "), (Throwable)saveException);
            }
            try {
                Trace.info((Object)this, (String)"run", (String)(" " + jobId + " Sleeping for " + 60 + " seconds"));
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                Trace.info((Object)this, (String)"run", (String)(" " + jobId + " Received InterruptedException"));
            }
        }
        int initializedDisks = 0;
        int arrayErrors = 0;
        int initErrors = 0;
        List list = this.getJobList();
        synchronized (list) {
            Iterator it = this.getJobList().iterator();
            while (it.hasNext()) {
                LunCreationJob job = (LunCreationJob)it.next();
                if (job.isArrayError()) {
                    ++arrayErrors;
                }
                if (job.isInitError()) {
                    ++initErrors;
                }
                if (!job.isWired() || job.isArrayError() || job.isInitError() || job.isJobFailed()) continue;
                ++initializedDisks;
            }
        }
        String completionStatus = new String(CREATED + initializedDisks + VDISKS_AND_ENCOUNTERED + arrayErrors + ARRAY_ERRORS + initErrors + INIT_ERRORS);
        if (arrayErrors + initErrors > 0) {
            Trace.info((Object)this, (String)"run", (String)(" Setting completion to ERROR with status = " + completionStatus));
            this.setCompletion(6, completionStatus, true);
        } else {
            Trace.info((Object)this, (String)"run", (String)(" Setting completion to OK with status = " + completionStatus));
            this.setCompletion(3, completionStatus, true);
        }
        this.cleanUpJob();
        Trace.info((Object)this, (String)"run", (String)(" " + jobId + " Polling complete "));
        Trace.info((Object)this, (String)"run", (String)(" " + jobId + " End "));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void propertyChange(PropertyChangeEvent e) {
        String METHOD = "propertyChange";
        Trace.methodBegin((Object)this, (String)"propertyChange");
        Trace.info((Object)this, (String)"propertyChange", (String)" Getting ModifyBroker lock ");
        ModifyBroker modifyBroker = ModifyBroker.getInstance();
        synchronized (modifyBroker) {
            Trace.info((Object)this, (String)"propertyChange", (String)"     got ModifyBroker lock ");
            Trace.info((Object)this, (String)"propertyChange", (String)" Performing synchronized property change action(s) ");
            this.doPropertyChangeWork(e);
            Trace.info((Object)this, (String)"propertyChange", (String)" Giving back ModifyBroker lock ");
        }
        Trace.methodEnd((Object)this, (String)"propertyChange");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPropertyChangeWork(PropertyChangeEvent e) {
        String METHOD = "doPropertyChangeWork";
        Trace.methodBegin((Object)this, (String)"doPropertyChangeWork");
        DspRapidMark rm = (DspRapidMark)e.getSource();
        String newValue = e.getNewValue().toString();
        Trace.warn((Object)this, (String)"doPropertyChangeWork", (String)(" " + this.getCimJobId() + " Property changed.  RM = " + rm.getName() + ", new value = " + newValue));
        boolean found = false;
        List list = this.getJobList();
        synchronized (list) {
            Iterator it = this.getJobList().iterator();
            while (it.hasNext() && !found) {
                LunCreationJob job = (LunCreationJob)it.next();
                String fullLunName = job.getLunWwn();
                boolean initSucceeded = false;
                if (fullLunName != null) {
                    fullLunName = new String(DspUtil.addColonsToWWN(fullLunName));
                }
                Trace.error((Object)this, (String)"doPropertyChangeWork", (String)(" " + this.getCimJobId() + " Checking LunCreationJob for LUN = " + fullLunName + " for a match"));
                if (fullLunName == null || !fullLunName.equals(newValue)) continue;
                Trace.info((Object)this, (String)"doPropertyChangeWork", (String)(" " + this.getCimJobId() + " Found our job"));
                found = true;
                job.setPercentComplete(100);
                job.setJobFailed(false);
                this.saveNewLunAssociations();
                try {
                    Trace.info((Object)this, (String)"doPropertyChangeWork", (String)(" " + this.getCimJobId() + " Sleeping for " + 30 + " seconds"));
                    Thread.sleep(30000L);
                }
                catch (Exception sleep1) {
                    // empty catch block
                }
                Trace.info((Object)this, (String)"doPropertyChangeWork", (String)(" " + this.getCimJobId() + " Initializing LUN " + newValue));
                Vector<String> nvPairs = new Vector<String>();
                nvPairs.add(new String("samDisk_setCurrent=" + fullLunName));
                DspResults initResults = null;
                try {
                    initResults = DevComm.getInstance().postWithDspResults(this.getDsp(), LUN_INIT_PAGE, nvPairs);
                    initSucceeded = initResults.requestSucceeded();
                }
                catch (Exception initEx) {
                    // empty catch block
                }
                try {
                    Trace.info((Object)this, (String)"doPropertyChangeWork", (String)(" " + this.getCimJobId() + " Sleeping for " + 30 + " seconds"));
                    Thread.sleep(30000L);
                }
                catch (Exception sleep2) {
                    // empty catch block
                }
                if (!initSucceeded) {
                    job.setInitError(true);
                    job.cleanT4VolSlice();
                    job.setWired();
                    Trace.error((Object)this, (String)"doPropertyChangeWork", (String)(" " + this.getCimJobId() + " Initialization failed for LUN " + newValue));
                    try {
                        String[] logArgs = new String[]{fullLunName, this.getDsp().getHost()};
                        LogAPI.staticLog((String)"DSP_VDISK_INIT_FAILED", (String[])logArgs, null);
                    }
                    catch (Exception logEx) {
                        // empty catch block
                    }
                    return;
                }
                DspPropertyNewDisk listener = new DspPropertyNewDisk(this.getDsp(), "New LUN " + newValue, false);
                listener.propertyChange(e);
                job.setWired();
                try {
                    Trace.info((Object)this, (String)"doPropertyChangeWork", (String)(" " + this.getCimJobId() + " Recalculating pool size"));
                    ModifySunStorEdge_DSPStoragePool.calculatePoolSize(this.getStoragePool());
                }
                catch (Exception spaceCalcEx) {
                    Trace.error((Object)this, (String)"doPropertyChangeWork", (String)" Took exception recalculating pool size");
                }
                try {
                    String[] logArgs = new String[]{fullLunName, this.getDsp().getHost()};
                    LogAPI.staticLog((String)"DSP_VDISK_INIT", (String[])logArgs, null);
                }
                catch (Exception logEx) {}
            }
        }
        if (!found) {
            Trace.info((Object)this, (String)"doPropertyChangeWork", (String)(" " + this.getCimJobId() + " Not our job"));
            this.addLunToEarlyNotifications(newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cleanUpJob() {
        String METHOD = "cleanUpJob";
        Trace.methodBegin((Object)this, (String)"cleanUpJob");
        if (this.isKilled()) {
            Trace.info((Object)this, (String)"cleanUpJob", (String)(" " + this.getCimJobId() + " Skipping sanity checks as we clean up this job"));
        } else {
            int jobsWeKnowAbout;
            Trace.info((Object)this, (String)"cleanUpJob", (String)(" " + this.getCimJobId() + " Doing sanity checks as we clean up this job"));
            int jobsTotal = this.getNumJobs();
            if (jobsTotal == 0) {
                Trace.error((Object)this, (String)"cleanUpJob", (String)(" " + this.getCimJobId() + " Have not been notified about any T4 jobs yet - not done"));
            }
            if ((jobsWeKnowAbout = this.getJobList().size()) != jobsTotal) {
                Trace.error((Object)this, (String)"cleanUpJob", (String)(" " + this.getCimJobId() + " Only have information on " + jobsWeKnowAbout + " jobs out of " + jobsTotal + " jobs total - not done"));
            }
            List list = this.getJobList();
            synchronized (list) {
                Iterator itDone = this.getJobList().iterator();
                while (itDone.hasNext()) {
                    LunCreationJob job = (LunCreationJob)itDone.next();
                    if (job.getPercentComplete() != 100) {
                        Trace.error((Object)this, (String)"cleanUpJob", (String)(" " + this.getCimJobId() + " T4 job for LUN " + job.getLunWwn() + " is not done"));
                        continue;
                    }
                    if (job.isJobFailed() || job.isWired()) continue;
                    Trace.error((Object)this, (String)"cleanUpJob", (String)(" " + this.getCimJobId() + " Found a job done, but not wired"));
                }
            }
        }
        Trace.info((Object)this, (String)"cleanUpJob", (String)(" " + this.getCimJobId() + " All jobs done - unregistering the change listener"));
        this.getDsp().getDspChangeListener().removePropertyChangeListener(this, "asynchNewDisk");
        if (this.getDeleteOnCompletion()) {
            this.deleteJob();
        }
    }

    private class ManualInit
    implements Runnable {
        private static final String CLASSNAME = "DspJobCreateLuns.ManualInit";
        private static final String MANUAL_MARK = "ManualDiskInit";
        private static final String MANUAL_MARK_VALUE = "ManualDiskInit";
        private static final String DONT_CARE = "Unknown";
        private String wwn;

        void setWwn(String newWwn) {
            this.wwn = newWwn;
        }

        String getWwn() {
            return this.wwn;
        }

        ManualInit(String wwn) {
            String METHOD = "Constructor";
            Trace.info((Object)this, (String)"Constructor", (String)(" Created to initialize " + wwn));
            this.setWwn(wwn);
        }

        public void run() {
            String METHOD = "run";
            Trace.methodBegin((Object)this, (String)"run");
            Trace.info((Object)this, (String)"run", (String)(" " + DspJobCreateLuns.this.getCimJobId() + " Manually persisting associations and firing propertyChange for LUN = " + this.getWwn()));
            DspJobCreateLuns.this.saveNewLunAssociations();
            try {
                Trace.info((Object)this, (String)"run", (String)(" " + DspJobCreateLuns.this.getCimJobId() + " Sleeping for " + 30 + " seconds before manually initing " + this.getWwn()));
                Thread.sleep(30000L);
            }
            catch (InterruptedException e) {
                Trace.info((Object)this, (String)"run", (String)(" " + DspJobCreateLuns.this.getCimJobId() + " Received InterruptedException"));
            }
            Trace.info((Object)this, (String)"run", (String)(" " + DspJobCreateLuns.this.getCimJobId() + " Manually initializing " + this.getWwn()));
            DspRapidMark newMark = new DspRapidMark("ManualDiskInit", "ManualDiskInit");
            PropertyChangeEvent manualEvent = new PropertyChangeEvent(newMark, "asynchNewDisk", DONT_CARE, this.getWwn());
            DspJobCreateLuns.this.propertyChange(manualEvent);
            Trace.info((Object)this, (String)"run", (String)(" " + DspJobCreateLuns.this.getCimJobId() + " Manual initialization complete for " + this.getWwn()));
        }
    }

    private class LunCreationJob {
        private static final String CLASSNAME = "DspJobCreateLuns.LunCreationJob";
        private static final String PERCENT_COMPLETE = "PercentComplete";
        private static final String EXTENT_CLASS = "SunStorEdge_DSPStorageExtent";
        private static final String SYS_CR_CLASS_NAME = "SunStorEdge_DSPStorageSystem";
        private static final String CR_CLASS_NAME = "SunStorEdge_DSPStorageExtent";
        private static final int MAX_POLLING_ERRORS = 100;
        String lunWwn;
        CIMObjectPath jobId;
        int percentComplete;
        boolean jobFailed;
        boolean arrayError;
        boolean initError;
        boolean lunConfigPersisted;
        CIMInstance extent;
        CIMInstance lunToPoolAssociation;
        boolean wired;

        String getLunWwn() {
            return this.lunWwn;
        }

        void setPercentComplete(int percent) {
            this.percentComplete = percent;
        }

        int getPercentComplete() {
            return this.percentComplete;
        }

        void setJobFailed(boolean flag) {
            this.jobFailed = flag;
        }

        boolean isJobFailed() {
            return this.jobFailed;
        }

        void setArrayError(boolean flag) {
            this.arrayError = flag;
        }

        boolean isArrayError() {
            return this.arrayError;
        }

        void setInitError(boolean flag) {
            this.initError = flag;
        }

        boolean isInitError() {
            return this.initError;
        }

        void setLunConfigPersisted() {
            this.lunConfigPersisted = true;
        }

        boolean isLunConfigPersisted() {
            return this.lunConfigPersisted;
        }

        void setExtent(CIMInstance newExtent) {
            this.extent = newExtent;
        }

        CIMInstance getExtent() {
            return this.extent;
        }

        void setLunToPoolAssociation(CIMInstance assoc) {
            this.lunToPoolAssociation = assoc;
        }

        CIMInstance getLunToPoolAssociation() {
            return this.lunToPoolAssociation;
        }

        void setWired() {
            this.wired = true;
            SunStorEdge_DSPPersistenceManager mgr = SunStorEdge_DSPPersistenceManager.getInstance();
            mgr.removeObsoleteInstance(this.getLunToPoolAssociation());
            this.setLunToPoolAssociation(null);
        }

        boolean isWired() {
            return this.wired;
        }

        LunCreationJob() {
            String METHOD = "Base Constructor";
            Trace.methodBegin((Object)this, (String)"Base Constructor");
            this.lunWwn = null;
            this.jobId = null;
            this.percentComplete = 0;
            this.jobFailed = false;
            this.arrayError = false;
            this.initError = false;
            this.lunConfigPersisted = false;
            this.lunToPoolAssociation = null;
            this.wired = false;
            Trace.methodEnd((Object)this, (String)"Base Constructor");
        }

        LunCreationJob(String wwn, CIMObjectPath job) {
            this();
            String METHOD = "String/Job Constructor";
            Trace.methodBegin((Object)this, (String)"String/Job Constructor");
            this.lunWwn = wwn;
            if (job != null) {
                job.setNameSpace("\\root\\se6x20\\");
            }
            this.jobId = job;
            Trace.methodEnd((Object)this, (String)"String/Job Constructor");
        }

        void updatePercentComplete() {
            String METHOD = "updatePercentComplete";
            Trace.methodBegin((Object)this, (String)"updatePercentComplete");
            Trace.info((Object)this, (String)"updatePercentComplete", (String)("    Lun WWN = " + this.lunWwn));
            if (this.percentComplete == 100) {
                Trace.info((Object)this, (String)"updatePercentComplete", (String)"    6120 job percent compete = 100%");
                return;
            }
            JobInterface job = this.getLunJob();
            if (job == null) {
                Trace.info((Object)this, (String)"updatePercentComplete", (String)"   6120 job not found. Assume completed");
                this.setPercentComplete(100);
                return;
            }
            if (job.isActive()) {
                this.setPercentComplete(job.getPercentComplete());
                Trace.info((Object)this, (String)"updatePercentComplete", (String)("    6120 job percent compete = " + this.getPercentComplete() + "%"));
            } else {
                this.setPercentComplete(100);
                Trace.info((Object)this, (String)"updatePercentComplete", (String)"    6120 job not active.  Assume completed");
                if (job.getStatus() == Constants.JobProperties.JOB_STATUS_OK_DONE) {
                    this.setJobFailed(false);
                    Trace.info((Object)this, (String)"updatePercentComplete", (String)"    6120 job completed successfully");
                } else {
                    this.setJobFailed(true);
                    Trace.info((Object)this, (String)"updatePercentComplete", (String)"    6120 job completed with status != OK");
                    this.cleanT4VolSlice();
                }
            }
        }

        void delete() {
            String METHOD = "delete";
            Trace.methodBegin((Object)this, (String)"delete");
            Trace.info((Object)this, (String)"delete", (String)("    Lun WWN = " + this.lunWwn));
            JobInterface job = this.getLunJob();
            if (job == null) {
                Trace.info((Object)this, (String)"delete", (String)"   6120 job not found. Assume completed");
                return;
            }
            try {
                job.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void kill() {
            String METHOD = "kill";
            Trace.methodBegin((Object)this, (String)"kill");
            Trace.info((Object)this, (String)"kill", (String)("    Lun WWN = " + this.lunWwn));
            boolean canKill = true;
            JobInterface job = this.getLunJob();
            if (job == null) {
                Trace.info((Object)this, (String)"kill", (String)"   6120 job not found. Assume completed");
                canKill = false;
            }
            if (this.getPercentComplete() == 100) {
                Trace.info((Object)this, (String)"kill", (String)"   6120 job already complete");
                canKill = false;
            }
            if (canKill) {
                try {
                    job.kill();
                    this.setJobFailed(true);
                    Trace.info((Object)this, (String)"kill", (String)" Job killed ");
                }
                catch (Exception e) {
                    Trace.info((Object)this, (String)"kill", (String)" Could not kill job - cleaning slices ");
                    this.cleanT4VolSlice();
                }
            } else if (!this.isWired()) {
                Trace.info((Object)this, (String)"kill", (String)" Removing unwired vollume/slices");
                this.cleanT4VolSlice();
            } else {
                Trace.info((Object)this, (String)"kill", (String)" LUN already wired - NOT removing vdisk");
            }
        }

        JobInterface getLunJob() {
            String METHOD = "getLunJob";
            JobInterface job = null;
            if (this.jobId == null) {
                Trace.error((Object)this, (String)"getLunJob", (String)" Lun creation job with null jobId!");
                return null;
            }
            ConfigContext context = new ConfigContext((CIMOMHandleWrapper)new ProviderToBOLConnection("\\root\\se6x20\\"));
            JobManager jobMgr = new JobManager();
            try {
                jobMgr.init(context, null);
                job = jobMgr.get(this.jobId, null);
            }
            catch (Exception e) {
                Trace.error((Object)this, (String)(" Unable to get Lun job for jobId " + this.jobId), (Throwable)e);
                return null;
            }
            return job;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void persistLunConfig(String nameSpace, String systemName, CIMObjectPath configurationService, CIMObjectPath storagePool) throws CIMException {
            CIMClass extentClass = null;
            CIMInstance newExtent = null;
            CIMProperty property = null;
            CIMObjectPath extentPath = null;
            String METHOD = "persistLunConfig";
            Trace.methodBegin((Object)this, (String)"persistLunConfig");
            if (this.isLunConfigPersisted()) {
                Trace.info((Object)this, (String)"persistLunConfig", (String)" Already persisted.  Nothing to do. ");
                return;
            }
            CIMObjectPath tmp = new CIMObjectPath("SunStorEdge_DSPStorageExtent");
            tmp.setNameSpace(nameSpace);
            extentClass = SunStorEdge_DSPProvider.cimom.getClass(tmp, false, true, true, null);
            if (extentClass == null) {
                Trace.error((Object)this, (String)"persistLunConfig", (String)" Unable to get StorageExtent Class. ");
                CIMException tmpe = new CIMException("CIM_ERR_FAILED");
                tmpe.setDescription("Internal error: Failed getClass.");
                throw tmpe;
            }
            newExtent = extentClass.newInstance();
            newExtent.setProperty("SystemCreationClassName", new CIMValue((Object)SYS_CR_CLASS_NAME));
            property = newExtent.getProperty("SystemCreationClassName");
            property.setOriginClass("CIM_LogicalDevice");
            newExtent.setProperty("SystemName", new CIMValue((Object)systemName));
            property = newExtent.getProperty("SystemName");
            property.setOriginClass("CIM_LogicalDevice");
            newExtent.setProperty("CreationClassName", new CIMValue((Object)"SunStorEdge_DSPStorageExtent"));
            property = newExtent.getProperty("CreationClassName");
            property.setOriginClass("CIM_LogicalDevice");
            newExtent.setProperty("DeviceID", new CIMValue((Object)this.lunWwn));
            property = newExtent.getProperty("DeviceID");
            property.setOriginClass("CIM_LogicalDevice");
            this.setExtent(newExtent);
            extentPath = newExtent.getObjectPath();
            try {
                SunStorEdge_DSPPersistenceManager mgr;
                SunStorEdge_DSPPersistenceManager sunStorEdge_DSPPersistenceManager = mgr = SunStorEdge_DSPPersistenceManager.getInstance();
                synchronized (sunStorEdge_DSPPersistenceManager) {
                    CIMObjectPath concreteComponentPath = new CIMObjectPath("SunStorEdge_DSPConcreteComponent");
                    concreteComponentPath.setNameSpace("\\root\\se6x20\\");
                    CIMObjectPath[] concreteComponentRefNames = RequestBroker.getInstance().referenceNames(concreteComponentPath, extentPath, "PartComponent");
                    if (null != concreteComponentRefNames) {
                        RequestBroker rb = RequestBroker.getInstance();
                        for (int i = 0; i < concreteComponentRefNames.length; ++i) {
                            if (!rb.isSyntheticCacheInstance(concreteComponentRefNames[i])) continue;
                            rb.deleteSyntheticCacheInstance(concreteComponentRefNames[i]);
                        }
                    }
                    CIMInstance assoc = ModifySunStorEdge_DSPStorageConfigurationService.associateExtentWithPool(nameSpace, storagePool, extentPath);
                    this.setLunToPoolAssociation(assoc);
                    mgr.addNewInstance(this.getLunToPoolAssociation());
                    this.setLunConfigPersisted();
                    Trace.info((Object)this, (String)"persistLunConfig", (String)(" Lun config persisted for  " + this.getLunWwn()));
                }
            }
            catch (Exception e) {
                Trace.info((Object)this, (String)"persistLunConfig", (String)("Unable to persist LUN config for LUN " + this.getLunWwn()));
            }
            Trace.methodEnd((Object)this, (String)"persistLunConfig");
        }

        private void cleanT4VolSlice() {
            String METHOD = "cleanT4VolSlice";
            Trace.methodBegin((Object)this, (String)"cleanT4VolSlice");
            String lun = this.getLunWwn();
            String jobId = DspJobCreateLuns.this.getCimJobId();
            if (lun == null) {
                Trace.info((Object)this, (String)"cleanT4VolSlice", (String)(" " + jobId + " Can't clean up - lun WWN is NULL"));
                return;
            }
            Trace.info((Object)this, (String)"cleanT4VolSlice", (String)(" " + jobId + " Creating thread to clean up slice " + lun));
            SliceCleanup cleanupTask = new SliceCleanup(lun, jobId, DspJobCreateLuns.this.getDsp(), this.getExtent());
            new Thread((Runnable)cleanupTask, "SliceCleanup for " + lun).start();
            Trace.methodEnd((Object)this, (String)"cleanT4VolSlice");
        }
    }

    private class SliceCleanup
    implements Runnable {
        private static final String CLASSNAME = "DspJobCreateLuns.SliceCleanup";
        private static final String RESCAN_PAGE = "response.xml";
        private static final String RESCAN_RM = "sysDoRescan";
        private String wwn;
        private String jobId;
        private CIMInstance extent;
        private ArrayObject dsp;

        void setWwn(String newWwn) {
            this.wwn = newWwn;
        }

        String getWwn() {
            return this.wwn;
        }

        void setJobId(String newJobId) {
            this.jobId = newJobId;
        }

        String getJobId() {
            return this.jobId;
        }

        void setExtent(CIMInstance newExtent) {
            this.extent = newExtent;
        }

        CIMInstance getExtent() {
            return this.extent;
        }

        void setDsp(ArrayObject newDsp) {
            this.dsp = newDsp;
        }

        ArrayObject getDsp() {
            return this.dsp;
        }

        SliceCleanup(String wwn, String jobId, ArrayObject dsp, CIMInstance extent) {
            String METHOD = "Constructor";
            Trace.info((Object)this, (String)"Constructor", (String)(" Created to clean up " + wwn));
            this.setWwn(wwn);
            this.setJobId(jobId);
            this.setDsp(dsp);
            this.setExtent(extent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String METHOD = "run";
            Trace.methodBegin((Object)this, (String)"run");
            String jobId = this.getJobId();
            Trace.info((Object)this, (String)"run", (String)(" " + jobId + " Cleaning up the T4 slice for LUN = " + this.getWwn()));
            Trace.info((Object)this, (String)"run", (String)" Getting ModifyBroker lock ");
            ModifyBroker modifyBroker = ModifyBroker.getInstance();
            synchronized (modifyBroker) {
                Trace.info((Object)this, (String)"run", (String)"     got ModifyBroker lock ");
                boolean done = false;
                while (!done) {
                    Trace.info((Object)this, (String)"run", (String)" Trying for cache lock ");
                    if (ModifyBroker.setCacheUpdateOwner("Job " + jobId + " vdisk cleanup")) {
                        Trace.info((Object)this, (String)"run", (String)"   Got cache lock ");
                        try {
                            ModifySunStorEdge_DSPStorageExtent.removeVdiskFromArray(this.getWwn(), this.getDsp(), false);
                            if (this.getExtent() != null) {
                                ModifySunStorEdge_DSPStorageExtent.removeExtentModel(this.getExtent().getObjectPath());
                            }
                            String page = new String(RESCAN_PAGE);
                            Vector<String> tokens = new Vector<String>();
                            tokens.add(new String("sysDoRescan= 1"));
                            Trace.info((Object)this, (String)"run", (String)" Forcing DSP storage rescan");
                            DspResults results = DevComm.getInstance().postWithDspResults(this.getDsp(), page, tokens);
                            if (!results.requestSucceeded()) {
                                Trace.error((Object)this, (String)"run", (String)(" Storage rescan request failed" + DspUtil.mapDSPReturnCode(results.getReturnCode())));
                            }
                        }
                        catch (Exception e) {
                            Trace.error((Object)this, (String)(" Unable to clean up LUN " + this.getWwn()), (Throwable)e);
                        }
                        ModifyBroker.clearCacheUpdateOwner(false, false);
                        done = true;
                        continue;
                    }
                    Trace.info((Object)this, (String)"run", (String)"   Didn't get lock.  Sleeping for 10 seconds");
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Exception lockSleepEx) {
                        Trace.info((Object)this, (String)"run", (String)"   Sleep interrupted - continuing");
                    }
                }
                Trace.info((Object)this, (String)"run", (String)" Giving back ModifyBroker lock ");
            }
            Trace.methodEnd((Object)this, (String)"run");
        }
    }
}

