/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.CIMCacheEvent;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyBroker;
import com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPConcreteJob;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import com.sun.netstorage.dsp.mgmt.se6920.SetRequest;
import com.sun.netstorage.dsp.mgmt.se6920.SunStorEdge_DSPProvider;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;

public abstract class DspJob {
    private static final String CLASSNAME = "DspJob";
    private static final String DSP_CLASSNAME = "SunStorEdge_DSPStorageSystem";
    private static final String DSP_CONCRETE_JOB = "SunStorEdge_DspConcreteJob";
    private static final String JOB_MODIFY_MODULE = "ModifySunStorEdge_DSPConcreteJob";
    private static final String OWNING_JOB_ELEMENT_CLASS = "SunStorEdge_DSPOwningJobElement";
    private static final String DEPENDENT = "OwnedElement";
    private static final String ANTECEDENT = "OwningElement";
    private static final String AFFECTED_JOB_ELEMENT_CLASS = "SunStorEdge_DSPAffectedJobElement";
    private static final String AFFECTED = "AffectedElement";
    private static final String AFFECTING = "AffectingElement";
    public static final String DESCRIPTION = "Description";
    public static final String DELETE_ON_COMPLETION = "DeleteOnCompletion";
    public static final String ELAPSED_TIME = "ElapsedTime";
    public static final String ERROR_CODE = "ErrorCode";
    public static final String ERROR_DESCRIPTION = "ErrorDescription";
    public static final String INSTANCE_ID = "InstanceID";
    public static final String JOB_STATUS = "JobStatus";
    public static final String NAME = "Name";
    public static final String NOTIFY = "Notify";
    public static final String OPERATIONAL_STATUS = "OperationalStatus";
    public static final String PERCENT_COMPLETE = "PercentComplete";
    public static final String START_TIME = "StartTime";
    public static final String SYSTEM_NAME = "SystemName";
    public static final String TIME_SUBMITTED = "TimeSubmitted";
    public static final String STATUS_ABORTED = "Aborted";
    public static final String STATUS_COMPLETED = "Completed";
    public static final String STATUS_DORMANT = "Dormant";
    public static final String STATUS_ERROR = "Error";
    public static final String STATUS_OK = "OK";
    public static final int STATUS_ABORTED_INT = 14;
    public static final int STATUS_COMPLETED_INT = 17;
    public static final int STATUS_DORMANT_INT = 15;
    public static final int STATUS_ERROR_INT = 6;
    public static final int STATUS_OK_INT = 3;
    static final String GENERIC_DESCRIPTION = "Unspecified description";
    static final String GENERIC_NAME = "DspJob";
    static final String GENERIC_ERROR = "Unspecified error";
    static final String DATE_FORMAT_PATTERN = "yyyy.MM.dd_HH:mm:ss.S";
    private static int jobCount = 0;
    private ArrayObject dsp;
    private CIMObjectPath cimJobPath;
    private CIMObjectPath owningJobPath;
    private String cimJobId;
    CIMInstance cimJob;
    private String cimConcreteJobSubclass = new String("SunStorEdge_DspConcreteJob");
    private String cimDescription = new String("Unspecified description");
    private String cimJobName = new String("DspJob");
    private String dspName = null;
    private Vector affectedElements = new Vector();
    private Vector affectedElementAssociations = new Vector();
    private int percentComplete = 0;
    private long startTime = 0L;
    private boolean deleteOnCompletion = false;
    private boolean killed = false;
    private boolean completionSet = false;
    private Vector statusVector = new Vector();
    private String statusString = new String();
    private String errorText = new String();
    private static final String sccs_id = "@(#)DspJob.java    1.32    05/04/29     SMI";

    public ArrayObject getDsp() {
        return this.dsp;
    }

    private void setCimJobPath(CIMObjectPath path) {
        this.cimJobPath = path;
    }

    public CIMObjectPath getCimJobPath() {
        return this.cimJobPath;
    }

    private void setOwningJobPath(CIMObjectPath path) {
        this.owningJobPath = path;
    }

    public CIMObjectPath getOwningJobPath() {
        return this.owningJobPath;
    }

    private void setCimJobId(String id) {
        this.cimJobId = id;
    }

    public String getCimJobId() {
        return this.cimJobId;
    }

    private void setCimJob(CIMInstance job) {
        this.cimJob = job;
    }

    public CIMInstance getCimJob() {
        return this.cimJob;
    }

    private void setDspName(String name) {
        this.dspName = name;
    }

    protected String getDspName() {
        return this.dspName;
    }

    protected Vector getAffectedElements() {
        return this.affectedElements;
    }

    protected void setAffectedElements(Vector affectedElements) {
        if (affectedElements == null) {
            return;
        }
        this.affectedElements = affectedElements;
    }

    protected Vector getAffectedElementAssociations() {
        return this.affectedElementAssociations;
    }

    protected void setAffectedElementAssociations(Vector affectedElementAssociations) {
        if (affectedElementAssociations == null) {
            return;
        }
        this.affectedElementAssociations = affectedElementAssociations;
    }

    protected synchronized void setPercentComplete(int percent) {
        if (this.percentComplete < 100) {
            this.updateElapsedTime();
        }
        this.percentComplete = percent;
        this.updateCimPercentComplete(percent);
    }

    public int getPercentComplete() {
        return this.percentComplete;
    }

    protected void setStartTime(Date date) {
        this.startTime = date.getTime();
    }

    public long getStartTime() {
        return this.startTime;
    }

    protected void setDeleteOnCompletion(boolean flag) {
        this.deleteOnCompletion = flag;
    }

    protected boolean getDeleteOnCompletion() {
        return this.deleteOnCompletion;
    }

    protected void setKilled(boolean flag) {
        this.killed = flag;
    }

    protected boolean isKilled() {
        return this.killed;
    }

    protected void setCompletionSet() {
        this.completionSet = true;
    }

    public boolean isCompletionSet() {
        return this.completionSet;
    }

    protected void setStatusVector(Vector newStatusVector) {
        this.statusVector = newStatusVector;
    }

    protected Vector getStatusVector() {
        return this.statusVector;
    }

    protected void setStatusString(String newStatusString) {
        this.statusString = newStatusString;
    }

    protected String getStatusString() {
        return this.statusString;
    }

    protected void setErrorText(String newErrorText) {
        this.errorText = newErrorText;
    }

    protected String getErrorText() {
        return this.errorText;
    }

    public DspJob(ArrayObject dsp) {
        String METHOD = "Constructor";
        Trace.info((Object)this, (String)"Constructor", (String)(" Begin - hostname = " + dsp.getHost()));
        this.calculateDspName(dsp);
        this.setCimJobId(new String("N/A"));
        this.setCimJob(null);
        this.dsp = dsp;
        ModifySunStorEdge_DSPConcreteJob jobMod = (ModifySunStorEdge_DSPConcreteJob)ModifyBroker.getInstance().getModule(dsp.getHost(), JOB_MODIFY_MODULE);
        if (jobMod != null) {
            jobMod.addNewJobToList(this);
        }
        Trace.info((Object)this, (String)"Constructor", (String)" End");
    }

    public synchronized CIMObjectPath createCimJob(String nameSpace, CIMObjectPath configurationService, Vector affectedElements) throws CIMException {
        String METHOD = "createCimJob";
        Trace.info((Object)this, (String)"createCimJob", (String)(" Begin - concreteJobSubclass = " + this.getCimConcreteJobSubclass()));
        Vector associations = this.getAffectedElementAssociations();
        if (configurationService == null) {
            Trace.error((Object)this, (String)"createCimJob", (String)" No job owner (storageConfigurationService) passed in. ");
            CIMException tmpe = new CIMException("CIM_ERR_FAILED");
            tmpe.setDescription("Internal error: no ConfigurationService supplied.");
            throw tmpe;
        }
        this.setAffectedElements(affectedElements);
        int thisJobNum = jobCount++;
        Date now = new Date();
        CIMObjectPath newJobPath = new CIMObjectPath(this.getCimConcreteJobSubclass());
        newJobPath.setNameSpace(nameSpace);
        CIMClass jobClass = SunStorEdge_DSPProvider.cimom.getClass(newJobPath, false, true, true, null);
        if (jobClass == null) {
            Trace.error((Object)this, (String)"createCimJob", (String)" Unable to create new DspJob - null job class");
            CIMException tmpe = new CIMException("CIM_ERR_FAILED");
            tmpe.setDescription("Internal error: Failed getClass.");
            throw tmpe;
        }
        CIMInstance dspJob = jobClass.newInstance();
        this.setCimJob(dspJob);
        dspJob.setProperty(DESCRIPTION, new CIMValue((Object)this.getCimDescription()));
        Vector<UnsignedInt16> statusVector = new Vector<UnsignedInt16>();
        statusVector.add(new UnsignedInt16(3));
        dspJob.setProperty(OPERATIONAL_STATUS, new CIMValue(statusVector, new CIMDataType(16)));
        dspJob.setProperty(JOB_STATUS, new CIMValue((Object)STATUS_OK));
        this.setStartTime(now);
        dspJob.setProperty(START_TIME, new CIMValue((Object)new CIMDateTime(now), new CIMDataType(12)));
        dspJob.setProperty(TIME_SUBMITTED, new CIMValue((Object)new CIMDateTime(now), new CIMDataType(12)));
        this.updateElapsedTime();
        this.updateCimPercentComplete(0);
        Boolean delFlag = new Boolean(this.getDeleteOnCompletion());
        dspJob.setProperty(DELETE_ON_COMPLETION, new CIMValue((Object)delFlag, new CIMDataType(9)));
        dspJob.setProperty(ERROR_CODE, new CIMValue((Object)new UnsignedInt16(0), new CIMDataType(2)));
        dspJob.setProperty(ERROR_DESCRIPTION, new CIMValue((Object)""));
        dspJob.setProperty("TaskFailureCount", new CIMValue((Object)new UnsignedInt16(0), new CIMDataType(2)));
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_PATTERN);
        StringBuffer idBuffer = new StringBuffer();
        idBuffer = dateFormat.format(now, idBuffer, new FieldPosition(0));
        String jobId = new String(idBuffer.toString() + "_" + thisJobNum);
        this.setCimJobId(jobId);
        dspJob.setProperty(INSTANCE_ID, new CIMValue((Object)jobId));
        dspJob.setProperty(NAME, new CIMValue((Object)this.getCimJobName()));
        dspJob.setProperty(SYSTEM_NAME, new CIMValue((Object)this.getDsp().getHost()));
        RequestBroker.getInstance().addSyntheticCacheInstance(dspJob);
        CIMObjectPath tmp = new CIMObjectPath(OWNING_JOB_ELEMENT_CLASS);
        tmp.setNameSpace(nameSpace);
        CIMClass owningJobClass = SunStorEdge_DSPProvider.cimom.getClass(tmp, false, true, true, null);
        if (owningJobClass == null) {
            Trace.error((Object)this, (String)"createCimJob", (String)" Unable to create association");
            CIMException tmpe = new CIMException("CIM_ERR_FAILED");
            tmpe.setDescription("Internal error: Failed getClass.");
            throw tmpe;
        }
        CIMInstance owningJob = owningJobClass.newInstance();
        configurationService.setNameSpace(nameSpace);
        owningJob.setProperty(ANTECEDENT, new CIMValue((Object)configurationService));
        CIMObjectPath dspJobPath = dspJob.getObjectPath();
        dspJobPath.setNameSpace(nameSpace);
        owningJob.setProperty(DEPENDENT, new CIMValue((Object)dspJobPath));
        CIMObjectPath owningJobPath = owningJob.getObjectPath();
        owningJobPath.setNameSpace(nameSpace);
        RequestBroker.getInstance().addSyntheticCacheInstance(owningJob);
        if (affectedElements != null) {
            Iterator it = affectedElements.iterator();
            while (it.hasNext()) {
                CIMObjectPath affectedElement = (CIMObjectPath)it.next();
                CIMObjectPath tmp2 = new CIMObjectPath(AFFECTED_JOB_ELEMENT_CLASS);
                tmp2.setNameSpace(nameSpace);
                CIMClass affectedJobClass = SunStorEdge_DSPProvider.cimom.getClass(tmp2, false, true, true, null);
                if (affectedJobClass == null) {
                    Trace.error((Object)this, (String)"createCimJob", (String)(" " + this.getCimJobId() + " Unable to create associations "));
                    CIMException tmpe = new CIMException("CIM_ERR_FAILED");
                    tmpe.setDescription("Internal error: Failed getClass.");
                    throw tmpe;
                }
                CIMInstance affectedJob = affectedJobClass.newInstance();
                affectedJob.setProperty(AFFECTING, new CIMValue((Object)dspJobPath));
                newJobPath.setNameSpace(nameSpace);
                affectedJob.setProperty(AFFECTED, new CIMValue((Object)affectedElement));
                associations.add(affectedJob.getObjectPath());
                RequestBroker.getInstance().addSyntheticCacheInstance(affectedJob);
                Trace.info((Object)this, (String)"createCimJob", (String)(" " + this.getCimJobId() + " AffectedJob association created "));
            }
        }
        try {
            String[] logArgs = new String[]{this.getCimJobId(), this.getDsp().getHost(), this.getCimDescription()};
            LogAPI.staticLog((String)"DSP_JOB_CREATED", (String[])logArgs, null);
        }
        catch (Exception logEx) {
            // empty catch block
        }
        dspJobPath.setNameSpace("");
        this.setCimJobPath(dspJobPath);
        this.setOwningJobPath(owningJobPath);
        Trace.info((Object)this, (String)"createCimJob", (String)" End");
        return dspJobPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void calculateDspName(ArrayObject dsp) {
        String name;
        block9: {
            String METHOD = "calculateDspName";
            name = null;
            Trace.info((Object)this, (String)"calculateDspName", (String)" Begin ");
            try {
                try {
                    CIMObjectPath dspPath = new CIMObjectPath(DSP_CLASSNAME);
                    dspPath.setNameSpace("\\root\\se6x20\\");
                    CIMClass dspClass = SunStorEdge_DSPProvider.cimom.getClass(dspPath, false, true, true, null);
                    if (dspClass == null) {
                        CIMException tmpe = new CIMException("CIM_ERR_FAILED");
                        tmpe.setDescription("Internal error: Failed getClass.");
                        throw tmpe;
                    }
                    CIMInstance[] dspArray = RequestBroker.getInstance().enumerateInstances(dspPath, false, false, true, null, dspClass);
                    if (dspArray.length >= 1) {
                        CIMProperty nameProp = dspArray[0].getProperty(NAME);
                        name = (String)nameProp.getValue().getValue();
                        Trace.info((Object)this, (String)"calculateDspName", (String)(" Retrieved name = " + name));
                    }
                }
                catch (Exception e) {
                    Trace.info((Object)this, (String)" Took an exception while attempting to retrieve DSP name", (Throwable)e);
                    Object var9_11 = null;
                    if (name == null) {
                        name = new String("Unknown");
                    }
                    Trace.info((Object)this, (String)"calculateDspName", (String)(" Job " + this.getCimJobId() + " will be created for DSP " + name));
                    this.setDspName(name);
                    return;
                }
                Object var9_10 = null;
                if (name != null) break block9;
                name = new String("Unknown");
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (name == null) {
                    name = new String("Unknown");
                }
                Trace.info((Object)this, (String)"calculateDspName", (String)(" Job " + this.getCimJobId() + " will be created for DSP " + name));
                this.setDspName(name);
                throw throwable;
            }
        }
        Trace.info((Object)this, (String)"calculateDspName", (String)(" Job " + this.getCimJobId() + " will be created for DSP " + name));
        this.setDspName(name);
    }

    protected void updateCimPercentComplete(int percent) {
        String METHOD = "updateCimPercentComplete";
        Trace.info((Object)this, (String)"updateCimPercentComplete", (String)" Begin ");
        CIMInstance dspJob = this.getCimJob();
        if (dspJob != null) {
            CIMCacheEvent modEvent = null;
            if (percent != 0) {
                modEvent = new CIMCacheEvent(6, RequestBroker.getDevCache(), this.getDsp());
                CIMInstance evtInst = (CIMInstance)dspJob.clone();
                modEvent.addInstance(evtInst);
                modEvent.addObjectPath(dspJob.getObjectPath());
            }
            try {
                dspJob.setProperty(PERCENT_COMPLETE, new CIMValue((Object)new UnsignedInt16(percent), new CIMDataType(2)));
                Trace.info((Object)this, (String)"updateCimPercentComplete", (String)(" Updated CIM percent complete attr to " + percent + "%"));
            }
            catch (CIMException e) {
                // empty catch block
            }
            if (modEvent != null) {
                modEvent.addInstance((CIMInstance)dspJob.clone());
                RequestBroker.getInstance().postEvent(modEvent);
            }
        } else {
            Trace.info((Object)this, (String)"updateCimPercentComplete", (String)" No CIM job to update");
        }
        Trace.info((Object)this, (String)"updateCimPercentComplete", (String)" End ");
    }

    protected void updateElapsedTime() {
        String METHOD = "updateElapsedTime";
        Trace.info((Object)this, (String)"updateElapsedTime", (String)" Begin ");
        long currentTime = System.currentTimeMillis();
        CIMInstance dspJob = this.getCimJob();
        if (dspJob != null) {
            try {
                dspJob.setProperty(ELAPSED_TIME, new CIMValue((Object)new CIMDateTime(new Date(currentTime - this.startTime)), new CIMDataType(12)));
            }
            catch (CIMException e) {
                // empty catch block
            }
        }
        Trace.info((Object)this, (String)"updateElapsedTime", (String)" End ");
    }

    protected void updateAttributes(SetRequest setRequest) throws CIMException {
        String METHOD = "updateAttributes";
        Trace.info((Object)this, (String)"updateAttributes", (String)" Begin");
        Properties props = setRequest.getProperties();
        CIMInstance dspJob = this.getCimJob();
        if (dspJob != null) {
            String taskResultTypes;
            String taskResults;
            String taskFailureCount;
            String percentComplete;
            String delOnCompletion;
            String notify;
            String name;
            CIMCacheEvent modEvent = new CIMCacheEvent(6, RequestBroker.getDevCache(), this.getDsp());
            CIMInstance evtInst = (CIMInstance)dspJob.clone();
            modEvent.addInstance(evtInst);
            modEvent.addObjectPath(dspJob.getObjectPath());
            String description = props.getProperty(DESCRIPTION);
            if (description != null) {
                dspJob.setProperty(DESCRIPTION, new CIMValue((Object)description));
            }
            if ((name = props.getProperty(NAME)) != null) {
                dspJob.setProperty(NAME, new CIMValue((Object)name));
            }
            if ((notify = props.getProperty(NOTIFY)) != null) {
                String status = (String)dspJob.getProperty(JOB_STATUS).getValue().getValue();
                if (status.equalsIgnoreCase(STATUS_COMPLETED) || status.equalsIgnoreCase(STATUS_ABORTED) || status.equalsIgnoreCase(STATUS_ERROR)) {
                    throw new CIMException("CIM_ERR_NOT_SUPPORTED");
                }
                dspJob.setProperty(NOTIFY, new CIMValue((Object)notify));
            }
            if ((delOnCompletion = props.getProperty(DELETE_ON_COMPLETION)) != null) {
                Boolean delFlag = new Boolean(delOnCompletion);
                this.setDeleteOnCompletion(delFlag);
                dspJob.setProperty(DELETE_ON_COMPLETION, new CIMValue((Object)delFlag, new CIMDataType(9)));
            }
            if ((percentComplete = props.getProperty(PERCENT_COMPLETE)) != null) {
                this.setPercentComplete(new Integer(percentComplete));
                if (new Integer(percentComplete) == 100) {
                    Vector<CIMProperty> newProps = new Vector<CIMProperty>();
                    Vector<UnsignedInt16> statusVector = new Vector<UnsignedInt16>();
                    statusVector.add(new UnsignedInt16(17));
                    newProps.add(new CIMProperty(OPERATIONAL_STATUS, new CIMValue(statusVector, new CIMDataType(16))));
                    dspJob.updatePropertyValues(newProps);
                }
            }
            if ((taskFailureCount = props.getProperty("TaskFailureCount")) != null) {
                Vector<CIMProperty> newProps = new Vector<CIMProperty>();
                newProps.add(new CIMProperty("TaskFailureCount", new CIMValue((Object)new UnsignedInt16(taskFailureCount), new CIMDataType(2))));
                dspJob.updatePropertyValues(newProps);
            }
            if ((taskResults = props.getProperty("TaskResults")) != null) {
                Vector<CIMProperty> newProps = new Vector<CIMProperty>();
                newProps.add(new CIMProperty("TaskResults", new CIMValue((Vector)setRequest.getPropertyValue("TaskResults"), new CIMDataType(22))));
                dspJob.updatePropertyValues(newProps);
            }
            if ((taskResultTypes = props.getProperty("TaskResultTypes")) != null) {
                Vector<CIMProperty> newProps = new Vector<CIMProperty>();
                newProps.add(new CIMProperty("TaskResultTypes", new CIMValue((Vector)setRequest.getPropertyValue("TaskResultTypes"), new CIMDataType(23))));
                dspJob.updatePropertyValues(newProps);
            }
            modEvent.addInstance((CIMInstance)dspJob.clone());
            RequestBroker.getInstance().postEvent(modEvent);
        }
    }

    public synchronized void resynchWithCimCache() {
        String METHOD = "resynchWithCimCache";
        Trace.info((Object)this, (String)"resynchWithCimCache", (String)" Begin");
    }

    public synchronized boolean isComplete() {
        String METHOD = "isComplete";
        Trace.methodBegin((Object)this, (String)"isComplete");
        Iterator it = this.getStatusVector().iterator();
        while (it.hasNext()) {
            UnsignedInt16 statusInt16 = (UnsignedInt16)it.next();
            int statusVal = statusInt16.intValue();
            switch (statusVal) {
                case 17: {
                    Trace.info((Object)this, (String)"isComplete", (String)" Completed flag is set.  We're done.");
                    return true;
                }
                case 14: {
                    Trace.info((Object)this, (String)"isComplete", (String)" Aborted flag is set.  We're done.");
                    return true;
                }
            }
        }
        int percent = this.getPercentComplete();
        if (percent == 100) {
            Trace.info((Object)this, (String)"isComplete", (String)(" Job " + this.getCimJobId() + " at 100% complete"));
            return true;
        }
        Trace.info((Object)this, (String)"isComplete", (String)(" Job " + this.getCimJobId() + " currently " + percent + " % complete."));
        return false;
    }

    protected void setCompletion(int status, String statusText, boolean isCompleted) {
        String METHOD = "setCompletion";
        Trace.methodBegin((Object)this, (String)"setCompletion");
        Trace.info((Object)this, (String)"setCompletion", (String)(" Status = " + status + ", text = " + statusText + ", completed = " + isCompleted));
        boolean isAborted = false;
        boolean isError = false;
        Vector<UnsignedInt16> newStatusVector = new Vector<UnsignedInt16>();
        String newStatusString = new String();
        String newErrorText = new String();
        CIMInstance dspJob = this.getCimJob();
        if (dspJob == null) {
            Trace.error((Object)this, (String)"setCompletion", (String)" Attempting to set invalid state for null job");
            return;
        }
        CIMCacheEvent modEvent = new CIMCacheEvent(6, RequestBroker.getDevCache(), this.getDsp());
        CIMInstance evtInst = (CIMInstance)dspJob.clone();
        modEvent.addInstance(evtInst);
        modEvent.addObjectPath(dspJob.getObjectPath());
        Iterator it = this.getStatusVector().iterator();
        block15: while (it.hasNext()) {
            UnsignedInt16 statusInt16 = (UnsignedInt16)it.next();
            int statusVal = statusInt16.intValue();
            switch (statusVal) {
                case 17: {
                    isCompleted = true;
                    continue block15;
                }
                case 14: {
                    isAborted = true;
                    continue block15;
                }
                case 6: {
                    isError = true;
                    continue block15;
                }
                case 3: {
                    continue block15;
                }
            }
            Trace.error((Object)this, (String)"setCompletion", (String)(" Job " + this.cimJobId + " currently has unsupported status = " + statusVal));
            Trace.error((Object)this, (String)"setCompletion", (String)"   Valid values are:  OK (3), COMPLETED (17), ERROR (6), and ABORTED (14)");
        }
        Trace.info((Object)this, (String)"setCompletion", (String)(" Existing job status:  Aborted = " + isAborted + ", isError = " + isError));
        switch (status) {
            case 14: {
                if (isAborted) {
                    Trace.info((Object)this, (String)"setCompletion", (String)" Trying to add 'aborted' to already aborted job");
                    break;
                }
                isAborted = true;
                Trace.info((Object)this, (String)"setCompletion", (String)" Setting job to 'aborted'");
                break;
            }
            case 6: {
                if (isError) {
                    Trace.info((Object)this, (String)"setCompletion", (String)" Trying to add 'error' to already errored job");
                    break;
                }
                isError = true;
                Trace.info((Object)this, (String)"setCompletion", (String)" Setting job to 'error'");
                break;
            }
            case 3: {
                if (!isAborted && !isError) break;
                Trace.info((Object)this, (String)"setCompletion", (String)" Attempting to add 'OK' to 'aborted/error' job - ignored");
                break;
            }
            default: {
                Trace.error((Object)this, (String)"setCompletion", (String)(" Attempting to set invalid state for job = " + this.cimJobId));
                return;
            }
        }
        String diagString = new String("");
        if (isCompleted) {
            newStatusVector.add(new UnsignedInt16(17));
            diagString = new String(diagString + " completed ");
        }
        if (isAborted) {
            newStatusVector.add(new UnsignedInt16(14));
            diagString = new String(diagString + " aborted ");
        }
        if (isError) {
            newStatusVector.add(new UnsignedInt16(6));
            diagString = new String(diagString + " error ");
        }
        if (!isAborted && !isError) {
            newStatusVector.add(new UnsignedInt16(3));
            diagString = new String(diagString + " ok ");
        }
        if (statusText == null) {
            statusText = isAborted ? new String(STATUS_ABORTED) : (isError ? new String(STATUS_ERROR) : (isCompleted ? new String(STATUS_COMPLETED) : new String(STATUS_OK)));
        }
        newStatusString = this.getStatusString().equals(new String()) ? statusText : new String(this.getStatusString() + " " + statusText);
        if (isAborted) {
            newErrorText = new String(STATUS_ABORTED);
        } else if (isError) {
            newErrorText = new String(STATUS_ERROR);
        }
        newStatusString = isAborted ? new String(STATUS_ABORTED) : (isError ? new String(STATUS_ERROR) : new String(STATUS_OK));
        Trace.info((Object)this, (String)"setCompletion", (String)(" Updating status vector to " + diagString));
        this.setStatusVector(newStatusVector);
        Trace.info((Object)this, (String)"setCompletion", (String)(" Updating status string to " + newStatusString));
        this.setStatusString(newStatusString);
        Trace.info((Object)this, (String)"setCompletion", (String)(" Updating error text to    " + newErrorText));
        this.setErrorText(newErrorText);
        try {
            dspJob.setProperty(JOB_STATUS, new CIMValue((Object)newStatusString));
            dspJob.setProperty(OPERATIONAL_STATUS, new CIMValue(newStatusVector, new CIMDataType(16)));
            if (!newErrorText.equals(new String())) {
                dspJob.setProperty(ERROR_CODE, new CIMValue((Object)new UnsignedInt16(1), new CIMDataType(2)));
                dspJob.setProperty(ERROR_DESCRIPTION, new CIMValue((Object)this.errorText));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String[] logArgs = new String[]{this.getCimJobId(), this.getDsp().getHost(), this.statusString};
            LogAPI.staticLog((String)"DSP_JOB_COMPLETED", (String[])logArgs, null);
        }
        catch (Exception logEx) {
            // empty catch block
        }
        if (isCompleted) {
            this.setCompletionSet();
        }
        modEvent.addInstance((CIMInstance)dspJob.clone());
        RequestBroker.getInstance().postEvent(modEvent);
    }

    protected synchronized void kill() {
        try {
            String[] logArgs = new String[]{this.getCimJobId(), this.getDsp().getHost()};
            LogAPI.staticLog((String)"DSP_JOB_KILLED", (String[])logArgs, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setKilled(true);
        this.setCompletion(14, null, true);
    }

    public synchronized void deleteJob() {
        String METHOD = "deleteJob";
        Trace.info((Object)this, (String)"deleteJob", (String)" Begin");
        this.removeFromCimCache();
        ModifySunStorEdge_DSPConcreteJob jobMod = (ModifySunStorEdge_DSPConcreteJob)ModifyBroker.getInstance().getModule(this.dsp.getHost(), JOB_MODIFY_MODULE);
        if (jobMod != null) {
            jobMod.removeJobFromList(this);
        }
        try {
            String[] logArgs = new String[]{this.getCimJobId(), this.getDsp().getHost()};
            LogAPI.staticLog((String)"DSP_JOB_DELETED", (String[])logArgs, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void removeFromCimCache() {
        CIMObjectPath owningJobPath;
        String METHOD = "removeFromCimCache";
        Trace.info((Object)this, (String)"removeFromCimCache", (String)" Begin");
        CIMObjectPath jobPath = this.getCimJobPath();
        if (jobPath != null) {
            RequestBroker.getInstance().deleteSyntheticCacheInstance(jobPath);
        }
        if ((owningJobPath = this.getOwningJobPath()) != null) {
            RequestBroker.getInstance().deleteSyntheticCacheInstance(owningJobPath);
        }
        Iterator it = this.getAffectedElementAssociations().iterator();
        while (it.hasNext()) {
            Trace.info((Object)this, (String)"removeFromCimCache", (String)" Removing AffectedJobAssociation ");
            CIMObjectPath affected = (CIMObjectPath)it.next();
            RequestBroker.getInstance().deleteSyntheticCacheInstance(affected);
        }
        Trace.info((Object)this, (String)"removeFromCimCache", (String)" Complete");
    }

    public String getCimConcreteJobSubclass() {
        return this.cimConcreteJobSubclass;
    }

    public void setCimConcreteJobSubclass(String cimConcreteJobSubclass) {
        if (cimConcreteJobSubclass == null) {
            return;
        }
        this.cimConcreteJobSubclass = cimConcreteJobSubclass;
    }

    public String getCimDescription() {
        return this.cimDescription;
    }

    public void setCimDescription(String cimDescription) {
        if (cimDescription == null) {
            return;
        }
        this.cimDescription = cimDescription;
        try {
            this.getCimJob().setProperty(DESCRIPTION, new CIMValue((Object)this.cimDescription));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getCimJobName() {
        return this.cimJobName;
    }

    public void setCimJobName(String cimJobName) {
        if (cimJobName == null) {
            return;
        }
        this.cimJobName = cimJobName;
    }

    public abstract void checkForJobCompletion();

    public void addAffectedElements(Vector affectedElements) throws CIMException {
        String METHOD = "addAffectedElements";
        Trace.methodBegin((Object)this, (String)"addAffectedElements");
        Vector curAffElem = new Vector(this.getAffectedElements());
        Vector curAffElemAssocs = new Vector(this.getAffectedElementAssociations());
        for (int i = 0; i < affectedElements.size(); ++i) {
            if (curAffElem.contains(affectedElements.get(i))) continue;
            curAffElem.add(affectedElements.get(i));
            CIMObjectPath affectedJobPath = new CIMObjectPath(AFFECTED_JOB_ELEMENT_CLASS);
            affectedJobPath.setNameSpace("\\root\\se6x20\\");
            CIMClass affectedJobClass = SunStorEdge_DSPProvider.cimom.getClass(affectedJobPath, false, true, true, null);
            if (affectedJobClass == null) {
                Trace.error((Object)this, (String)"addAffectedElements", (String)(" " + this.getCimJobId() + " Unable to create associations "));
                CIMException tmpe = new CIMException("CIM_ERR_FAILED");
                tmpe.setDescription("Internal error: Failed getClass.");
                throw tmpe;
            }
            CIMInstance affectedJob = affectedJobClass.newInstance();
            affectedJob.setProperty(AFFECTING, new CIMValue((Object)this.getCimJobPath()));
            affectedJob.setProperty(AFFECTED, new CIMValue((Object)((CIMObjectPath)affectedElements.get(i))));
            curAffElemAssocs.add(affectedElements.get(i));
            RequestBroker.getInstance().addSyntheticCacheInstance(affectedJob);
            Trace.info((Object)this, (String)"addAffectedElements", (String)(" " + this.getCimJobId() + " AffectedJob association created "));
        }
        this.setAffectedElements(curAffElem);
        this.setAffectedElementAssociations(curAffElemAssocs);
    }
}

