/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.Constants;
import com.sun.netstorage.dsp.mgmt.se6920.DspDebounceTimer;
import com.sun.netstorage.dsp.mgmt.se6920.DspEventTarget;
import com.sun.netstorage.dsp.mgmt.se6920.DspPage;
import com.sun.netstorage.dsp.mgmt.se6920.DspPropertyVolumeMirrorResilver;
import com.sun.netstorage.dsp.mgmt.se6920.DspTimedActionListener;
import com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStorageVolume;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.UnsignedInt16;

class DspEventTargetResilver
extends DspEventTarget
implements DspTimedActionListener {
    private static String CLASSNAME = "DspEventTargetResilver";
    private static final String VOLUME_MIRROR_RESILVER_JOBNAME = "MirrorResilver";
    private static final String VOLUME_MIRROR_RESILVERALL_JOBNAME = "MirrorResilverAll";
    private static final int MAX_WAIT = 60;
    private static final int MAX_NOTIFICATIONS = 10;
    private int baseline = 0;
    private int amountOfWorkToDo = 0;
    private Map timerMap = Collections.synchronizedMap(new HashMap());
    private static final String sccs_id = "@(#)DspEventTargetResilver.java    1.7    06/02/14     SMI";

    private void setBaseline(int newBaseline) {
        String METHOD = "setBaseline";
        if (this.baseline == 0 && newBaseline > 0) {
            this.baseline = newBaseline;
            this.amountOfWorkToDo = 100 - this.baseline;
            Trace.info((Object)this, (String)"setBaseline", (String)(" Resilver baseline set to " + this.baseline + ", with amountOfWorkToDo = " + this.amountOfWorkToDo));
        }
    }

    public DspEventTargetResilver(ArrayObject theDsp, String targetWwn) {
        super(theDsp, targetWwn);
        String METHOD = "Constructor";
        Trace.methodBegin((Object)this, (String)METHOD);
        this.getValidJobnames().add(VOLUME_MIRROR_RESILVER_JOBNAME);
        this.getValidJobnames().add(VOLUME_MIRROR_RESILVERALL_JOBNAME);
    }

    public void update(String notifiedWwn, int newPercent, String status) {
        String METHOD = "update";
        Trace.methodBegin((Object)this, (String)"update");
        Trace.info((Object)this, (String)"update", (String)(" notifiedWwn = " + notifiedWwn + ", newPercent = " + newPercent + ", status = " + status));
        int scaledPercent = 0;
        this.setBaseline(newPercent);
        if (newPercent != 0) {
            if (this.amountOfWorkToDo != 0 && (scaledPercent = 100 * (newPercent - this.baseline) / this.amountOfWorkToDo) < 0) {
                scaledPercent = 0;
            }
            if (newPercent == 100) {
                scaledPercent = 100;
            }
        }
        Trace.info((Object)this, (String)"update", (String)(" Scaled the resilver percent from " + newPercent + " using baseline = " + this.baseline + ", amountOfWorkToDo = " + this.amountOfWorkToDo + ", to get scaledPercent = " + scaledPercent));
        super.update(notifiedWwn, scaledPercent, status);
    }

    protected void updateVolume(String notifiedWwn) {
        String METHOD = "updateVolume";
        Trace.methodBegin((Object)this, (String)"updateVolume");
        Trace.info((Object)this, (String)"updateVolume", (String)(" notifiedWwn = " + notifiedWwn));
        if (this.getVolume() == null) {
            Trace.info((Object)this, (String)"updateVolume", (String)" No volume to update");
            return;
        }
        if (this.isKilled()) {
            Trace.info((Object)this, (String)"updateVolume", (String)" already killed - not updating volume");
            return;
        }
        if (this.timerMap.containsKey(notifiedWwn)) {
            Trace.info((Object)this, (String)"updateVolume", (String)" Giving the timer a kick");
            ((DspDebounceTimer)this.timerMap.get(notifiedWwn)).notifyTimer();
        } else {
            Trace.info((Object)this, (String)"updateVolume", (String)" Creating a new timer");
            DspDebounceTimer timer = new DspDebounceTimer(30, 60, 10, 10, 30, this, notifiedWwn, notifiedWwn + " MirrorResilverTimer");
            this.timerMap.put(notifiedWwn, timer);
            timer.startTimer();
        }
    }

    public void doTimedAction(DspDebounceTimer timer, Object parms) {
        String METHOD = "doTimedAction";
        Trace.methodBegin((Object)this, (String)METHOD);
        if (parms == null) {
            Trace.error((Object)this, (String)METHOD, (String)" Called with null parms - can't do anything!");
            return;
        }
        String notifiedWwn = (String)parms;
        Trace.info((Object)this, (String)METHOD, (String)(" Updating CIM instance for notified WWN = " + notifiedWwn));
        String volPage = new String(this.getReloadPage() + notifiedWwn);
        RequestBroker.getInstance().reloadCachePage(this.getDsp(), volPage);
        this.timerMap.remove(notifiedWwn);
    }

    public void reloadInfo() {
        String METHOD = "reloadInfo";
        Trace.methodBegin((Object)this, (String)"reloadInfo");
        String volPage = new String(DspPage.VOL_PAGE + "?samVolume_SetByWwn=" + this.getTargetVolumeWwn());
        RequestBroker.getInstance().reloadCachePage(this.getDsp(), volPage);
        Map wwnMap = this.getNotificationWwns();
        Set compWwns = wwnMap.keySet();
        Iterator it = compWwns.iterator();
        while (it.hasNext()) {
            String compWwn = (String)it.next();
            volPage = new String(DspPage.VOL_PAGE + "?samVolume_SetByWwn=" + compWwn);
            RequestBroker.getInstance().reloadCachePage(this.getDsp(), volPage);
        }
    }

    public boolean checkCompletionFlags(Vector notificationInfo) {
        String METHOD = "checkCompletionFlags";
        Trace.methodBegin((Object)this, (String)"checkCompletionFlags");
        String mirrorWwn = this.getTargetVolumeWwn();
        Map wwnMap = this.getNotificationWwns();
        Set compWwns = wwnMap.keySet();
        try {
            Iterator it = compWwns.iterator();
            while (it.hasNext()) {
                String compWwn = (String)it.next();
                boolean resilvering = false;
                Trace.info((Object)this, (String)"checkCompletionFlags", (String)("Looking up component: " + compWwn));
                CIMInstance compVol = ModifySunStorEdge_DSPStorageVolume.getStorageVolume(compWwn.replaceAll(":", ""));
                if (compVol != null) {
                    Trace.info((Object)this, (String)"checkCompletionFlags", (String)"Found component.");
                    Vector opStatus = (Vector)compVol.getProperty("OperationalStatus").getValue().getValue();
                    if (opStatus != null) {
                        for (int i = 0; i < opStatus.size(); ++i) {
                            UnsignedInt16 opVal = (UnsignedInt16)opStatus.get(i);
                            Trace.info((Object)this, (String)"checkCompletionFlags", (String)("Op value: " + opVal));
                            if (!opVal.equals((Object)Constants.MIRROR_STATE_RESILVER)) continue;
                            resilvering = true;
                        }
                        if (resilvering) continue;
                        Trace.info((Object)this, (String)"checkCompletionFlags", (String)"Component does not appear to be resilvering.");
                        notificationInfo.add(compWwn);
                        notificationInfo.add(mirrorWwn);
                        notificationInfo.add("OK");
                        continue;
                    }
                    Trace.error((Object)this, (String)"checkCompletionFlags", (String)"Operational Status not found.");
                    return false;
                }
                Trace.error((Object)this, (String)"checkCompletionFlags", (String)"Could not find component volume.");
                return false;
            }
        }
        catch (CIMException ce) {
            Trace.error((Object)this, (String)"checkCompletionFlags", (String)"Errors trying to check target completion.");
            return false;
        }
        return true;
    }

    public void sendNotification(Vector notificationInfo) {
        String METHOD = "sendNotification";
        Trace.methodBegin((Object)this, (String)"sendNotification");
        if (notificationInfo.size() != 0) {
            int compCount = notificationInfo.size() / 3;
            for (int i = 0; i < compCount; ++i) {
                String firstWwn = (String)notificationInfo.get(i * 3);
                String secondWwn = (String)notificationInfo.get(i * 3 + 1);
                String status = (String)notificationInfo.get(i * 3 + 2);
                DspPropertyVolumeMirrorResilver listener = DspPropertyVolumeMirrorResilver.getInstance(this.getDsp());
                PropertyChangeEvent newEvent = listener.createNotification(firstWwn, 100, status, secondWwn, 0);
                Trace.info((Object)this, (String)"sendNotification", (String)"Sending artificial completion notification...");
                listener.propertyChange(newEvent);
            }
        } else {
            Trace.error((Object)this, (String)"sendNotification", (String)"No wwns to build notification from!");
        }
    }
}

