/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.DspDebounceTimer;
import com.sun.netstorage.dsp.mgmt.se6920.DspEventTarget;
import com.sun.netstorage.dsp.mgmt.se6920.DspPage;
import com.sun.netstorage.dsp.mgmt.se6920.DspPropertyVolumeReplicationSync;
import com.sun.netstorage.dsp.mgmt.se6920.DspTimedActionListener;
import com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStorageVolume;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;

class DspEventTargetReplicationSync
extends DspEventTarget
implements DspTimedActionListener {
    private static String CLASSNAME = "DspEventTargetReplicationSync";
    private static final String VOLUME_MIRROR_REPLICATION_JOBNAME = "RemoteMirrorResync";
    private static final int MAX_WAIT = 60;
    private static final int MAX_NOTIFICATIONS = 10;
    private Map timerMap = Collections.synchronizedMap(new HashMap());
    private int setIndex = 0;
    private static final String sccs_id = "@(#)DspEventTargetReplicationSync.java    1.9    05/04/22     SMI";

    public void setSetIndex(int index) {
        this.setIndex = index;
    }

    public int getSetIndex() {
        return this.setIndex;
    }

    public DspEventTargetReplicationSync(ArrayObject theDsp, String targetWwn) {
        super(theDsp, targetWwn);
        String METHOD = "Constructor";
        Trace.methodBegin((Object)this, (String)METHOD);
        this.getValidJobnames().add(VOLUME_MIRROR_REPLICATION_JOBNAME);
    }

    protected void updateVolume(String notifiedWwn) {
        String METHOD = "updateVolume";
        Trace.methodBegin((Object)this, (String)"updateVolume");
        Trace.info((Object)this, (String)"updateVolume", (String)(" notifiedWwn = " + notifiedWwn));
        if (this.getVolume() == null) {
            Trace.info((Object)this, (String)"updateVolume", (String)" No volume to update");
            return;
        }
        if (this.isKilled()) {
            Trace.info((Object)this, (String)"updateVolume", (String)" already killed - not updating volume");
            return;
        }
        if (this.timerMap.containsKey(notifiedWwn)) {
            Trace.info((Object)this, (String)"updateVolume", (String)" Giving the timer a kick");
            ((DspDebounceTimer)this.timerMap.get(notifiedWwn)).notifyTimer();
        } else {
            Trace.info((Object)this, (String)"updateVolume", (String)" Creating a new timer");
            DspDebounceTimer timer = new DspDebounceTimer(30, 60, 10, 10, 30, this, notifiedWwn, notifiedWwn + " ReplicationResyncTimer");
            this.timerMap.put(notifiedWwn, timer);
            timer.startTimer();
        }
    }

    public void doTimedAction(DspDebounceTimer timer, Object parms) {
        String METHOD = "doTimedAction";
        Trace.methodBegin((Object)this, (String)METHOD);
        if (parms == null) {
            Trace.error((Object)this, (String)METHOD, (String)" Called with null parms - can't do anything!");
            return;
        }
        String notifiedWwn = (String)parms;
        String targetWwn = this.getTargetVolumeWwn();
        Trace.info((Object)this, (String)METHOD, (String)(" Updating CIM instance for " + targetWwn + " because of notification for remote WWN = " + notifiedWwn));
        String volPage = new String(this.getReloadPage() + targetWwn);
        RequestBroker.getInstance().reloadCachePage(this.getDsp(), volPage);
        this.timerMap.remove(notifiedWwn);
    }

    public void reloadInfo() {
        String METHOD = "reloadInfo";
        Trace.methodBegin((Object)this, (String)"reloadInfo");
        String volPage = new String(DspPage.VOL_PAGE + "?samVolume_SetByWwn=" + this.getTargetVolumeWwn());
        RequestBroker.getInstance().reloadCachePage(this.getDsp(), volPage);
    }

    public boolean checkCompletionFlags(Vector notificationInfo) {
        String METHOD = "checkCompletionFlags";
        Trace.methodBegin((Object)this, (String)"checkCompletionFlags");
        try {
            String localVolWwn = this.getTargetVolumeWwn();
            String remoteVolWwn = null;
            CIMInstance localVol = ModifySunStorEdge_DSPStorageVolume.getStorageVolume(localVolWwn.replaceAll(":", ""));
            CIMObjectPath remoteSyncPath = new CIMObjectPath("SunStorEdge_DSPRemoteStorageSynchronized");
            remoteSyncPath.setNameSpace("\\root\\se6x20\\");
            CIMInstance[] remoteSyncs = RequestBroker.getInstance().references(remoteSyncPath, localVol.getObjectPath(), "SystemElement", true, true, null);
            if (remoteSyncs != null && remoteSyncs.length != 0) {
                UnsignedInt16 syncState = (UnsignedInt16)remoteSyncs[0].getProperty("SyncState").getValue().getValue();
                CIMObjectPath remoteVolPath = (CIMObjectPath)remoteSyncs[0].getProperty("SyncedElement").getValue().getValue();
                CIMInstance repSet = RequestBroker.getInstance().findInstance(remoteVolPath);
                UnsignedInt32 repErrorStatus = null;
                if (repSet == null) {
                    Trace.error((Object)this, (String)"checkCompletionFlags", (String)"Unable to get replication error status from RepSet");
                    return false;
                }
                repErrorStatus = (UnsignedInt32)repSet.getProperty("ReplicationErrorStatus").getValue().getValue();
                if (syncState.intValue() != 5 || repErrorStatus.intValue() != 0) {
                    Trace.info((Object)this, (String)"checkCompletionFlags", (String)"Not currently synchronizing or in error,job must be completed.");
                    remoteVolWwn = (String)remoteVolPath.getKey("DeviceID").getValue().getValue();
                    notificationInfo.add(remoteVolWwn);
                    notificationInfo.add(localVolWwn);
                    notificationInfo.add("OK");
                    return true;
                }
                Trace.info((Object)this, (String)"checkCompletionFlags", (String)"RepSet appears to be synchronizing.");
                return false;
            }
        }
        catch (CIMException ce) {
            Trace.error((Object)this, (String)"checkCompletionFlags", (String)"Errors examining completion of job.");
            return false;
        }
        return false;
    }

    public void sendNotification(Vector notificationInfo) {
        String METHOD = "sendNotification";
        Trace.methodBegin((Object)this, (String)"sendNotification");
        if (notificationInfo.size() != 0) {
            String firstWwn = (String)notificationInfo.get(0);
            String secondWwn = (String)notificationInfo.get(1);
            String status = (String)notificationInfo.get(2);
            DspPropertyVolumeReplicationSync listener = DspPropertyVolumeReplicationSync.getInstance(this.getDsp());
            PropertyChangeEvent newEvent = listener.createNotification(firstWwn, 100, status, secondWwn, 0);
            Trace.info((Object)this, (String)"sendNotification", (String)"Sending artificial completion notification...");
            listener.propertyChange(newEvent);
        } else {
            Trace.error((Object)this, (String)"sendNotification", (String)"No wwns to build notification from!");
        }
    }
}

