/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.DspDebounceTimer;
import com.sun.netstorage.dsp.mgmt.se6920.DspEventTarget;
import com.sun.netstorage.dsp.mgmt.se6920.DspTimedActionListener;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

class DspEventTargetPitRollback
extends DspEventTarget
implements DspTimedActionListener {
    private static String CLASSNAME = "DspEventTargetPitRollback";
    private static final String VOLUME_PIT_ROLLBACK_JOBNAME = "PITRollback";
    private static final int MAX_WAIT = 60;
    private static final int MAX_NOTIFICATIONS = 3;
    private Map timerMap = Collections.synchronizedMap(new HashMap());
    private static final String sccs_id = "@(#)DspEventTargetPitRollback.java    1.7    05/05/10     SMI";

    public DspEventTargetPitRollback(ArrayObject theDsp, String targetWwn) {
        super(theDsp, targetWwn);
        String METHOD = "Constructor";
        Trace.methodBegin((Object)this, (String)METHOD);
        this.getValidJobnames().add(VOLUME_PIT_ROLLBACK_JOBNAME);
    }

    protected void updateVolume(String notifiedWwn) {
        String METHOD = "updateVolume";
        Trace.methodBegin((Object)this, (String)"updateVolume");
        Trace.info((Object)this, (String)"updateVolume", (String)(" notifiedWwn = " + notifiedWwn));
        if (this.getVolume() == null) {
            Trace.info((Object)this, (String)"updateVolume", (String)" No volume to update");
            return;
        }
        if (this.isKilled()) {
            Trace.info((Object)this, (String)"updateVolume", (String)" already killed - not updating volume");
            return;
        }
        if (this.timerMap.containsKey(notifiedWwn)) {
            Trace.info((Object)this, (String)"updateVolume", (String)" Giving the timer a kick");
            ((DspDebounceTimer)this.timerMap.get(notifiedWwn)).notifyTimer();
        } else {
            Trace.info((Object)this, (String)"updateVolume", (String)" Creating a new timer");
            DspDebounceTimer timer = new DspDebounceTimer(30, 60, 3, 10, 30, this, notifiedWwn, notifiedWwn + " PitRollbackTimer");
            this.timerMap.put(notifiedWwn, timer);
            timer.startTimer();
        }
    }

    public void doTimedAction(DspDebounceTimer timer, Object parms) {
        String METHOD = "doTimedAction";
        Trace.methodBegin((Object)this, (String)METHOD);
        if (parms == null) {
            Trace.error((Object)this, (String)METHOD, (String)" Called with null parms - can't do anything!");
            return;
        }
        String notifiedWwn = (String)parms;
        Trace.info((Object)this, (String)METHOD, (String)(" Updating CIM instance for snapshot volume " + notifiedWwn + " because of notification for WWN = " + notifiedWwn));
        String volPage = new String(this.getReloadPage() + notifiedWwn);
        RequestBroker.getInstance().reloadCachePage(this.getDsp(), volPage);
        String targetWwn = this.getTargetVolumeWwn();
        Trace.info((Object)this, (String)METHOD, (String)(" Updating CIM instance for parent volume " + targetWwn + " because of notification for WWN = " + notifiedWwn));
        volPage = new String(this.getReloadPage() + targetWwn);
        RequestBroker.getInstance().reloadCachePage(this.getDsp(), volPage);
        this.timerMap.remove(notifiedWwn);
    }

    public void reloadInfo() {
        String METHOD = "reloadInfo";
        Trace.methodBegin((Object)this, (String)"reloadInfo");
    }

    public boolean checkCompletionFlags(Vector notificationInfo) {
        return false;
    }

    public void sendNotification(Vector notificationInfo) {
        String METHOD = "sendNotification";
        Trace.methodBegin((Object)this, (String)"sendNotification");
    }
}

