/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.DspJob;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyBroker;
import com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPConcreteJob;
import com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStorageVolume;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;

abstract class DspEventTarget {
    private static String CLASSNAME = "DspEventTarget";
    private static String SYSTEM_CLASS = "SunStorEdge_DSPStorageSystem";
    private static String VOLUME_CLASS = "SunStorEdge_DSPStorageVolume";
    private static String CLASSNAME_PROP = "SystemCreationClassName";
    private static String SYSTEM_NAME_PROP = "SystemName";
    private static String NAME_PROP = "Name";
    private static String CREATION_CLASSNAME_PROP = "CreationClassName";
    private static String DEVICE_ID_PROP = "DeviceID";
    private static final String AFFECTED_JOB_ELEMENT_CLASS = "SunStorEdge_DSPAffectedJobElement";
    private static final String AFFECTED = "AffectedElement";
    private static final String AFFECTING = "AffectingElement";
    private static final String DSP_CONCRETE_JOB = "SunStorEdge_DspConcreteJob";
    private static final String VOLUME_PIT_ROLLBACK_JOBNAME = "PIT Rollback";
    private static final String JOB_MODIFY_MODULE = "ModifySunStorEdge_DSPConcreteJob";
    private static final String VOLSTAT_PAGE_REQUEST = "volstat.xml?samVolume_SetByWwn=";
    private static final String STATUS_OK = "OK";
    private static final String STATUS_ERROR = "ERROR";
    private String reloadPage = "volstat.xml?samVolume_SetByWwn=";
    private ArrayObject dsp = null;
    private String targetVolumeWwn = null;
    private Map notificationWwns = new HashMap();
    private int percentComplete = 0;
    private int errorsReceived = 0;
    private boolean jobToldAboutErrors = false;
    private CIMObjectPath volume = null;
    private DspJob job = null;
    private Date updateTime = null;
    private boolean killed = false;
    private List validJobnames = new ArrayList();
    private static final String sccs_id = "@(#)DspEventTarget.java    1.16    05/04/22     SMI";

    public String getTargetVolumeWwn() {
        return this.targetVolumeWwn;
    }

    public void setTargetVolumeWwn(String wwn) {
        this.targetVolumeWwn = wwn;
    }

    public DspJob getJob() {
        return this.job;
    }

    public void setJob(DspJob newjob) {
        this.job = newjob;
    }

    public CIMObjectPath getVolume() {
        return this.volume;
    }

    public boolean isKilled() {
        return this.killed;
    }

    public boolean isStale(Date staleTime) {
        return this.updateTime.before(staleTime);
    }

    public int getPercentComplete() {
        return this.percentComplete;
    }

    private void setPercentComplete(int newPercent) {
        this.percentComplete = newPercent;
    }

    private boolean isJobToldAboutErrors() {
        return this.jobToldAboutErrors;
    }

    private void setJobToldAboutErrors(boolean flag) {
        this.jobToldAboutErrors = flag;
    }

    public int getErrorsReceived() {
        return this.errorsReceived;
    }

    private void setErrorsReceived(int newCount) {
        this.errorsReceived = newCount;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public String getReloadPage() {
        return this.reloadPage;
    }

    public ArrayObject getDsp() {
        return this.dsp;
    }

    public Map getNotificationWwns() {
        return this.notificationWwns;
    }

    protected List getValidJobnames() {
        return this.validJobnames;
    }

    public DspEventTarget(ArrayObject theDsp, String targetWwn) {
        String METHOD = "Constructor";
        Trace.methodBegin((Object)this, (String)METHOD);
        this.dsp = theDsp;
        this.targetVolumeWwn = targetWwn;
        this.updateTime = new Date(System.currentTimeMillis());
    }

    public void addNotificationWwn(String notifiedWwn) {
        String METHOD = "addNotificationWwn";
        Trace.methodBegin((Object)this, (String)"addNotificationWwn");
        Trace.info((Object)this, (String)"addNotificationWwn", (String)(" notifiedWwn = " + notifiedWwn));
        if (this.getPercentComplete() != 0) {
            Trace.info((Object)this, (String)"addNotificationWwn", (String)" We've already received notifications.  Adding to table and updating target");
            this.update(notifiedWwn, 0, STATUS_OK);
        } else {
            Trace.info((Object)this, (String)"addNotificationWwn", (String)" Adding WWN to notification list");
            this.getNotificationWwns().put(notifiedWwn, new Integer(0));
        }
    }

    public void update(String notifiedWwn, int newPercent, String status) {
        String METHOD = "update";
        Trace.methodBegin((Object)this, (String)"update");
        Trace.info((Object)this, (String)"update", (String)(" notifiedWwn = " + notifiedWwn + ", newPercent = " + newPercent + ", status = " + status));
        this.updateTime = new Date(System.currentTimeMillis());
        boolean updateTable = false;
        if (this.getNotificationWwns().containsKey(notifiedWwn)) {
            int currentPercent = (Integer)this.getNotificationWwns().get(notifiedWwn);
            Trace.info((Object)this, (String)"update", (String)(" Current percent for notifiedWwn = " + notifiedWwn + " = " + currentPercent));
            if (newPercent < 0 || newPercent > 100) {
                Trace.error((Object)this, (String)"update", (String)(" Invalid newPercent:  " + newPercent));
            } else if (currentPercent != 100) {
                if (newPercent > currentPercent) {
                    Trace.info((Object)this, (String)"update", (String)(" Need to update percent complete for notification Wwn " + notifiedWwn));
                    updateTable = true;
                } else {
                    Trace.info((Object)this, (String)"update", (String)(" Obsolete notification.  Percent complete already " + currentPercent + " for notifiedWwn" + notifiedWwn));
                }
            } else {
                Trace.info((Object)this, (String)"update", (String)" Obsolete notification.  WWN already 100% complete");
            }
        } else {
            Trace.info((Object)this, (String)"update", (String)(" New notifiedWwn " + notifiedWwn));
            updateTable = true;
        }
        if (updateTable) {
            Trace.info((Object)this, (String)"update", (String)" Updating notification table ");
            this.getNotificationWwns().put(notifiedWwn, new Integer(newPercent));
            this.updatePercent();
        }
        if (!status.equals(STATUS_OK)) {
            this.setErrorsReceived(this.getErrorsReceived() + 1);
            Trace.info((Object)this, (String)"update", (String)(" This notifictation had a status of " + status + ".  Updating error counter to" + this.getErrorsReceived()));
        }
        if (this.volume == null) {
            this.findVolume();
        }
        if (this.volume != null) {
            this.updateVolume(notifiedWwn);
        } else {
            Trace.debug((Object)this, (String)"update", (String)" No volume to update");
        }
        if (this.job == null) {
            this.findJob();
        }
        if (this.job == null && this.volume != null) {
            Trace.info((Object)this, (String)"update", (String)" Creating a spontaneous job for this volume");
            this.createJob();
        }
        if (this.job != null) {
            this.updateJob();
        } else {
            Trace.debug((Object)this, (String)"update", (String)" No volume to update");
        }
        Trace.methodEnd((Object)this, (String)"update");
    }

    private void updatePercent() {
        String METHOD = "updatePercent";
        Trace.methodBegin((Object)this, (String)"updatePercent");
        int newPercent = 0;
        int elements = 0;
        Collection notifiedElements = this.getNotificationWwns().values();
        Iterator it = notifiedElements.iterator();
        while (it.hasNext()) {
            newPercent += ((Integer)it.next()).intValue();
            ++elements;
        }
        if (elements == 0) {
            Trace.debug((Object)this, (String)"updatePercent", (String)" No elements in notification list");
            this.setPercentComplete(0);
        } else {
            Trace.debug((Object)this, (String)"updatePercent", (String)(" Calculating new percentComplete by averaging " + elements + " in notification list"));
            int oldPercent = this.getPercentComplete();
            int percent = newPercent / elements;
            this.setPercentComplete(percent);
            Trace.debug((Object)this, (String)"updatePercent", (String)(" Updating percentComplete from " + oldPercent + " to " + percent + " percent"));
        }
        Trace.methodEnd((Object)this, (String)"updatePercent");
    }

    public void kill() {
        String METHOD = "kill";
        Trace.methodBegin((Object)this, (String)"kill");
        this.killed = true;
    }

    private void findVolume() {
        String METHOD = "findVolume";
        Trace.methodBegin((Object)this, (String)"findVolume");
        if (this.volume != null) {
            Trace.info((Object)this, (String)"findVolume", (String)" Already have the volume");
            return;
        }
        if (this.getTargetVolumeWwn() == null) {
            Trace.info((Object)this, (String)"findVolume", (String)" No volume WWN set - can't find it");
            return;
        }
        Trace.info((Object)this, (String)"findVolume", (String)(" Searching for volume with WWN = " + this.getTargetVolumeWwn()));
        String searchWwn = this.getTargetVolumeWwn().replaceAll(":", "");
        Object curVolPath = null;
        CIMInstance curVol = null;
        try {
            curVol = ModifySunStorEdge_DSPStorageVolume.getStorageVolume(searchWwn);
        }
        catch (CIMException e1) {
            Trace.error((Object)this, (String)"findVolume", (String)(" Exception searching for volume with WWN = " + this.getTargetVolumeWwn()));
        }
        if (curVol != null) {
            this.volume = curVol.getObjectPath();
            Trace.info((Object)this, (String)"findVolume", (String)" Found the volume");
        } else {
            Trace.info((Object)this, (String)"findVolume", (String)" Cound not find the volume");
        }
    }

    private void findJob() {
        CIMObjectPath[] jobPaths;
        String METHOD = "findJob";
        Trace.methodBegin((Object)this, (String)"findJob");
        if (this.volume == null) {
            Trace.info((Object)this, (String)"findJob", (String)" No volume.  Can't find a job without a volume");
            return;
        }
        CIMObjectPath jobAssocPath = new CIMObjectPath(AFFECTED_JOB_ELEMENT_CLASS);
        try {
            jobPaths = RequestBroker.getInstance().associatorNames(jobAssocPath, this.volume, DSP_CONCRETE_JOB, AFFECTED, AFFECTING);
        }
        catch (CIMException e1) {
            return;
        }
        if (jobPaths != null) {
            Trace.info((Object)this, (String)"findJob", (String)" Checking job list");
            ModifySunStorEdge_DSPConcreteJob jobMod = (ModifySunStorEdge_DSPConcreteJob)ModifyBroker.getInstance().getModule(this.dsp.getHost(), JOB_MODIFY_MODULE);
            if (jobMod != null) {
                DspJob tmpJob = null;
                for (int i = 0; i < jobPaths.length; ++i) {
                    try {
                        tmpJob = jobMod.findCimJob(jobPaths[i]);
                        String jobName = tmpJob.getCimJobName();
                        Iterator it = this.getValidJobnames().iterator();
                        while (it.hasNext()) {
                            String supportedJob = (String)it.next();
                            if (!jobName.equals(supportedJob)) continue;
                            Trace.info((Object)this, (String)"findJob", (String)" Found a job!");
                            this.job = tmpJob;
                            return;
                        }
                        continue;
                    }
                    catch (CIMException e) {
                        // empty catch block
                    }
                }
            }
        }
        Trace.info((Object)this, (String)"findJob", (String)" Could not find a job!");
    }

    protected void updateVolume(String notifiedWwn) {
        String METHOD = "updateVolume";
        Trace.methodBegin((Object)this, (String)"updateVolume");
        if (this.volume == null) {
            Trace.info((Object)this, (String)"updateVolume", (String)" No volume to update");
            return;
        }
        if (!this.isKilled()) {
            Trace.info((Object)this, (String)"updateVolume", (String)" Updating volume");
            String volPage = new String(VOLSTAT_PAGE_REQUEST + this.getTargetVolumeWwn());
            RequestBroker.getInstance().reloadCachePage(this.dsp, volPage);
        } else {
            Trace.info((Object)this, (String)"updateVolume", (String)" already killed - not updating volume");
        }
    }

    protected void updateJob() {
        String METHOD = "updateJob";
        Trace.methodBegin((Object)this, (String)"updateJob");
        if (this.job == null) {
            Trace.info((Object)this, (String)"updateJob", (String)" No job to update");
            return;
        }
        if (!this.isKilled()) {
            Trace.info((Object)this, (String)"updateJob", (String)" Updating job");
            this.job.setPercentComplete(this.getPercentComplete());
            if (this.getErrorsReceived() != 0 && !this.isJobToldAboutErrors()) {
                this.job.setCompletion(6, this.getTargetVolumeWwn(), false);
                this.setJobToldAboutErrors(true);
            }
        } else {
            Trace.info((Object)this, (String)"updateJob", (String)" already killed - not updating job");
        }
    }

    private boolean createJob() {
        String METHOD = "createJob";
        Trace.methodBegin((Object)this, (String)"createJob");
        Trace.info((Object)this, (String)"createJob", (String)" This is a stub.");
        return false;
    }

    public void checkForTargetCompletion(boolean reloadPage) {
        Vector notificationInfo;
        String METHOD = "checkForTargetCompletion";
        Trace.methodBegin((Object)this, (String)"checkForTargetCompletion");
        if (reloadPage) {
            this.reloadInfo();
        }
        if (this.checkCompletionFlags(notificationInfo = new Vector())) {
            this.sendNotification(notificationInfo);
        }
    }

    public abstract void reloadInfo();

    public abstract boolean checkCompletionFlags(Vector var1);

    public abstract void sendNotification(Vector var1);
}

