/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.DspTimedActionListener;

public class DspDebounceTimer
implements Runnable {
    private static final String CLASSNAME = "DspDebounceTimer";
    public static final int DEFAULT_SLEEP_TIME = 10;
    public static final int DEFAULT_MIN_WAIT = 30;
    private boolean standaloneDebugMessaging = false;
    private int sleepTime = 10000;
    private int minTime = 0;
    private int maxTime = 0;
    private int origMaxTime = 0;
    private int newMinimumWaitTime = 30000;
    private int maxNotifications = 0;
    private boolean maxWaitTimeSet = false;
    private boolean maxNotificationsSet = false;
    private DspTimedActionListener listener = null;
    private Object listenerParms = null;
    private String name = new String("UnNamedDebounceTimer");
    private static final String sccs_id = "@(#)DspDebounceTimer.java    1.2    05/03/11   SMI";

    private void setStandaloneDebugMessaging(boolean flag) {
        this.standaloneDebugMessaging = flag;
        this.standaloneMsg("Standalone debug messaging set to " + flag);
    }

    private void standaloneMsg(String msg) {
        if (this.standaloneDebugMessaging) {
            System.out.println("      Timer " + this.getName() + ": " + msg);
        }
    }

    public String getName() {
        return this.name;
    }

    public DspDebounceTimer(int minWait, int maxWait, int maxNotifications, int sleepInterval, int newMinimumWaitTime, DspTimedActionListener listener, Object listenerActionParms, String timerName) throws IllegalArgumentException {
        String METHOD = "Constructor";
        Trace.methodBegin((Object)this, (String)METHOD);
        if (listener == null) {
            throw new IllegalArgumentException("Missing listener param");
        }
        if (minWait < 0) {
            throw new IllegalArgumentException("Invalid value for minWait: " + minWait);
        }
        if (maxWait < 0) {
            throw new IllegalArgumentException("Invalid value for maxWait: " + maxWait);
        }
        if (maxNotifications < 0) {
            throw new IllegalArgumentException("Invalid value for maxNotifications: " + maxNotifications);
        }
        if (sleepInterval < 0) {
            throw new IllegalArgumentException("Invalid value for sleepInterval: " + sleepInterval);
        }
        Trace.info((Object)this, (String)METHOD, (String)" Setting the timer values");
        this.minTime = minWait * 1000;
        this.maxTime = maxWait * 1000;
        this.origMaxTime = maxWait;
        if (maxWait != 0) {
            this.maxWaitTimeSet = true;
        }
        this.maxNotifications = maxNotifications;
        if (maxNotifications != 0) {
            this.maxNotificationsSet = true;
        }
        if (sleepInterval != 0) {
            this.sleepTime = sleepInterval * 1000;
        }
        if (newMinimumWaitTime != 0) {
            this.newMinimumWaitTime = newMinimumWaitTime * 1000;
        }
        this.listener = listener;
        this.listenerParms = listenerActionParms;
        if (timerName != null) {
            this.name = timerName;
        }
        Trace.methodEnd((Object)this, (String)METHOD);
    }

    public DspDebounceTimer(int minWait, DspTimedActionListener listener, Object listenerActionParms, String timerName) throws IllegalArgumentException {
        this(minWait, 0, 0, 10, minWait, listener, listenerActionParms, timerName);
    }

    public DspDebounceTimer(int minWait, DspTimedActionListener listener, Object listenerActionParms) throws IllegalArgumentException {
        this(minWait, listener, listenerActionParms, null);
    }

    public void startTimer() {
        String METHOD = "startTimer";
        Trace.info((Object)this, (String)METHOD, (String)(" Timer " + this.name + " creating the timer run thread"));
        this.standaloneMsg("startTimer called - starting timer thread");
        Thread timerThread = new Thread((Runnable)this, "DspDebounceTimer " + this.name);
        timerThread.start();
        Trace.info((Object)this, (String)METHOD, (String)(" Timer " + this.name + " run thread started"));
    }

    public synchronized void notifyTimer() {
        this.notifyTimer(0);
    }

    public synchronized void notifyTimer(int minimumWait) {
        String METHOD = "notifyTimer";
        Trace.methodBegin((Object)this, (String)METHOD);
        this.standaloneMsg("notifyTimer called with delay = " + minimumWait);
        int newDelay = this.newMinimumWaitTime;
        if (this.maxNotificationsSet) {
            --this.maxNotifications;
        }
        if (minimumWait != 0) {
            newDelay = minimumWait * 1000;
        }
        this.standaloneMsg("computed delay is  = " + newDelay + " ms");
        if (this.minTime == 0) {
            Trace.info((Object)this, (String)METHOD, (String)(" Timer " + this.name + " already expired"));
            this.standaloneMsg("Timer already expired");
        } else if (newDelay > this.minTime) {
            Trace.info((Object)this, (String)METHOD, (String)(" Timer " + this.name + " reset from " + this.minTime + " ms to " + newDelay + " ms"));
            this.standaloneMsg("Timer reset from " + this.minTime + " ms to " + newDelay + " ms");
            this.minTime = newDelay;
        } else {
            Trace.info((Object)this, (String)METHOD, (String)(" Timer " + this.name + " not reset because " + newDelay + " ms is not more than current timer of " + this.minTime + " ms"));
            this.standaloneMsg("Timer not reset because " + newDelay + " ms is not more than current timer of " + this.minTime + " ms");
        }
    }

    public synchronized void disableAction() {
        String METHOD = "disableAction";
        this.listener = null;
        Trace.info((Object)this, (String)METHOD, (String)(" Timer " + this.name + " disabled"));
        this.standaloneMsg("disabled");
    }

    private synchronized int decrementAndCheckTime(int millisecs) {
        String METHOD = "decrementAndCheckTime";
        Trace.methodBegin((Object)this, (String)METHOD);
        this.minTime -= millisecs;
        this.standaloneMsg("Minimum wait time = " + this.minTime / 1000 + " sec");
        if (this.minTime <= 0) {
            this.standaloneMsg("Minimum wait timer expired");
            this.minTime = 0;
        }
        if (this.maxWaitTimeSet) {
            this.standaloneMsg("Checking max timer");
            this.maxTime -= millisecs;
            if (this.maxTime <= 0) {
                this.minTime = 0;
                this.standaloneMsg("  Max timer expired");
            } else {
                this.standaloneMsg("  Max timer still has " + this.maxTime / 1000 + " sec before max timer timeout");
            }
        }
        if (this.maxNotificationsSet) {
            this.standaloneMsg("Checking max notifications");
            if (this.maxNotifications <= 0) {
                this.minTime = 0;
                this.standaloneMsg("  Max notifications reached");
            } else {
                this.standaloneMsg("  Still have " + this.maxNotifications + " before invoking action");
            }
        }
        this.standaloneMsg("Still has " + this.minTime / 1000 + " sec");
        return this.minTime;
    }

    public void run() {
        String METHOD = "run";
        int timeRemaining = 1;
        Trace.info((Object)this, (String)"run", (String)(" Timer " + this.name + " Begin "));
        this.standaloneMsg("Run method called");
        while (timeRemaining > 0) {
            try {
                Trace.info((Object)this, (String)"run", (String)(" Timer " + this.name + " sleeping for " + this.sleepTime / 1000 + " seconds before checking timer"));
                this.standaloneMsg("Sleep for " + this.sleepTime / 1000 + " sec");
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException e) {
                Trace.info((Object)this, (String)"run", (String)" Received InterruptedException - checking timer");
            }
            timeRemaining = this.decrementAndCheckTime(this.sleepTime);
            Trace.info((Object)this, (String)"run", (String)(" Timer " + this.name + " has " + timeRemaining / 1000 + " seconds to sleep before running"));
        }
        this.standaloneMsg("Timer expired");
        if (this.listener != null) {
            Trace.info((Object)this, (String)"run", (String)(" Timer " + this.name + " Running timed action"));
            this.standaloneMsg("Running action");
            this.listener.doTimedAction(this, this.listenerParms);
        } else {
            Trace.info((Object)this, (String)"run", (String)(" Timer " + this.name + " Timer has been disabled - null listener"));
            this.standaloneMsg("Timer has been disabled - null listener");
        }
        Trace.info((Object)this, (String)"run", (String)(" Timer " + this.name + " Complete"));
        this.standaloneMsg("Run complete");
    }

    public static void main(String[] args) {
        System.out.println("\nTest4:  Create a timer that expires in 15 sec or 5 notifications");
        System.out.println("        Notify 5 times.  Timer should expire at 1st check");
        class DebounceTester
        implements DspTimedActionListener {
            DspDebounceTimer timer = null;

            public DebounceTester(int minWait, int maxWait, int maxNotifications, int sleepInterval, int newMinWaitTime, String timerName) {
                this.timer = new DspDebounceTimer(minWait, maxWait, maxNotifications, sleepInterval, newMinWaitTime, this, timerName, timerName);
            }

            public DspDebounceTimer getTimer() {
                return this.timer;
            }

            public synchronized void doTimedAction(DspDebounceTimer timer, Object parms) {
                System.out.println("\ndoTimedAction called");
                if (parms instanceof String) {
                    System.out.println("  parms = " + parms);
                }
            }
        }
        DebounceTester test4 = new DebounceTester(15, 0, 5, 5, 15, "test4Timer");
        DspDebounceTimer test4Timer = test4.getTimer();
        test4Timer.setStandaloneDebugMessaging(true);
        test4Timer.startTimer();
        test4Timer.notifyTimer();
        test4Timer.notifyTimer();
        test4Timer.notifyTimer();
        test4Timer.notifyTimer();
        test4Timer.notifyTimer();
        for (int i = 1; i <= 30; ++i) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            System.out.print(i + " ");
        }
        System.out.println("\nTest4:  Complete\n");
        System.out.println("Tests complete\n");
    }
}

