/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.DspRapidMark;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Label;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import rl.clbroker.Broker;
import rl.clbroker.ExceptionObserver;
import rl.clbroker.ExceptionOccurence;
import rl.clbroker.RlBeanProperty;
import rl.clbroker.RlUtil;

public class DspChangeListener
extends Thread
implements ExceptionObserver {
    private static final String CLASSNAME = "DspChangeListener";
    public static final int DEFAULT_CHANGE_LISTENER_PORT = 3002;
    private static final String DEFAULT_USERID = "root";
    private static final String DEFAULT_PASSWORD = "pirus";
    public static final int RUN_FOREVER = -1;
    private static int exceptionCounter = 0;
    private ArrayObject dsp = null;
    private String host;
    private int port = 3002;
    private String userid;
    private String password;
    private int maxPacketSize = 4096;
    private boolean useTcp = true;
    private boolean brokerStarted = false;
    private List universalListeners = new ArrayList();
    private List monitoredRms = new ArrayList();
    private int runTimer = 0;
    private boolean runDebug = false;
    private JFrame frame;
    JPanel contents;
    private boolean usingVisuals = false;
    private static final String sccs_id = " * @(#)DspChangeListener.java    1.15    05/04/14     SMI";
    static /* synthetic */ Class class$java$lang$String;

    protected String getHost() {
        return this.host;
    }

    protected int getPort() {
        return this.port;
    }

    protected String getUserid() {
        return this.userid;
    }

    protected String getPassword() {
        return this.password;
    }

    protected int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    protected boolean getUseTcp() {
        return this.useTcp;
    }

    protected boolean isBrokerStarted() {
        return this.brokerStarted;
    }

    protected void setBrokerStarted(boolean flag) {
        this.brokerStarted = flag;
    }

    public int getRunTimer() {
        return this.runTimer;
    }

    public void setRunTimer(int seconds) {
        this.runTimer = seconds;
    }

    public boolean getRunDebug() {
        return this.runDebug;
    }

    public void setRunDebug(boolean flag) {
        this.runDebug = flag;
    }

    protected JFrame getFrame() {
        return this.frame;
    }

    protected JPanel getContents() {
        return this.contents;
    }

    protected boolean getUsingVisuals() {
        return this.usingVisuals;
    }

    public DspChangeListener(String host, int port, String userid, String password, boolean useVisuals) throws UnknownHostException {
        this.host = host;
        this.port = port;
        userid = new String(userid);
        password = new String(password);
        this.usingVisuals = useVisuals;
        RlUtil.setTraceLevel(4);
        RlUtil.setTraceStream(2);
        int traceLevel = Trace.getLoggingLevel(this.getClass());
        if (traceLevel > 3) {
            RlUtil.setIgnoreKeepAliveMsgs(false);
        } else {
            RlUtil.setIgnoreKeepAliveMsgs(true);
        }
        if (this.usingVisuals) {
            this.frame = new JFrame(CLASSNAME);
            this.contents = new JPanel();
            this.contents.setBorder(BorderFactory.createEmptyBorder(30, 30, 10, 30));
            this.contents.setLayout(new GridLayout(0, 1));
            this.frame.getContentPane().add(this.contents);
            this.frame.pack();
            this.frame.setVisible(this.usingVisuals);
            this.frame.setSize(new Dimension(300, 200));
            this.frame.setVisible(true);
        }
        this.initializeCommunications();
    }

    public DspChangeListener(String host, int port, String userid, String password) throws UnknownHostException {
        this(host, port, userid, password, false);
    }

    public DspChangeListener(String host, int port) throws UnknownHostException {
        this(host, port, DEFAULT_USERID, DEFAULT_PASSWORD);
    }

    public DspChangeListener(String host) throws UnknownHostException {
        this(host, 3002);
    }

    public DspChangeListener(ArrayObject dsp, boolean useVisuals) throws UnknownHostException {
        this(dsp.getHost(), dsp.getListenerPort(), dsp.getUser(), dsp.getPassword(), false);
        this.dsp = dsp;
    }

    private synchronized DspRapidMark findMonitoredRapidMark(String rmName) {
        DspRapidMark rm = null;
        Iterator it = this.monitoredRms.iterator();
        while (it.hasNext()) {
            rm = (DspRapidMark)it.next();
            if (!rm.getName().equals(rmName)) continue;
            return rm;
        }
        return null;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener, String rapidMark) {
        if (listener == null) {
            return;
        }
        if (rapidMark != null) {
            DspRapidMark rm = this.findMonitoredRapidMark(rapidMark);
            if (rm == null) {
                rm = new DspRapidMark(rapidMark, "");
                Broker.addMagicMarkup(rapidMark, "java.lang.String", false);
                RlBeanProperty beanProp = Broker.wrapBeanProperty((Object)rm, "text", class$java$lang$String == null ? (class$java$lang$String = DspChangeListener.class$("java.lang.String")) : class$java$lang$String, "getValue", "setValue");
                Broker.bindMarkupToBeanProperty(rapidMark, "", null, beanProp, false, false, true, null);
                if (this.usingVisuals) {
                    ListenerLabel label = new ListenerLabel(rm);
                    JPanel contents = this.getContents();
                    contents.add(new Label(rapidMark + " change listener:"));
                    contents.add(label);
                    this.getFrame().pack();
                    this.getFrame().setVisible(this.usingVisuals);
                }
                rm.addPropertyChangeListener(listener);
                Iterator it = this.universalListeners.iterator();
                while (it.hasNext()) {
                    rm.addPropertyChangeListener((PropertyChangeListener)it.next());
                }
                this.monitoredRms.add(rm);
            } else {
                rm.addPropertyChangeListener(listener);
            }
        } else {
            Iterator it = this.monitoredRms.iterator();
            while (it.hasNext()) {
                ((DspRapidMark)it.next()).addPropertyChangeListener(listener);
            }
            int index = this.universalListeners.indexOf(listener);
            if (index == -1) {
                this.universalListeners.add(listener);
            }
        }
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.addPropertyChangeListener(listener, null);
    }

    public synchronized PropertyChangeListener[] findPropertyChangeListener(String rapidMark) {
        if (rapidMark == null) {
            return null;
        }
        DspRapidMark rm = this.findMonitoredRapidMark(rapidMark);
        if (rm != null) {
            return rm.getListeners();
        }
        return null;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener, String rapidMark) {
        if (listener == null) {
            return;
        }
        if (rapidMark != null) {
            DspRapidMark rm = this.findMonitoredRapidMark(rapidMark);
            if (rm != null) {
                rm.removePropertyChangeListener(listener);
            }
        } else {
            Iterator it = this.monitoredRms.iterator();
            while (it.hasNext()) {
                ((DspRapidMark)it.next()).removePropertyChangeListener(listener);
            }
            int index = this.universalListeners.indexOf(listener);
            if (index != -1) {
                this.universalListeners.remove(index);
            }
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.removePropertyChangeListener(listener, null);
    }

    public synchronized void removeAllPropertyChangeListeners(String rapidMark) {
        if (rapidMark != null) {
            DspRapidMark rm = this.findMonitoredRapidMark(rapidMark);
            if (rm != null) {
                rm.removeAllPropertyChangeListeners();
            }
        } else {
            Iterator it = this.monitoredRms.iterator();
            while (it.hasNext()) {
                ((DspRapidMark)it.next()).removeAllPropertyChangeListeners();
            }
            this.universalListeners = new ArrayList();
        }
    }

    public synchronized void removeAllPropertyChangeListeners() {
        this.removeAllPropertyChangeListeners(null);
    }

    private void initializeCommunications() throws UnknownHostException {
        RlUtil.trace(4, "    DspChangeListener.initializeCommunications");
        if (this.usingVisuals) {
            Broker.setCurrentDisplay(this.frame);
        } else {
            Broker.setCurrentDisplay(null);
        }
        Broker.setOptions(this.host, this.port, this.maxPacketSize);
        Broker.setUser(this.userid, this.password);
        Broker.registerExceptionObserver(this);
        Broker.start();
        RlUtil.trace(4, "    DspChangeListener.initializeCommunications - complete");
    }

    public void exceptionOccurred(ExceptionOccurence exc) {
        String METHOD = "exceptionOccurred";
        RlUtil.trace(4, "    DspChangeListener.exceptionOccurred");
        Trace.error((Object)this, (String)"exceptionOccurred", (String)("RL Exception: " + exc.toString()));
        Trace.error((Object)this, (String)"exceptionOccurred", (Throwable)exc.getException());
        Thread exceptionThread = new Thread(new Runnable(){

            public void run() {
                RlUtil.trace(4, "    DspChangeListener.exceptionOccurred thread run");
                if (DspChangeListener.this.dsp == null) {
                    RlUtil.trace(4, "    DspChangeListener.exceptionOccurred thread - standalone testing module hit exception");
                    try {
                        DspChangeListener.this.disableCommunications();
                        DspChangeListener.this.restartCommunications();
                    }
                    catch (Exception exception) {}
                } else {
                    RlUtil.trace(4, "    DspChangeListener.exceptionOccurred thread - using dsp.handleChangeListenerException");
                    DspChangeListener.this.dsp.handleChangeListenerException();
                }
            }
        });
        exceptionThread.setName(" RLexceptionThread " + ++exceptionCounter);
        exceptionThread.setDaemon(true);
        RlUtil.trace(4, "    DspChangeListener.exceptionOccurred - starting thread");
        exceptionThread.start();
    }

    public ArrayObject getDspAsArrayObject() {
        if (this.dsp != null) {
            return this.dsp;
        }
        return ArrayObject.getInstance(this.getHost(), this.getPort(), this.getUserid(), this.getPassword());
    }

    public void run() {
        int dotCount = 0;
        if (this.runDebug) {
            System.out.print("  *** Starting DspChangeListener to run ");
            if (-1 == this.runTimer) {
                System.out.println("forever");
            } else {
                System.out.println(" for " + this.runTimer + " seconds");
            }
        }
        while (this.runTimer > 0 || this.runTimer == -1) {
            if (this.runDebug) {
                System.out.print(".");
                if (++dotCount > 60) {
                    System.out.println("");
                    dotCount = 0;
                }
            }
            try {
                DspChangeListener.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.runTimer <= 0) continue;
            --this.runTimer;
        }
        if (this.runDebug) {
            System.out.print("  *** Stopping DspChangeListener");
        }
    }

    public String toDebugString() {
        StringBuffer work = new StringBuffer("DspChangeListener has <" + this.monitoredRms.size() + "> monitored RMs: \n");
        Iterator it = this.monitoredRms.iterator();
        while (it.hasNext()) {
            DspRapidMark rm = (DspRapidMark)it.next();
            work.append(rm.toDebugString() + "\n");
        }
        return work.toString();
    }

    public void disableCommunications() {
        RlUtil.trace(4, "    DspChangeListener.disableCommunications");
        Broker.pausePolling();
        Broker.pauseHandlers();
        Broker.breakCommunications();
        RlUtil.trace(4, "    DspChangeListener.disableCommunications - complete");
    }

    public void restartCommunications() throws Exception {
        RlUtil.trace(4, "    DspChangeListener.restartCommunications");
        try {
            Broker.startCommunications();
            Broker.registerExceptionObserver(this);
            Broker.unpauseHandlers();
            Broker.unpausePolling();
        }
        catch (Exception e) {
            RlUtil.trace(4, "    DspChangeListener.disableCommunications - exception");
            throw new Exception("RapidLogic Broker communication error");
        }
        RlUtil.trace(4, "    DspChangeListener.disableCommunications - complete");
    }

    public void start() {
        Broker.unpauseHandlers();
    }

    public void stopListener() {
        Broker.pauseHandlers();
    }

    public void unpauseHandlers() {
        Broker.unpauseHandlers();
    }

    public void pauseHandlers() {
        Broker.pauseHandlers();
    }

    public void kill() {
        this.removeAllPropertyChangeListeners();
        Broker.kill();
    }

    public static void usage() {
        System.out.println("\nUsage:  DspPropertyChangeListener <host> <port> [-u userid] [-p password]  [-r <rapidMark>] [-g]\n\n");
        System.out.println("  Specify -g  flag to display graphically");
    }

    public static void main(String[] argv) throws Exception {
        int currentArg = 0;
        int argc = argv.length;
        String host = null;
        int port = 3002;
        String userid = new String(DEFAULT_USERID);
        String password = new String(DEFAULT_PASSWORD);
        boolean useGraphics = false;
        String userRm = null;
        DspRapidMark rm = null;
        Object newEvent = null;
        PropertyChangeListener propertyChangeListener1 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                DspRapidMark rm = (DspRapidMark)e.getSource();
                System.out.println("\n\tpropertyChangeListener1 got a PropertyChangeEvent from " + rm.getName());
                System.out.println("\t\tOld value:  " + e.getOldValue());
                System.out.println("\t\tNew value:  " + e.getNewValue());
            }

            public String toString() {
                return "propertyChangeListener1";
            }
        };
        PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                DspRapidMark rm = (DspRapidMark)e.getSource();
                System.out.println("\n\tpropertyChangeListener2 got a PropertyChangeEvent from " + rm.getName());
                System.out.println("\t\tOld value:  " + e.getOldValue());
                System.out.println("\t\tNew value:  " + e.getNewValue());
            }

            public String toString() {
                return "propertyChangeListener2";
            }
        };
        PropertyChangeListener propertyChangeListener3 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                DspRapidMark rm = (DspRapidMark)e.getSource();
                System.out.println("\n\tpropertyChangeListener3 got a PropertyChangeEvent from " + rm.getName());
                System.out.println("\t\tOld value:  " + e.getOldValue());
                System.out.println("\t\tNew value:  " + e.getNewValue());
            }

            public String toString() {
                return "propertyChangeListener3";
            }
        };
        if (argc < 2) {
            DspChangeListener.usage();
            System.exit(1);
        }
        host = argv[currentArg++];
        try {
            port = Integer.parseInt(argv[currentArg++]);
        }
        catch (NumberFormatException nfe) {
            DspChangeListener.usage();
            System.exit(1);
        }
        if (currentArg < argc && argv[currentArg].equals("-u")) {
            if (currentArg + 1 >= argc) {
                System.out.println("*** Need to specify userid with '-u'");
                DspChangeListener.usage();
                System.exit(1);
            }
            userid = argv[currentArg + 1];
            currentArg += 2;
        }
        if (currentArg < argc && argv[currentArg].equals("-p")) {
            if (currentArg + 1 >= argc) {
                System.out.println("*** Need to specify password with '-p'");
                DspChangeListener.usage();
                System.exit(1);
            }
            password = argv[currentArg + 1];
            currentArg += 2;
        }
        if (currentArg < argc && argv[currentArg].equals("-r")) {
            if (currentArg + 1 >= argc) {
                System.out.println("*** Need to specify rapidMark namd with '-r'");
                DspChangeListener.usage();
                System.exit(1);
            }
            userRm = argv[currentArg + 1];
            currentArg += 2;
        }
        if (currentArg < argc && argv[currentArg].equals("-g")) {
            useGraphics = true;
            ++currentArg;
        }
        System.out.println("\nDspChangeListener starting\n\n");
        if (userRm != null) {
            System.out.println("\n  Listening for changes to RM " + userRm + "\n\n");
        }
        DspChangeListener listener = new DspChangeListener(host, port, userid, password, useGraphics);
        System.out.println("\nNew DspChangeListener created: " + listener.toDebugString() + "\n");
        if (userRm != null) {
            String rapidMark = userRm;
            listener.addPropertyChangeListener(propertyChangeListener3, rapidMark);
            System.out.println("\n Registered PCL3 to listen for changes to " + rapidMark + ":\n" + listener.toDebugString());
            listener.setRunDebug(true);
            listener.setRunTimer(-1);
            listener.run();
            listener.removeAllPropertyChangeListeners(rapidMark);
            System.out.println("\n Unregistered all callbacks for changes to " + rapidMark + ":\n" + listener.toDebugString());
        } else {
            String rapidMark = "rapidMark1";
            listener.addPropertyChangeListener(propertyChangeListener1, rapidMark);
            System.out.println("\n Registered PCL1 to listen for changes to " + rapidMark + ":\n" + listener.toDebugString());
            rapidMark = "rapidMark2";
            listener.addPropertyChangeListener(propertyChangeListener1, rapidMark);
            System.out.println("\n Registered PCL1 to listen for changes to " + rapidMark + ":\n" + listener.toDebugString());
            rapidMark = "rapidMark3";
            listener.addPropertyChangeListener(propertyChangeListener1, rapidMark);
            System.out.println("\n Registered PCL1 to listen for changes to " + rapidMark + ":\n" + listener.toDebugString());
            rapidMark = "rapidMark2";
            listener.addPropertyChangeListener(propertyChangeListener2, rapidMark);
            System.out.println("\n Registered PCL2 to listen for changes to " + rapidMark + ":\n" + listener.toDebugString());
            rapidMark = "rapidMark2";
            listener.addPropertyChangeListener(propertyChangeListener3, rapidMark);
            System.out.println("\n Registered PCL3 to listen for changes to " + rapidMark + ":\n" + listener.toDebugString());
            rapidMark = "rapidMark3";
            listener.addPropertyChangeListener(propertyChangeListener3, rapidMark);
            System.out.println("\n Registered PCL3 to listen for changes to " + rapidMark + ":\n" + listener.toDebugString());
            listener.addPropertyChangeListener(propertyChangeListener1);
            System.out.println("\n Registered PCL1 to listen for changes to any rapid mark :\n" + listener.toDebugString());
            rapidMark = "rapidMark4";
            listener.addPropertyChangeListener(propertyChangeListener2, rapidMark);
            System.out.println("\n Registered PCL2 to listen for changes to " + rapidMark + ":\n" + listener.toDebugString());
            System.out.println("    (Note:  PCL1 should also be listening to rapidMark4)");
            rm = listener.findMonitoredRapidMark("rapidMark2");
            System.out.println("\nSimulate rm value update by broker for " + rm.getName() + "\n");
            rm.setValue("newValue by setValue()");
            System.out.println("\n Before unregistering any change listners:\n" + listener.toDebugString());
            listener.removePropertyChangeListener(propertyChangeListener1);
            System.out.println("\n Unregistered PCL1 to listen for changes to all rapidMarks:\n" + listener.toDebugString());
            rapidMark = "rapidMark5";
            listener.addPropertyChangeListener(propertyChangeListener2, rapidMark);
            System.out.println("\n Registered PCL2 to listen for changes to " + rapidMark + ":\n" + listener.toDebugString());
            System.out.println("    (PCL1 should not be added to RM5)");
            rapidMark = "rapidMark3";
            listener.removePropertyChangeListener(propertyChangeListener3, rapidMark);
            System.out.println("\n Unregistered PCL3 to listen for changes to " + rapidMark + ":\n" + listener.toDebugString());
            rapidMark = "rapidMark2";
            listener.removeAllPropertyChangeListeners(rapidMark);
            System.out.println("\n Unregistered all callbacks for changes to " + rapidMark + ":\n" + listener.toDebugString());
            listener.removeAllPropertyChangeListeners();
            System.out.println("\n Unregistered all callbacks for all RMs:\n" + listener.toDebugString());
        }
        System.out.println("\n\n Done!\n\n");
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class ListenerLabel
    extends JLabel
    implements PropertyChangeListener {
        ListenerLabel(DspRapidMark rm) {
            rm.addPropertyChangeListener(this);
        }

        public synchronized void propertyChange(PropertyChangeEvent evt) {
            this.setText(evt.getNewValue().toString());
        }

        public String toString() {
            return new String("DspChangeListener graphic label");
        }
    }
}

