/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayException;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.DspResults;
import com.sun.netstorage.dsp.mgmt.se6920.DspResultsParser;
import com.sun.netstorage.dsp.mgmt.se6920.StorEdgeIOException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.misc.BASE64Encoder;

public class DevComm {
    private static final String CLASSNAME = "DevComm";
    public static final String URL_ENCODING = "UTF-8";
    private HashMap arrayMap = new HashMap();
    private static DevComm singleton = null;
    private boolean debug = false;
    private static final String sccs_id = "@(#)DevComm.java    1.24    04/11/23   SMI";

    public void setDebug(boolean flag) {
        this.debug = flag;
    }

    public boolean getDebug() {
        return this.debug;
    }

    private DevComm() {
    }

    public static DevComm getInstance() {
        if (singleton == null) {
            singleton = new DevComm();
        }
        return singleton;
    }

    public void init(ArrayList inventory) {
        for (int i = 0; i < inventory.size(); ++i) {
            ArrayObject arrayObject = (ArrayObject)inventory.get(i);
            this.arrayMap.put(new String(arrayObject.getHost()), new ArrayAccess(arrayObject));
        }
    }

    boolean isValidArray(ArrayObject array) {
        String METHOD = "isValidArray";
        if (this.arrayMap.get(array.getHost()) == null) {
            this.arrayMap.put(new String(array.getHost()), new ArrayAccess(array));
        }
        return true;
    }

    public InputStream get(ArrayObject array, String fileName) throws ArrayException, StorEdgeIOException {
        return this.get(array, fileName, false, true, false);
    }

    public InputStream get(ArrayObject array, String fileName, boolean useCRAM, boolean retryflag, boolean doingLogin) throws ArrayException, StorEdgeIOException {
        String METHOD = "get";
        Trace.info((Object)this, (String)METHOD, (String)(" Begin  fileName = " + fileName));
        if (!this.isValidArray(array)) {
            Trace.error((Object)this, (String)METHOD, (String)(" Invalid array: " + array.getHost()));
            throw new ArrayException("Invalid array = " + array.getHost());
        }
        if (!array.isLoggedIn() && !doingLogin) {
            Trace.error((Object)this, (String)METHOD, (String)(" Invalid array: " + array.getHost()));
            Trace.error((Object)this, (String)METHOD, (String)" Not logged in.");
            throw new ArrayException("Invalid array = " + array.getHost() + " - not logged in");
        }
        try {
            ArrayAccess tmpAccess = (ArrayAccess)this.arrayMap.get(array.getHost());
            return tmpAccess.get(fileName, useCRAM, retryflag);
        }
        catch (ArrayException e) {
            Trace.error((Object)this, (String)(" ArrayException: " + array.getHost()), (Throwable)e);
            if (!doingLogin) {
                array.reconnect();
            }
            throw e;
        }
        catch (StorEdgeIOException e) {
            Trace.error((Object)this, (String)(" StorEdgeIOException: " + array.getHost()), (Throwable)e);
            if (!doingLogin) {
                array.reconnect();
            }
            throw e;
        }
    }

    public BufferedReader postWithResults(ArrayObject array, String postPage, Vector nameValuePairs) throws ArrayException, StorEdgeIOException {
        return this.postWithResults(array, postPage, nameValuePairs, false);
    }

    public BufferedReader postWithResults(ArrayObject array, String postPage, Vector nameValuePairs, boolean doingLogin) throws ArrayException, StorEdgeIOException {
        String METHOD = "postWithResults";
        Trace.info((Object)this, (String)METHOD, (String)" Begin ");
        if (!this.isValidArray(array)) {
            Trace.error((Object)this, (String)METHOD, (String)(" Invalid array: " + array.getHost()));
            throw new ArrayException("Invalid array = " + array.getHost());
        }
        if (!array.isLoggedIn() && !doingLogin) {
            Trace.error((Object)this, (String)METHOD, (String)(" Invalid array: " + array.getHost()));
            Trace.error((Object)this, (String)METHOD, (String)" Not logged in.");
            throw new ArrayException("Invalid array = " + array.getHost() + " - not logged in");
        }
        try {
            ArrayAccess tmpAccess = (ArrayAccess)this.arrayMap.get(array.getHost());
            return tmpAccess.postWithResults(postPage, nameValuePairs);
        }
        catch (ArrayException e) {
            Trace.error((Object)this, (String)(" ArrayException: " + array.getHost()), (Throwable)e);
            if (!doingLogin) {
                array.reconnect();
            }
            throw e;
        }
        catch (StorEdgeIOException e) {
            Trace.error((Object)this, (String)(" StorEdgeIOException: " + array.getHost()), (Throwable)e);
            if (!doingLogin) {
                array.reconnect();
            }
            throw e;
        }
        catch (IOException ex) {
            Trace.error((Object)this, (String)(" IOException: " + array.getHost()), (Throwable)ex);
            if (!doingLogin) {
                array.reconnect();
            }
            throw new StorEdgeIOException(0);
        }
    }

    public DspResults postWithDspResults(ArrayObject array, String postPage, Vector nameValuePairs) throws ArrayException, StorEdgeIOException {
        return this.postWithDspResults(array, postPage, nameValuePairs, false);
    }

    public DspResults postWithDspResults(ArrayObject array, String postPage, Vector nameValuePairs, boolean doingLogin) throws ArrayException, StorEdgeIOException {
        DspResults results;
        String METHOD = "postWithDspResults";
        Trace.info((Object)this, (String)METHOD, (String)" Begin ");
        BufferedReader reply = null;
        DspResultsParser parser = new DspResultsParser();
        try {
            Trace.info((Object)this, (String)METHOD, (String)(" Posting page " + postPage));
            reply = this.postWithResults(array, postPage, nameValuePairs, doingLogin);
            results = parser.parseResults(reply);
        }
        catch (ArrayException ae) {
            Trace.error((Object)this, (String)METHOD, (String)(" ArrayException during DSP post of page " + postPage + ": " + ae.toString()));
            throw ae;
        }
        catch (StorEdgeIOException sioe) {
            Trace.error((Object)this, (String)METHOD, (String)(" StorEdgeIOException during DSP post of page " + postPage + ": " + sioe.toString()));
            throw sioe;
        }
        Trace.info((Object)this, (String)METHOD, (String)(" Returning results from " + postPage + ":  " + results));
        return results;
    }

    public DspResults fakePostWithDspResults(ArrayObject array, String postPage, Vector nameValuePairs) throws ArrayException, StorEdgeIOException {
        String METHOD = "fakePostWithDspResults";
        Trace.info((Object)this, (String)METHOD, (String)" Begin ");
        StringBuffer postData = new StringBuffer();
        DspResults results = new DspResults("SUCCESS", 0, "OK", "None");
        ArrayAccess tmpAccess = (ArrayAccess)this.arrayMap.get(array.getHost());
        for (int i = 0; i < nameValuePairs.size(); ++i) {
            String currentNvPair = (String)nameValuePairs.get(i);
            tmpAccess.addNameValuePair(postData, currentNvPair);
        }
        Trace.info((Object)this, (String)METHOD, (String)(" Returning results from " + postPage + ":  " + results));
        return results;
    }

    public static void usage() {
        System.out.println("usage    {--get <url> | --post <url> | --login} <dsp> <user> <pw> [[name=value]...]");
        System.out.println("get:   Retrieve a page from the specified DSP");
        System.out.println("post:  Post a request to the specified DSP");
        System.out.println("login: Test the mechanics of the login get/post combo");
        System.out.println("\n");
        System.out.println("example : --get system.htm 10.8.89.111 root root_pw");
        System.out.println("example : --post sysCacheMode 10.8.89.111 root root_pw name1=val1");
        System.out.println("example : --login 10.8.89.111 root root_pw");
    }

    public static void main(String[] args) {
        int currentArg = 0;
        boolean login = false;
        boolean get = false;
        boolean post = false;
        String page = null;
        Vector<String> nameValue = new Vector<String>();
        boolean useCram = false;
        DevComm devComm = null;
        ArrayObject array = null;
        ArrayList<ArrayObject> arrayList = null;
        BufferedReader reply = null;
        DspResults results = null;
        if (args.length < 1) {
            DevComm.usage();
            System.exit(1);
        }
        if (args[currentArg].equals("--get")) {
            if (args.length < 5) {
                DevComm.usage();
                System.exit(1);
            }
            get = true;
        } else if (args[currentArg].equals("--post")) {
            if (args.length < 5) {
                DevComm.usage();
                System.exit(1);
            }
            post = true;
        } else if (args[currentArg].equals("--login")) {
            if (args.length < 4) {
                DevComm.usage();
                System.exit(1);
            }
            login = true;
        } else {
            System.out.println("*** Invalid function: '--get', '--post', or '--login' required");
            DevComm.usage();
            System.exit(1);
        }
        ++currentArg;
        if (get || post) {
            page = args[currentArg++];
        }
        String host = args[currentArg++];
        String user = args[currentArg++];
        String pw = args[currentArg++];
        for (int i = currentArg; i < args.length; ++i) {
            nameValue.add(args[i]);
        }
        devComm = DevComm.getInstance();
        array = ArrayObject.getInstance(host, 80, user, pw);
        arrayList = new ArrayList<ArrayObject>();
        arrayList.add(array);
        devComm.init(arrayList);
        try {
            if (login) {
                System.out.println("\nLogging in using debug - check trace output log ");
                array.login(true);
            }
            if (get || post) {
                System.out.println("\nStarting login/keepAlive thread...");
                array.login();
                System.out.println("    ...started login/keepAlive thread\n");
                if (get) {
                    System.out.println("\nGetting page " + page + "\n\n");
                    reply = new BufferedReader(new InputStreamReader(devComm.get(array, page), URL_ENCODING));
                } else if (post) {
                    System.out.println("\nPosting for page " + page + "\n\n");
                    results = devComm.postWithDspResults(array, page, nameValue);
                    System.out.println("\nPost results:");
                    System.out.println(results.toString());
                    System.out.println("\n");
                }
                System.out.println("\nLogging out...");
                array.logout(false);
                System.out.println("    ...logout complete");
            } else {
                System.out.println("\nNothing to do\n\n");
                System.exit(0);
            }
            if (reply != null) {
                String line;
                System.out.println("Reply:\n");
                while ((line = reply.readLine()) != null) {
                    System.out.println(line);
                }
            } else {
                System.out.println("*** Null reply!");
            }
        }
        catch (Exception e) {
            System.out.println("*** Exception:\n" + e.getMessage());
        }
        System.out.println("\n\nDone!\n\n");
        System.exit(0);
    }

    private class ArrayAccess {
        private static final String CLASSNAME = "DevComm.ArrayAccess";
        private static final int TWO_MINUTES = 120000;
        private static final String SYS_SHUTDOWN = "sysShutdown";
        private static final String SYS_RESET = "sysReset";
        private ArrayObject array;
        private String localHost;

        public ArrayAccess(ArrayObject array) {
            this.array = array;
            try {
                this.localHost = InetAddress.getLocalHost().toString();
            }
            catch (Exception e) {
                this.localHost = "localhost";
            }
        }

        public boolean getCRAMFlag() {
            return this.array.getCRAMFlag();
        }

        public String getHost() {
            return this.array.getHost();
        }

        public int getPort() {
            return this.array.getPort();
        }

        public String getUser() {
            return this.array.getUser();
        }

        public String getPass() {
            return this.array.getPassword();
        }

        public String getName() {
            if (this.array.getPort() == 0 || this.array.getPort() == 80) {
                return this.array.getHost();
            }
            return this.array.getHost() + ":" + this.array.getPort();
        }

        public synchronized InputStream get(String fileName) throws ArrayException, StorEdgeIOException {
            return this.get(fileName, true);
        }

        public synchronized InputStream get(String file, boolean useCRAMAuthorization) throws ArrayException, StorEdgeIOException {
            return this.get(file, useCRAMAuthorization, true);
        }

        public synchronized InputStream get(String file, boolean useCRAMAuthorization, boolean retryflag) throws ArrayException, StorEdgeIOException {
            String METHOD = "get";
            Trace.debug((Object)this, (String)METHOD, (String)" Begin ");
            InputStream inStream = null;
            try {
                inStream = this.getStream(file, useCRAMAuthorization, retryflag);
                BufferedInputStream bufInStream = new BufferedInputStream(inStream);
                Trace.debug((Object)this, (String)METHOD, (String)" Got stream ");
                return bufInStream;
            }
            catch (ArrayException e) {
                throw e;
            }
            catch (StorEdgeIOException e) {
                throw e;
            }
            catch (Exception e) {
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw new ArrayException(e);
            }
        }

        private InputStream getStream(String file, boolean useCRAMAuthorization) throws ArrayException, StorEdgeIOException {
            return this.getStream(file, useCRAMAuthorization, true);
        }

        private InputStream getStream(String file, boolean useCRAMAuthorization, boolean retryflag) throws ArrayException, StorEdgeIOException {
            String METHOD = "getStream";
            Trace.debug((Object)this, (String)METHOD, (String)" Begin ");
            HttpURLConnection connection = null;
            try {
                if (!file.startsWith("/")) {
                    file = "/" + file;
                }
                URL url = new URL("http", this.array.getHost(), this.array.getPort(), file);
                Trace.warn((Object)this, (String)METHOD, (String)(" URL: " + url));
                int response = 0;
                ConnectThread connectThread = null;
                for (int attempt = 0; attempt < 4; ++attempt) {
                    String encoding;
                    if (!retryflag) {
                        attempt = 3;
                    }
                    connection = (HttpURLConnection)url.openConnection();
                    if (useCRAMAuthorization) {
                        Trace.debug((Object)this, (String)METHOD, (String)" Using CRAM - Write/Post");
                        connection.setRequestProperty("Authorization", "CRAM");
                        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    } else {
                        String nonce = this.array.getNonce();
                        if (nonce.equals("")) {
                            Trace.debug((Object)this, (String)METHOD, (String)" NOT Using CRAM - Discovery/Get");
                            String userPasswd = "guest";
                            encoding = new BASE64Encoder().encode(userPasswd.getBytes());
                            connection.setRequestProperty("Authorization", "Basic " + encoding);
                        } else {
                            Trace.debug((Object)this, (String)METHOD, (String)" Using nonce authorization");
                            connection.setRequestProperty("Cookie", "auth=" + nonce);
                        }
                    }
                    connection.setAllowUserInteraction(false);
                    connection.setRequestMethod("GET");
                    connectThread = new ConnectThread(connection);
                    connectThread.connect();
                    response = connectThread.getResponseCode();
                    if (response == 401 && useCRAMAuthorization) {
                        String cramChallenge = connection.getHeaderField("CRAM-Challenge");
                        if (response == 401 && cramChallenge != null) {
                            byte[] cramResponse = null;
                            try {
                                cramResponse = this.getCRAMResponse(this.array.getUser(), this.array.getPassword(), cramChallenge);
                            }
                            catch (NoSuchAlgorithmException na) {
                                Trace.error((Object)this, (String)METHOD, (String)(" NoSuchAlgorithm: " + this.array.getHost() + this.array.getPort()));
                                throw new ArrayException(na);
                            }
                            encoding = new BASE64Encoder().encode(cramResponse);
                            connection = (HttpURLConnection)url.openConnection();
                            connection.setRequestProperty("Authorization", "CRAM");
                            connection.setRequestProperty("credential", encoding);
                            connection.setAllowUserInteraction(false);
                            connection.setUseCaches(false);
                            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                            connection.setRequestMethod("GET");
                            connection.setDoOutput(true);
                            connectThread = new ConnectThread(connection);
                            connectThread.connect();
                            response = connectThread.getResponseCode();
                        }
                    }
                    Trace.warn((Object)this, (String)METHOD, (String)(" HTTPResponse code: " + response + " for URL: " + url));
                    if (response == 401 && useCRAMAuthorization) {
                        Thread.sleep(11000L);
                    }
                    if (response == 200 || response == 401 || response == 404 || response == 503) break;
                    Trace.warn((Object)this, (String)METHOD, (String)(" DevComm.post: Http failure attempt " + (attempt + 1)));
                    Trace.warn((Object)this, (String)" Unknown HTTPResponse code:", (Throwable)new Exception());
                    connection.disconnect();
                    String[] logargs = new String[]{String.valueOf(response), String.valueOf(attempt), "4", "30"};
                    Thread.sleep(30000L);
                }
                int errorCode = 0;
                switch (response) {
                    case 200: {
                        break;
                    }
                    case 401: {
                        errorCode = 3;
                        break;
                    }
                    case 404: {
                        errorCode = 1;
                        break;
                    }
                    case 503: {
                        errorCode = 2;
                        break;
                    }
                    default: {
                        errorCode = 0;
                    }
                }
                if (response != 200) {
                    connection.disconnect();
                    throw new StorEdgeIOException(errorCode, connection.getErrorStream());
                }
                return connectThread.getInputStream();
            }
            catch (StorEdgeIOException ex) {
                throw ex;
            }
            catch (IOException ex) {
                throw new StorEdgeIOException(0);
            }
            catch (Exception e) {
                Trace.error((Object)this, (String)METHOD, (String)(" Exception in get: " + e.getMessage()));
                throw new ArrayException(e);
            }
        }

        private byte[] getCRAMResponse(String username, String password, String cramChallenge) throws NoSuchAlgorithmException {
            int i;
            int offset;
            String credential = username + ":" + cramChallenge;
            MessageDigest classMD = MessageDigest.getInstance("MD5");
            if (password != null) {
                byte[] passwdbuff = password.getBytes();
                classMD.update(passwdbuff, 0, passwdbuff.length);
            }
            byte[] passwdDigest = classMD.digest();
            byte[] chbuff = cramChallenge.getBytes();
            byte[] cbuff = new byte[passwdDigest.length + chbuff.length + 1];
            for (int i2 = 0; i2 < passwdDigest.length; ++i2) {
                cbuff[i2] = passwdDigest[i2];
            }
            cbuff[passwdDigest.length] = 38;
            for (int i3 = offset = passwdDigest.length + 1; i3 < offset + chbuff.length; ++i3) {
                cbuff[i3] = chbuff[i3 - offset];
            }
            classMD.update(cbuff, 0, cbuff.length);
            byte[] classdigest = classMD.digest();
            byte[] userbuff = (username + ":").getBytes();
            byte[] credentialbuff = new byte[userbuff.length + classdigest.length];
            for (i = 0; i < userbuff.length; ++i) {
                credentialbuff[i] = userbuff[i];
            }
            for (i = offset = userbuff.length; i < offset + classdigest.length; ++i) {
                credentialbuff[i] = classdigest[i - offset];
            }
            return credentialbuff;
        }

        public synchronized void post(Vector urlRequestData, String method) throws ArrayException, StorEdgeIOException {
            String METHOD = "post";
            StringBuffer postRequest = new StringBuffer();
            postRequest.append("update?");
            if (urlRequestData == null) {
                Trace.error((Object)this, (String)"post", (String)"Invalid urlRequestData");
                throw new ArrayException("Invalid urlRequestData");
            }
            for (int i = 0; i < urlRequestData.size(); ++i) {
                String tokenValuePair = (String)urlRequestData.get(i);
                if (!this.IsValidTokenValuePair(tokenValuePair)) {
                    Trace.warn((Object)this, (String)"post", (String)("Invald token-value pair: " + tokenValuePair));
                    throw new ArrayException("Invalid token-value pair: " + tokenValuePair);
                }
                tokenValuePair.trim();
                postRequest.append(tokenValuePair + "&");
            }
            if (method != null && method != "") {
                postRequest.append(method + "=Apply");
            }
            InputStream is = this.get(postRequest.toString(), true);
            try {
                is.close();
            }
            catch (IOException ex) {
                Trace.error((Object)this, (String)("DevComm.post: Exception closing strem" + ex.getMessage()), (Throwable)ex);
            }
        }

        public BufferedReader postWithResults(String postPage, Vector nameValuePairs) throws ArrayException, StorEdgeIOException, IOException {
            String METHOD = "postWithResults";
            Trace.info((Object)this, (String)METHOD, (String)" Begin ");
            StringBuffer postData = new StringBuffer();
            if (postPage == null) {
                Trace.error((Object)this, (String)METHOD, (String)" Invalid URL for post page");
                throw new ArrayException("Invalid URL for post page");
            }
            if (nameValuePairs == null) {
                Trace.error((Object)this, (String)METHOD, (String)" Invalid nameValuePairs supplied");
                throw new ArrayException("Invalid nameValuePairs supplied");
            }
            for (int i = 0; i < nameValuePairs.size(); ++i) {
                String currentNvPair = (String)nameValuePairs.get(i);
                this.addNameValuePair(postData, currentNvPair);
            }
            return this.doPost(postPage, postData.toString());
        }

        private BufferedReader doPost(String postPage, String postData) throws ArrayException, StorEdgeIOException {
            String METHOD = "doPost";
            Trace.info((Object)this, (String)METHOD, (String)" Begin ");
            String page = new String();
            HttpURLConnection connection = null;
            URL url = null;
            Object connectThread = null;
            boolean response = false;
            int retry = 0;
            if (!postPage.startsWith("/")) {
                page = "/";
            }
            page = page + postPage;
            try {
                url = new URL("http", this.array.getHost(), this.array.getPort(), page);
                Trace.warn((Object)this, (String)METHOD, (String)(" URL:      " + url));
                Trace.warn((Object)this, (String)METHOD, (String)(" postData: " + postData));
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setAllowUserInteraction(false);
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setUseCaches(false);
                connection.setRequestProperty("Content-length", String.valueOf(postData.length()));
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("MasE", "MasE");
                connection.setRequestProperty("Cookie", "auth=" + this.array.getNonce());
                if (DevComm.this.getDebug()) {
                    System.out.println("Sending request for page" + page + " - retry # " + retry++);
                    System.out.println("   URL = " + url);
                }
                Trace.info((Object)this, (String)METHOD, (String)" Sending request ");
                OutputStream requestStream = connection.getOutputStream();
                requestStream.write(postData.getBytes());
                requestStream.flush();
                requestStream.close();
                BufferedReader responseReader = new BufferedReader(new InputStreamReader(connection.getInputStream(), DevComm.URL_ENCODING));
                Trace.warn((Object)this, (String)METHOD, (String)(" Received response from post to URL: " + url));
                return responseReader;
            }
            catch (StorEdgeIOException ex) {
                Trace.error((Object)this, (String)(" StorEdgeIOException: " + ex.getMessage()), (Throwable)ex);
                throw ex;
            }
            catch (IOException ex) {
                Trace.error((Object)this, (String)(" IOException: " + ex.getMessage()), (Throwable)ex);
                throw new StorEdgeIOException(0);
            }
            catch (Exception e) {
                Trace.error((Object)this, (String)(" Exception: " + e.getMessage()), (Throwable)e);
                throw new ArrayException(e);
            }
        }

        private void addNameValuePair(StringBuffer postData, String nvPair) throws ArrayException {
            String METHOD = "addNameValuePair";
            Trace.debug((Object)this, (String)METHOD, (String)" Begin ");
            String token = null;
            String equalsSign = null;
            String value = null;
            String tooMuch = null;
            try {
                StringTokenizer tokenizer = new StringTokenizer(nvPair, "=", true);
                token = tokenizer.nextToken();
                equalsSign = tokenizer.nextToken();
                value = tokenizer.nextToken();
                tooMuch = tokenizer.nextToken();
                throw new ArrayException("Invalid name/value pair");
            }
            catch (Exception e) {
                if (token == null || equalsSign == null) {
                    throw new ArrayException("Invalid name/value pair - " + nvPair);
                }
                if (tooMuch == null) {
                    try {
                        if (postData.length() != 0) {
                            postData.append("&");
                        }
                        postData.append(URLEncoder.encode(token, DevComm.URL_ENCODING) + "=");
                        if (value != null) {
                            postData.append(URLEncoder.encode(value, DevComm.URL_ENCODING));
                        }
                        Trace.debug((Object)this, (String)METHOD, (String)(" postData = " + postData));
                        return;
                    }
                    catch (Exception urlException) {
                        Trace.warn((Object)this, (String)" URL Exception - unable to URLencode data ", (Throwable)urlException);
                        throw new ArrayException("Unable to URLencode name/value pair, token = '" + token + "', value = '" + value + "'");
                    }
                }
                Trace.warn((Object)this, (String)METHOD, (String)(" Invalid name/value pair: " + nvPair));
                throw new ArrayException("Invalid name/value pair - " + nvPair);
            }
        }

        private boolean IsValidTokenValuePair(String tokenValuePair) throws ArrayException {
            String token = null;
            String equalsSign = null;
            String value = null;
            String tooMuch = null;
            try {
                StringTokenizer tokenizer = new StringTokenizer(tokenValuePair, "=", true);
                token = tokenizer.nextToken();
                equalsSign = tokenizer.nextToken();
                value = tokenizer.nextToken();
                tooMuch = tokenizer.nextToken();
                throw new Exception("Invalid name/value pair");
            }
            catch (Exception e) {
                if (token == null || equalsSign == null) {
                    return false;
                }
                return tooMuch == null;
            }
        }

        protected class ConnectThread
        extends Thread {
            transient HttpURLConnection connection;
            transient int response = -1;
            transient InputStream stream;
            transient Exception e = null;

            public ConnectThread(HttpURLConnection connection) {
                super("6120HttpReader:ConnectThread");
                this.connection = connection;
            }

            public void connect() throws ArrayException {
                this.start();
                long timeout = 60000L;
                boolean update = false;
                URL url = this.connection.getURL();
                String file = url.getFile();
                if (file.startsWith("/update") && file.indexOf(ArrayAccess.SYS_SHUTDOWN) == -1 && file.indexOf(ArrayAccess.SYS_RESET) == -1) {
                    timeout = 120000L;
                }
                try {
                    this.join(timeout);
                }
                catch (InterruptedException ex) {
                    Trace.error((Object)this, (String)"Join exception", (Throwable)ex);
                    throw new ArrayException(ex);
                }
                if (this.isAlive()) {
                    this.interrupt();
                    throw new ArrayException("Connection Timeout");
                }
            }

            public void run() {
                try {
                    try {
                        this.stream = this.connection.getInputStream();
                        this.response = this.connection.getResponseCode();
                    }
                    catch (SocketException se) {
                        throw se;
                    }
                    catch (IOException io) {
                        try {
                            this.response = this.connection.getResponseCode();
                        }
                        catch (IOException i) {
                            throw io;
                        }
                    }
                    this.response = this.connection.getResponseCode();
                }
                catch (Exception e) {
                    this.e = e;
                }
            }

            public int getResponseCode() throws Exception {
                if (this.e != null) {
                    throw this.e;
                }
                return this.response;
            }

            public InputStream getInputStream() {
                return this.stream;
            }
        }
    }
}

