/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import java.math.BigInteger;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMFlavor;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.cim.UnsignedInt8;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class CimInstanceXMLFilter
extends XMLFilterImpl {
    private static final String REFERENCECLASS = "REFERENCECLASS";
    private static final String CLASSNAME = "CLASSNAME";
    private static final String SUPERCLASS = "SUPERCLASS";
    private static final String TOSUBCLASS = "TOSUBCLASS";
    private static final String CLASSORIGIN = "CLASSORIGIN";
    private static final String ARRAYSIZE = "ARRAYSIZE";
    private static final String TRANSLATABLE = "TRANSLATABLE";
    private static final String TYPE = "TYPE";
    private static final String VALUETYPE = "VALUETYPE";
    private static final String INSTANCE = "INSTANCE";
    private static final String INSTANCENAME = "INSTANCENAME";
    private static final String INSTANCEPATH = "INSTANCEPATH";
    private static final String KEYBINDING = "KEYBINDING";
    private static final String KEYVALUE = "KEYVALUE";
    private static final String OBJECTPATH = "OBJECTPATH";
    private static final String PROPERTY = "PROPERTY";
    private static final String PROPERTY_ARRAY = "PROPERTY.ARRAY";
    private static final String PROPERTY_REFERENCE = "PROPERTY.REFERENCE";
    private static final String QUALIFIER = "QUALIFIER";
    private static final String QUALIFIER_DECLARATION = "QUALIFIER.DECLARATION";
    private static final String VALUE = "VALUE";
    private static final String VALUE_ARRAY = "VALUE.ARRAY";
    private static final String VALUE_REFERENCE = "VALUE.REFERENCE";
    private static final String ISARRAY = "ISARRAY";
    private static final String NAME = "NAME";
    private static final String OVERRIDABLE = "OVERRIDABLE";
    private static final String PROTOCOLVERSION = "PROTOCOLVERSION";
    private static final String PROTOCOLVERSIONSTRING = "1.0";
    private static final String PROPAGATED = "PROPAGATED";
    private static final String REFERENCE = "REFERENCE";
    private static final String REFERENCETYPE = "reference";
    private static final String NUM_TYPE = "numeric";
    private static final String COLON = ":";
    private static final String PERIOD = ".";
    private static final String MINUS = "-";
    private static final String PLUS = "+";
    private static final String STR_TYPE = "string";
    private static final String BOOL_TYPE = "boolean";
    private static final String CHAR16 = "char16";
    private static final String DATETIME = "datetime";
    private static final String REAL32 = "real32";
    private static final String REAL64 = "real64";
    private static final String SINT = "sint";
    private static final String SINT8 = "sint8";
    private static final String SINT16 = "sint16";
    private static final String SINT32 = "sint32";
    private static final String SINT64 = "sint64";
    private static final String UINT = "uint";
    private static final String UINT8 = "uint8";
    private static final String UINT16 = "uint16";
    private static final String UINT32 = "uint32";
    private static final String UINT64 = "uint64";
    private static final String SMALL_D = "d";
    private static final String SMALL_E = "e";
    private static final String CAPS_E = "E";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String EMPTY_STR = "";
    private static final String OPERATING_SYSTEM = "StorEdge_6120OperatingSystem";
    private static final String CURRENT_TIMEZONE = "CurrentTimeZone";
    private static final String SLOT = "StorEdge_6120Slot";
    private static final String NUMBER = "Number";
    private static final String POOL = "StorEdge_6120StoragePool";
    private static final String OP_STATUS = "OperationalStatus";
    private static final String OTHER_DESC = "OtherStatusDescriptions";
    private static final String NO = "no";
    private static final String YES = "yes";
    private static final String INITIALIZING = "initializing";
    private static final String SPACE = " ";
    private static final String ONE = "1";
    private static final String TWO = "2";
    private static final String EIGHT = "8";
    private static final String FIFTEEN = "15";
    private boolean inInstance = false;
    private CIMInstance inst = null;
    private boolean inQualifier = false;
    private CIMQualifier qual = null;
    private boolean inProp = false;
    private boolean inPropArray = false;
    private boolean inPropRef = false;
    private CIMProperty prop = null;
    private boolean inValue = false;
    private boolean inValueArray = false;
    private boolean inValueReference = false;
    private CIMValue value = null;
    private CIMObjectPath objPath = null;
    private String keyName = null;
    private boolean nullPoolOtherStatusDesc = false;
    private CIMProperty poolOtherStatusDesc = null;
    private String valueType = "string";
    private String propValueType = null;
    private String qualValueType = null;
    private StringBuffer valueBuffer = null;
    private List instList = null;
    private List propList = null;
    private List qualList = null;
    private List valueList = null;
    private static final int MAX_LIST_SIZE = 2000;
    private String ipAddress = null;
    private final HashMap myEventHandlers = new HashMap(11);
    private final HashMap myValueHandlers = new HashMap(15);

    public CimInstanceXMLFilter(XMLReader parent, List aList) {
        super(parent);
        this.initEventHandlers();
        this.initValueHandlers();
        this.instList = aList != null ? aList : new ArrayList(2000);
        this.propList = new ArrayList();
        this.qualList = new ArrayList();
        this.valueList = new ArrayList();
        this.valueBuffer = new StringBuffer();
        try {
            this.ipAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            this.ipAddress = new String(EMPTY_STR);
        }
    }

    public List getInstanceList() {
        return this.instList;
    }

    public String getLastInstance() {
        if (this.inst != null && this.inst.getClassName() != null) {
            return this.inst.getClassName();
        }
        return EMPTY_STR;
    }

    public String getLastProperty() {
        if (this.prop != null && this.prop.getName() != null) {
            return this.prop.getName();
        }
        return EMPTY_STR;
    }

    public void startDocument() throws SAXException {
        this.inInstance = false;
        super.startDocument();
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes atts) throws SAXException {
        CimInstanceEventHandler handler = this.findEventHandler(namespaceURI, localName, qualifiedName);
        if (handler != null) {
            handler.startElement(namespaceURI, localName, qualifiedName, atts);
        }
        super.startElement(namespaceURI, localName, qualifiedName, atts);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        CimInstanceEventHandler handler = this.findEventHandler(uri, localName, qName);
        if (handler != null) {
            handler.endElement(uri, localName, qName);
        }
        super.endElement(uri, localName, qName);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.inInstance && this.valueBuffer != null) {
            this.valueBuffer.append(ch, start, length);
        }
        super.ignorableWhitespace(ch, start, length);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.inInstance && this.valueBuffer != null) {
            this.valueBuffer.append(ch, start, length);
        }
        super.characters(ch, start, length);
    }

    protected String fixupPropValue(String value) {
        if (this.propValueType.equals(DATETIME) && this.inst.getClassName().equals(OPERATING_SYSTEM) && this.prop.getName().equals(CURRENT_TIMEZONE)) {
            return CimInstanceXMLFilter.mapTimezoneNameToMinutes(value);
        }
        if (this.inst.getClassName().equals(SLOT) && this.prop.getName().equals(NUMBER)) {
            int dee = value.lastIndexOf(SMALL_D);
            return value.substring(dee + 1);
        }
        if (this.inst.getClassName().equals(POOL) && this.prop.getName().equals(OP_STATUS)) {
            if (value.startsWith(NO)) {
                if (value.endsWith(COLON)) {
                    value = FIFTEEN;
                    this.nullPoolOtherStatusDesc = false;
                } else if (value.endsWith(INITIALIZING)) {
                    value = EIGHT;
                    this.nullPoolOtherStatusDesc = true;
                } else {
                    value = ONE;
                    this.nullPoolOtherStatusDesc = false;
                }
            } else if (value.endsWith(COLON)) {
                value = TWO;
                this.nullPoolOtherStatusDesc = true;
            } else {
                value = ONE;
                this.nullPoolOtherStatusDesc = false;
            }
            if (this.poolOtherStatusDesc != null && this.nullPoolOtherStatusDesc) {
                this.poolOtherStatusDesc.setValue(new CIMValue(null));
            }
        } else if (this.inst.getClassName().equals(POOL) && this.prop.getName().equals(OTHER_DESC)) {
            this.poolOtherStatusDesc = this.prop;
            if (this.nullPoolOtherStatusDesc) {
                value = EMPTY_STR;
            }
        }
        return value;
    }

    public static String mapTimezoneNameToMinutes(String timeZoneName) {
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneName);
        Calendar calendar = Calendar.getInstance(timeZone);
        int msecOffset = timeZone.getOffset(calendar.getTime().getTime());
        short minsOffset = 0;
        if (msecOffset != 0) {
            minsOffset = (short)(msecOffset / 60000);
        }
        return new Short(minsOffset).toString();
    }

    private CimInstanceEventHandler findEventHandler(String namespaceURI, String localName, String qualifiedName) {
        CimInstanceEventHandler handler = this.getEventHandler(localName);
        return handler;
    }

    private CimInstanceEventHandler getEventHandler(String theElementName) {
        String key = theElementName != null ? theElementName.toLowerCase() : null;
        return (CimInstanceEventHandler)this.myEventHandlers.get(key);
    }

    private void mapEventHandler(String theElementName, CimInstanceEventHandler theHandler) {
        String key = theElementName != null ? theElementName.toLowerCase() : null;
        this.myEventHandlers.put(key, theHandler);
    }

    private void initEventHandlers() {
        if (this.myEventHandlers.size() == 0) {
            this.mapEventHandler(INSTANCE, new InstanceEventHandler());
            this.mapEventHandler(INSTANCENAME, new InstanceNameEventHandler());
            this.mapEventHandler(PROPERTY, new PropertyEventHandler());
            this.mapEventHandler(PROPERTY_ARRAY, new PropertyArrayEventHandler());
            this.mapEventHandler(PROPERTY_REFERENCE, new PropertyReferenceEventHandler());
            this.mapEventHandler(VALUE, new ValueEventHandler());
            this.mapEventHandler(VALUE_ARRAY, new ValueArrayEventHandler());
            this.mapEventHandler(VALUE_REFERENCE, new ValueReferenceEventHandler());
            this.mapEventHandler(QUALIFIER, new QualifierEventHandler());
            this.mapEventHandler(KEYBINDING, new KeyBindingEventHandler());
            this.mapEventHandler(KEYVALUE, new KeyValueEventHandler());
        }
    }

    protected CIMValue valueObject(String value, String type) throws SAXException {
        CIMValue cimValue = null;
        CimInstanceValueHandler handler = type == null ? this.getValueHandler(STR_TYPE) : this.getValueHandler(type);
        if (handler != null) {
            cimValue = handler.valueObject(value, type);
        }
        return cimValue;
    }

    private CimInstanceValueHandler getValueHandler(String cimType) {
        String key = cimType != null ? cimType.toLowerCase() : null;
        return (CimInstanceValueHandler)this.myValueHandlers.get(key);
    }

    private void mapValueHandler(String theElementName, CimInstanceValueHandler theHandler) {
        String key = theElementName != null ? theElementName.toLowerCase() : null;
        this.myValueHandlers.put(key, theHandler);
    }

    private void initValueHandlers() {
        if (this.myValueHandlers.size() == 0) {
            this.mapValueHandler(BOOL_TYPE, new BooleanValueEventHandler());
            this.mapValueHandler(CHAR16, new Char16ValueEventHandler());
            this.mapValueHandler(STR_TYPE, new StringValueEventHandler());
            this.mapValueHandler(DATETIME, new DatetimeValueEventHandler());
            this.mapValueHandler(REAL32, new Real32ValueEventHandler());
            this.mapValueHandler(REAL64, new Real64ValueEventHandler());
            this.mapValueHandler(SINT8, new Sint8ValueEventHandler());
            this.mapValueHandler(SINT16, new Sint16ValueEventHandler());
            this.mapValueHandler(SINT32, new Sint32ValueEventHandler());
            this.mapValueHandler(SINT64, new Sint64ValueEventHandler());
            this.mapValueHandler(UINT8, new Uint8ValueEventHandler());
            this.mapValueHandler(UINT16, new Uint16ValueEventHandler());
            this.mapValueHandler(UINT32, new Uint32ValueEventHandler());
            this.mapValueHandler(UINT64, new Uint64ValueEventHandler());
        }
    }

    private class Char16ValueEventHandler
    extends BaseValueEventHandler
    implements CimInstanceValueHandler {
        private Char16ValueEventHandler() {
        }

        public CIMValue valueObject(String value, String type) throws SAXException {
            CIMValue returnValue = super.valueObject(value, type);
            if (returnValue == null) {
                returnValue = this.getCIMValue(new Character(value.charAt(0)), value, type);
            }
            return returnValue;
        }
    }

    private class DatetimeValueEventHandler
    extends BaseValueEventHandler
    implements CimInstanceValueHandler {
        private DatetimeValueEventHandler() {
        }

        public CIMValue valueObject(String value, String type) throws SAXException {
            CIMValue returnValue = super.valueObject(value, type);
            if (returnValue == null) {
                returnValue = this.getCIMValue(new CIMDateTime(value), value, type);
            }
            return returnValue;
        }
    }

    private class Real64ValueEventHandler
    extends BaseValueEventHandler
    implements CimInstanceValueHandler {
        private Real64ValueEventHandler() {
        }

        public CIMValue valueObject(String value, String type) throws SAXException {
            CIMValue returnValue = super.valueObject(value, type);
            if (returnValue == null) {
                returnValue = this.getCIMValue(new Double(value), value, type);
            }
            return returnValue;
        }
    }

    private class Real32ValueEventHandler
    extends BaseValueEventHandler
    implements CimInstanceValueHandler {
        private Real32ValueEventHandler() {
        }

        public CIMValue valueObject(String value, String type) throws SAXException {
            CIMValue returnValue = super.valueObject(value, type);
            if (returnValue == null) {
                returnValue = this.getCIMValue(new Float(value), value, type);
            }
            return returnValue;
        }
    }

    private class BooleanValueEventHandler
    extends BaseValueEventHandler
    implements CimInstanceValueHandler {
        private BooleanValueEventHandler() {
        }

        public CIMValue valueObject(String value, String type) throws SAXException {
            CIMValue returnValue = super.valueObject(value, type);
            if (returnValue == null) {
                returnValue = this.getCIMValue(Boolean.valueOf(value), value, type);
            }
            return returnValue;
        }
    }

    private class StringValueEventHandler
    extends BaseValueEventHandler
    implements CimInstanceValueHandler {
        private StringValueEventHandler() {
        }

        public CIMValue valueObject(String value, String type) throws SAXException {
            CIMValue returnValue = super.valueObject(value, type);
            if (returnValue == null) {
                returnValue = this.getCIMValue(value, value, type);
            }
            return returnValue;
        }
    }

    private class Sint64ValueEventHandler
    extends IntegerBaseValueEventHandler
    implements CimInstanceValueHandler {
        private Sint64ValueEventHandler() {
        }

        public CIMValue valueObject(String value, String type) throws SAXException {
            CIMValue returnValue = super.valueObject(value, type);
            if (returnValue == null) {
                returnValue = this.getCIMValue(Long.valueOf(this.findRadixAndTruncate(value, type), this.radix), value, type);
            }
            return returnValue;
        }
    }

    private class Sint32ValueEventHandler
    extends IntegerBaseValueEventHandler
    implements CimInstanceValueHandler {
        private Sint32ValueEventHandler() {
        }

        public CIMValue valueObject(String value, String type) throws SAXException {
            CIMValue returnValue = super.valueObject(value, type);
            if (returnValue == null) {
                returnValue = this.getCIMValue(Integer.valueOf(this.findRadixAndTruncate(value, type), this.radix), value, type);
            }
            return returnValue;
        }
    }

    private class Sint16ValueEventHandler
    extends IntegerBaseValueEventHandler
    implements CimInstanceValueHandler {
        private Sint16ValueEventHandler() {
        }

        public CIMValue valueObject(String value, String type) throws SAXException {
            CIMValue returnValue = super.valueObject(value, type);
            if (returnValue == null) {
                returnValue = this.getCIMValue(Short.valueOf(this.findRadixAndTruncate(value, type), this.radix), value, type);
            }
            return returnValue;
        }
    }

    private class Sint8ValueEventHandler
    extends IntegerBaseValueEventHandler
    implements CimInstanceValueHandler {
        private Sint8ValueEventHandler() {
        }

        public CIMValue valueObject(String value, String type) throws SAXException {
            CIMValue returnValue = super.valueObject(value, type);
            if (returnValue == null) {
                returnValue = this.getCIMValue(Byte.valueOf(this.findRadixAndTruncate(value, type), this.radix), value, type);
            }
            return returnValue;
        }
    }

    private class Uint64ValueEventHandler
    extends IntegerBaseValueEventHandler
    implements CimInstanceValueHandler {
        private Uint64ValueEventHandler() {
        }

        public CIMValue valueObject(String value, String type) throws SAXException {
            CIMValue returnValue = super.valueObject(value, type);
            if (returnValue == null) {
                returnValue = this.getCIMValue(new UnsignedInt64(new BigInteger(this.findRadixAndTruncate(value, type), this.radix)), value, type);
            }
            return returnValue;
        }
    }

    private class Uint32ValueEventHandler
    extends IntegerBaseValueEventHandler
    implements CimInstanceValueHandler {
        private Uint32ValueEventHandler() {
        }

        public CIMValue valueObject(String value, String type) throws SAXException {
            CIMValue returnValue = super.valueObject(value, type);
            if (returnValue == null) {
                returnValue = this.getCIMValue(new UnsignedInt32(Long.valueOf(this.findRadixAndTruncate(value, type), this.radix).longValue()), value, type);
            }
            return returnValue;
        }
    }

    private class Uint16ValueEventHandler
    extends IntegerBaseValueEventHandler
    implements CimInstanceValueHandler {
        private Uint16ValueEventHandler() {
        }

        public CIMValue valueObject(String value, String type) throws SAXException {
            CIMValue returnValue = super.valueObject(value, type);
            if (returnValue == null) {
                returnValue = this.getCIMValue(new UnsignedInt16(Integer.valueOf(this.findRadixAndTruncate(value, type), this.radix).intValue()), value, type);
            }
            return returnValue;
        }
    }

    private class Uint8ValueEventHandler
    extends IntegerBaseValueEventHandler
    implements CimInstanceValueHandler {
        private Uint8ValueEventHandler() {
        }

        public CIMValue valueObject(String value, String type) throws SAXException {
            CIMValue returnValue = super.valueObject(value, type);
            if (returnValue == null) {
                returnValue = this.getCIMValue(new UnsignedInt8(Short.valueOf(this.findRadixAndTruncate(value, type), this.radix).shortValue()), value, type);
            }
            return returnValue;
        }
    }

    private class IntegerBaseValueEventHandler
    extends BaseValueEventHandler
    implements CimInstanceValueHandler {
        protected int radix;

        private IntegerBaseValueEventHandler() {
        }

        protected String findRadixAndTruncate(String value, String type) {
            int end;
            String fixedValue = value.toLowerCase();
            char[] ch = fixedValue.toCharArray();
            int start = 0;
            this.radix = 10;
            for (end = 0; end < ch.length; ++end) {
                if (Character.isDigit(ch[end])) continue;
                if (ch[end] == 'x') {
                    this.radix = 16;
                    start = ++end;
                    end = ch.length;
                    break;
                }
                if (ch[end] == 'b') {
                    this.radix = 2;
                    break;
                }
                if (ch[end] == '.') break;
            }
            if (start < end) {
                return value.substring(start, end);
            }
            return value;
        }
    }

    private abstract class BaseValueEventHandler
    implements CimInstanceValueHandler {
        private BaseValueEventHandler() {
        }

        public CIMValue valueObject(String value, String type) throws SAXException {
            CIMValue returnValue = null;
            if (value != null && value.length() == 0 || value == null) {
                returnValue = this.getCIMValue(null, value, type);
            }
            return returnValue;
        }

        protected CIMValue getCIMValue(Object o, String value, String type) throws SAXException {
            try {
                return new CIMValue(o);
            }
            catch (IllegalArgumentException iae) {
                throw new SAXException("Can't create CIMValue: " + value != null ? value : ("null " + type != null ? type : "null"), iae);
            }
        }
    }

    private static interface CimInstanceValueHandler {
        public CIMValue valueObject(String var1, String var2) throws SAXException;
    }

    private class KeyValueEventHandler
    implements CimInstanceEventHandler {
        private KeyValueEventHandler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            CimInstanceXMLFilter.this.valueType = CimInstanceXMLFilter.STR_TYPE;
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            try {
                CimInstanceXMLFilter.this.objPath.addKey(CimInstanceXMLFilter.this.keyName, new CIMValue((Object)CimInstanceXMLFilter.this.valueBuffer.toString().trim(), CIMDataType.getDataType((String)CimInstanceXMLFilter.this.valueType)));
            }
            catch (CIMException cime) {
                CimInstanceXMLFilter.this.objPath.addKey(CimInstanceXMLFilter.this.keyName, new CIMValue((Object)CimInstanceXMLFilter.this.valueBuffer.toString().trim()));
            }
        }
    }

    private class KeyBindingEventHandler
    implements CimInstanceEventHandler {
        private KeyBindingEventHandler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            CimInstanceXMLFilter.this.valueBuffer.setLength(0);
            CimInstanceXMLFilter.this.keyName = atts.getValue(CimInstanceXMLFilter.EMPTY_STR, CimInstanceXMLFilter.NAME);
            if (CimInstanceXMLFilter.this.keyName == null) {
                CimInstanceXMLFilter.this.keyName = CimInstanceXMLFilter.EMPTY_STR;
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        }
    }

    private class InstanceNameEventHandler
    implements CimInstanceEventHandler {
        private InstanceNameEventHandler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            String nameValue = atts.getValue(CimInstanceXMLFilter.EMPTY_STR, CimInstanceXMLFilter.CLASSNAME);
            if (nameValue != null) {
                CimInstanceXMLFilter.this.objPath.setObjectName(nameValue);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        }
    }

    private class ValueArrayEventHandler
    implements CimInstanceEventHandler {
        private ValueArrayEventHandler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            CimInstanceXMLFilter.this.valueBuffer.setLength(0);
            CimInstanceXMLFilter.this.valueList.clear();
            CimInstanceXMLFilter.this.inValueArray = true;
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            try {
                if (CimInstanceXMLFilter.this.inQualifier) {
                    CimInstanceXMLFilter.this.qual.setValue(new CIMValue(new Vector(CimInstanceXMLFilter.this.valueList), CIMDataType.getDataType((String)CimInstanceXMLFilter.this.qualValueType, (boolean)true)));
                } else if (CimInstanceXMLFilter.this.inPropArray) {
                    CimInstanceXMLFilter.this.prop.setValue(new CIMValue(new Vector(CimInstanceXMLFilter.this.valueList), CIMDataType.getDataType((String)CimInstanceXMLFilter.this.propValueType, (boolean)true)));
                }
            }
            catch (CIMException cime) {
                throw new SAXException("Badly formed Property Type: " + CimInstanceXMLFilter.this.propValueType + CimInstanceXMLFilter.SPACE + CimInstanceXMLFilter.this.inst.getClassName() != null ? CimInstanceXMLFilter.this.inst.getClassName() : (CimInstanceXMLFilter.EMPTY_STR + CimInstanceXMLFilter.this.prop.getName() != null ? CimInstanceXMLFilter.PERIOD + CimInstanceXMLFilter.this.prop.getName() : CimInstanceXMLFilter.EMPTY_STR), (Exception)((Object)cime));
            }
            CimInstanceXMLFilter.this.inValueArray = false;
        }
    }

    private class ValueReferenceEventHandler
    implements CimInstanceEventHandler {
        private ValueReferenceEventHandler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            CimInstanceXMLFilter.this.objPath = new CIMObjectPath();
            CimInstanceXMLFilter.this.objPath.setNameSpace("\\root\\se6x20\\");
            CimInstanceXMLFilter.this.objPath.setHost(CimInstanceXMLFilter.this.ipAddress);
            CimInstanceXMLFilter.this.inValueReference = true;
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            CimInstanceXMLFilter.this.prop.setValue(new CIMValue((Object)CimInstanceXMLFilter.this.objPath, new CIMDataType(CimInstanceXMLFilter.this.objPath.getObjectName())));
            CimInstanceXMLFilter.this.inValueReference = false;
        }
    }

    private class ValueEventHandler
    implements CimInstanceEventHandler {
        private ValueEventHandler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            CimInstanceXMLFilter.this.valueBuffer.setLength(0);
            CimInstanceXMLFilter.this.inValue = true;
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (CimInstanceXMLFilter.this.inValueArray) {
                if (CimInstanceXMLFilter.this.inQualifier) {
                    CIMValue cimValue = CimInstanceXMLFilter.this.valueObject(CimInstanceXMLFilter.this.valueBuffer.toString().trim(), CimInstanceXMLFilter.this.qualValueType);
                    if (!cimValue.isNullValue()) {
                        CimInstanceXMLFilter.this.valueList.add(cimValue.getValue());
                    }
                    cimValue = null;
                } else {
                    CIMValue cimValue = CimInstanceXMLFilter.this.valueObject(CimInstanceXMLFilter.this.fixupPropValue(CimInstanceXMLFilter.this.valueBuffer.toString().trim()), CimInstanceXMLFilter.this.propValueType);
                    if (!cimValue.isNullValue()) {
                        CimInstanceXMLFilter.this.valueList.add(cimValue.getValue());
                    }
                    cimValue = null;
                }
            } else if (CimInstanceXMLFilter.this.inQualifier) {
                CimInstanceXMLFilter.this.qual.setValue(CimInstanceXMLFilter.this.valueObject(CimInstanceXMLFilter.this.valueBuffer.toString().trim(), CimInstanceXMLFilter.this.qualValueType));
            } else if (CimInstanceXMLFilter.this.inPropRef) {
                CimInstanceXMLFilter.this.prop.setValue(CimInstanceXMLFilter.this.valueObject(CimInstanceXMLFilter.this.valueBuffer.toString().trim(), CimInstanceXMLFilter.this.propValueType));
            } else if (CimInstanceXMLFilter.this.inProp) {
                CimInstanceXMLFilter.this.prop.setValue(CimInstanceXMLFilter.this.valueObject(CimInstanceXMLFilter.this.fixupPropValue(CimInstanceXMLFilter.this.valueBuffer.toString().trim()), CimInstanceXMLFilter.this.propValueType));
            }
            CimInstanceXMLFilter.this.valueBuffer.setLength(0);
            CimInstanceXMLFilter.this.inValue = false;
        }
    }

    private class PropertyArrayEventHandler
    extends PropertyBaseEventHandler
    implements CimInstanceEventHandler {
        private PropertyArrayEventHandler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            super.startElement(namespaceURI, localName, qName, atts);
            CimInstanceXMLFilter.this.inPropArray = true;
            try {
                CimInstanceXMLFilter.this.prop.setType(CIMDataType.getDataType((String)CimInstanceXMLFilter.this.propValueType, (boolean)true));
            }
            catch (CIMException cime) {
                throw new SAXException("Badly formed Property Array Type: " + CimInstanceXMLFilter.this.propValueType + CimInstanceXMLFilter.SPACE + CimInstanceXMLFilter.this.inst.getClassName() != null ? CimInstanceXMLFilter.this.inst.getClassName() : (CimInstanceXMLFilter.PERIOD + this.nameValue != null ? this.nameValue : CimInstanceXMLFilter.EMPTY_STR), (Exception)((Object)cime));
            }
            catch (IllegalArgumentException iae) {
                throw new SAXException("Can't set Property Array Type: " + CimInstanceXMLFilter.this.propValueType + CimInstanceXMLFilter.SPACE + CimInstanceXMLFilter.this.inst.getClassName() != null ? CimInstanceXMLFilter.this.inst.getClassName() : (CimInstanceXMLFilter.PERIOD + this.nameValue != null ? this.nameValue : CimInstanceXMLFilter.EMPTY_STR), iae);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            super.endElement(namespaceURI, localName, qName);
        }
    }

    private class PropertyReferenceEventHandler
    extends PropertyBaseEventHandler
    implements CimInstanceEventHandler {
        private PropertyReferenceEventHandler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            super.startElement(namespaceURI, localName, qName, atts);
            CimInstanceXMLFilter.this.inPropRef = true;
            this.attValue = atts.getValue(CimInstanceXMLFilter.EMPTY_STR, CimInstanceXMLFilter.REFERENCECLASS);
            if (this.attValue != null) {
                CimInstanceXMLFilter.this.prop.setType(new CIMDataType(this.attValue));
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            super.endElement(namespaceURI, localName, qName);
        }
    }

    private class PropertyEventHandler
    extends PropertyBaseEventHandler
    implements CimInstanceEventHandler {
        private PropertyEventHandler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            super.startElement(namespaceURI, localName, qName, atts);
            CimInstanceXMLFilter.this.inProp = true;
            try {
                CimInstanceXMLFilter.this.prop.setType(CIMDataType.getDataType((String)CimInstanceXMLFilter.this.propValueType, (boolean)false));
            }
            catch (CIMException cime) {
                throw new SAXException("Badly formed Property Type: " + CimInstanceXMLFilter.this.propValueType + CimInstanceXMLFilter.SPACE + CimInstanceXMLFilter.this.inst.getClassName() != null ? CimInstanceXMLFilter.this.inst.getClassName() : (CimInstanceXMLFilter.PERIOD + this.nameValue != null ? this.nameValue : CimInstanceXMLFilter.EMPTY_STR), (Exception)((Object)cime));
            }
            catch (IllegalArgumentException iae) {
                throw new SAXException("Can't set Property Type: " + CimInstanceXMLFilter.this.propValueType + CimInstanceXMLFilter.SPACE + CimInstanceXMLFilter.this.inst.getClassName() != null ? CimInstanceXMLFilter.this.inst.getClassName() : (CimInstanceXMLFilter.PERIOD + this.nameValue != null ? this.nameValue : CimInstanceXMLFilter.EMPTY_STR), iae);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            super.endElement(namespaceURI, localName, qName);
        }
    }

    private class PropertyBaseEventHandler
    implements CimInstanceEventHandler {
        protected String attValue;
        protected String nameValue;

        private PropertyBaseEventHandler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            CimInstanceXMLFilter.this.prop = new CIMProperty();
            this.nameValue = atts.getValue(CimInstanceXMLFilter.EMPTY_STR, CimInstanceXMLFilter.NAME);
            if (this.nameValue != null) {
                CimInstanceXMLFilter.this.prop.setName(this.nameValue);
            }
            String attValue = null;
            attValue = atts.getValue(CimInstanceXMLFilter.EMPTY_STR, CimInstanceXMLFilter.TYPE);
            if (attValue != null) {
                CimInstanceXMLFilter.this.propValueType = attValue;
            }
            if ((attValue = atts.getValue(CimInstanceXMLFilter.EMPTY_STR, CimInstanceXMLFilter.CLASSORIGIN)) != null) {
                CimInstanceXMLFilter.this.prop.setOriginClass(attValue);
            }
            if ((attValue = atts.getValue(CimInstanceXMLFilter.EMPTY_STR, CimInstanceXMLFilter.ARRAYSIZE)) != null) {
                try {
                    int size = Integer.parseInt(attValue.trim());
                }
                catch (NumberFormatException nfe) {
                    throw new SAXException("Bad Property Attribute: ARRAYSIZE " + CimInstanceXMLFilter.this.inst.getClassName() != null ? CimInstanceXMLFilter.this.inst.getClassName() : (CimInstanceXMLFilter.PERIOD + this.nameValue != null ? this.nameValue : CimInstanceXMLFilter.EMPTY_STR), nfe);
                }
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            CimInstanceXMLFilter.this.propList.add(CimInstanceXMLFilter.this.prop);
            CimInstanceXMLFilter.this.prop = null;
            CimInstanceXMLFilter.this.inProp = false;
            CimInstanceXMLFilter.this.inPropArray = false;
            CimInstanceXMLFilter.this.inPropRef = false;
        }
    }

    private class QualifierEventHandler
    implements CimInstanceEventHandler {
        private QualifierEventHandler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            CimInstanceXMLFilter.this.inQualifier = true;
            CimInstanceXMLFilter.this.qual = new CIMQualifier();
            String nameValue = atts.getValue(CimInstanceXMLFilter.EMPTY_STR, CimInstanceXMLFilter.NAME);
            if (nameValue != null) {
                CimInstanceXMLFilter.this.qual.setName(nameValue);
            }
            String attValue = null;
            attValue = atts.getValue(CimInstanceXMLFilter.EMPTY_STR, CimInstanceXMLFilter.TYPE);
            if (attValue != null) {
                CimInstanceXMLFilter.this.qualValueType = attValue;
            }
            if ((attValue = atts.getValue(CimInstanceXMLFilter.EMPTY_STR, CimInstanceXMLFilter.OVERRIDABLE)) != null) {
                if (attValue.equalsIgnoreCase(CimInstanceXMLFilter.TRUE)) {
                    CimInstanceXMLFilter.this.qual.addFlavor(new CIMFlavor(0));
                } else {
                    CimInstanceXMLFilter.this.qual.addFlavor(new CIMFlavor(1));
                }
            }
            if ((attValue = atts.getValue(CimInstanceXMLFilter.EMPTY_STR, CimInstanceXMLFilter.TOSUBCLASS)) != null) {
                if (attValue.equalsIgnoreCase(CimInstanceXMLFilter.TRUE)) {
                    CimInstanceXMLFilter.this.qual.addFlavor(new CIMFlavor(3));
                } else {
                    CimInstanceXMLFilter.this.qual.addFlavor(new CIMFlavor(2));
                }
            }
            if ((attValue = atts.getValue(CimInstanceXMLFilter.EMPTY_STR, CimInstanceXMLFilter.TRANSLATABLE)) != null && attValue.equalsIgnoreCase(CimInstanceXMLFilter.TRUE)) {
                CimInstanceXMLFilter.this.qual.addFlavor(new CIMFlavor(4));
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (!CimInstanceXMLFilter.this.inQualifier) {
                CimInstanceXMLFilter.this.qual.setValue(CimInstanceXMLFilter.this.valueObject(CimInstanceXMLFilter.this.valueBuffer.toString().trim(), CimInstanceXMLFilter.this.qualValueType));
            }
            if (CimInstanceXMLFilter.this.inProp | CimInstanceXMLFilter.this.inPropArray | CimInstanceXMLFilter.this.inPropRef) {
                try {
                    CimInstanceXMLFilter.this.prop.addQualifier(CimInstanceXMLFilter.this.qual);
                }
                catch (CIMException cime) {}
            } else if (CimInstanceXMLFilter.this.inInstance) {
                CimInstanceXMLFilter.this.qualList.add(CimInstanceXMLFilter.this.qual);
            }
            CimInstanceXMLFilter.this.qual = null;
            CimInstanceXMLFilter.this.inQualifier = false;
        }
    }

    private class InstanceEventHandler
    implements CimInstanceEventHandler {
        private InstanceEventHandler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            CimInstanceXMLFilter.this.inst = new CIMInstance();
            String nameValue = atts.getValue(CimInstanceXMLFilter.EMPTY_STR, CimInstanceXMLFilter.CLASSNAME);
            if (nameValue != null) {
                CimInstanceXMLFilter.this.inst.setClassName(nameValue);
            }
            CimInstanceXMLFilter.this.propList.clear();
            CimInstanceXMLFilter.this.qualList.clear();
            CimInstanceXMLFilter.this.inInstance = true;
            CimInstanceXMLFilter.this.nullPoolOtherStatusDesc = false;
            CimInstanceXMLFilter.this.poolOtherStatusDesc = null;
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            CimInstanceXMLFilter.this.inst.setQualifiers(new Vector(CimInstanceXMLFilter.this.qualList));
            CimInstanceXMLFilter.this.inst.setProperties(new Vector(CimInstanceXMLFilter.this.propList));
            CimInstanceXMLFilter.this.instList.add(CimInstanceXMLFilter.this.inst);
            CimInstanceXMLFilter.this.inst = null;
            CimInstanceXMLFilter.this.inInstance = false;
        }
    }

    private static interface CimInstanceEventHandler {
        public void startElement(String var1, String var2, String var3, Attributes var4) throws SAXException;

        public void endElement(String var1, String var2, String var3) throws SAXException;
    }
}

