/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.CIMCacheEvent;
import com.sun.netstorage.dsp.mgmt.se6920.CIMCacheListener;
import com.sun.netstorage.dsp.mgmt.se6920.CacheAddr;
import com.sun.netstorage.dsp.mgmt.se6920.CacheEventManager;
import com.sun.netstorage.dsp.mgmt.se6920.ObjectPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;

public class CIMInstanceCache
implements CacheEventManager {
    private final String VOLUME_CLASS = "SunStorEdge_DSPStorageVolume";
    private final int COP_HASH_SIZE = 5000;
    private final int CON_HASH_SIZE = 200;
    private final int INST_HASH_SIZE = 5000;
    private final int VOL_HASH_SIZE = 1024;
    private HashMap copIndex = new HashMap(5000);
    private HashMap conIndex = new HashMap(200);
    private HashMap cimInsts = new HashMap();
    private HashMap volInsts = new HashMap(1024);
    private EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$com$sun$netstorage$dsp$mgmt$se6920$CIMCacheListener;

    public CIMInstanceCache() {
    }

    protected CIMInstanceCache(HashMap arrayInsts) {
        this.cimInsts = arrayInsts;
    }

    protected HashMap getConIndex() {
        return this.conIndex;
    }

    protected HashMap getCopIndex() {
        return this.copIndex;
    }

    public void addArray(ArrayObject array) {
        this.addArray(array, null);
    }

    public void addArray(ArrayObject array, CIMInstance tlo) {
        CIMCacheEvent arrayEvent;
        if (array == null) {
            return;
        }
        if (this.cimInsts.get(array) != null) {
            arrayEvent = new CIMCacheEvent(2, this, array);
            this.removeArrayImpl(array, arrayEvent);
        } else {
            arrayEvent = new CIMCacheEvent(1, this, array);
        }
        this.addArrayImpl(array, tlo, arrayEvent);
        this.postEvent(arrayEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addArrayWithInstances(ArrayObject array, CIMInstance[] mos) {
        if (array == null) {
            return;
        }
        HashMap hashMap = this.cimInsts;
        synchronized (hashMap) {
            CIMCacheEvent arrayEvent;
            if (this.cimInsts.get(array) != null) {
                arrayEvent = new CIMCacheEvent(2, this, array);
                this.removeArrayImpl(array, arrayEvent);
            } else {
                arrayEvent = new CIMCacheEvent(1, this, array);
            }
            this.addArrayImpl(array, null, arrayEvent);
            if (mos == null) {
                this.postEvent(arrayEvent);
                return;
            }
            for (int i = 0; i < mos.length; ++i) {
                this.addImpl(array, mos[i], arrayEvent);
            }
            this.postEvent(arrayEvent);
        }
    }

    public void add(ArrayObject array, CIMInstance mo) {
        CIMCacheEvent addEvent;
        if (array == null || mo == null) {
            return;
        }
        CIMObjectPath cop = mo.getObjectPath();
        if (this.copIndex.containsKey(new ObjectPath(cop))) {
            addEvent = new CIMCacheEvent(6, this, array);
            CIMInstance evtInst = (CIMInstance)this.getLiveInstance(cop).clone();
            addEvent.addInstance(evtInst);
        } else {
            addEvent = new CIMCacheEvent(4, this, array);
        }
        addEvent.addObjectPath(cop);
        this.addImpl(array, mo, addEvent);
        this.postEvent(addEvent);
    }

    void addWithoutEvent(ArrayObject array, CIMInstance mo) {
        this.putInCache(array, mo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CIMObjectPath putInCache(ArrayObject array, CIMInstance mo) {
        CIMObjectPath cop = mo.getObjectPath();
        String con = cop.getObjectName();
        Integer hs = new Integer(cop.toString().hashCode());
        CacheAddr addr = new CacheAddr(array, cop);
        HashMap hashMap = this.cimInsts;
        synchronized (hashMap) {
            HashMap<Integer, CIMInstance> cims = (HashMap<Integer, CIMInstance>)this.cimInsts.get(array);
            if (cims == null) {
                cims = new HashMap<Integer, CIMInstance>();
                this.cimInsts.put(array, cims);
            }
            cims.put(hs, mo);
            this.copIndex.put(new ObjectPath(cop), addr);
            LinkedHashMap<Integer, CacheAddr> conMap = (LinkedHashMap<Integer, CacheAddr>)this.conIndex.get(con);
            if (conMap == null) {
                conMap = new LinkedHashMap<Integer, CacheAddr>();
                this.conIndex.put(con, conMap);
            }
            conMap.put(hs, addr);
            this.addVolInst(mo);
        }
        return cop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(ArrayObject array, CIMInstance[] mos) {
        if (array == null || mos == null) {
            return;
        }
        HashMap hashMap = this.cimInsts;
        synchronized (hashMap) {
            for (int i = 0; i < mos.length; ++i) {
                this.add(array, mos[i]);
            }
        }
    }

    public void removeArray(ArrayObject array) {
        if (array == null) {
            return;
        }
        CIMCacheEvent arrayEvent = new CIMCacheEvent(3, this, array);
        this.removeArrayImpl(array, arrayEvent);
        this.postEvent(arrayEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CIMObjectPath cop) {
        if (cop == null) {
            return;
        }
        HashMap hashMap = this.cimInsts;
        synchronized (hashMap) {
            CacheAddr addr = (CacheAddr)this.copIndex.get(new ObjectPath(cop));
            String volName = null;
            if (addr == null) {
                return;
            }
            ArrayObject array = addr.getArray();
            if (array == null) {
                return;
            }
            HashMap cimMap = (HashMap)this.cimInsts.get(array);
            if (cimMap == null || cimMap.size() < 1) {
                return;
            }
            CIMCacheEvent arrayEvent = new CIMCacheEvent(5, this, array);
            String con = cop.getObjectName();
            Integer hs = new Integer(addr.getCOPHashCode());
            CIMInstance evtInst = (CIMInstance)this.getLiveInstance(cop).clone();
            arrayEvent.addInstance(evtInst);
            arrayEvent.addObjectPath(cop);
            if (con.equals("SunStorEdge_DSPStorageVolume")) {
                volName = this.getVolInstName(cop);
            }
            this.copIndex.remove(new ObjectPath(cop));
            LinkedHashMap conMap = (LinkedHashMap)this.conIndex.get(con);
            if (conMap != null) {
                conMap.remove(hs);
            }
            cimMap.remove(hs);
            if (volName != null) {
                this.removeVolInst(volName);
            }
            this.postEvent(arrayEvent);
        }
    }

    public void remove(ArrayObject array, CIMObjectPath cop) {
        if (array == null || cop == null) {
            return;
        }
        CIMCacheEvent removeEvent = new CIMCacheEvent(5, this, array);
        this.removeInstance(array, cop, removeEvent);
        this.postEvent(removeEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeInstance(ArrayObject array, CIMObjectPath cop, CIMCacheEvent event) {
        CIMInstance evtInst = (CIMInstance)this.getLiveInstance(cop).clone();
        event.addInstance(evtInst);
        event.addObjectPath(cop);
        HashMap hashMap = this.cimInsts;
        synchronized (hashMap) {
            String volName = null;
            HashMap cimMap = (HashMap)this.cimInsts.get(array);
            if (cimMap == null || cimMap.size() < 1) {
                return;
            }
            String con = cop.getObjectName();
            Integer hs = new Integer(cop.toString().hashCode());
            if (con.equals("SunStorEdge_DSPStorageVolume")) {
                volName = this.getVolInstName(cop);
            }
            this.copIndex.remove(new ObjectPath(cop));
            LinkedHashMap conMap = (LinkedHashMap)this.conIndex.get(con);
            if (conMap != null) {
                conMap.remove(hs);
            }
            cimMap.remove(hs);
            if (volName != null) {
                this.removeVolInst(volName);
            }
        }
    }

    public void removeAll(ArrayObject array, CIMObjectPath[] cops) {
        if (array == null || cops == null) {
            return;
        }
        this.removeInstances(array, cops, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeInstances(ArrayObject array, CIMObjectPath[] cops, CIMCacheEvent event) {
        HashMap hashMap = this.cimInsts;
        synchronized (hashMap) {
            HashMap cimMap = (HashMap)this.cimInsts.get(array);
            if (cimMap == null || cimMap.size() < 1) {
                return;
            }
            for (int i = 0; i < cops.length; ++i) {
                String volName = null;
                String con = cops[i].getObjectName();
                Integer hs = new Integer(cops[i].toString().hashCode());
                if (con.equals("SunStorEdge_DSPStorageVolume")) {
                    volName = this.getVolInstName(cops[i]);
                }
                CIMCacheEvent removeEvent = new CIMCacheEvent(5, this, array);
                CIMInstance evtInst = (CIMInstance)this.getLiveInstance(cops[i]).clone();
                removeEvent.addInstance(evtInst);
                removeEvent.addObjectPath(cops[i]);
                this.postEvent(removeEvent);
                this.copIndex.remove(new ObjectPath(cops[i]));
                LinkedHashMap conMap = (LinkedHashMap)this.conIndex.get(con);
                if (conMap != null) {
                    conMap.remove(hs);
                }
                cimMap.remove(hs);
                if (volName == null) continue;
                this.removeVolInst(volName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMInstance getLiveInstance(CIMObjectPath cop) {
        if (cop == null) {
            return null;
        }
        CIMInstance mo = null;
        HashMap hashMap = this.cimInsts;
        synchronized (hashMap) {
            CacheAddr addr = (CacheAddr)this.copIndex.get(new ObjectPath(cop));
            if (addr != null) {
                ArrayObject array = addr.getArray();
                Integer hs = new Integer(addr.getCOPHashCode());
                HashMap cimMap = (HashMap)this.cimInsts.get(array);
                if (cimMap == null) {
                    this.copIndex.remove(new ObjectPath(cop));
                    return null;
                }
                mo = (CIMInstance)cimMap.get(hs);
            } else {
                String bucketName = cop.getObjectName();
                HashMap bucket = (HashMap)this.conIndex.get(bucketName);
                if (bucket != null) {
                    Iterator it = bucket.values().iterator();
                    while (it.hasNext()) {
                        addr = (CacheAddr)it.next();
                        HashMap cimMap = (HashMap)this.cimInsts.get(addr.getArray());
                        CIMInstance inst = (CIMInstance)cimMap.get(new Integer(addr.getCOPHashCode()));
                        if (!ObjectPath.objectPathsAreEqual(inst.getObjectPath(), cop)) continue;
                        mo = inst;
                        break;
                    }
                }
            }
        }
        return mo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMInstance getLiveInstance(ArrayObject array, CIMObjectPath cop) {
        if (array == null || cop == null) {
            return null;
        }
        Integer hs = new Integer(cop.toString().hashCode());
        CIMInstance mo = null;
        HashMap hashMap = this.cimInsts;
        synchronized (hashMap) {
            HashMap cimMap = (HashMap)this.cimInsts.get(array);
            if (cimMap == null) {
                this.copIndex.remove(new ObjectPath(cop));
                return null;
            }
            mo = (CIMInstance)cimMap.get(hs);
        }
        return mo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMInstance[] enumerate(ArrayObject array) {
        Collection list;
        HashMap hashMap = this.cimInsts;
        synchronized (hashMap) {
            HashMap cimMap = (HashMap)this.cimInsts.get(array);
            if (cimMap == null || cimMap.size() < 1) {
                return null;
            }
            list = cimMap.values();
        }
        return list == null ? null : list.toArray(new CIMInstance[0]);
    }

    public CIMInstance[] enumerate(ArrayObject array, CIMObjectPath cop) {
        if (array == null) {
            return this.enumerate(cop);
        }
        if (cop == null) {
            return this.enumerate(array);
        }
        return this.enumerate(array, cop.getObjectName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMInstance[] enumerate(ArrayObject array, String con) {
        String METHOD = "enumerate";
        if (con == null) {
            return this.enumerate(array);
        }
        ArrayList<CIMInstance> list = new ArrayList<CIMInstance>();
        HashMap hashMap = this.cimInsts;
        synchronized (hashMap) {
            LinkedHashMap conMap = (LinkedHashMap)this.conIndex.get(con);
            if (conMap == null || conMap.size() < 1) {
                this.conIndex.remove(con);
                return null;
            }
            Collection col = conMap.values();
            Iterator addrs = col.iterator();
            HashMap cimMap = (HashMap)this.cimInsts.get(array);
            HashSet<Integer> hcToRemove = null;
            while (addrs != null && addrs.hasNext()) {
                CacheAddr addr = (CacheAddr)addrs.next();
                Integer hs = new Integer(addr.getCOPHashCode());
                if (cimMap == null) {
                    CacheAddr tmpADDR = (CacheAddr)conMap.get(hs);
                    Trace.info((Object)this, (String)"enumerate", (String)("WOULD have removed " + tmpADDR));
                    continue;
                }
                if (!array.equals(addr.getArray())) continue;
                CIMInstance nci = (CIMInstance)cimMap.get(hs);
                if (nci != null) {
                    list.add(nci);
                    continue;
                }
                if (hcToRemove == null) {
                    hcToRemove = new HashSet<Integer>();
                }
                hcToRemove.add(hs);
                Trace.info((Object)this, (String)"enumerate", (String)"CIMInstanceCache.enumerate(ArrayObject, String) found null CIM object will remove the stale index.");
            }
            if (hcToRemove != null) {
                Iterator i = hcToRemove.iterator();
                while (i.hasNext()) {
                    conMap.remove(i.next());
                }
            }
        }
        return list.size() == 0 ? null : list.toArray(new CIMInstance[0]);
    }

    public CIMInstance[] enumerate(CIMObjectPath cop) {
        if (cop == null) {
            return null;
        }
        return this.enumerate(cop.getObjectName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMInstance[] enumerate(String con) {
        String METHOD = "enumerate";
        if (con == null || "".equals(con)) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        HashMap hashMap = this.cimInsts;
        synchronized (hashMap) {
            if (con.equals("SunStorEdge_DSPStorageVolume")) {
                list.addAll(this.volInsts.values());
                return list.size() == 0 ? null : list.toArray(new CIMInstance[0]);
            }
            LinkedHashMap conMap = (LinkedHashMap)this.conIndex.get(con);
            if (conMap == null || conMap.size() < 1) {
                this.conIndex.remove(con);
                return null;
            }
            Collection col = conMap.values();
            Iterator addrs = col.iterator();
            ArrayObject prev = null;
            HashMap cimMap = null;
            HashSet<Integer> hcToRemove = null;
            while (addrs != null && addrs.hasNext()) {
                CacheAddr addr = (CacheAddr)addrs.next();
                Integer hs = new Integer(addr.getCOPHashCode());
                ArrayObject curr = addr.getArray();
                if (prev == null || !prev.equals(curr)) {
                    cimMap = (HashMap)this.cimInsts.get(curr);
                    prev = curr;
                }
                if (cimMap != null) {
                    CIMInstance nci = (CIMInstance)cimMap.get(hs);
                    if (nci != null) {
                        list.add(nci);
                        continue;
                    }
                    if (hcToRemove == null) {
                        hcToRemove = new HashSet();
                    }
                    hcToRemove.add(hs);
                    Trace.info((Object)this, (String)"enumerate", (String)"CIMInstanceCache.enumerate(String) found null CIMInstance will remove it from index.");
                    continue;
                }
                if (hcToRemove == null) {
                    hcToRemove = new HashSet<Integer>();
                }
                hcToRemove.add(hs);
                Trace.info((Object)this, (String)"enumerate", (String)"CIMInstanceCache.enumerate(String) found null cimMap from old array--will remove it from index.");
            }
            if (hcToRemove != null) {
                Iterator i = hcToRemove.iterator();
                while (i.hasNext()) {
                    conMap.remove(i.next());
                }
            }
        }
        return list.size() == 0 ? null : list.toArray(new CIMInstance[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CacheAddr getCacheAddr(CIMObjectPath cop) {
        CacheAddr addr = null;
        HashMap hashMap = this.cimInsts;
        synchronized (hashMap) {
            addr = (CacheAddr)this.copIndex.get(new ObjectPath(cop));
        }
        return addr;
    }

    public CIMInstance findVolume(String volumeName) {
        String METHOD = "findVolume";
        Trace.methodBegin((Object)this, (String)"findVolume");
        return (CIMInstance)this.volInsts.get(volumeName);
    }

    public void addVolInst(CIMInstance inst) {
        String METHOD = "addVolInst";
        CIMObjectPath cop = inst.getObjectPath();
        if (cop.getObjectName().equals("SunStorEdge_DSPStorageVolume")) {
            CIMProperty nameProp = inst.getProperty("ElementName");
            CIMValue nameVal = null;
            String name = null;
            if (nameProp != null) {
                nameVal = nameProp.getValue();
            } else {
                Trace.error((Object)this, (String)"addVolInst", (String)"Unable to retrieve name of volume, ignoring.");
                nameVal = null;
            }
            if (nameVal != null && nameVal.getValue() != null) {
                name = (String)nameVal.getValue();
                this.volInsts.put(name, inst);
            }
        }
    }

    public void removeVolInst(String name) {
        String METHOD = "removeVolInst";
        this.volInsts.remove(name);
    }

    private String getVolInstName(CIMObjectPath cop) {
        String METHOD = "getVolInstName";
        CIMInstance volInst = this.getLiveInstance(cop);
        if (volInst != null) {
            CIMProperty nameProp = volInst.getProperty("ElementName");
            CIMValue nameVal = null;
            if (nameProp != null) {
                nameVal = nameProp.getValue();
            } else {
                Trace.error((Object)this, (String)"getVolInstName", (String)"Unable to retrieve name of volume, ignoring.");
                nameVal = null;
            }
            if (nameVal != null && nameVal.getValue() != null) {
                return (String)nameVal.getValue();
            }
        }
        return null;
    }

    protected void addArrayImpl(ArrayObject array, CIMInstance tlo, CIMCacheEvent arrayEvent) {
        HashMap<Integer, CIMInstance> cimMap = new HashMap<Integer, CIMInstance>();
        if (tlo != null) {
            Integer hs = new Integer(tlo.getObjectPath().toString().hashCode());
            cimMap.put(hs, tlo);
            CIMObjectPath cop = tlo.getObjectPath();
            arrayEvent.addInstance(tlo);
            CacheAddr addr = new CacheAddr(array, cop.toString().hashCode());
            this.copIndex.put(new ObjectPath(tlo.getObjectPath()), addr);
            LinkedHashMap<Integer, CacheAddr> conMap = (LinkedHashMap<Integer, CacheAddr>)this.conIndex.get(cop.getObjectName());
            if (null == conMap) {
                conMap = new LinkedHashMap<Integer, CacheAddr>();
            }
            conMap.put(new Integer(cop.toString().hashCode()), addr);
            this.conIndex.put(cop.getObjectName(), conMap);
            this.addVolInst(tlo);
        }
        this.cimInsts.put(array, cimMap);
    }

    protected void addImpl(ArrayObject array, CIMInstance mo, CIMCacheEvent event) {
        event.addInstance(mo);
        this.putInCache(array, mo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeArrayImpl(ArrayObject array, CIMCacheEvent event) {
        HashMap hashMap = this.cimInsts;
        synchronized (hashMap) {
            HashMap cimMap = (HashMap)this.cimInsts.get(array);
            Vector<String> volNames = new Vector<String>();
            if (cimMap == null) {
                return;
            }
            if (cimMap.size() < 1) {
                this.cimInsts.remove(array);
                return;
            }
            CIMInstanceCache oldArrayCache = new CIMInstanceCache(cimMap);
            event.setOldCache(oldArrayCache);
            boolean LAZY = false;
            if (!LAZY) {
                Collection col = cimMap.values();
                CIMInstance[] cims = col.toArray(new CIMInstance[0]);
                for (int i = 0; i < cims.length; ++i) {
                    LinkedHashMap conMap;
                    CIMObjectPath cop = cims[i].getObjectPath();
                    if (cop.getObjectName().equals("SunStorEdge_DSPStorageVolume")) {
                        volNames.add(this.getVolInstName(cop));
                    }
                    cop.setNameSpace("");
                    String con = cop.getObjectName();
                    Integer hs = new Integer(cop.toString().hashCode());
                    ObjectPath copKey = new ObjectPath(cop);
                    Object addr = this.copIndex.remove(copKey);
                    if (addr != null) {
                        oldArrayCache.getCopIndex().put(copKey, addr);
                    }
                    if ((conMap = (LinkedHashMap)this.conIndex.get(con)) == null || (addr = conMap.remove(hs)) == null) continue;
                    LinkedHashMap oldConMap = (LinkedHashMap)oldArrayCache.getConIndex().get(con);
                    if (null == oldConMap) {
                        oldConMap = new LinkedHashMap();
                    }
                    oldConMap.put(hs, addr);
                    oldArrayCache.getConIndex().put(cop.getObjectName(), oldConMap);
                }
            }
            this.cimInsts.remove(array);
            if (volNames.size() > 0) {
                for (int i = 0; i < volNames.size(); ++i) {
                    this.removeVolInst((String)volNames.get(i));
                }
            }
        }
    }

    public void addCIMCacheListener(CIMCacheListener aListener) {
        this.listenerList.add(class$com$sun$netstorage$dsp$mgmt$se6920$CIMCacheListener == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$CIMCacheListener = CIMInstanceCache.class$("com.sun.netstorage.dsp.mgmt.se6920.CIMCacheListener")) : class$com$sun$netstorage$dsp$mgmt$se6920$CIMCacheListener, aListener);
    }

    public void removeCIMCacheListener(CIMCacheListener aListener) {
        this.listenerList.remove(class$com$sun$netstorage$dsp$mgmt$se6920$CIMCacheListener == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$CIMCacheListener = CIMInstanceCache.class$("com.sun.netstorage.dsp.mgmt.se6920.CIMCacheListener")) : class$com$sun$netstorage$dsp$mgmt$se6920$CIMCacheListener, aListener);
    }

    public void postEvent(CIMCacheEvent event) {
        String METHOD = "postEvent";
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$com$sun$netstorage$dsp$mgmt$se6920$CIMCacheListener == null ? CIMInstanceCache.class$("com.sun.netstorage.dsp.mgmt.se6920.CIMCacheListener") : class$com$sun$netstorage$dsp$mgmt$se6920$CIMCacheListener)) continue;
            ((CIMCacheListener)listeners[i + 1]).cacheEvent(event);
        }
        Trace.info((Object)this, (String)"postEvent", (String)("CacheEvent " + (event.getArray() != null ? event.getArray().toString() : "NULL Array") + " Type: " + CIMCacheEvent.eventTypeName[event.getType()]));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

