/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayException;
import com.sun.netstorage.dsp.mgmt.se6920.DevComm;
import com.sun.netstorage.dsp.mgmt.se6920.DspChangeListener;
import com.sun.netstorage.dsp.mgmt.se6920.DspPropertyChangeListener;
import com.sun.netstorage.dsp.mgmt.se6920.DspPropertyDeletedVolume;
import com.sun.netstorage.dsp.mgmt.se6920.DspPropertyModifiedChassis;
import com.sun.netstorage.dsp.mgmt.se6920.DspPropertyModifiedPort;
import com.sun.netstorage.dsp.mgmt.se6920.DspPropertyNewConsistencyGroup;
import com.sun.netstorage.dsp.mgmt.se6920.DspPropertyNewDisk;
import com.sun.netstorage.dsp.mgmt.se6920.DspPropertyNewDomain;
import com.sun.netstorage.dsp.mgmt.se6920.DspPropertyNewServer;
import com.sun.netstorage.dsp.mgmt.se6920.DspPropertyNewVolume;
import com.sun.netstorage.dsp.mgmt.se6920.DspPropertyRemovedElement;
import com.sun.netstorage.dsp.mgmt.se6920.DspPropertyVolumeMirrorResilver;
import com.sun.netstorage.dsp.mgmt.se6920.DspPropertyVolumeReplicationSync;
import com.sun.netstorage.dsp.mgmt.se6920.DspPropertyVolumeStateChange;
import com.sun.netstorage.dsp.mgmt.se6920.DspResults;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyBroker;
import com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPConcreteJob;
import com.sun.netstorage.dsp.mgmt.se6920.ModifySunStorEdge_DSPStorageVolume;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import com.sun.netstorage.dsp.mgmt.se6920.SunStorEdge_DSPPersistenceManager;
import com.sun.netstorage.dsp.mgmt.se6920.utils.MD5;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Vector;
import javax.wbem.cim.CIMException;

public class ArrayObject {
    private static final String CLASSNAME = "ArrayObject";
    private static final String JOB_MODIFY_MODULE = "ModifySunStorEdge_DSPConcreteJob";
    public static final String FLUSH_CACHE_RM = "asynchFlushCache";
    public static final String MODIFIED_CHASSIS_RM = "asynchModifiedChassis";
    public static final String MODIFIED_PORT_RM = "asynchModifiedPort";
    public static final String NEW_BOARD_RM = "asynchNewBoard";
    public static final String NEW_DISK_RM = "asynchNewDisk";
    public static final String NEW_DOMAIN_RM = "asynchNewDomain";
    public static final String NEW_PORT_RM = "asynchNewPort";
    public static final String NEW_SERVER_RM = "asynchNewServer";
    public static final String NEW_VOLUME_RM = "asynchNewVolume";
    public static final String NEW_CONSISTENCY_GROUP_RM = "asynchNewVolInGroup";
    public static final String MODIFIED_VOLUME_RM = "asynchModifiedVolume";
    public static final String VOLUME_STATE_CHANGE_RM = "asynchVolumeStateChange";
    public static final String VOLUME_PIT_ROLLBACK_RM = "asynchVolumePitRollback";
    public static final String VOLUME_MIRROR_RESILVER_RM = "asynchVolumeResilver";
    public static final String VOLUME_REPL_RESYNC_RM = "asynchVolumeResync";
    public static final String REMOVED_BOARD_RM = "asynchRemovedBoard";
    public static final String REMOVED_DISK_RM = "asynchRemovedDisk";
    public static final String REMOVED_DOMAIN_RM = "asynchRemovedDomain";
    public static final String REMOVED_PORT_RM = "asynchRemovedPort";
    public static final String REMOVED_SERVER_RM = "asynchRemovedServer";
    public static final String REMOVED_VOLUME_RM = "asynchRemovedVolume";
    public static final String UN_INITED_DISK_REQUEST = "samDisk_genAsynchsForUninitDisks=blah";
    private static final String PLATFORM_HOST_ID = "samUtil_PlatformNameFromStr";
    private static final String PLATFORM_IP = "samUtil_PlatformIp";
    private static final String PLATFORM_WRITE = "samUtil_PlatformWrite";
    private static final String RNID_PAGE = "response.xml";
    private String host;
    private int port = 80;
    private int listenerPort = 3002;
    private String user;
    private String password;
    private String nonce;
    private Boolean loggingIn = Boolean.FALSE;
    private boolean loggedIn = false;
    private boolean useCRAM = true;
    private boolean isAlive = true;
    private Thread refreshThread = null;
    private boolean keepRunning = true;
    private boolean cacheInitialized = false;
    private boolean cacheBeingUpdated = false;
    private int keepAliveCounter = 0;
    private KeepAlive keepAlive = null;
    private boolean keepLoggedIn = false;
    private ArrayObject myself = null;
    private int reconnectCounter = 0;
    private boolean dspReconnectInProgress = false;
    private String dspReconnectInProgressLock = new String("lock");
    private boolean rlReconnectInProgress = false;
    private String rlReconnectInProgressLock = new String("lock");
    private int rlFailureCount = 0;
    private boolean firstLogin = true;
    private String rnidHostId;
    private String rnidIpAddr;
    private static final int SLEEP_INTERVAL = 60000;
    private static final int SLEEP_A_MINUTE = 60000;
    private static final int SLEEP_FIVE_SECONDS = 5000;
    private static final int SLEEP_A_BIT = 5000;
    private int numberOfSleeps = 5;
    private static HashMap instances = new HashMap();
    private DspChangeListener dspChangeListener;
    private static final String sccs_id = "@(#)ArrayObject.java    1.49    05/08/31   SMI";
    static /* synthetic */ Class class$com$sun$netstorage$dsp$mgmt$se6920$ArrayObject;

    private ArrayObject() {
    }

    public static ArrayObject getInstance(String host, String user, String pass) {
        String METHOD = "getInstance";
        String key = new String(host + "+" + user + "+" + pass);
        ArrayObject ao = (ArrayObject)instances.get(key);
        if (null == ao) {
            ao = new ArrayObject();
            ao.host = host;
        }
        ao.user = user;
        ao.password = null == pass ? "" : pass;
        ao.nonce = new String();
        ao.myself = ao;
        instances.put(key, ao);
        ao.dspChangeListener = null;
        ao.rnidHostId = null;
        ao.rnidIpAddr = null;
        return ao;
    }

    public static ArrayObject getInstance(String host, int port, String user, String pass) {
        String METHOD = "getInstance";
        ArrayObject ao = ArrayObject.getInstance(host, user, pass);
        ao.port = port;
        return ao;
    }

    public static void removeArray(ArrayObject ao) {
        String METHOD = "removeArray";
        if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$dsp$mgmt$se6920$ArrayObject == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$ArrayObject = ArrayObject.class$("com.sun.netstorage.dsp.mgmt.se6920.ArrayObject")) : class$com$sun$netstorage$dsp$mgmt$se6920$ArrayObject))) {
            Trace.methodBegin((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$ArrayObject == null ? (class$com$sun$netstorage$dsp$mgmt$se6920$ArrayObject = ArrayObject.class$("com.sun.netstorage.dsp.mgmt.se6920.ArrayObject")) : class$com$sun$netstorage$dsp$mgmt$se6920$ArrayObject), (String)"removeArray");
        }
        instances.remove(ao.getHost());
    }

    public String getHost() {
        String METHOD = "getHost";
        return this.host;
    }

    public int getPort() {
        String METHOD = "getPort";
        return this.port;
    }

    public int getListenerPort() {
        return this.listenerPort;
    }

    public void setListenerPort(int newPort) {
        this.listenerPort = newPort;
    }

    public String getUser() {
        String METHOD = "getUser";
        return this.user;
    }

    public String getPassword() {
        String METHOD = "getPassword";
        return this.password;
    }

    private void setNonce(String newNonce) {
        String METHOD = "setNonce";
        this.nonce = newNonce;
    }

    public String getNonce() {
        String METHOD = "getNonce";
        return this.nonce;
    }

    private KeepAlive getKeepAlive() {
        return this.keepAlive;
    }

    private void setKeepAlive(KeepAlive newKeepAlive) {
        this.keepAlive = newKeepAlive;
    }

    public boolean isCacheInitialized() {
        return this.cacheInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getDspReconnectInProgress() {
        String string = this.dspReconnectInProgressLock;
        synchronized (string) {
            return this.dspReconnectInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setDspReconnectInProgress(boolean flag) {
        String string = this.dspReconnectInProgressLock;
        synchronized (string) {
            boolean currentFlag = this.dspReconnectInProgress;
            if (currentFlag == flag) {
                return false;
            }
            this.dspReconnectInProgress = flag;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getRlReconnectInProgress() {
        String string = this.rlReconnectInProgressLock;
        synchronized (string) {
            return this.rlReconnectInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setRlReconnectInProgress(boolean flag) {
        String string = this.rlReconnectInProgressLock;
        synchronized (string) {
            boolean currentFlag = this.rlReconnectInProgress;
            if (currentFlag == flag) {
                return false;
            }
            this.rlReconnectInProgress = flag;
            return true;
        }
    }

    public DspChangeListener getDspChangeListener() {
        return this.dspChangeListener;
    }

    public boolean getCRAMFlag() {
        String METHOD = "getCRAMFlag";
        return this.useCRAM;
    }

    public void endRefreshThread() {
        String METHOD = "endRefreshThread";
        if (Trace.isTraceEnabled((Object)this)) {
            Trace.methodBegin((Object)this, (String)"endRefreshThread");
        }
        this.keepRunning = false;
        if (null != this.refreshThread) {
            this.refreshThread.interrupt();
        }
    }

    public void cacheRefreshed() {
        String METHOD = "cacheRefreshed";
        if (Trace.isTraceEnabled((Object)this)) {
            Trace.methodBegin((Object)this, (String)"cacheRefreshed");
        }
        if (null != this.refreshThread && !this.cacheBeingUpdated) {
            this.refreshThread.interrupt();
        }
    }

    public boolean equals(Object obj) {
        String METHOD = "equals";
        boolean ret = false;
        if (null != obj && obj instanceof ArrayObject) {
            ret = this.host.equals(((ArrayObject)obj).getHost());
        }
        return ret;
    }

    public int hashCode() {
        String METHOD = "hashCode";
        return this.host.hashCode();
    }

    void startRefreshThread() {
        String METHOD = "startRefreshThread";
        if (Trace.isTraceEnabled((Object)this)) {
            Trace.methodBegin((Object)this, (String)"startRefreshThread");
        }
        if (null != this.refreshThread) {
            return;
        }
        this.refreshThread = new Thread(new Runnable(){

            public void run() {
                while (ArrayObject.this.keepRunning) {
                    try {
                        if (!ArrayObject.this.cacheBeingUpdated) {
                            Trace.warn((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$ArrayObject == null ? ArrayObject.class$("com.sun.netstorage.dsp.mgmt.se6920.ArrayObject") : class$com$sun$netstorage$dsp$mgmt$se6920$ArrayObject), (String)"startRefreshThread", (String)" Cache expiring... ");
                            ArrayObject.this.cacheBeingUpdated = true;
                            RequestBroker.getInstance().invalidateCache(ArrayObject.this);
                        }
                        ArrayObject.this.cacheBeingUpdated = false;
                        try {
                            for (int i = 0; i < ArrayObject.this.numberOfSleeps; ++i) {
                                Trace.warn((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$ArrayObject == null ? ArrayObject.class$("com.sun.netstorage.dsp.mgmt.se6920.ArrayObject") : class$com$sun$netstorage$dsp$mgmt$se6920$ArrayObject), (String)"startRefreshThread", (String)(" Refreshing in ... " + (ArrayObject.this.numberOfSleeps - i) * 60000 + " ms"));
                                Thread.sleep(60000L);
                            }
                        }
                        catch (InterruptedException iex) {
                            Trace.warn((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$ArrayObject == null ? ArrayObject.class$("com.sun.netstorage.dsp.mgmt.se6920.ArrayObject") : class$com$sun$netstorage$dsp$mgmt$se6920$ArrayObject), (String)"startRefreshThread", (String)" Interrupted... ");
                            ArrayObject.this.cacheBeingUpdated = true;
                        }
                    }
                    catch (Exception ex) {
                        Trace.error((Class)(class$com$sun$netstorage$dsp$mgmt$se6920$ArrayObject == null ? ArrayObject.class$("com.sun.netstorage.dsp.mgmt.se6920.ArrayObject") : class$com$sun$netstorage$dsp$mgmt$se6920$ArrayObject), (String)"Exception", (Throwable)ex);
                    }
                }
            }
        });
        this.refreshThread.setName(this + " Refresh");
        this.refreshThread.setDaemon(true);
        this.refreshThread.start();
    }

    void initializeCache() {
        String METHOD = "initializeCache";
        if (Trace.isTraceEnabled((Object)this)) {
            Trace.methodBegin((Object)this, (String)"initializeCache");
        }
        boolean cacheNotUpdated = true;
        while (cacheNotUpdated) {
            if (this.cacheBeingUpdated) continue;
            this.cacheBeingUpdated = true;
            RequestBroker.getAllDeviceInstances(this);
            cacheNotUpdated = false;
        }
        this.cacheBeingUpdated = false;
        this.cacheInitialized = true;
    }

    void loadPersistedDataToCache() {
        String METHOD = "loadPersistedDataToCache";
        if (Trace.isTraceEnabled((Object)this)) {
            Trace.methodBegin((Object)this, (String)"loadPersistedDataToCache");
        }
        boolean cacheNotUpdated = true;
        while (cacheNotUpdated) {
            if (this.cacheBeingUpdated) continue;
            this.cacheBeingUpdated = true;
            SunStorEdge_DSPPersistenceManager.getInstance().processPersistedData();
            try {
                ModifySunStorEdge_DSPStorageVolume.healVolumePoolAssocs();
            }
            catch (CIMException ce) {
                Trace.error((Object)this, (String)"loadPersistedDataToCache", (String)"Exception occured when trying to heal volumes.");
                Trace.error((Object)this, (String)"loadPersistedDataToCache", (Throwable)ce);
            }
            cacheNotUpdated = false;
        }
        this.cacheBeingUpdated = false;
    }

    public boolean permitUpload() {
        String METHOD = "permitUpload";
        if (Trace.isTraceEnabled((Object)this)) {
            Trace.methodBegin((Object)this, (String)"permitUpload");
        }
        return true;
    }

    public synchronized boolean isLoggedIn() {
        return this.loggedIn;
    }

    public synchronized void setLoggedIn(boolean flag) {
        this.loggedIn = flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLoggingIn() {
        Boolean bl = this.loggingIn;
        synchronized (bl) {
            return this.loggingIn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean setLoggingIn(boolean flag) {
        Boolean bl = this.loggingIn;
        synchronized (bl) {
            boolean currentValue = this.loggingIn;
            if (currentValue == flag) {
                return false;
            }
            this.loggingIn = flag;
            return true;
        }
    }

    public void login() {
        this.login(false);
    }

    public void login(boolean debugLogin) {
        String METHOD = "login";
        Trace.methodBegin((Object)this, (String)"login");
        DevComm devComm = DevComm.getInstance();
        if (this.isLoggedIn()) {
            Trace.info((Object)this, (String)"login", (String)" Already logged in ");
            return;
        }
        if (!this.setLoggingIn(true)) {
            Trace.info((Object)this, (String)"login", (String)" Log in already in progress ");
        }
        boolean loggedIn = false;
        this.keepLoggedIn = true;
        while (!loggedIn && this.keepLoggedIn) {
            try {
                Trace.error((Object)this, (String)"login", (String)" Attempting login ");
                this.getNonceFromDsp();
                loggedIn = this.sendLogin(debugLogin);
            }
            catch (Exception e) {
                Trace.error((Object)this, (String)"login", (String)" Login failed ");
            }
            if (loggedIn) continue;
            Trace.error((Object)this, (String)"login", (String)" Sleeping for 60 seconds");
            try {
                Thread.sleep(60000L);
            }
            catch (Exception e) {}
        }
        this.setLoggingIn(false);
        if (loggedIn) {
            try {
                String[] logArgs = new String[]{this.getHost()};
                LogAPI.staticLog((String)"DEVCOMM_CONNECTED", (String[])logArgs, null);
            }
            catch (Exception logEx) {
                // empty catch block
            }
            Trace.error((Object)this, (String)"login", (String)" Login succeeded");
            this.setLoggedIn(true);
            if (this.dspChangeListener == null) {
                this.startChangeListener();
            } else {
                try {
                    this.dspChangeListener.restartCommunications();
                }
                catch (Exception e) {
                    this.startChangeListener();
                }
            }
            this.startKeepAlive();
            if (this.firstLogin) {
                this.firstLogin = false;
            } else {
                this.sendRnid();
                RequestBroker.getInstance().invalidateCache(this);
                this.getMissedNotifications();
                ModifySunStorEdge_DSPConcreteJob jobMod = (ModifySunStorEdge_DSPConcreteJob)ModifyBroker.getInstance().getModule(this.getHost(), JOB_MODIFY_MODULE);
                jobMod.checkOutstandingJobs();
                try {
                    ModifySunStorEdge_DSPStorageVolume.healVolumePoolAssocs();
                }
                catch (CIMException ce) {
                    Trace.error((Object)this, (String)"login", (String)"Exception occured when trying to heal volumes.");
                    Trace.error((Object)this, (String)"login", (Throwable)ce);
                }
                Thread thread = SunStorEdge_DSPPersistenceManager.getProcessVDiskThread();
                if (thread != null) {
                    thread.interrupt();
                }
            }
            this.setDspReconnectInProgress(false);
            this.setRlReconnectInProgress(false);
        }
        Trace.methodEnd((Object)this, (String)"login");
    }

    private void getNonceFromDsp() throws ArrayException {
        String METHOD = "getNonceFromDsp";
        Trace.info((Object)this, (String)"getNonceFromDsp", (String)" Begin ");
        DevComm devComm = DevComm.getInstance();
        BufferedReader loginPage = null;
        String inputLine = null;
        try {
            loginPage = new BufferedReader(new InputStreamReader(devComm.get(this, "/", false, false, true)));
            String matchStr = "<input type=\"hidden\" name=\"nonce\" value=";
            while ((inputLine = loginPage.readLine()) != null) {
                if (-1 >= inputLine.indexOf(matchStr)) continue;
                int temp = inputLine.indexOf(matchStr) + 41;
                this.nonce = inputLine.substring(temp, temp + 16);
                Trace.info((Object)this, (String)"getNonceFromDsp", (String)(" Nonce =  " + this.nonce));
            }
            loginPage.close();
        }
        catch (IOException e) {
            Trace.error((Object)this, (String)" Unable to get nonce - Exception", (Throwable)e);
            throw new ArrayException("Unable to log in");
        }
        if (this.nonce == null) {
            Trace.error((Object)this, (String)"getNonceFromDsp", (String)" Unable to get nonce ");
            throw new ArrayException("Unable to log in");
        }
        Trace.info((Object)this, (String)"getNonceFromDsp", (String)" End ");
    }

    private boolean sendLogin(boolean debugEnabled) {
        DspResults loginReply;
        String METHOD = "sendLogin";
        Trace.info((Object)this, (String)"sendLogin", (String)" Begin ");
        MD5 md5 = new MD5();
        Vector<String> nvPairs = new Vector<String>();
        DevComm devComm = DevComm.getInstance();
        BufferedReader loginPage = null;
        String inputLine = null;
        md5.Init();
        md5.Update(this.getPassword());
        String encryptedPass = md5.asHex();
        encryptedPass = encryptedPass.substring(0, 16);
        md5.Init();
        md5.Update(this.getUser() + ":" + encryptedPass + ":" + this.getNonce());
        String encryptedParm = md5.asHex();
        nvPairs.add("encoded=" + this.getUser() + ":" + encryptedParm);
        nvPairs.add("nonce=" + this.getNonce());
        nvPairs.add("URL=/");
        if (debugEnabled) {
            try {
                loginPage = devComm.postWithResults(this, "/", nvPairs, true);
                Trace.info((Object)this, (String)"sendLogin", (String)"Login results:");
                System.out.println("Login results:");
                while ((inputLine = loginPage.readLine()) != null) {
                    Trace.info((Object)this, (String)"sendLogin", (String)inputLine);
                    System.out.println(inputLine);
                }
                loginPage.close();
            }
            catch (Exception e) {
                System.out.println("Took exception posting login page");
            }
            return true;
        }
        try {
            loginReply = devComm.postWithDspResults(this, "/", nvPairs, true);
            Trace.warn((Object)this, (String)"sendLogin", (String)("Login request returned " + loginReply));
            Trace.info((Object)this, (String)"sendLogin", (String)" End ");
        }
        catch (Exception loginEx) {
            return false;
        }
        return loginReply.requestSucceeded();
    }

    private void startChangeListener() {
        String METHOD = "startChangeListener";
        Trace.info((Object)this, (String)"startChangeListener", (String)" Begin ");
        if (this.dspChangeListener != null) {
            Trace.info((Object)this, (String)"startChangeListener", (String)" Cleaning up existing change listener ");
            try {
                this.dspChangeListener.kill();
            }
            catch (Exception killEx) {
                Trace.info((Object)this, (String)" Took exception cleaning up existing change listener ", (Throwable)killEx);
            }
            this.dspChangeListener = null;
        }
        try {
            this.dspChangeListener = new DspChangeListener(this, false);
            DspPropertyChangeListener pcl = new DspPropertyRemovedElement(this, "CacheFlushListener", false);
            this.dspChangeListener.addPropertyChangeListener(pcl, FLUSH_CACHE_RM);
            pcl = new DspPropertyModifiedChassis(this);
            this.dspChangeListener.addPropertyChangeListener(pcl, MODIFIED_CHASSIS_RM);
            this.dspChangeListener.addPropertyChangeListener(pcl, NEW_BOARD_RM);
            this.dspChangeListener.addPropertyChangeListener(pcl, REMOVED_BOARD_RM);
            pcl = new DspPropertyModifiedPort(this);
            this.dspChangeListener.addPropertyChangeListener(pcl, MODIFIED_PORT_RM);
            pcl = new DspPropertyNewDisk(this);
            this.dspChangeListener.addPropertyChangeListener(pcl, NEW_DISK_RM);
            pcl = new DspPropertyNewDomain(this);
            this.dspChangeListener.addPropertyChangeListener(pcl, NEW_DOMAIN_RM);
            pcl = new DspPropertyNewServer(this);
            this.dspChangeListener.addPropertyChangeListener(pcl, NEW_SERVER_RM);
            pcl = new DspPropertyNewVolume(this);
            this.dspChangeListener.addPropertyChangeListener(pcl, NEW_VOLUME_RM);
            pcl = new DspPropertyNewConsistencyGroup(this);
            this.dspChangeListener.addPropertyChangeListener(pcl, NEW_CONSISTENCY_GROUP_RM);
            pcl = new DspPropertyRemovedElement(this);
            this.dspChangeListener.addPropertyChangeListener(pcl, REMOVED_DISK_RM);
            this.dspChangeListener.addPropertyChangeListener(pcl, REMOVED_DOMAIN_RM);
            this.dspChangeListener.addPropertyChangeListener(pcl, REMOVED_PORT_RM);
            this.dspChangeListener.addPropertyChangeListener(pcl, REMOVED_SERVER_RM);
            pcl = new DspPropertyDeletedVolume(this);
            this.dspChangeListener.addPropertyChangeListener(pcl, REMOVED_VOLUME_RM);
            pcl = DspPropertyVolumeMirrorResilver.getInstance(this);
            this.dspChangeListener.addPropertyChangeListener(pcl, VOLUME_MIRROR_RESILVER_RM);
            pcl = DspPropertyVolumeReplicationSync.getInstance(this);
            this.dspChangeListener.addPropertyChangeListener(pcl, VOLUME_REPL_RESYNC_RM);
            pcl = new DspPropertyVolumeStateChange(this);
            this.dspChangeListener.addPropertyChangeListener(pcl, VOLUME_STATE_CHANGE_RM);
        }
        catch (Exception e) {
            this.dspChangeListener = null;
        }
    }

    private void startKeepAlive() {
        String METHOD = "startKeepAlive";
        Trace.methodBegin((Object)this, (String)"startKeepAlive");
        KeepAlive keepAlive = this.getKeepAlive();
        if (keepAlive != null) {
            Trace.info((Object)this, (String)"startKeepAlive", (String)" Shutting down existing keepAlive");
            keepAlive.setReconnectOnError(false);
            keepAlive.setConnected(false);
        }
        this.setKeepAlive(null);
        Trace.info((Object)this, (String)"startKeepAlive", (String)" Starting new keepAlive");
        keepAlive = new KeepAlive(this, this.keepAliveCounter++);
        keepAlive.startHeartbeat();
        this.setKeepAlive(keepAlive);
        Trace.methodEnd((Object)this, (String)"startKeepAlive");
    }

    public synchronized void logout(boolean stopRightNow) {
        this.logout(stopRightNow, true);
    }

    public synchronized void logout(boolean stopRightNow, boolean removeChangeListener) {
        String METHOD = "logout";
        if (Trace.isTraceEnabled((Object)this)) {
            Trace.methodBegin((Object)this, (String)"logout");
        }
        this.keepLoggedIn = false;
        this.nonce = new String();
        if (this.isLoggedIn()) {
            this.setLoggedIn(false);
            KeepAlive keepAlive = this.getKeepAlive();
            if (keepAlive != null) {
                Trace.info((Object)this, (String)"logout", (String)" Shutting down keepalive");
                this.setKeepAlive(null);
                keepAlive.setReconnectOnError(false);
                keepAlive.setConnected(false);
                if (stopRightNow) {
                    Trace.info((Object)this, (String)"logout", (String)" interrupting keepalive");
                    keepAlive.interruptHeartbeat();
                }
            } else {
                Trace.info((Object)this, (String)"logout", (String)" no Keepalive to shut down");
            }
        }
        if (this.dspChangeListener != null) {
            if (removeChangeListener) {
                Trace.info((Object)this, (String)"logout", (String)" removing change listener");
                this.dspChangeListener.removeAllPropertyChangeListeners();
                this.dspChangeListener = null;
            } else {
                Trace.info((Object)this, (String)"logout", (String)" disabling change listener");
                this.dspChangeListener.disableCommunications();
            }
        }
        try {
            String[] logArgs = new String[]{this.getHost()};
            LogAPI.staticLog((String)"DEVCOMM_DISCONNECTED", (String[])logArgs, null);
        }
        catch (Exception logEx) {
            // empty catch block
        }
        Trace.info((Object)this, (String)"logout", (String)" complete");
    }

    public void initialLogin() {
        String METHOD = "initialLogin";
        if (Trace.isTraceEnabled((Object)this)) {
            Trace.methodBegin((Object)this, (String)"initialLogin");
        }
        try {
            String[] logArgs = new String[]{this.getHost()};
            LogAPI.staticLog((String)"DEVCOMM_INITIAL_CONNECT", (String[])logArgs, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModifyBroker.clearCacheInitialized();
        this.login();
        this.initializeCache();
        ModifyBroker.setCacheInitialized();
    }

    public synchronized void reconnect() {
        String METHOD = "reconnect";
        Trace.info((Object)this, (String)"reconnect", (String)" Begin ");
        if (!this.setDspReconnectInProgress(true)) {
            Trace.info((Object)this, (String)"reconnect", (String)" Reconnect already in progress. ");
            return;
        }
        this.setRlReconnectInProgress(true);
        this.logout(true, false);
        ModifyBroker.clearCacheUpdateOwner(true, true);
        Thread loginThread = new Thread(new Runnable(){

            public void run() {
                ArrayObject.this.login();
            }
        });
        try {
            String[] logArgs = new String[]{this.getHost()};
            LogAPI.staticLog((String)"DEVCOMM_RECONNECT", (String[])logArgs, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Trace.info((Object)this, (String)"reconnect", (String)" Forking off reconnect thread ");
        loginThread.setName(this + " reconnect " + this.reconnectCounter++);
        loginThread.setDaemon(true);
        loginThread.start();
    }

    public void setRnid(String hostId, String ipAddr) {
        this.rnidHostId = hostId;
        this.rnidIpAddr = ipAddr;
        this.sendRnid();
    }

    public void sendRnid() {
        String METHOD = "sendRnid";
        Trace.info((Object)this, (String)"sendRnid", (String)" Begin ");
        Trace.info((Object)this, (String)"sendRnid", (String)(" rnidHostId = " + this.rnidHostId + " rnidIpAddr = " + this.rnidIpAddr));
        if (this.rnidHostId == null || this.rnidIpAddr == null) {
            Trace.info((Object)this, (String)"sendRnid", (String)" Cannot send:  rnidHostId or rnidIpAddr not set ");
            return;
        }
        String page = new String(RNID_PAGE);
        Vector<String> nvPairs = new Vector<String>();
        nvPairs.add(new String("samUtil_PlatformNameFromStr=" + this.rnidHostId));
        nvPairs.add(new String("samUtil_PlatformIp=" + this.rnidIpAddr));
        nvPairs.add(new String("samUtil_PlatformWrite=1"));
        try {
            DspResults rnidReply = DevComm.getInstance().postWithDspResults(this, page, nvPairs);
            Trace.info((Object)this, (String)"sendRnid", (String)" Rnid request sent");
            Trace.info((Object)this, (String)"sendRnid", (String)(" Rnid request returned " + rnidReply));
            Trace.info((Object)this, (String)"sendRnid", (String)" End ");
        }
        catch (Exception ex) {
            Trace.error((Object)this, (String)" Rnid request took an exception ", (Throwable)ex);
        }
    }

    public void handleChangeListenerException() {
        int failureCount = this.rlFailureCount++;
        String METHOD = "handleChangeListenerException";
        Trace.info((Object)this, (String)"handleChangeListenerException", (String)(" Failure " + failureCount + " " + " Begin "));
        if (!this.setRlReconnectInProgress(true)) {
            Trace.info((Object)this, (String)"handleChangeListenerException", (String)(" Failure " + failureCount + " " + " ChangeListener reconnect already in progress "));
            return;
        }
        try {
            Trace.info((Object)this, (String)"handleChangeListenerException", (String)(" Failure " + failureCount + " " + " Sleeping before checking comms status"));
            Thread.sleep(5000L);
        }
        catch (Exception sleepE) {
            Trace.error((Object)this, (String)(" Failure " + failureCount + " " + " Sleep failed.  Continuing with reconnect "), (Throwable)sleepE);
        }
        if (this.getDspReconnectInProgress()) {
            Trace.info((Object)this, (String)"handleChangeListenerException", (String)(" Failure " + failureCount + " " + " All Dsp communications are lost.  ChangeListener will be restored as part of reconnect that is already in progress "));
            return;
        }
        Trace.info((Object)this, (String)"handleChangeListenerException", (String)(" Failure " + failureCount + " " + " Reconnecting ChangeListener "));
        try {
            this.dspChangeListener.disableCommunications();
            this.dspChangeListener.restartCommunications();
            Trace.info((Object)this, (String)"handleChangeListenerException", (String)(" Failure " + failureCount + " " + " Reconnected to ChangeListener.  Resynching. "));
            this.getMissedNotifications();
        }
        catch (Exception e) {
            Trace.info((Object)this, (String)"handleChangeListenerException", (String)(" Failure " + failureCount + " " + " Failed to reconnect ChangeListener.  Restarting all comms "));
            this.reconnect();
        }
        this.setRlReconnectInProgress(false);
        Trace.info((Object)this, (String)"handleChangeListenerException", (String)(" Failure " + failureCount + " " + " End "));
    }

    private void getMissedNotifications() {
        String METHOD = "getMissedNotifications";
        Trace.info((Object)this, (String)"getMissedNotifications", (String)" Begin ");
        try {
            DevComm devComm = DevComm.getInstance();
            String page = new String(RNID_PAGE);
            Vector<String> nvPairs = new Vector<String>();
            nvPairs.add(UN_INITED_DISK_REQUEST);
            DspResults resynchReply = devComm.postWithDspResults(this, page, nvPairs);
            Trace.info((Object)this, (String)"getMissedNotifications", (String)" Resynch request sent");
            Trace.info((Object)this, (String)"getMissedNotifications", (String)(" Resynch request returned " + resynchReply));
        }
        catch (Exception e) {
            Trace.info((Object)this, (String)"getMissedNotifications", (String)" Took exception trying to get missed notifications ");
        }
    }

    public String toString() {
        String METHOD = "toString";
        return "ArrayObject:" + this.getHost();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class KeepAlive
    implements Runnable {
        private static final String CLASSNAME = "ArrayObject.KeepAlive";
        private static final String KEEPALIVE_FILE = "system.xml";
        ArrayObject dsp;
        int keepAliveId = 0;
        boolean connected = false;
        boolean reconnectOnError = false;
        private Thread heartbeatThread = null;

        private ArrayObject getDsp() {
            return this.dsp;
        }

        private void setDsp(ArrayObject newDsp) {
            this.dsp = newDsp;
        }

        private int getKeepAliveId() {
            return this.keepAliveId;
        }

        private void setKeepAliveId(int newId) {
            this.keepAliveId = newId;
        }

        private boolean isConnected() {
            return this.connected;
        }

        private void setConnected(boolean newFlag) {
            this.connected = newFlag;
        }

        private boolean shouldReconnectOnError() {
            return this.reconnectOnError;
        }

        private void setReconnectOnError(boolean newFlag) {
            this.reconnectOnError = newFlag;
        }

        private Thread getHeartbeatThread() {
            return this.heartbeatThread;
        }

        private void setHeartbeatThread(Thread newThread) {
            this.heartbeatThread = newThread;
        }

        KeepAlive(ArrayObject dsp, int keepAliveId) {
            String METHOD = "Constructor";
            Trace.methodBegin((Object)this, (String)"Constructor");
            this.setDsp(dsp);
            this.setKeepAliveId(keepAliveId);
            Trace.methodEnd((Object)this, (String)"Constructor");
        }

        void startHeartbeat() {
            String METHOD = "startHeartbeat";
            Trace.methodBegin((Object)this, (String)"startHeartbeat");
            this.setConnected(true);
            this.setReconnectOnError(true);
            this.heartbeatThread = new Thread((Runnable)this, this.getDsp() + " KeepAlive " + this.getKeepAliveId());
            this.heartbeatThread.start();
            Trace.methodEnd((Object)this, (String)"startHeartbeat");
        }

        void interruptHeartbeat() {
            String METHOD = "interruptHeartbeat";
            Trace.methodBegin((Object)this, (String)"interruptHeartbeat");
            Thread heartbeatThread = this.getHeartbeatThread();
            if (heartbeatThread != null) {
                Trace.info((Object)this, (String)"interruptHeartbeat", (String)" Interrupting heartbeat thread ");
                heartbeatThread.interrupt();
                this.setHeartbeatThread(null);
            } else {
                Trace.info((Object)this, (String)"interruptHeartbeat", (String)" No heartbeat to interrupt ");
            }
            Trace.methodEnd((Object)this, (String)"interruptHeartbeat");
        }

        public void run() {
            String METHOD = "run";
            Trace.methodBegin((Object)this, (String)"run");
            DevComm devComm = DevComm.getInstance();
            while (this.isConnected()) {
                Trace.warn((Object)this, (String)"run", (String)(" " + this.getDsp() + " Sending keepalive heartbeat"));
                try {
                    BufferedReader junkPage = new BufferedReader(new InputStreamReader(devComm.get(this.getDsp(), KEEPALIVE_FILE)));
                    junkPage.close();
                }
                catch (Exception ex) {
                    Trace.error((Object)this, (String)"run", (String)(" " + this.getDsp() + " Took exception on keepalive heartbeat "));
                    Trace.error((Object)this, (String)"Exception", (Throwable)ex);
                    this.setConnected(false);
                }
                if (!this.isConnected()) continue;
                try {
                    Trace.warn((Object)this, (String)"run", (String)(" " + this.getDsp() + " Refreshing in ... " + 60000 + " ms"));
                    Thread.sleep(60000L);
                }
                catch (InterruptedException iex) {
                    Trace.warn((Object)this, (String)"run", (String)(" " + this.getDsp() + " Keepalive sleep interrupted... "));
                }
            }
            if (this.shouldReconnectOnError()) {
                Trace.error((Object)this, (String)"run", (String)(" " + this.getDsp() + " attempting to log back in"));
                this.getDsp().login();
            } else {
                Trace.error((Object)this, (String)"run", (String)(" " + this.getDsp() + " not attempting to log back in"));
            }
            Trace.methodEnd((Object)this, (String)"run");
        }
    }
}

