/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.dsp.mgmt.se6920;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.dsp.mgmt.se6920.ArrayObject;
import com.sun.netstorage.dsp.mgmt.se6920.Constants;
import com.sun.netstorage.dsp.mgmt.se6920.DevComm;
import com.sun.netstorage.dsp.mgmt.se6920.ModifyBroker;
import com.sun.netstorage.dsp.mgmt.se6920.RequestBroker;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class ArrayInventory
implements Constants {
    private static ArrayList inventory = null;
    private static ArrayInventory instance = null;
    private static boolean initialized = false;

    private ArrayInventory() {
        inventory = new ArrayList();
    }

    public static synchronized ArrayInventory getInstance() {
        if (instance == null) {
            instance = new ArrayInventory();
        }
        return instance;
    }

    public ArrayObject getArrayObject(String hostIP) {
        Iterator invIter = inventory.iterator();
        ArrayObject ret = null;
        while (invIter.hasNext()) {
            ArrayObject tempObj = (ArrayObject)invIter.next();
            if (!tempObj.getHost().equals(hostIP)) continue;
            ret = tempObj;
        }
        return ret;
    }

    public ArrayList getArrayInventory() {
        return inventory;
    }

    public void removeInventoryMember(String hostIP) {
        this.removeInventoryMember(ArrayObject.getInstance(hostIP, "user", "pass"));
    }

    public synchronized void removeInventoryMember(ArrayObject ao) {
    }

    public synchronized void addInventoryMember(ArrayObject ao) {
        if (!inventory.contains(ao)) {
            inventory.add(ao);
            RequestBroker.getInstance().addArray(ao);
            DevComm.getInstance().init(instance.getArrayInventory());
            ModifyBroker.addArray(ao);
        }
    }

    public synchronized void updateInventoryMember(ArrayObject ao) {
    }

    public synchronized void init() {
        String METHOD = "init";
        String DSPPROPFILE = "/opt/se6x20/resources/dsp.properties";
        if (!System.getProperty("os.name").equals("SunOS")) {
            DSPPROPFILE = System.getProperty("DSP_PROPERTIES_FILE");
        }
        String HOSTKEY = "HOST";
        String PORTKEY = "PORT";
        String USERKEY = "USERNAME";
        String PASSKEY = "PASSWORD";
        String PROPHDR = "DSP Properties File";
        String host = "10.10.10.10";
        int port = 80;
        String username = "root";
        String password = "root";
        if (!initialized) {
            try {
                FileInputStream propStream = new FileInputStream(DSPPROPFILE);
                Properties props = new Properties();
                props.load(propStream);
                host = props.getProperty("HOST");
                String portString = props.getProperty("PORT");
                Integer portInteger = new Integer(portString);
                port = portInteger;
                username = props.getProperty("USERNAME");
                password = props.getProperty("PASSWORD");
                Trace.info((Object)this, (String)"init", (String)("Array Inventory host = " + host));
                Trace.info((Object)this, (String)"init", (String)("Array Inventory port = " + port));
                Trace.info((Object)this, (String)"init", (String)("Array Inventory username = " + username));
                Trace.info((Object)this, (String)"init", (String)("Array Inventory password = " + password));
                ArrayInventory.getInstance().addInventoryMember(ArrayObject.getInstance(host, port, username, password));
            }
            catch (Exception ex) {
                Trace.error((Object)this, (String)"Could not create ArrayObject:", (Throwable)ex);
            }
            initialized = true;
        }
    }
}

