/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.dm.util.authorization;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class AuthorizationUtility
implements Runnable {
    private static AuthorizationUtility auth = new AuthorizationUtility();
    private static final String GUEST_OPERATIONS = "GuestOperations.properties";
    private static final String STORAGE_OPERATIONS = "StorageOperations.properties";
    private static final String ADMIN_OPERATIONS = "AdminOperations.properties";
    private static final String USER_ROLES = "/opt/se6x20/resources/user.properties";
    private static final boolean ALWAYS_AUTHORIZE_ROOT = false;
    private static final String CONFIG_FILE_NAME = "/auth.properties";
    private static final String AUTH_CONFIG_FILE_LOCATION = "se6xx0-auth-files-location";
    private static final String DEFAULT_AUTH_CONFIG_FILE_LOCATION = "";
    private static final String USER_ROLE_CONFIG_PROPERTY = "users.properties";
    private Properties configuration = null;
    private String defaultFilesLocation = "";
    private Properties guestOps;
    private Properties storageOps;
    private Properties adminOps;
    private Properties userRoles;
    private Thread updater;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$dm$util$authorization$AuthorizationUtility;

    public static AuthorizationUtility getInstance() {
        return auth;
    }

    private AuthorizationUtility() {
        try {
            this.loadConfigFile();
            this.load();
        }
        catch (IOException e) {
            System.err.println("Authorization: Unable to load initial data.");
            e.printStackTrace();
        }
        this.updater = new Thread(this);
        try {
            this.updater.setDaemon(true);
            this.updater.setName("SUN StorEdge 6xx0 Authorization data loader");
            this.updater.setPriority(1);
        }
        catch (Exception e) {
            System.err.println("Authorization: Unable to modify current thread params.");
            e.printStackTrace();
        }
        this.updater.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfigFile() {
        block6: {
            this.configuration = new Properties();
            this.defaultFilesLocation = System.getProperty(AUTH_CONFIG_FILE_LOCATION, DEFAULT_AUTH_CONFIG_FILE_LOCATION);
            try {
                InputStream stream = (class$com$sun$netstorage$mgmt$dm$util$authorization$AuthorizationUtility == null ? (class$com$sun$netstorage$mgmt$dm$util$authorization$AuthorizationUtility = AuthorizationUtility.class$("com.sun.netstorage.mgmt.dm.util.authorization.AuthorizationUtility")) : class$com$sun$netstorage$mgmt$dm$util$authorization$AuthorizationUtility).getResourceAsStream(this.defaultFilesLocation + CONFIG_FILE_NAME);
                if (null != stream) {
                    try {
                        this.configuration.load(stream);
                        break block6;
                    }
                    finally {
                        stream.close();
                    }
                }
                FileInputStream configFile = new FileInputStream(this.defaultFilesLocation + CONFIG_FILE_NAME);
                this.configuration.load(configFile);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private String getParameter(String paramName, String defaultValue) {
        if (this.configuration != null && this.configuration.getProperty(paramName) != null) {
            return this.configuration.getProperty(paramName);
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        InputStream guestFile = this.getClass().getResourceAsStream(this.getParameter(GUEST_OPERATIONS, GUEST_OPERATIONS));
        InputStream storageFile = this.getClass().getResourceAsStream(this.getParameter(STORAGE_OPERATIONS, STORAGE_OPERATIONS));
        InputStream adminFile = this.getClass().getResourceAsStream(this.getParameter(ADMIN_OPERATIONS, ADMIN_OPERATIONS));
        FileInputStream userFile = new FileInputStream(this.getParameter(USER_ROLE_CONFIG_PROPERTY, USER_ROLES));
        Properties localUserRoles = new Properties();
        localUserRoles.load(userFile);
        Properties localGuestOps = new Properties();
        Properties localStorageOps = new Properties();
        Properties localAdminOps = new Properties();
        localGuestOps.load(guestFile);
        localStorageOps.load(storageFile);
        localAdminOps.load(adminFile);
        AuthorizationUtility authorizationUtility = this;
        synchronized (authorizationUtility) {
            this.userRoles = localUserRoles;
            this.guestOps = localGuestOps;
            this.storageOps = localStorageOps;
            this.adminOps = localAdminOps;
        }
    }

    public void run() {
        long sleepTime = Long.MAX_VALUE;
        while (true) {
            try {
                while (true) {
                    Thread.sleep(sleepTime);
                }
            }
            catch (InterruptedException e) {
                try {
                    this.load();
                    sleepTime = Long.MAX_VALUE;
                    continue;
                }
                catch (IOException e2) {
                    sleepTime = 5000L;
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAuthName(String user, String operation) {
        String role = null;
        boolean ret = false;
        Properties localUserRoles = null;
        Properties localGuestOps = null;
        Properties localStorageOps = null;
        Properties localAdminOps = null;
        if (!System.getProperty("os.name").equals("SunOS")) {
            return true;
        }
        ret = false;
        AuthorizationUtility authorizationUtility = this;
        synchronized (authorizationUtility) {
            localUserRoles = this.userRoles;
            localGuestOps = this.guestOps;
            localStorageOps = this.storageOps;
            localAdminOps = this.adminOps;
        }
        if (localUserRoles == null || localGuestOps == null || localStorageOps == null || localAdminOps == null) {
            try {
                this.load();
            }
            catch (IOException e) {
                System.err.println("Authorization: Unable to reload data.");
                e.printStackTrace();
            }
        }
        if ((role = localUserRoles.getProperty(user)) == null) {
            ret = false;
        } else if (role.toLowerCase().equals("guest")) {
            if (localGuestOps.getProperty(operation) != null) {
                ret = true;
            }
        } else if (role.toLowerCase().equals("storage")) {
            if (localStorageOps.getProperty(operation) != null) {
                ret = true;
            }
        } else if (role.toLowerCase().equals("admin") && localAdminOps.getProperty(operation) != null) {
            ret = true;
        }
        return ret;
    }

    public String getRole(String user) {
        String r = this.userRoles.getProperty(user);
        if (r == null) {
            try {
                this.load();
            }
            catch (IOException e) {
                System.err.println("Authorization: Unable to reload data.");
                e.printStackTrace();
            }
            r = this.userRoles.getProperty(user);
        }
        return r;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

