/*
 * Decompiled with CFR 0.152.
 */
package com.sun.providers.tests.t4;

import com.sun.providers.tests.t4.CIMTesterBase;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;

public class CIMModifyArraySpare
extends CIMTesterBase {
    public String extraArgs() {
        return "<array name> <number of drives> <drive name1> <drive name2..> <add/remove>";
    }

    public static void main(String[] args) {
        try {
            CIMModifyArraySpare test = new CIMModifyArraySpare(args);
        }
        catch (CIMException e) {
            System.err.println("FAILED: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    public CIMModifyArraySpare(String[] args) throws CIMException {
        super(args);
        Enumeration spareSets;
        if (args.length != this.baseArgs() + Integer.parseInt(args[5]) + 3) {
            this.usage();
            System.exit(1);
        }
        String ipAddr = null;
        try {
            ipAddr = InetAddress.getByName(args[4]).getHostAddress();
            System.out.println("DEBUG: hostname " + args[4] + " = " + ipAddr);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        CIMObjectPath cop = new CIMObjectPath("StorEdge_6120StorageConfigurationService");
        System.out.println("DEBUG: Enumerating " + cop);
        Enumeration services = this.client.enumerateInstances(cop, false, false, true);
        CIMInstance conf = null;
        CIMObjectPath init = null;
        while (services.hasMoreElements()) {
            conf = (CIMInstance)services.nextElement();
            if (!conf.getProperty("SystemName").getValue().getValue().toString().equalsIgnoreCase(ipAddr)) continue;
            System.out.println("Found instance of storageConfg! ");
            init = conf.getObjectPath();
            break;
        }
        if (init == null) {
            System.out.println("Failed to find instance of ConfigService!");
            System.exit(1);
        }
        CIMInstance extent = null;
        Vector<String> driveNames = new Vector<String>();
        int numDrives = Integer.parseInt(args[5]);
        for (int i = 0; i < numDrives; ++i) {
            driveNames.add(args[6 + i]);
        }
        String operation = args[6 + numDrives];
        System.out.println("Trying to " + operation + " the array spares...");
        Vector<CIMObjectPath> driveVec = new Vector<CIMObjectPath>();
        cop = new CIMObjectPath("StorEdge_6120StorageExtent");
        Enumeration extents = this.client.enumerateInstances(cop, false, false, true);
        if (extents == null) {
            System.out.println("Could not discover any extents for this creation of a pool.");
        }
        while (extents.hasMoreElements()) {
            extent = (CIMInstance)extents.nextElement();
            String name = extent.getProperty("DeviceID").getValue().getValue().toString();
            System.out.println("Found extent: " + extent.getObjectPath());
            if (!driveNames.contains(name)) continue;
            System.out.println("Found match for StorageExtent: " + name);
            driveVec.add(extent.getObjectPath());
            driveNames.remove(name);
        }
        if (!driveNames.isEmpty()) {
            System.out.println("ERROR: No StorageExtents found to match: " + driveNames.toString());
            System.exit(1);
        }
        if ((spareSets = this.client.enumerateInstances(cop = new CIMObjectPath("StorEdge_6120ArraySparedSet"), false, false, true)) == null) {
            System.out.println("Could not find a spare set to modify!");
            System.exit(1);
        }
        CIMObjectPath spareSet = null;
        if (spareSets.hasMoreElements()) {
            CIMInstance set = (CIMInstance)spareSets.nextElement();
            spareSet = set.getObjectPath();
        }
        CIMArgument[] outArgs = new CIMArgument[]{new CIMArgument("Job", new CIMValue(null)), new CIMArgument("SparedSet", new CIMValue(null))};
        CIMArgument[] inArgs = new CIMArgument[3];
        Vector<String> v = new Vector<String>();
        Enumeration enumeration = driveVec.elements();
        while (enumeration.hasMoreElements()) {
            v.add(enumeration.nextElement().toString());
        }
        inArgs[0] = new CIMArgument("RedundantExtents", new CIMValue(v));
        inArgs[1] = new CIMArgument("SparedSet", new CIMValue((Object)spareSet));
        inArgs[2] = new CIMArgument("JobDescription", new CIMValue((Object)"blah"));
        CIMValue results = null;
        try {
            results = this.client.invokeMethod(init, "CreateOrModifyArraySparedSet", inArgs, outArgs);
        }
        catch (Exception e) {
            System.out.println("DEBUG: Exception caught: \n");
            e.printStackTrace();
            return;
        }
        System.out.println("Completed: Results are: " + results);
    }
}

