/*
 * Decompiled with CFR 0.152.
 */
package com.sun.providers.tests.t4;

import com.sun.providers.tests.t4.CIMTesterBase;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;

public class CIMDeleteStorageVolume
extends CIMTesterBase {
    public String extraArgs() {
        return "<arrayname> <volname>";
    }

    public static void main(String[] args) {
        try {
            CIMDeleteStorageVolume test = new CIMDeleteStorageVolume(args);
        }
        catch (CIMException e) {
            System.err.println("FAILED: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    public CIMDeleteStorageVolume(String[] args) throws CIMException {
        super(args);
        if (args.length != this.baseArgs() + 2) {
            this.usage();
            System.exit(1);
        }
        String ipAddr = null;
        try {
            ipAddr = InetAddress.getByName(args[4]).getHostAddress();
            System.out.println("DEBUG: hostname " + args[4] + " = " + ipAddr);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        CIMObjectPath cop = new CIMObjectPath("SunStorEdge_6120StorageConfigurationService");
        System.out.println("DEBUG: Enumerating " + cop);
        Enumeration services = this.client.enumerateInstances(cop, false, false, true);
        CIMInstance conf = null;
        CIMObjectPath init = null;
        while (services.hasMoreElements()) {
            conf = (CIMInstance)services.nextElement();
            if (conf.getProperty("SystemName").getValue().getValue().toString().equalsIgnoreCase(ipAddr)) {
                System.out.println("DEBUG: Found match for instance of ConfService " + conf.toString());
                init = conf.getObjectPath();
                System.out.println("DEBUG: ObjectPath for instance found is : " + init.toString());
                break;
            }
            System.out.println("DEBUG: ConfService: " + conf.toString() + " does not match");
        }
        CIMObjectPath volCop = new CIMObjectPath("SunStorEdge_6120StorageVolume");
        System.out.println("DEBUG: Enumerating " + volCop);
        Enumeration volumes = this.client.enumerateInstances(volCop, true, false, true);
        while (volumes.hasMoreElements()) {
            CIMInstance volume = (CIMInstance)volumes.nextElement();
            if (volume == null || ipAddr == null) continue;
            System.out.println("DEBUG: Instance " + volume.getObjectPath());
            String volName = args[5];
            CIMProperty prop = volume.getProperty("OtherIdentifyingInfo");
            if (prop == null) {
                System.out.println("OtherIdentifyingInfo is null! " + volume);
                break;
            }
            System.out.println("OtherIdentifyingInfo :" + prop);
            CIMValue volVal = prop.getValue();
            Vector nameVec = (Vector)volVal.getValue();
            String volSliceName = (String)nameVec.firstElement();
            System.out.println("volSlice name : " + volSliceName);
            if (!volSliceName.equalsIgnoreCase(volName)) continue;
            System.out.println("Slice found!  " + volName + " matched\n " + volume.toString());
            CIMArgument[] inArgs = new CIMArgument[1];
            CIMArgument[] outArgs = new CIMArgument[]{new CIMArgument("Job", new CIMValue(null))};
            inArgs[0] = new CIMArgument("TheElement", new CIMValue((Object)volume.getObjectPath()));
            CIMValue results = null;
            try {
                results = this.client.invokeMethod(init, "ReturnToStoragePool", inArgs, outArgs);
            }
            catch (Exception e) {
                System.out.println("DEBUG: Exception caught: \n");
                e.printStackTrace();
                return;
            }
            System.out.println("COMPLETE: Results are: " + results);
            break;
        }
    }
}

