/*
 * Decompiled with CFR 0.152.
 */
package com.sun.providers.tests.t4;

import com.sun.providers.tests.t4.CIMTesterBase;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;

public class CIMCreateVLVStoragePool
extends CIMTesterBase {
    public String extraArgs() {
        return "<array name> <new pool name> <domain>";
    }

    public static void main(String[] args) {
        try {
            CIMCreateVLVStoragePool test = new CIMCreateVLVStoragePool(args);
        }
        catch (CIMException e) {
            System.err.println("FAILED: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    public CIMCreateVLVStoragePool(String[] args) throws CIMException {
        super(args);
        CIMInstance setting;
        if (args.length != this.baseArgs() + 3) {
            this.usage();
            System.exit(1);
        }
        String ipAddr = null;
        try {
            ipAddr = InetAddress.getByName(args[4]).getHostAddress();
            System.out.println("DEBUG: hostname " + args[4] + " = " + ipAddr);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        CIMObjectPath cop = new CIMObjectPath("SunStorEdge_DSPStorageConfigurationService");
        System.out.println("DEBUG: Enumerating " + cop);
        String scsName = args[6] + "VolumeCreationService";
        Enumeration services = this.client.enumerateInstances(cop, false, false, true);
        CIMInstance conf = null;
        CIMObjectPath init = null;
        while (services.hasMoreElements()) {
            conf = (CIMInstance)services.nextElement();
            if (!conf.getProperty("Name").getValue().getValue().toString().equalsIgnoreCase(scsName)) continue;
            System.out.println("Found instance of storageConf service");
            init = conf.getObjectPath();
            break;
        }
        CIMObjectPath oursetting = null;
        Object storSet = null;
        String name = args[5];
        Vector fruVec = new Vector();
        boolean numDrives = false;
        cop = new CIMObjectPath("SunStorEdge_StorageSettingWithHints");
        System.out.println("DEBUG: Getting CIM Class " + cop);
        CIMClass proto = this.client.getClass(cop, false, true, false, null);
        if (proto == null) {
            System.err.println("FAILED: Unable to get class");
            System.exit(1);
        }
        if ((setting = proto.newInstance()) == null) {
            System.err.println("FAILED: No instance from class");
            System.exit(1);
        }
        String spinRedunMin = "0";
        String spinRedunMax = "0";
        String dataRedunMin = "1";
        String dataRedunMax = "1";
        Boolean noSingle = new Boolean("false");
        setting.setProperty("NoSinglePointOfFailure", new CIMValue((Object)noSingle));
        setting.setProperty("DataRedundancyMin", new CIMValue((Object)dataRedunMin));
        setting.setProperty("DataRedundancyMax", new CIMValue((Object)dataRedunMax));
        setting.setProperty("PackageRedundancyMin", new CIMValue((Object)spinRedunMin));
        setting.setProperty("PackageRedundancyMax", new CIMValue((Object)spinRedunMax));
        setting.setProperty("ProductVersion", new CIMValue((Object)new String("3.0")));
        setting.setProperty("ElementName", new CIMValue((Object)new String("mjcVLVProfile")));
        setting.setProperty("InstanceID", new CIMValue((Object)new String("VLVProfile" + args[4])));
        setting.setProperty("VirtualizationStrategy", new CIMValue((Object)new UnsignedInt16(2)));
        setting.setProperty("StripeSize", new CIMValue((Object)new UnsignedInt16(2)));
        setting.setProperty("SegmentSize", new CIMValue((Object)new UnsignedInt16(1)));
        setting.setProperty("NumberOfDisks", new CIMValue((Object)new UnsignedInt16(0)));
        setting.setProperty("SnapshotPoolPercent", new CIMValue((Object)new UnsignedInt16(0)));
        System.out.println("Requesting a new StorageSetting instance: ");
        System.out.println("NoSinglePointOfFailure: " + noSingle);
        System.out.println("DataRedundancyMax: " + dataRedunMax);
        System.out.println("DataRedundancyMin: " + dataRedunMin);
        System.out.println("PackageRedundancyMax: " + spinRedunMax);
        System.out.println("PackageRedundancyMax: " + spinRedunMin);
        try {
            oursetting = this.client.createInstance(new CIMObjectPath("SunStorEdge_StorageSettingWithHints"), setting);
        }
        catch (CIMException ce) {
            System.out.println("Failed to create the StorageSetting instance: " + setting.toString());
            System.exit(1);
        }
        if (oursetting == null) {
            System.err.println("Could not create our instance of StorageSetting!");
            System.exit(1);
        }
        System.out.println("StorageSetting ObjectPath : " + oursetting);
        CIMArgument[] outArgs = new CIMArgument[3];
        Object nullValue = null;
        CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("ElementName", new CIMValue((Object)name)), new CIMArgument("Goal", new CIMValue((Object)oursetting)), new CIMArgument("Pool", null)};
        CIMValue results = null;
        try {
            results = this.client.invokeMethod(init, "CreateOrModifyStoragePool", inArgs, outArgs);
        }
        catch (Exception e) {
            System.out.println("DEBUG: Exception caught: \n");
            e.printStackTrace();
            return;
        }
        System.out.println("Completed: Results are: " + results);
    }
}

