/*
 * Decompiled with CFR 0.152.
 */
package com.sun.providers.tests.t4;

import com.sun.providers.tests.t4.CIMTesterBase;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;

public class CIMCreateStoragePool
extends CIMTesterBase {
    public String extraArgs() {
        return "<array name> <new pool name> <extents> <raid level> <hot spare [dedicated|array|both|neither]>";
    }

    public static void main(String[] args) {
        try {
            CIMCreateStoragePool test = new CIMCreateStoragePool(args);
        }
        catch (CIMException e) {
            System.err.println("FAILED: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    public CIMCreateStoragePool(String[] args) throws CIMException {
        super(args);
        CIMInstance setting;
        if (args.length != this.baseArgs() + 5) {
            this.usage();
            System.exit(1);
        }
        String ipAddr = null;
        try {
            ipAddr = InetAddress.getByName(args[4]).getHostAddress();
            System.out.println("DEBUG: hostname " + args[4] + " = " + ipAddr);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Vector<String> spareStrings = new Vector<String>();
        spareStrings.add("array");
        spareStrings.add("dedicated");
        spareStrings.add("neither");
        spareStrings.add("both");
        if (!spareStrings.contains(args[8].toLowerCase())) {
            System.err.println("Wrong hot spare choice");
            this.usage();
            System.exit(1);
        }
        CIMObjectPath cop = new CIMObjectPath("SunStorEdge_6120StorageConfigurationService");
        System.out.println("DEBUG: Enumerating " + cop);
        Enumeration services = this.client.enumerateInstances(cop, false, false, true);
        CIMInstance conf = null;
        CIMObjectPath init = null;
        while (services.hasMoreElements()) {
            conf = (CIMInstance)services.nextElement();
            if (!conf.getProperty("SystemName").getValue().getValue().toString().equalsIgnoreCase(ipAddr)) continue;
            System.out.println("Found instance of storageConf: " + cop);
            init = conf.getObjectPath();
            break;
        }
        CIMObjectPath oursetting = null;
        Object storSet = null;
        String drives = args[6];
        String name = args[5];
        Vector<String> fruVec = new Vector<String>();
        int numDrives = 0;
        String startDrive = drives.substring(drives.indexOf("u"), drives.indexOf("-"));
        System.out.println("Start Drive: " + startDrive);
        String trayNum = drives.substring(drives.indexOf("u"), drives.indexOf("d"));
        System.out.println("Tray number: " + trayNum);
        int firstDrive = Integer.parseInt(startDrive.substring(startDrive.indexOf("d") + 1));
        System.out.println("First Drive: " + firstDrive);
        int lastDrive = Integer.parseInt(drives.substring(drives.indexOf("-") + 1));
        System.out.println("Last Drive: " + lastDrive);
        for (int i = firstDrive; i <= lastDrive; ++i) {
            if (i < 10) {
                fruVec.add(trayNum + "d0" + i);
            } else {
                fruVec.add(trayNum + "d" + i);
            }
            numDrives += numDrives;
        }
        String[] driveArray = new String[numDrives];
        Vector<CIMObjectPath> driveVec = new Vector<CIMObjectPath>();
        cop = new CIMObjectPath("SunStorEdge_6120StorageExtent");
        Enumeration extents = this.client.enumerateInstances(cop, false, false, true);
        if (extents == null) {
            System.out.println("Could not discover any extents for this creation of a pool.");
        }
        while (extents.hasMoreElements()) {
            CIMInstance it = (CIMInstance)extents.nextElement();
            if (!ipAddr.equals(it.getProperty("SystemName").getValue().getValue().toString()) || !fruVec.contains(it.getProperty("DeviceID").getValue().getValue().toString())) continue;
            System.out.println("StorageExtent added: " + it.getObjectPath());
            driveVec.add(it.getObjectPath());
        }
        cop = new CIMObjectPath("SunStorEdge_6120StorageSetting");
        System.out.println("DEBUG: Getting CIM Class " + cop);
        CIMClass proto = this.client.getClass(cop, false, true, false, null);
        if (proto == null) {
            System.err.println("FAILED: Unable to get class");
            System.exit(1);
        }
        if ((setting = proto.newInstance()) == null) {
            System.err.println("FAILED: No instance from class");
            System.exit(1);
        }
        String packRedunMin = "0";
        String packRedunMax = "0";
        String dataRedunMin = "1";
        String dataRedunMax = "1";
        Boolean noSingle = new Boolean("false");
        if (args[7].equalsIgnoreCase("1")) {
            noSingle = new Boolean("true");
            dataRedunMin = "2";
            dataRedunMax = "2";
            if (args[8].equalsIgnoreCase("array")) {
                packRedunMin = "1";
                packRedunMax = "2";
            } else if (args[8].equalsIgnoreCase("dedicated")) {
                packRedunMin = "2";
                packRedunMax = "2";
            } else if (args[8].equalsIgnoreCase("both")) {
                packRedunMin = "2";
                packRedunMax = "3";
            } else if (args[8].equalsIgnoreCase("neither")) {
                packRedunMin = "1";
                packRedunMax = "1";
            }
        } else if (args[7].equalsIgnoreCase("5")) {
            noSingle = new Boolean("true");
            if (args[8].equalsIgnoreCase("array")) {
                packRedunMin = "1";
                packRedunMax = "2";
            } else if (args[8].equalsIgnoreCase("dedicated")) {
                packRedunMin = "2";
                packRedunMax = "2";
            } else if (args[8].equalsIgnoreCase("both")) {
                packRedunMin = "2";
                packRedunMax = "3";
            } else if (args[8].equalsIgnoreCase("neither")) {
                packRedunMin = "1";
                packRedunMax = "1";
            }
        }
        setting.setProperty("NoSinglePointOfFailure", new CIMValue((Object)noSingle));
        setting.setProperty("DataRedundancyMin", new CIMValue((Object)dataRedunMin));
        setting.setProperty("DataRedundancyMax", new CIMValue((Object)dataRedunMax));
        setting.setProperty("PackageRedundancyMin", new CIMValue((Object)packRedunMin));
        setting.setProperty("PackageRedundancyMax", new CIMValue((Object)packRedunMax));
        System.out.println("Requesting a new StorageSetting instance: ");
        System.out.println("NoSinglePointOfFailure: " + noSingle);
        System.out.println("DataRedundancyMax: " + dataRedunMax);
        System.out.println("DataRedundancyMin: " + dataRedunMin);
        System.out.println("PackageRedundancyMax: " + packRedunMax);
        System.out.println("PackageRedundancyMax: " + packRedunMin);
        try {
            oursetting = this.client.createInstance(new CIMObjectPath("SunStorEdge_6120StorageSetting"), setting);
        }
        catch (CIMException ce) {
            System.out.println("Failed to create the StorageSetting instance: " + setting.toString());
            System.exit(1);
        }
        if (oursetting == null) {
            System.err.println("Could not create our instance of StorageSetting!");
            System.exit(1);
        }
        CIMArgument[] outArgs = new CIMArgument[]{new CIMArgument("Job", new CIMValue(null)), new CIMArgument("Size", new CIMValue(null)), new CIMArgument("Pool")};
        CIMArgument[] inArgs = new CIMArgument[6];
        inArgs[0] = new CIMArgument("InstanceName", new CIMValue((Object)name));
        inArgs[1] = new CIMArgument("Goal", new CIMValue((Object)oursetting));
        inArgs[2] = new CIMArgument("Size", new CIMValue(null));
        inArgs[3] = new CIMArgument("InPools", new CIMValue(null));
        Vector<String> v = new Vector<String>();
        Enumeration enumeration = driveVec.elements();
        while (enumeration.hasMoreElements()) {
            v.add(enumeration.nextElement().toString());
        }
        inArgs[4] = new CIMArgument("InExtents", new CIMValue(v));
        inArgs[5] = new CIMArgument("Pool", new CIMValue(null));
        CIMValue results = null;
        try {
            results = this.client.invokeMethod(init, "CreateOrModifyStoragePool", inArgs, outArgs);
        }
        catch (Exception e) {
            System.out.println("DEBUG: Exception caught: \n");
            e.printStackTrace();
            return;
        }
        System.out.println("Completed: Results are: " + results);
    }
}

