/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.core.data;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.MenuData;
import com.sun.netstorage.mgmt.dm.util.authorization.AuthorizationUtility;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class UserData {
    public static String ADMIN_USER = "admin";
    public static final String STORAGE_USER = "storage";
    public static final String GUEST_USER = "guest";
    public static final String ACCESS_READ_ONLY = "read-only";
    public static final String ACCESS_READ_WRITE = "read-write";
    static UserData _instance = new UserData();
    Hashtable acl = new Hashtable(10);
    Hashtable defaultMenu = new Hashtable(10);

    private UserData() {
        this.initUsers();
    }

    public static UserData getInstance() {
        return _instance;
    }

    private void initUsers() {
        try {
            LinkedHashMap<String, String> adminMenuItems = new LinkedHashMap<String, String>(6);
            adminMenuItems.put(MenuData.STORAGE_MGMT_MENU, ACCESS_READ_ONLY);
            adminMenuItems.put(MenuData.JOBS_MENU, ACCESS_READ_ONLY);
            adminMenuItems.put(MenuData.STORAGE_ACCESS_MENU, ACCESS_READ_ONLY);
            adminMenuItems.put(MenuData.ADMIN_MENU, ACCESS_READ_WRITE);
            this.setUserACL(ADMIN_USER, adminMenuItems, MenuData.ADMIN_MENU);
            LinkedHashMap<String, String> storageMenuItems = new LinkedHashMap<String, String>(6);
            storageMenuItems.put(MenuData.STORAGE_MGMT_MENU, ACCESS_READ_WRITE);
            storageMenuItems.put(MenuData.JOBS_MENU, ACCESS_READ_WRITE);
            storageMenuItems.put(MenuData.STORAGE_ACCESS_MENU, ACCESS_READ_WRITE);
            storageMenuItems.put(MenuData.ADMIN_MENU, ACCESS_READ_ONLY);
            this.setUserACL(STORAGE_USER, storageMenuItems, MenuData.STORAGE_MGMT_MENU);
            LinkedHashMap<String, String> guestMenuItems = new LinkedHashMap<String, String>(6);
            guestMenuItems.put(MenuData.STORAGE_MGMT_MENU, ACCESS_READ_ONLY);
            guestMenuItems.put(MenuData.JOBS_MENU, ACCESS_READ_ONLY);
            guestMenuItems.put(MenuData.STORAGE_ACCESS_MENU, ACCESS_READ_ONLY);
            guestMenuItems.put(MenuData.ADMIN_MENU, ACCESS_READ_ONLY);
            this.setUserACL(GUEST_USER, guestMenuItems, MenuData.STORAGE_MGMT_MENU);
        }
        catch (Throwable t) {
            Trace.verbose((Object)this, (String)"initUserData", (Throwable)t);
        }
    }

    public String getDefaultMenuItem(String argUser) {
        String defMen = this.defaultMenu.get(argUser) == null ? MenuData.STORAGE_MGMT_MENU : (String)this.defaultMenu.get(argUser);
        return defMen;
    }

    public List getVisibleMenus(String argUser) {
        if (argUser == null) {
            return null;
        }
        Map menus = null;
        menus = (Map)this.acl.get(argUser);
        if (menus == null) {
            return null;
        }
        Iterator it = menus.keySet().iterator();
        Vector<String> list = new Vector<String>(10);
        while (it.hasNext()) {
            list.add((String)it.next());
        }
        Trace.verbose((Object)this, (String)"getVisibleMenus", (String)"return menus");
        return list;
    }

    public void initUserData(String argUser) throws IllegalArgumentException, UnauthorizedException {
        Trace.methodBegin((Object)this, (String)"initUserData");
        if (argUser == null || argUser.trim().equals("")) {
            Trace.verbose((Object)this, (String)"initUserData", (String)"Cannot initialize null or empty user.");
            throw new IllegalArgumentException();
        }
        try {
            Trace.verbose((Object)this, (String)"initUserData", (String)"get AuthorizationUtility");
            AuthorizationUtility auth = null;
            try {
                auth = AuthorizationUtility.getInstance();
            }
            catch (Exception e) {
                Trace.verbose((Object)this, (String)"initUserData", (Throwable)e);
                Trace.verbose((Object)this, (String)"initUserData", (String)"FAILED IN AuthorizationUtility CONSTRUCTOR - ATTEMPT TO CONTINUE");
            }
            Trace.verbose((Object)this, (String)"initUserData", (String)("create user ACL for user " + argUser));
            LinkedHashMap userMenuItems = new LinkedHashMap(6);
            this.fillMenu(argUser, MenuData.STORAGE_MGMT_MENU, auth, userMenuItems);
            this.fillMenu(argUser, MenuData.JOBS_MENU, auth, userMenuItems);
            this.fillMenu(argUser, MenuData.ADMIN_MENU, auth, userMenuItems);
            if (userMenuItems.isEmpty()) {
                Trace.verbose((Object)this, (String)"initUserData", (String)"NO ACL FOR USER: user is authorized,  but ACL for this user is empty - NO ACCESS");
                throw new UnauthorizedException("error.login.noaccess");
            }
            String role = null;
            role = this.getUserRole(argUser);
            Trace.verbose((Object)this, (String)"initUserData", (String)("User role is:" + role));
            String defMenu = this.getDefaultMenuForRole(role);
            this.defaultMenu.put(argUser, defMenu);
            this.setUserACL(argUser, userMenuItems, defMenu);
            Trace.verbose((Object)this, (String)"initUserData", (String)"ACL build completed");
        }
        catch (Throwable t) {
            Trace.verbose((Object)this, (String)"initUserData", (String)"ERROR ESTABLISHING USER ACL - ASSUME NO ACCESS");
            Trace.verbose((Object)this, (String)"initUserData", (String)("user not authorized:" + t.toString()));
            throw new UnauthorizedException("error.login.noaccess");
        }
    }

    public String getUserRole(String argUser) {
        String role = null;
        try {
            role = AuthorizationUtility.getInstance().getRole(argUser);
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"getUserRole", (String)"User role not found");
        }
        return role;
    }

    private void fillMenu(String argUser, String menuItem, AuthorizationUtility auth, LinkedHashMap userMenuItems) {
        if (auth.checkAuthName(argUser, menuItem + ".modify")) {
            Trace.verbose((Object)this, (String)"initUserData", (String)"User authorized to modify storage access");
            userMenuItems.put(menuItem, ACCESS_READ_WRITE);
        } else if (auth.checkAuthName(argUser, menuItem + ".read")) {
            Trace.verbose((Object)this, (String)"initUserData", (String)"User authorized to read-only storage access");
            userMenuItems.put(menuItem, ACCESS_READ_ONLY);
        }
    }

    private String getDefaultMenuForRole(String role) {
        if (role == null || role.trim().equals("") || role.trim().equalsIgnoreCase(GUEST_USER)) {
            return MenuData.STORAGE_MGMT_MENU;
        }
        if (role.trim().equalsIgnoreCase(ADMIN_USER)) {
            return MenuData.ADMIN_MENU;
        }
        return MenuData.STORAGE_MGMT_MENU;
    }

    public Iterator getUserMenus(String argUser) {
        if (argUser == null) {
            return null;
        }
        Map menus = null;
        menus = (Map)this.acl.get(argUser);
        if (menus == null) {
            return null;
        }
        Iterator it = menus.keySet().iterator();
        while (it.hasNext()) {
            Trace.verbose((Object)this, (String)"getUserMenus", (String)("UserMenu item:" + it.next()));
        }
        return menus.keySet().iterator();
    }

    public boolean isVisibleMenu(String argMenuItem, String argUser) {
        Trace.methodBegin((Object)this, (String)"isVisibleMenu");
        Trace.verbose((Object)this, (String)"isVisibleMenu", (String)(" MENU ITEM:" + argMenuItem + "<"));
        if (argMenuItem == null || argUser == null) {
            Trace.verbose((Object)this, (String)"isVisibleMenu", (String)("one argument is null; Menu Item:" + argMenuItem + "< User:" + argUser + "<"));
            return false;
        }
        Map menu = (Map)this.acl.get(argUser);
        if (menu == null) {
            Trace.verbose((Object)this, (String)"isVisibleMenu", (String)"Map for user not found - item not visible");
            return false;
        }
        if (menu.containsKey(argMenuItem)) {
            Trace.verbose((Object)this, (String)"isVisibleMenu", (String)"menu item found in the map - it is visible");
            return true;
        }
        Trace.verbose((Object)this, (String)"isVisibleMenu", (String)"menu item NOT found in the map - it is NOT visible");
        return false;
    }

    public void setUserACL(String argUser, Map argMenuItems, String argDefaultMenuItem) throws IllegalArgumentException {
        if (argUser == null || argMenuItems == null || argDefaultMenuItem == null) {
            Trace.verbose((Object)this, (String)"One of the arguments for user access control list is null", (Throwable)new IllegalArgumentException());
            throw new IllegalArgumentException();
        }
        if (!argMenuItems.containsKey(argDefaultMenuItem)) {
            Trace.verbose((Object)this, (String)"setUserACL", (String)("###########User ACL:" + argMenuItems + " Default item is:" + argDefaultMenuItem));
            Trace.verbose((Object)this, (String)"Default menu item for user  is not included in the list of visible menu items", (Throwable)new IllegalArgumentException());
            throw new IllegalArgumentException();
        }
        this.acl.put(argUser, argMenuItems);
        this.defaultMenu.put(argUser, argDefaultMenuItem);
    }

    public boolean isReadOnly(String argUser, String argMenuItem) throws IllegalArgumentException {
        if (argUser == null || argMenuItem == null) {
            Trace.verbose((Object)this, (String)"isReadOnly", (String)("UserID:" + argUser + " MenuItem:" + argMenuItem));
            throw new IllegalArgumentException();
        }
        Map menus = (Map)this.acl.get(argUser);
        if (menus == null) {
            return true;
        }
        String access = (String)menus.get(argMenuItem);
        if (access == null) {
            return true;
        }
        return !access.equals(ACCESS_READ_WRITE);
    }

    public boolean allowMultipleSessions(String argUser) {
        Trace.methodBegin((Object)this, (String)"allowMultipleSessions");
        if (argUser == null) {
            throw new IllegalArgumentException();
        }
        Trace.verbose((Object)this, (String)"allowMultipleSessions", (String)("ACL:" + this.acl + "for user:" + argUser));
        boolean allowMS = false;
        try {
            String role = this.getUserRole(argUser);
            if (role != null && role.trim().equalsIgnoreCase(GUEST_USER)) {
                allowMS = true;
            }
        }
        catch (Exception re) {
            Trace.verbose((Object)this, (String)"initUserData", (String)"ERROR GETTING ROLE FROM AuthorizationUtility");
            Trace.verbose((Object)this, (String)"initUserData", (String)" - ASSUME EXCLUSIVE ACCESS");
        }
        return allowMS;
    }
}

