/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.initial;

import com.sun.netstorage.array.mgmt.cfg.initial.Ping;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class SetInitialConfig {
    private static Logger logger = Logger.getLogger((Class)(class$com$sun$netstorage$array$mgmt$cfg$initial$SetInitialConfig == null ? (class$com$sun$netstorage$array$mgmt$cfg$initial$SetInitialConfig = SetInitialConfig.class$("com.sun.netstorage.array.mgmt.cfg.initial.SetInitialConfig")) : class$com$sun$netstorage$array$mgmt$cfg$initial$SetInitialConfig));
    private static ResourceBundle messages;
    private InetAddress testHost = null;
    private String id = null;
    private String networkSetting = null;
    private InetAddress address = null;
    private InetAddress firewallAddress = null;
    private InetAddress spAddress = null;
    private InetAddress gateway = null;
    private String mask = null;
    private InetAddress nameServer = null;
    private String domainName = null;
    private String yes;
    private String no;
    private BufferedReader reader;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$initial$SetInitialConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            logger.debug((Object)"entering main");
            SetInitialConfig me = new SetInitialConfig();
            me.setInitialConfig();
        }
        catch (Throwable x) {
            logger.error((Object)x.getMessage(), x);
            System.err.println(x.getMessage());
        }
        finally {
            logger.debug((Object)"exiting main");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SetInitialConfig() {
        try {
            logger.debug((Object)"entering SetInitialConfig constructor");
            if (messages == null) {
                System.out.println("No messages resource bundle found.Exiting");
                System.exit(10);
            }
            this.yes = messages.getString("YES");
            this.no = messages.getString("NO");
            InputStreamReader isr = new InputStreamReader(System.in);
            this.reader = new BufferedReader(isr);
        }
        catch (Throwable x) {
            logger.error((Object)x.getMessage(), x);
            System.err.println(x.getMessage());
            System.exit(10);
        }
        finally {
            logger.debug((Object)"exiting SetInitialConfig constructor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printHeader(String header) {
        try {
            int i;
            logger.debug((Object)"entering printHeader");
            int length = header.length() + 4;
            System.out.println();
            for (i = 0; i < length; ++i) {
                System.out.print("*");
            }
            System.out.println();
            System.out.print("* ");
            System.out.print(header);
            System.out.println(" *");
            for (i = 0; i < length; ++i) {
                System.out.print("*");
            }
            System.out.println();
        }
        finally {
            logger.debug((Object)"exiting printHeader");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printSubHeader(String header) {
        try {
            logger.debug((Object)"entering printSubHeader");
            int length = header.length() + 4;
            System.out.println();
            System.out.print("* ");
            System.out.print(header + "\n");
            for (int i = 0; i < length; ++i) {
                System.out.print("-");
            }
            System.out.println();
        }
        finally {
            logger.debug((Object)"exiting printHeader");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResponse(Object defaultValue) {
        try {
            logger.debug((Object)"Entering readResponse");
            if (null != defaultValue) {
                if (this.useDefault(defaultValue)) {
                    if (defaultValue instanceof InetAddress) {
                        String string = ((InetAddress)defaultValue).getHostAddress();
                        return string;
                    }
                    String string = defaultValue.toString();
                    return string;
                }
                System.out.print(messages.getString("NEW_VALUE"));
            }
            System.out.print(" ");
            System.out.flush();
            String string = this.reader.readLine();
            return string;
        }
        catch (Throwable x) {
            logger.error((Object)x.getMessage(), x);
            String string = "";
            return string;
        }
        finally {
            logger.debug((Object)"Exiting readResponse");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean useDefault(Object defaultValue) {
        try {
            logger.debug((Object)"entering useDefault");
            MessageFormat format = new MessageFormat(messages.getString("USE"));
            String prompt = format.format(new Object[]{defaultValue});
            System.out.println();
            System.out.print(prompt);
            String response = this.readResponse(null);
            boolean bl = this.yes.equalsIgnoreCase(response);
            return bl;
        }
        finally {
            logger.debug((Object)"exiting useDefault");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testNetwork() {
        boolean result;
        block11: {
            logger.debug((Object)"entering testNetwork");
            result = false;
            try {
                String line = null;
                while (this.reader.ready()) {
                    line = this.reader.readLine();
                }
                this.printSubHeader(messages.getString("TEST_HOST_HEADER"));
                while (true) {
                    System.out.println();
                    System.out.print(messages.getString("TEST_HOST_PROMPT"));
                    String s = this.readResponse(this.testHost);
                    try {
                        this.testHost = InetAddress.getByName(s);
                    }
                    catch (Throwable x) {
                        this.testHost = null;
                    }
                    if (null == this.testHost) {
                        System.out.println();
                        System.out.println(messages.getString("INVALID_VALUE"));
                        continue;
                    }
                    System.out.println();
                    System.out.println(messages.getString("TEST_HOST_WARNING"));
                    if (this.ping(this.testHost)) {
                        System.out.println();
                        this.printParameter("TEST_HOST_SUCCESS", this.testHost.getHostAddress());
                        result = true;
                        break block11;
                    }
                    System.out.println();
                    this.printParameter("TEST_HOST_FAILURE", this.testHost.getHostAddress());
                    s = this.readResponse(null);
                    if (!this.yes.equalsIgnoreCase(s)) break;
                }
                result = false;
            }
            catch (Throwable x) {
                result = false;
            }
            finally {
                logger.debug((Object)"exiting testNetwork");
            }
        }
        return result;
    }

    private void restoreConfig() {
        logger.debug((Object)"entering restoreConfig");
        this.printSubHeader(messages.getString("RESTORE_HEADER"));
        System.out.println();
        System.out.println(messages.getString("RESTORE_WARNING"));
        System.out.println();
        System.out.println(messages.getString("PRESS_ENTER"));
        this.readResponse(null);
        this.printParameter("RUNNING_STEP_OUT_OF_ONE", messages.getString("ONE"));
        System.out.println(" " + messages.getString("RESTORE_HEADER"));
        boolean ok = this.executeCommand("/opt/SUNWfbru/fbr -r");
        if (!ok) {
            this.printParameter("FAILURE", messages.getString("RESTORE_OPERATION_RESULT"));
            this.continueOnError();
        } else {
            this.printParameter("SUCCESS", messages.getString("RESTORE_OPERATION_RESULT"));
        }
        logger.debug((Object)"exiting restoreConfig");
    }

    private boolean initialConfig() {
        try {
            logger.debug((Object)"entering initialConfig");
            this.printSubHeader(messages.getString("INITIAL_CONFIG_HEADER"));
            System.out.println(messages.getString("INITIAL_CONFIG_WARNING"));
            String fixed = messages.getString("FIXED");
            boolean done = false;
            while (!done) {
                done = this.inputStorageId();
            }
            done = false;
            while (!done) {
                System.out.println();
                System.out.println(messages.getString("DHCP_OR_FIXED"));
                System.out.println();
                System.out.println(messages.getString("DHCP_PROMPT"));
                System.out.println(messages.getString("FIXED_PROMPT"));
                try {
                    String response = this.readResponse(null);
                    if (response.equalsIgnoreCase(messages.getString("ONE"))) {
                        this.networkSetting = "DHCP";
                        done = true;
                        continue;
                    }
                    if (response.equalsIgnoreCase(messages.getString("TWO"))) {
                        this.networkSetting = fixed;
                        done = true;
                        continue;
                    }
                    throw new Exception("invalid value");
                }
                catch (Throwable x) {
                    System.out.println();
                    System.out.println(messages.getString("INVALID_VALUE"));
                }
            }
            if (fixed.equalsIgnoreCase(this.networkSetting)) {
                done = false;
                while (!done) {
                    System.out.println();
                    System.out.println(messages.getString("IP_ADDRESS_PROMPT"));
                    try {
                        this.address = InetAddress.getByName(this.readResponse(this.address));
                        done = true;
                    }
                    catch (Throwable x) {
                        System.out.println();
                        System.out.println(messages.getString("INVALID_VALUE"));
                    }
                }
                done = false;
                while (!done) {
                    System.out.println();
                    System.out.println(messages.getString("GATEWAY_PROMPT"));
                    try {
                        this.gateway = InetAddress.getByName(this.readResponse(this.gateway));
                        done = true;
                    }
                    catch (Throwable x) {
                        System.out.println();
                        System.out.println(messages.getString("INVALID_VALUE"));
                    }
                }
                done = false;
                while (!done) {
                    System.out.println();
                    System.out.println(messages.getString("MASK_PROMPT"));
                    try {
                        this.mask = this.readResponse(this.mask);
                        if (this.validateMask(this.mask)) {
                            done = true;
                            continue;
                        }
                        throw new Exception("invalid valid");
                    }
                    catch (Throwable x) {
                        System.out.println();
                        System.out.println(messages.getString("INVALID_VALUE"));
                    }
                }
                done = false;
                while (!done) {
                    System.out.println();
                    System.out.println(messages.getString("NAME_SERVER_PROMPT"));
                    try {
                        this.nameServer = InetAddress.getByName(this.readResponse(this.nameServer));
                        done = true;
                    }
                    catch (Throwable x) {
                        System.out.println();
                        System.out.println(messages.getString("INVALID_VALUE"));
                    }
                }
                done = false;
                while (!done) {
                    System.out.println();
                    System.out.println(messages.getString("DOMAIN_NAME_PROMPT"));
                    try {
                        this.domainName = this.readResponse(null);
                        done = true;
                    }
                    catch (Throwable x) {
                        System.out.println();
                        System.out.println(messages.getString("INVALID_VALUE"));
                    }
                }
            }
            this.printSubHeader(messages.getString("SYSTEM_SETTINGS"));
            this.printParameter("DISPLAY_ID", this.id);
            System.out.println();
            this.printSubHeader(messages.getString("NETWORK_SETTINGS"));
            this.printParameter("DISPLAY_NETWORK_SETTING", this.networkSetting);
            System.out.println();
            if (fixed.equals(this.networkSetting)) {
                this.printParameter("DISPLAY_ADDRESS", this.address.getHostAddress());
                System.out.println();
                this.printParameter("DISPLAY_GATEWAY", this.gateway.getHostAddress());
                System.out.println();
                this.printParameter("DISPLAY_MASK", this.mask);
                System.out.println();
                this.printParameter("DISPLAY_NAME_SERVER", this.nameServer.getHostAddress());
                System.out.println();
                this.printParameter("DISPLAY_DOMAIN_NAME", this.domainName);
                System.out.println();
            }
            while (true) {
                System.out.println();
                System.out.println(messages.getString("CONFIRM_SETTINGS_PROMPT"));
                String s = this.readResponse(null);
                if (this.yes.equalsIgnoreCase(s)) {
                    boolean bl = true;
                    return bl;
                }
                if (this.no.equalsIgnoreCase(s)) {
                    boolean bl = false;
                    return bl;
                }
                System.out.println();
                System.out.println(messages.getString("INVALID_VALUE"));
            }
        }
        finally {
            logger.debug((Object)"exiting initialConfig");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean inputStorageId() {
        boolean result;
        block16: {
            logger.debug((Object)"entering inputStorageId");
            result = false;
            int currentId = this.getCurrentId();
            String currentIdString = currentId >= 0 ? "" + currentId : messages.getString("UNCONFIGURED");
            System.out.println();
            if (currentId >= 0 && currentId <= 7) {
                this.printParameter("STOREDGE_ID_EXCLUDE", currentIdString);
            } else {
                System.out.println(messages.getString("STOREDGE_ID"));
            }
            this.id = this.readResponse(this.id);
            try {
                int n = Integer.parseInt(this.id);
                if (n != currentId && n >= 0 && n <= 7) {
                    String s = "sp" + n;
                    String fw = s + "-firewall";
                    try {
                        this.spAddress = InetAddress.getByName(s);
                        this.firewallAddress = InetAddress.getByName(fw);
                    }
                    catch (Throwable x) {
                        this.spAddress = null;
                        this.firewallAddress = null;
                    }
                    if (null == this.spAddress || null == this.firewallAddress) {
                        System.out.println();
                        System.out.println(messages.getString("INVALID_VALUE"));
                    } else {
                        boolean firewallOK;
                        boolean spOK = !this.ping(this.spAddress);
                        boolean bl = firewallOK = !this.ping(this.firewallAddress);
                        if (spOK && firewallOK) {
                            result = true;
                        } else {
                            String hostnameError = spOK ? this.firewallAddress.getHostAddress() : this.spAddress.getHostAddress();
                            System.out.println();
                            this.printParameter("HOSTNAME_IN_USE", hostnameError);
                        }
                    }
                    break block16;
                }
                if (n == currentId) {
                    System.out.println();
                    System.out.println(messages.getString("STOREDGE_ID_ALREADY_SET"));
                } else {
                    System.out.println();
                    System.out.println(messages.getString("INVALID_VALUE"));
                }
            }
            catch (Throwable x) {
                System.out.println();
                System.out.println(messages.getString("INVALID_VALUE"));
            }
            finally {
                logger.debug((Object)"exiting inputStorageId");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printParameter(String message, Object parameter) {
        try {
            logger.debug((Object)"entering printParameter");
            message = messages.getString(message);
            MessageFormat format = new MessageFormat(message);
            System.out.print(format.format(new Object[]{parameter}));
        }
        finally {
            logger.debug((Object)"exiting printParameter");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateMask(String s) {
        try {
            logger.debug((Object)"entering validateMask");
            StringTokenizer tokenizer = new StringTokenizer(s, ".");
            if (4 != tokenizer.countTokens()) {
                boolean bl = false;
                return bl;
            }
            for (int i = 0; i < 4; ++i) {
                int n;
                s = tokenizer.nextToken();
                try {
                    n = Integer.parseInt(s);
                }
                catch (Throwable x) {
                    boolean bl = false;
                    logger.debug((Object)"exiting validateMask");
                    return bl;
                }
                if (n >= 0 && n <= 255) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            logger.debug((Object)"exiting validateMask");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConfig() {
        block16: {
            try {
                logger.debug((Object)"entering setConfig");
                String response = "";
                this.printSubHeader(messages.getString("SET_CONFIG_HEADER"));
                System.out.println();
                System.out.println(messages.getString("PRESS_ENTER"));
                this.readResponse(null);
                try {
                    System.out.println();
                    this.printParameter("RUNNING_STEP_OUT_OF_SIX", messages.getString("ONE"));
                    System.out.println(messages.getString("FIREWALL_CONFIG_SCRIPT"));
                    boolean ok = this.runFirewallScript();
                    if (!ok) {
                        this.printParameter("FAILURE", messages.getString("FIREWALL_CONFIG_SCRIPT_RESULT"));
                        this.continueOnError();
                    } else {
                        this.printParameter("SUCCESS", messages.getString("FIREWALL_CONFIG_SCRIPT_RESULT"));
                    }
                    System.out.println();
                    this.printParameter("RUNNING_STEP_OUT_OF_SIX", messages.getString("TWO"));
                    System.out.println(messages.getString("IFCONFIG"));
                    ok = this.runIfconfig();
                    if (!ok) {
                        this.printParameter("FAILURE", messages.getString("IFCONFIG"));
                        this.continueOnError();
                    } else {
                        this.printParameter("SUCCESS", messages.getString("IFCONFIG"));
                    }
                    System.out.println();
                    this.printParameter("RUNNING_STEP_OUT_OF_SIX", messages.getString("THREE"));
                    System.out.println(messages.getString("ROUTE"));
                    ok = this.runRoute();
                    if (!ok) {
                        this.printParameter("FAILURE", messages.getString("ROUTE"));
                        this.continueOnError();
                    } else {
                        this.printParameter("SUCCESS", messages.getString("ROUTE"));
                    }
                    System.out.println();
                    this.printParameter("RUNNING_STEP_OUT_OF_SIX", messages.getString("FOUR"));
                    System.out.println(messages.getString("DEFAULT_ROUTER"));
                    ok = this.updateDefaultRouter();
                    if (!ok) {
                        this.printParameter("FAILURE", messages.getString("DEFAULT_ROUTER"));
                        this.continueOnError();
                    } else {
                        this.printParameter("SUCCESS", messages.getString("DEFAULT_ROUTER"));
                    }
                    System.out.println();
                    this.printParameter("RUNNING_STEP_OUT_OF_SIX", messages.getString("FIVE"));
                    System.out.println(messages.getString("PERSIST_HOSTNAME"));
                    ok = this.persistHostname();
                    if (!ok) {
                        this.printParameter("FAILURE", messages.getString("PERSIST_HOSTNAME"));
                        this.continueOnError();
                    } else {
                        this.printParameter("SUCCESS", messages.getString("PERSIST_HOSTNAME"));
                    }
                    System.out.println();
                    this.printParameter("RUNNING_STEP_OUT_OF_SIX", messages.getString("SIX"));
                    System.out.println(messages.getString("RESOLV"));
                    ok = this.updateResolvFile();
                    if (!ok) {
                        this.printParameter("FAILURE", messages.getString("RESOLV"));
                        this.continueOnError();
                        break block16;
                    }
                    this.printParameter("SUCCESS", messages.getString("RESOLV"));
                }
                catch (Throwable x) {
                    logger.debug((Object)(" Exception: " + x.getMessage()));
                    System.out.println(messages.getString("SYSTEM_ERROR"));
                    System.out.println("Exception:" + x);
                    System.exit(-1);
                }
            }
            finally {
                logger.debug((Object)"exiting setConfig");
            }
        }
    }

    private void continueOnError() {
        System.out.println("");
        System.out.println(messages.getString("CONTINUE_ON_ERROR"));
        String response = this.readResponse(null);
        if (!this.yes.equalsIgnoreCase(response)) {
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unconfig() {
        try {
            logger.debug((Object)"entering unconfig");
            this.printSubHeader(messages.getString("UNCONFIG_HEADER"));
            System.out.println();
            System.out.println(messages.getString("PRESS_ENTER"));
            this.readResponse(null);
            int currentId = this.getCurrentId();
            String currentIdString = currentId >= 0 ? "" + currentId : messages.getString("UNCONFIGURED");
            try {
                String s = "new_sp";
                String fw = "new_firewall";
                this.spAddress = InetAddress.getByName(s);
                this.firewallAddress = InetAddress.getByName(fw);
            }
            catch (Throwable x) {
                logger.debug((Object)(" Exception: " + x.getMessage()));
                this.spAddress = null;
                this.firewallAddress = null;
            }
            if (this.spAddress != null && this.firewallAddress != null) {
                System.out.println();
                this.printParameter("RUNNING_STEP_OUT_OF_THREE", messages.getString("ONE"));
                this.printParameter("RUNNING", messages.getString("IFCONFIG"));
                boolean ok = this.runIfconfig();
                if (!ok) {
                    this.printParameter("FAILURE", messages.getString("IFCONFIG"));
                    System.out.println();
                } else {
                    this.printParameter("SUCCESS", messages.getString("IFCONFIG"));
                    System.out.println();
                }
                System.out.println();
                this.printParameter("RUNNING_STEP_OUT_OF_THREE", messages.getString("TWO"));
                this.printParameter("RUNNING", messages.getString("ROUTE"));
                ok = this.runRoute();
                if (!ok) {
                    this.printParameter("FAILURE", messages.getString("ROUTE"));
                } else {
                    this.printParameter("SUCCESS", messages.getString("ROUTE"));
                }
                System.out.println();
                this.printParameter("RUNNING_STEP_OUT_OF_THREE", messages.getString("THREE"));
                this.printParameter("RUNNING", messages.getString("PERSIST_HOSTNAME"));
                ok = this.persistHostname();
                if (!ok) {
                    this.printParameter("FAILURE", messages.getString("PERSIST_HOSTNAME"));
                } else {
                    this.printParameter("SUCCESS", messages.getString("PERSIST_HOSTNAME"));
                }
            } else {
                this.printParameter("FAILURE", messages.getString("UNCONFIG_HEADER"));
            }
        }
        finally {
            logger.debug((Object)"exiting unconfig");
        }
    }

    private void setInitialConfig() {
        try {
            logger.debug((Object)"entering setInitialConfig");
            boolean i = false;
            while (true) {
                this.printHeader(messages.getString("HEADER"));
                boolean done = false;
                String response = null;
                while (!done) {
                    System.out.println();
                    System.out.println(messages.getString("RESTORE_INIT_OR_UNCONFIG"));
                    System.out.println();
                    System.out.println(messages.getString("INITIAL_PROMPT"));
                    System.out.println(messages.getString("RESTORE_PROMPT"));
                    System.out.println(messages.getString("UNCONFIG_PROMPT"));
                    String initial = messages.getString("INITIAL");
                    String restore = messages.getString("RESTORE");
                    String unconfigure = messages.getString("UNCONFIGURE");
                    response = this.readResponse(null);
                    if (response.equalsIgnoreCase(messages.getString("ONE"))) {
                        done = true;
                        continue;
                    }
                    if (response.equalsIgnoreCase(messages.getString("TWO"))) {
                        done = true;
                        continue;
                    }
                    if (response.equalsIgnoreCase(messages.getString("THREE"))) {
                        done = true;
                        continue;
                    }
                    System.out.println();
                    System.out.println(messages.getString("INVALID_VALUE"));
                }
                if (response.equalsIgnoreCase(messages.getString("ONE"))) {
                    done = false;
                    while (!done) {
                        done = this.initialConfig();
                    }
                    this.setConfig();
                } else if (response.equalsIgnoreCase(messages.getString("TWO"))) {
                    this.restoreConfig();
                } else if (response.equalsIgnoreCase(messages.getString("THREE"))) {
                    this.unconfig();
                    return;
                }
                if (this.testNetwork()) {
                    System.out.println("\n");
                    this.printParameter("SUCCESS", "SetInitialConfig");
                    System.out.println();
                    return;
                }
                System.out.println("");
                this.printParameter("FAILURE", "SetInitialConfig");
                System.out.println();
                System.out.println(messages.getString("TRY_AGAIN"));
                response = this.readResponse(null);
                if (this.yes.equalsIgnoreCase(response)) continue;
                return;
            }
        }
        finally {
            logger.debug((Object)"exiting setInitialConfig");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ping(InetAddress host) {
        try {
            logger.debug((Object)"entering ping");
            Ping pinger = new Ping(host);
            if (-1L == pinger.ping()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            logger.debug((Object)"exiting ping");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getParameter(String key, String defaultValue) {
        try {
            logger.debug((Object)"entering getParameter");
            String result = defaultValue;
            try {
                messages.getString(key);
            }
            catch (Throwable x) {
                logger.debug((Object)(" Exception: " + x.getMessage()));
            }
            String string = System.getProperty(key, result);
            return string;
        }
        finally {
            logger.debug((Object)"exiting getParameter");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentId() {
        logger.debug((Object)"entering getCurrentId");
        int result = -1;
        try {
            BufferedReader fileReader;
            String line;
            File nodenameFile = new File("/etc/nodename");
            if (nodenameFile.exists() && (line = (fileReader = new BufferedReader(new FileReader(nodenameFile))).readLine()) != null && line.trim().length() != 0 && line.startsWith("sp")) {
                result = new Integer(line.trim().substring(2));
            }
        }
        catch (Throwable x) {
            logger.debug((Object)(" Exception: " + x.getMessage()));
        }
        finally {
            logger.debug((Object)"exiting getCurrentId");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runFirewallScript() {
        logger.debug((Object)"entering runFirewallScript");
        boolean result = false;
        try {
            StringBuffer cmd = new StringBuffer("/opt/se6x20/bin/configure_FW -d ");
            if ("0".equals(this.id)) {
                cmd.append(" --dhcp_server en --dhcp_dns_server " + this.nameServer.getHostAddress());
            } else {
                cmd.append(" --dhcp_server dis");
            }
            cmd.append(" --lan_ip_addr " + this.firewallAddress.getHostAddress() + " --port_fwd_addr " + this.spAddress.getHostAddress());
            if (this.networkSetting.equals(messages.getString("FIXED"))) {
                cmd.append(" --wan_ip_addr " + this.address.getHostAddress() + " --wan_gateway " + this.gateway.getHostAddress() + " --wan_subnet_mask " + this.mask + " --wan_addr_type static");
            } else if (this.networkSetting.equalsIgnoreCase("DHCP")) {
                cmd.append(" --wan_addr_type dynamic");
            }
            result = this.executeCommand(cmd.toString());
        }
        catch (Throwable x) {
            logger.debug((Object)(" Exception: " + x.getMessage()));
        }
        finally {
            logger.debug((Object)"exiting runFirewallScript");
        }
        return result;
    }

    private boolean runIfconfig() {
        logger.debug((Object)"entering runIfconfig");
        boolean result = false;
        String cmd = null;
        cmd = this.mask != null ? "ifconfig dmfe0 set " + this.spAddress.getHostAddress() + " netmask " + this.mask : "ifconfig dmfe0 set " + this.spAddress.getHostAddress() + " netmask 255.255.255.0";
        result = this.executeCommand(cmd);
        logger.debug((Object)"exiting runIfconfig");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean runRoute() {
        boolean result;
        block13: {
            BufferedReader processOutput;
            block12: {
                logger.debug((Object)"entering runRoute");
                result = false;
                processOutput = null;
                Process process = Runtime.getRuntime().exec("netstat -r ");
                process.waitFor();
                processOutput = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                line = null;
                while ((line = processOutput.readLine()) != null) {
                    StringTokenizer tokenizer = new StringTokenizer(line, " \t");
                    String defaultRoute = null;
                    if (tokenizer.hasMoreTokens() && "default".equals(tokenizer.nextToken().trim()) && tokenizer.hasMoreTokens()) {
                        defaultRoute = tokenizer.nextToken();
                    }
                    if (defaultRoute == null) continue;
                    this.executeCommand("route delete default " + defaultRoute);
                }
                result = this.executeCommand("route add default " + this.firewallAddress.getHostAddress());
                Object var8_8 = null;
                if (processOutput == null) break block12;
                try {
                    processOutput.close();
                }
                catch (Throwable x2) {
                    // empty catch block
                }
            }
            logger.debug((Object)"exiting runRoute");
            {
                break block13;
                catch (Throwable x) {
                    logger.debug((Object)(" Exception: " + x.getMessage()));
                    Object var8_9 = null;
                    if (processOutput != null) {
                        try {
                            processOutput.close();
                        }
                        catch (Throwable x2) {
                            // empty catch block
                        }
                    }
                    logger.debug((Object)"exiting runRoute");
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (processOutput != null) {
                    try {
                        processOutput.close();
                    }
                    catch (Throwable x2) {
                        // empty catch block
                    }
                }
                logger.debug((Object)"exiting runRoute");
                throw throwable;
            }
        }
        return result;
    }

    private boolean persistHostname() {
        logger.debug((Object)"entering persistHostname");
        boolean result = false;
        result = this.updateEtcFiles("nodename") && this.updateEtcFiles("hostname.dmfe0") && this.updateHostsFiles() && this.updateDumpadm() && this.executeCommand("hostname " + this.spAddress.getHostName());
        logger.debug((Object)"exiting persistHostname");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateDumpadm() {
        logger.debug((Object)"entering updateDumpadm");
        boolean result = false;
        try {
            File varCrashHostnameDir = new File("/var/crash/" + this.spAddress.getHostName());
            if (!varCrashHostnameDir.exists()) {
                varCrashHostnameDir.mkdir();
                System.out.println(" directory created ");
            }
            result = this.executeCommand("dumpadm -s /var/crash/" + this.spAddress.getHostName());
        }
        catch (Throwable x) {
            logger.debug((Object)(" Exception: " + x.getMessage()));
        }
        finally {
            logger.debug((Object)"exiting updateDumpadm");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeCommand(String cmd) {
        logger.debug((Object)"entering executeCommand");
        boolean result = false;
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            int retCode = process.waitFor();
            if (retCode == 0) {
                result = true;
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable x) {
            logger.debug((Object)(" Exception: " + x.getMessage()));
        }
        finally {
            logger.debug((Object)"exiting executeCommand");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean updateEtcFiles(String fileName) {
        boolean result;
        block15: {
            File tmpFile;
            OutputStreamWriter fr;
            block13: {
                logger.debug((Object)"entering updateEtcFiles");
                result = true;
                fr = null;
                tmpFile = null;
                File resultFile = new File("/etc/" + fileName);
                tmpFile = new File("/etc/." + fileName);
                String content = this.spAddress.getHostName() + "\n";
                fr = new FileWriter(tmpFile);
                fr.write(content);
                fr.flush();
                fr.close();
                result = tmpFile.renameTo(resultFile);
                Object var8_8 = null;
                if (fr == null) break block13;
                try {
                    fr.close();
                }
                catch (Throwable x2) {
                    // empty catch block
                }
            }
            if (tmpFile != null && tmpFile.exists()) {
                tmpFile.delete();
            }
            break block15;
            {
                catch (Throwable x) {
                    logger.debug((Object)(" Exception: " + x.getMessage()));
                    result = false;
                    Object var8_9 = null;
                    if (fr != null) {
                        try {
                            fr.close();
                        }
                        catch (Throwable x2) {
                            // empty catch block
                        }
                    }
                    if (tmpFile != null && tmpFile.exists()) {
                        tmpFile.delete();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (Throwable x2) {
                        // empty catch block
                    }
                }
                if (tmpFile != null && tmpFile.exists()) {
                    tmpFile.delete();
                }
                throw throwable;
            }
        }
        logger.debug((Object)"exiting updateEtcFiles");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean updateHostsFiles() {
        logger.debug((Object)"entering updateHostsFiles");
        boolean result = true;
        FileWriter fw = null;
        BufferedReader fr = null;
        File tmpFile = null;
        File fileNetDir = new File("/etc/net");
        if (fileNetDir.exists()) {
            File[] fileList = fileNetDir.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                Throwable x2222;
                Object var12_12;
                block17: {
                    block16: {
                        File hostsFile = null;
                        hostsFile = new File(fileList[i].getAbsolutePath() + "/hosts");
                        if (!hostsFile.exists()) break block16;
                        fr = new BufferedReader(new FileReader(hostsFile));
                        String line = null;
                        tmpFile = new File(fileList[i].getAbsolutePath() + "/.hosts");
                        fw = new FileWriter(tmpFile);
                        while ((line = fr.readLine()) != null) {
                            if (line.startsWith("#")) {
                                fw.write(line + "\n");
                            } else {
                                String content = this.spAddress.getHostName() + "\t" + this.spAddress.getHostName() + "\n";
                                fw.write(content);
                            }
                            fw.flush();
                        }
                        fr.close();
                        fw.close();
                        result = tmpFile.renameTo(hostsFile);
                    }
                    var12_12 = null;
                    if (fw == null) break block17;
                    try {
                        fr.close();
                    }
                    catch (Throwable x2222) {
                        // empty catch block
                    }
                }
                if (tmpFile == null || !tmpFile.exists()) continue;
                tmpFile.delete();
                {
                    continue;
                    catch (Throwable x3) {
                        logger.debug((Object)(" Exception: " + x3.getMessage()));
                        result = false;
                        var12_12 = null;
                        if (fw != null) {
                            try {
                                fr.close();
                            }
                            catch (Throwable x2222) {
                                // empty catch block
                            }
                        }
                        if (tmpFile == null || !tmpFile.exists()) continue;
                        tmpFile.delete();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var12_12 = null;
                    if (fw != null) {
                        try {
                            fr.close();
                        }
                        catch (Throwable x2222) {
                            // empty catch block
                        }
                    }
                    if (tmpFile != null && tmpFile.exists()) {
                        tmpFile.delete();
                    }
                    throw throwable;
                }
            }
        }
        logger.debug((Object)("exiting updateHostsFiles with " + result));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private synchronized boolean updateDefaultRouter() {
        boolean result;
        block15: {
            File tmpFile;
            OutputStreamWriter fr;
            block13: {
                logger.debug((Object)"entering updateDefaultRouter");
                result = false;
                fr = null;
                tmpFile = null;
                File resolvFile = new File("/etc/defaultrouter");
                tmpFile = new File("/etc/.defaultrouter");
                String content = this.firewallAddress.getHostAddress() + "\n";
                fr = new FileWriter(tmpFile);
                fr.write(content);
                fr.flush();
                fr.close();
                result = tmpFile.renameTo(resolvFile);
                Object var7_7 = null;
                if (fr == null) break block13;
                try {
                    fr.close();
                }
                catch (Throwable x2) {
                    // empty catch block
                }
            }
            if (tmpFile != null && tmpFile.exists()) {
                tmpFile.delete();
            }
            break block15;
            {
                catch (Throwable x) {
                    logger.debug((Object)(" Exception: " + x.getMessage()));
                    Object var7_8 = null;
                    if (fr != null) {
                        try {
                            fr.close();
                        }
                        catch (Throwable x2) {
                            // empty catch block
                        }
                    }
                    if (tmpFile != null && tmpFile.exists()) {
                        tmpFile.delete();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (Throwable x2) {
                        // empty catch block
                    }
                }
                if (tmpFile != null && tmpFile.exists()) {
                    tmpFile.delete();
                }
                throw throwable;
            }
        }
        logger.debug((Object)"exiting updateDefaultRouter");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private synchronized boolean updateResolvFile() {
        boolean result;
        block15: {
            File tmpFile;
            OutputStreamWriter fr;
            block13: {
                logger.debug((Object)"entering updateResolvFile");
                result = false;
                fr = null;
                tmpFile = null;
                File resolvFile = new File("/etc/resolv.conf");
                tmpFile = new File("/etc/.resolv.conf");
                String content = null;
                content = this.domainName != null ? "nameserver " + this.nameServer.getHostAddress() + "\n" + "domain " + this.domainName + "\n" : "nameserver " + this.nameServer.getHostAddress() + "\n";
                fr = new FileWriter(tmpFile);
                fr.write(content);
                fr.flush();
                fr.close();
                result = tmpFile.renameTo(resolvFile);
                Object var7_7 = null;
                if (fr == null) break block13;
                try {
                    fr.close();
                }
                catch (Throwable x2) {
                    // empty catch block
                }
            }
            if (tmpFile != null && tmpFile.exists()) {
                tmpFile.delete();
            }
            break block15;
            {
                catch (Throwable x) {
                    logger.debug((Object)(" Exception: " + x.getMessage()));
                    Object var7_8 = null;
                    if (fr != null) {
                        try {
                            fr.close();
                        }
                        catch (Throwable x2) {
                            // empty catch block
                        }
                    }
                    if (tmpFile != null && tmpFile.exists()) {
                        tmpFile.delete();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (Throwable x2) {
                        // empty catch block
                    }
                }
                if (tmpFile != null && tmpFile.exists()) {
                    tmpFile.delete();
                }
                throw throwable;
            }
        }
        logger.debug((Object)"exiting updateResolvFile");
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            messages = ResourceBundle.getBundle("com.sun.netstorage.array.mgmt.cfg.initial.messages");
        }
        catch (Throwable x) {
            logger.fatal((Object)x.getMessage(), x);
            System.exit(10);
        }
    }
}

