/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.server.validator.date;

import com.sun.netstorage.array.mgmt.cfg.cli.server.ValidationException;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractDateParser {
    private Pattern compiledPattern;

    public final Calendar parseDate(String dateString) throws ValidationException {
        return this.parseDate(dateString, TimeZone.getDefault(), Locale.getDefault());
    }

    public final Calendar parseDate(String dateString, TimeZone timeZone, Locale locale) throws ValidationException {
        return this.parseDate(dateString, Calendar.getInstance(timeZone, locale));
    }

    public final Calendar parseDate(String dateString, Calendar calendar) throws ValidationException {
        Matcher matcher = this.getCompiledPattern().matcher(dateString);
        calendar.setLenient(false);
        if (matcher.matches()) {
            try {
                calendar = this.buildCalendar(calendar, matcher);
            }
            catch (Exception e) {
                throw new ValidationException("error.validation.invalidDateFormat");
            }
        } else {
            throw new ValidationException("error.validation.invalidDateFormat");
        }
        try {
            calendar.getTime();
        }
        catch (Exception e) {
            throw new ValidationException(null, "error.validation.invalidDateFormat");
        }
        return calendar;
    }

    protected abstract Calendar buildCalendar(Calendar var1, Matcher var2) throws Exception;

    protected abstract String getDatePattern();

    private Pattern getCompiledPattern() {
        if (this.compiledPattern == null) {
            this.compiledPattern = Pattern.compile(this.getDatePattern());
        }
        return this.compiledPattern;
    }
}

