/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.server.specification;

import com.sun.netstorage.array.mgmt.cfg.cli.server.ConfigurationException;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Resource;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Specification;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Specified;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ValidationException;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Validator;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ValidatorFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class ResourceSpec
implements Specification {
    private String resourceType;
    private String valueType;
    private String needsToHaveValue;
    private String displayName;
    private boolean listValueAllowed;
    private List allowedValues = new ArrayList();
    private ValidatorFactory validatorFactory = ValidatorFactory.getInstance();

    public void satisfiedBy(Specified argument) throws ValidationException, ConfigurationException {
        if (argument == null) {
            throw new ValidationException("error.validation.illegalResourceValue");
        }
        Resource resource = (Resource)argument;
        List values = resource.getValues();
        if ("always".equals(this.needsToHaveValue) && !this.haveValues(values)) {
            throw new ValidationException("error.validation.missingResourceValue");
        }
        if ("never".equals(this.needsToHaveValue) && this.haveValues(values)) {
            throw new ValidationException("error.validation.resourceValueNotAllowed");
        }
        if (!this.isListValueAllowed() && values.size() > 1) {
            StringBuffer valueList = this.valueListAsString(values);
            throw new ValidationException(valueList.toString(), "error.validation.resourceListValuesNotAllowed");
        }
        for (int i = 0; i < values.size(); ++i) {
            if (this.allowedValues != null && !this.allowedValues.isEmpty()) {
                this.checkEnumeratedValue(resource);
                continue;
            }
            if (this.getValueType() == null) continue;
            Validator validator = this.validatorFactory.getValidatorForTargetType(this.getValueType());
            validator.validate((String)values.get(i));
        }
    }

    private StringBuffer valueListAsString(List values) {
        StringBuffer valueList = new StringBuffer();
        valueList.append(values.get(0));
        for (int i = 1; i < values.size(); ++i) {
            valueList.append(",").append(values.get(i));
        }
        return valueList;
    }

    private boolean haveValues(List values) {
        return values != null && !values.isEmpty();
    }

    private void checkEnumeratedValue(Resource resource) throws ValidationException {
        if (resource.getValues() == null || resource.getValues().isEmpty()) {
            throw new ValidationException("error.validation.missingResourceValue");
        }
        if (resource.getValues().size() > 1) {
            throw new ValidationException("error.validation.resourceListValuesNotAllowed");
        }
        String value = (String)resource.getValues().get(0);
        if (!this.allowedValues.contains(value)) {
            throw new ValidationException(value, "error.validation.illegalResourceValue");
        }
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String type) {
        this.valueType = type;
    }

    public List getAllowedValues() {
        return this.allowedValues;
    }

    public boolean isListValueAllowed() {
        return this.listValueAllowed;
    }

    public String getNeedsToHaveValue() {
        return this.needsToHaveValue;
    }

    public void setAllowedValues(List allowedValues) {
        this.allowedValues = allowedValues;
    }

    public void addAllowedValue(String value) {
        this.allowedValues.add(value);
    }

    public void setListValueAllowed(boolean listAllowed) {
        this.listValueAllowed = listAllowed;
    }

    public void setNeedsToHaveValue(String needsToHaveValue) {
        this.needsToHaveValue = needsToHaveValue;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n\t\tResourceSpec");
        sb.append("\n\t\t\tResource Type = " + this.resourceType);
        sb.append("\n\t\t\tNeeds to have value = " + this.needsToHaveValue);
        if (!"never".equals(this.needsToHaveValue)) {
            sb.append("\n\t\t\tValue Type = " + this.valueType);
            if (this.displayName == null) {
                sb.append("\n\t\t\tDisplay Name = " + this.valueType);
            } else {
                sb.append("\n\t\t\tDisplay Name = " + this.displayName);
            }
            sb.append("\n\t\t\tList value allowed = " + this.listValueAllowed);
            if (this.getAllowedValues() != null && !this.getAllowedValues().isEmpty()) {
                sb.append("\n\t\t\tAllowed values");
                for (int i = 0; i < this.getAllowedValues().size(); ++i) {
                    sb.append("\n\t\t\t\t").append(this.getAllowedValues().get(i));
                }
            }
        }
        return sb.toString();
    }

    public String usage(Locale locale) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.resourceType);
        if ("never".equals(this.needsToHaveValue)) {
            return sb.toString();
        }
        if ("always".equals(this.needsToHaveValue)) {
            sb.append(" <");
        } else {
            sb.append(" ").append("[");
        }
        if (this.allowedValues != null && !this.allowedValues.isEmpty()) {
            int count = this.allowedValues.size();
            for (int i = 0; i < count - 1; ++i) {
                sb.append(this.allowedValues.get(i)).append("|");
            }
            sb.append(this.allowedValues.get(count - 1));
        } else if (this.listValueAllowed) {
            sb.append(this.displayName() + "[," + this.displayName() + "...]");
        } else {
            sb.append(this.displayName());
        }
        if ("always".equals(this.needsToHaveValue)) {
            sb.append(">");
        } else {
            sb.append("]");
        }
        return sb.toString();
    }

    private String displayName() {
        ResourceBundle rb = ResourceBundle.getBundle("com.sun.netstorage.array.mgmt.cfg.cli.ini.CLIResource");
        if (this.displayName == null || "".equals(this.displayName)) {
            return this.valueType;
        }
        return rb.getString(this.displayName);
    }
}

