/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.server.specification;

import com.sun.netstorage.array.mgmt.cfg.cli.server.ConfigurationException;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ValidationException;
import com.sun.netstorage.array.mgmt.cfg.cli.server.specification.CommandOptionSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class OptionListSpec {
    private String listName;
    private String processorClassPath;
    private String preprocessorClassPath;
    private List optionSpecs = new ArrayList();
    private HashMap specMapByLongName = new HashMap();
    private HashMap specMapByShortName = new HashMap();
    private List specsForRequiredOptions = new ArrayList();
    private List specsForOptionalOptions = new ArrayList();

    public OptionListSpec(String listName) throws Exception {
        this.listName = listName;
    }

    public void addOptionSpec(CommandOptionSpec spec) {
        if (null != spec) {
            this.optionSpecs.add(spec);
            this.specMapByLongName.put(spec.getLongName(), spec);
            this.specMapByShortName.put(spec.getShortName(), spec);
            if (spec.isRequired()) {
                this.specsForRequiredOptions.add(spec);
            } else {
                this.specsForOptionalOptions.add(spec);
            }
        }
    }

    public String validateOptions(List options) throws ValidationException, ConfigurationException {
        String result = null;
        if (!options.isEmpty() && this.specMapByLongName.isEmpty()) {
            throw new ValidationException(this.mergeOptionList(options), "error.validation.unknownOption");
        }
        ArrayList remainingRequiredOptionSpecs = new ArrayList(this.specsForRequiredOptions);
        for (int i = 0; i < options.size(); ++i) {
            Option o = (Option)options.get(i);
            String name = o.getName();
            CommandOptionSpec spec = (CommandOptionSpec)this.specMapByLongName.get(name);
            if (spec == null) {
                spec = (CommandOptionSpec)this.specMapByShortName.get(name);
            }
            if (spec == null) {
                throw new ValidationException(name, "error.validation.unknownOption");
            }
            spec.satisfiedBy(o);
            remainingRequiredOptionSpecs.remove(spec);
        }
        if (remainingRequiredOptionSpecs.size() > 0) {
            throw new ValidationException(this.buildMissingOptionsString(remainingRequiredOptionSpecs), "error.validation.requiredOptionMissing");
        }
        result = this.listName;
        return result;
    }

    private String mergeOptionList(List options) {
        StringBuffer sb = new StringBuffer();
        sb.append(((Option)options.get(0)).getName());
        for (int i = 1; i < options.size(); ++i) {
            sb.append(", ").append(((Option)options.get(i)).getName());
        }
        return sb.toString();
    }

    private String buildMissingOptionsString(List missing) {
        if (missing == null || missing.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (missing.size() >= 1) {
            sb.append(((CommandOptionSpec)missing.get(0)).getShortName());
        }
        for (int i = 1; i < missing.size(); ++i) {
            CommandOptionSpec spec = (CommandOptionSpec)missing.get(i);
            sb.append(", ").append(spec.getShortName());
        }
        return sb.toString();
    }

    public void usage(Locale locale, StringBuffer sb) {
        if (!this.optionSpecs.isEmpty()) {
            sb.append(" ");
            for (int i = 0; i < this.optionSpecs.size(); ++i) {
                sb.append(((CommandOptionSpec)this.optionSpecs.get(i)).usage(locale));
            }
        }
    }

    public String getProcessorClassPath() {
        return this.processorClassPath;
    }

    public void setProcessorClassPath(String aClassPath) {
        this.processorClassPath = aClassPath;
    }

    public String getPreprocessorClassPath() {
        return this.preprocessorClassPath;
    }

    public void setPreprocessorClassPath(String aClassPath) {
        this.preprocessorClassPath = aClassPath;
    }
}

