/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.server.specification;

import com.sun.netstorage.array.mgmt.cfg.cli.server.ConfigurationException;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Specification;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Specified;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ValidationException;
import com.sun.netstorage.array.mgmt.cfg.cli.server.specification.OptionListSpec;
import com.sun.netstorage.array.mgmt.cfg.cli.server.specification.ResourceSpec;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class CommandSpec
implements Specification {
    private String commandName;
    private ResourceSpec resourceSpec;
    private List optionListSpecs = new ArrayList();
    private String commandProcessor;
    private String commandPreprocessor;

    public void satisfiedBy(Specified specified) throws ValidationException, ConfigurationException {
        ParsedCommandLine command = (ParsedCommandLine)specified;
        List optionsToValidate = command.getOptions();
        if (command == null) {
            throw new ValidationException("error.validation.nullCommand");
        }
        String processorClassPath = this.commandProcessor;
        String preprocessorClassPath = this.commandPreprocessor;
        if (this.optionListSpecs != null && !this.optionListSpecs.isEmpty()) {
            if (optionsToValidate == null) {
                throw new ValidationException("error.validation.requiredOptionMissing");
            }
            String validListName = null;
            int n = this.optionListSpecs.size();
            for (int i = 0; i < n; ++i) {
                OptionListSpec ol;
                block11: {
                    ol = (OptionListSpec)this.optionListSpecs.get(i);
                    try {
                        validListName = ol.validateOptions(optionsToValidate);
                    }
                    catch (ValidationException ve) {
                        if (this.optionListSpecs.size() != 1) break block11;
                        throw ve;
                    }
                }
                if (null == validListName) continue;
                preprocessorClassPath = ol.getPreprocessorClassPath();
                processorClassPath = ol.getProcessorClassPath();
                break;
            }
            if (null == validListName) {
                throw new ValidationException("error.validation.invalidOptions");
            }
            command.setOptionListName(validListName);
        } else if (null != optionsToValidate && !optionsToValidate.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            sb.append(((Option)optionsToValidate.get(0)).getName());
            int n = optionsToValidate.size();
            for (int k = 1; k < n; ++k) {
                sb.append(", ").append(((Option)optionsToValidate.get(k)).getName());
            }
            throw new ValidationException(sb.toString(), "error.validation.unknownOption");
        }
        if (this.resourceSpec != null) {
            this.resourceSpec.satisfiedBy(command.getResource());
        }
        command.setPreprocessorClassPath(this.commandPreprocessor);
        command.setProcessorClassPath(processorClassPath);
    }

    public String usage(Locale locale, boolean showOptions) {
        StringWriter writer = new StringWriter();
        if (this.optionListSpecs.isEmpty()) {
            showOptions = false;
        }
        if (showOptions) {
            int n = this.optionListSpecs.size();
            for (int i = 0; i < n; ++i) {
                writer.write(this.commandName);
                writer.write(" ");
                OptionListSpec ol = (OptionListSpec)this.optionListSpecs.get(i);
                ol.usage(locale, writer.getBuffer());
                if (this.resourceSpec != null) {
                    writer.write(" ");
                    writer.write(this.getResourceSpec().usage(locale));
                }
                writer.write(System.getProperty("line.separator"));
            }
        } else {
            writer.write(this.commandName);
            writer.write(" ");
            if (this.resourceSpec != null) {
                writer.write(" ");
                writer.write(this.getResourceSpec().usage(locale));
            }
        }
        return writer.toString();
    }

    public String getCommandName() {
        return this.commandName;
    }

    public ResourceSpec getResourceSpec() {
        return this.resourceSpec;
    }

    public void setCommandName(String commandName) {
        this.commandName = commandName;
    }

    public void setResourceSpec(ResourceSpec resourceSpec) {
        this.resourceSpec = resourceSpec;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nCommandSpec");
        sb.append("\n\tCommand name = " + this.commandName);
        sb.append("\n\tResource" + this.resourceSpec);
        return sb.toString();
    }

    public String getCommandProcessor() {
        return this.commandProcessor;
    }

    public void setCommandProcessor(String commandProcessor) {
        this.commandProcessor = commandProcessor;
    }

    public boolean hasPreprocessor() {
        return this.commandPreprocessor != null;
    }

    public String getCommandPreprocessor() {
        return this.commandPreprocessor;
    }

    public void setCommandPreprocessor(String commandPreprocessor) {
        this.commandPreprocessor = commandPreprocessor;
    }

    public void addOptionListSpec(OptionListSpec aOptionList) {
        this.optionListSpecs.add(aOptionList);
    }
}

