/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.server.specification;

import com.sun.netstorage.array.mgmt.cfg.bui.utilities.Validate;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ConfigurationException;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Specification;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Specified;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ValidationException;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Validator;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ValidatorFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class CommandOptionSpec
implements Specification {
    private boolean required;
    private boolean listAllowed;
    private String shortName;
    private String longName;
    private String valueType;
    private List allowedValues = new ArrayList();
    private String needsToHaveValue;
    private String displayName;
    private ValidatorFactory validatorFactory = ValidatorFactory.getInstance();

    public void satisfiedBy(Specified specified) throws ValidationException, ConfigurationException {
        Option option = (Option)specified;
        List values = option.getValues();
        if (!"never".equals(this.needsToHaveValue)) {
            if ("always".equals(this.needsToHaveValue) && (values == null || values.isEmpty())) {
                throw new ValidationException(this.getShortName(), "error.validation.missingOptionValue");
            }
            if (!this.isListAllowed() && values.size() > 1) {
                throw new ValidationException(this.getShortName(), "error.validation.optionListValuesNotAllowed");
            }
            for (int i = 0; i < values.size(); ++i) {
                if (this.allowedValues != null && !this.allowedValues.isEmpty()) {
                    this.checkEnumeratedValue(option);
                    continue;
                }
                if (this.getValueType() == null) continue;
                Validator validator = this.validatorFactory.getValidatorForTargetType(this.getValueType());
                validator.validate((String)values.get(i));
            }
        } else if (values != null && !values.isEmpty()) {
            throw new ValidationException(this.getShortName(), "error.validation.optionValueNotAllowed");
        }
    }

    private void checkEnumeratedValue(Option option) throws ValidationException {
        if (option.getValues() == null || option.getValues().isEmpty()) {
            throw new ValidationException(this.getShortName(), "error.validation.missingOptionValue");
        }
        if (option.getValues().size() > 1) {
            throw new ValidationException(this.getShortName(), "error.validation.optionListValuesNotAllowed");
        }
        String value = (String)option.getValues().get(0);
        for (int i = 0; i < this.allowedValues.size(); ++i) {
            int max;
            String[] rangeValues;
            int min;
            String allowedValue = (String)this.allowedValues.get(i);
            if (!(allowedValue.matches("\\d+\\.\\.\\d+") ? Validate.numberInRange(value, min = Integer.parseInt((rangeValues = allowedValue.split("\\.\\."))[0]), max = Integer.parseInt(rangeValues[1])) : allowedValue.equals(value))) continue;
            return;
        }
        throw new ValidationException(value, "error.validation.illegalOptionValue");
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getLongName() {
        return this.longName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setRequired(boolean isRequired) {
        this.required = isRequired;
    }

    public void setLongName(String longName) {
        this.longName = longName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public List getAllowedValues() {
        return this.allowedValues;
    }

    public void setAllowedValues(List allowedValues) {
        this.allowedValues = allowedValues;
    }

    public void addAllowedValue(String value) {
        this.allowedValues.add(value);
    }

    public boolean isListAllowed() {
        return this.listAllowed;
    }

    public void setListAllowed(boolean isListAllowed) {
        this.listAllowed = isListAllowed;
    }

    public String getNeedsToHaveValue() {
        return this.needsToHaveValue;
    }

    public void setNeedsToHaveValue(String needsToHaveValue) {
        this.needsToHaveValue = needsToHaveValue;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n\t\tCommandOptionSpec");
        sb.append("\n\t\t\tLong name = " + this.longName);
        sb.append("\n\t\t\tShort name = " + this.shortName);
        sb.append("\n\t\t\tNeeds to have value = " + this.needsToHaveValue);
        if (!"never".equals(this.needsToHaveValue)) {
            sb.append("\n\t\t\tType = " + this.valueType);
            sb.append("\n\t\t\tList value allowed = " + this.listAllowed);
            if (this.getAllowedValues() != null && !this.getAllowedValues().isEmpty()) {
                sb.append("\n\t\t\tAllowed values");
                for (int i = 0; i < this.getAllowedValues().size(); ++i) {
                    sb.append("\n\t\t\t\t").append(this.getAllowedValues().get(i));
                }
            }
        }
        return sb.toString();
    }

    public String usage(Locale locale) {
        StringBuffer sb = new StringBuffer();
        if (!this.required) {
            sb.append("[");
        }
        sb.append(this.getShortName());
        sb.append("|");
        sb.append(this.getLongName());
        if ("always".equals(this.needsToHaveValue)) {
            sb.append(" <");
        } else if ("sometimes".equals(this.needsToHaveValue)) {
            sb.append(" [");
        }
        if (this.allowedValues != null && !this.allowedValues.isEmpty()) {
            int count = this.allowedValues.size();
            for (int i = 0; i < count - 1; ++i) {
                sb.append(this.allowedValues.get(i)).append("|");
            }
            sb.append(this.allowedValues.get(count - 1));
        } else if (this.listAllowed) {
            sb.append(this.displayName() + "[," + this.displayName() + "...]");
        } else {
            sb.append(this.displayName());
        }
        if ("always".equals(this.needsToHaveValue)) {
            sb.append(">");
        } else if ("sometimes".equals(this.needsToHaveValue)) {
            sb.append("]");
        }
        if (!this.required) {
            sb.append("]");
        }
        sb.append(" ");
        return sb.toString();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    private String displayName() {
        ResourceBundle rb = ResourceBundle.getBundle("com.sun.netstorage.array.mgmt.cfg.cli.ini.CLIResource");
        if (this.displayName == null || "".equals(this.displayName)) {
            return this.valueType;
        }
        return rb.getString(this.displayName);
    }
}

