/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.server.preprocessor;

import com.sun.netstorage.array.mgmt.cfg.admin.business.ArrayRegistration;
import com.sun.netstorage.array.mgmt.cfg.admin.business.ManageArrayRegistrationsFactory;
import com.sun.netstorage.array.mgmt.cfg.admin.business.ManageArrayRegistrationsInterface;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.cli.server.preprocessor.CommandPreprocessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.server.specification.CommandSpec;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.ActiveUserInfo;
import com.sun.netstorage.array.mgmt.cfg.util.IPUtil;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpSession;
import org.apache.soap.rpc.SOAPContext;

public class InteractivePasswordRequestor
extends CommandPreprocessorBase {
    public boolean preprocess(SOAPContext context, CommandResult result, boolean userInputPhase, CommandSpec spec, ParsedCommandLine pcl, Locale locale, String userInput) throws Exception {
        HttpSession session = this.getHttpSession(context);
        Repository rep = Repository.getRepository();
        ActiveUserInfo aui = (ActiveUserInfo)((Object)rep.getProperty((Object)session.getId()));
        if ("guest".equals(aui.role) && "list".equals(pcl.getCommandName())) {
            return true;
        }
        String arrayName = this.getArrayName(pcl);
        if (arrayName == null) {
            return true;
        }
        if (!this.isTranscientPasswordNeeded(context, arrayName)) {
            return true;
        }
        if (userInputPhase) {
            session.removeAttribute("cli.interactive.spec");
            session.removeAttribute("cli.interactive.pcl");
            session.removeAttribute("user.input.phase");
            this.setTranscientPassword(context, userInput, arrayName);
            return true;
        }
        session.setAttribute("cli.interactive.spec", (Object)spec);
        session.setAttribute("cli.interactive.pcl", (Object)pcl);
        session.setAttribute("user.input.phase", (Object)"user.input.phase");
        ResourceBundle rb = ResourceBundle.getBundle("com.sun.netstorage.array.mgmt.cfg.cli.ini.CLIResource", locale);
        result.setResult(rb.getString("login.EnterPassword"));
        result.setErrorId("888");
        return false;
    }

    private String getLocalizedArrayHealthStatus(Locale locale, String healthCode) {
        ResourceBundle rb = ResourceBundle.getBundle("com.sun.netstorage.array.mgmt.cfg.cli.ini.CLIResource", locale);
        String localized = rb.getString("t4.status.unknown");
        try {
            localized = rb.getString("t4.status." + healthCode);
        }
        catch (Exception e) {
            // empty catch block
        }
        return localized;
    }

    protected boolean isTranscientPasswordNeeded(SOAPContext soapContext, String arrayName) throws Exception {
        String methodName = "isTranscientPasswordNeeded";
        ConfigContext context = this.getConfigContext(soapContext);
        boolean result = false;
        ArrayRegistration arrayReg = null;
        String ipAddr = IPUtil.lookUpIP((String)arrayName);
        Trace.verbose((Object)this, (String)"isTranscientPasswordNeeded", (String)("IP address for given name = " + ipAddr));
        try {
            ManageArrayRegistrationsInterface regManager = ManageArrayRegistrationsFactory.getManager();
            arrayReg = regManager.getArrayRegByIP(context, ipAddr);
        }
        catch (ConfigMgmtException e) {
            if ("CIM_ERR_ACCESS_DENIED".equals(e.getEmbededException().getMessage())) {
                throw e;
            }
            throw new SEItemNotFoundException(arrayName);
        }
        Trace.verbose((Object)this, (String)"isTranscientPasswordNeeded", (String)("Found corresponding array registration: " + arrayReg.toString()));
        if (arrayReg.getHealthStatus() == 6) {
            Trace.verbose((Object)this, (String)"isTranscientPasswordNeeded", (String)"Account status is error, need password");
            result = true;
        }
        Trace.verbose((Object)this, (String)"isTranscientPasswordNeeded", (String)("Is transient password needed? = " + result));
        return result;
    }

    protected void setTranscientPassword(SOAPContext soapContext, String password, String arrayName) throws Exception {
        String methodName = "setTranscientPassword";
        ConfigContext context = this.getConfigContext(soapContext);
        ArrayRegistration arrayReg = null;
        String ipAddr = IPUtil.lookUpIP((String)arrayName);
        Trace.verbose((Object)this, (String)"setTranscientPassword", (String)("IP address for given name = " + ipAddr));
        ManageArrayRegistrationsInterface regManager = ManageArrayRegistrationsFactory.getManager();
        arrayReg.setPassword(password);
        regManager.save(context, arrayReg);
        regManager.reload(arrayReg);
        if (arrayReg.getHealthStatus() != 2) {
            throw new UnauthorizedException("registeredarray.invalidPassword");
        }
    }

    protected String getArrayName(ParsedCommandLine pcl) {
        List options = pcl.getOptions();
        String arrayName = null;
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            String optionName = option.getName();
            if ("-i".equals(optionName) || "--ipaddress".equals(optionName)) {
                arrayName = option.getFirstValue();
            }
            if ("-a".equals(optionName) || "--array".equals(optionName)) {
                arrayName = option.getFirstValue();
                break;
            }
            if (!"-S".equals(optionName) && !"--sdomain".equals(optionName)) continue;
            arrayName = option.getFirstValue();
            break;
        }
        return arrayName;
    }
}

