/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.server.parser;

import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandParser;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandSpecRepository;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Configuration;
import com.sun.netstorage.array.mgmt.cfg.cli.server.MalformedCommandException;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Resource;
import com.sun.netstorage.array.mgmt.cfg.cli.server.parser.SpecialCaseFilter;
import com.sun.netstorage.array.mgmt.cfg.util.ClassLoaderUtils;
import com.sun.netstorage.array.mgmt.cfg.util.XMLUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class CommandLineParser
implements CommandParser {
    private CommandSpecRepository repository;
    private List filters = new ArrayList();
    private static final String FILTER_CONFIGURATION = "/cli/configuration/filters";

    public CommandLineParser() throws Exception {
        this.repository = CommandSpecRepository.getInstance();
        this.initialize();
    }

    public void parseCommand(String commandLine, ParsedCommandLine command) throws MalformedCommandException {
        if (commandLine == null || command == null) {
            throw new MalformedCommandException("error.parsing.malformedCommand");
        }
        ArrayList commandTokens = this.tokenizeCommandLine(commandLine = this.normalizeCommandLine(commandLine));
        if (commandTokens.isEmpty()) {
            throw new MalformedCommandException("error.parsing.malformedCommand");
        }
        this.applyFilters(commandTokens);
        command.setCommandName(this.findCommandName(commandTokens));
        command.setResource(this.findResource(commandTokens));
        command.setOptions(this.findOptions(commandTokens));
        this.processErrors(commandTokens);
    }

    private void processErrors(ArrayList commandTokens) throws MalformedCommandException {
        if (!commandTokens.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            sb.append(commandTokens.get(0));
            for (int i = 1; i < commandTokens.size(); ++i) {
                sb.append(", ").append(commandTokens.get(i));
            }
            throw new MalformedCommandException(sb.toString(), "error.parsing.extraElements");
        }
    }

    private ArrayList tokenizeCommandLine(String commandLine) {
        ArrayList<String> commandTokens = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(commandLine, "\n");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            commandTokens.add(token);
        }
        return commandTokens;
    }

    private String normalizeCommandLine(String commandLine) {
        commandLine = commandLine.replaceAll("[\\s*\n\\s*],", ",");
        commandLine = commandLine.replaceAll(",[\\s*\n\\s*]", ",");
        commandLine = commandLine.replaceAll("\\s*,\\s*", ",");
        return commandLine;
    }

    private String findCommandName(List tokenList) throws MalformedCommandException {
        if (tokenList == null || tokenList.isEmpty()) {
            throw new MalformedCommandException("error.parsing.malformedCommand");
        }
        String name = (String)tokenList.get(0);
        if (!this.repository.isCommandSupported(name)) {
            throw new MalformedCommandException(name + ": ", "error.parsing.illegalCommandName");
        }
        tokenList.remove(0);
        return name;
    }

    private Resource findResource(List tokenList) throws MalformedCommandException {
        if (tokenList == null) {
            throw new MalformedCommandException("error.validation.nullCommand");
        }
        ArrayList foundParts = new ArrayList();
        Resource resource = new Resource();
        if (tokenList.isEmpty()) {
            resource.setType("none");
        } else if (tokenList.size() == 1) {
            if (this.isResource((String)tokenList.get(0))) {
                resource.setType((String)tokenList.get(0));
                foundParts.add(tokenList.get(0));
            }
        } else {
            int lastTokenIndex = tokenList.size() - 1;
            String lastToken = (String)tokenList.get(lastTokenIndex);
            String priorToLastToken = (String)tokenList.get(lastTokenIndex - 1);
            if (this.isResource(lastToken)) {
                if (this.isResource(priorToLastToken)) {
                    resource.setType(priorToLastToken);
                    resource.setValues(this.tokenizeValues(lastToken));
                    foundParts.add(priorToLastToken);
                    foundParts.add(lastToken);
                } else {
                    resource.setType(lastToken);
                    foundParts.add(lastToken);
                }
            } else if (this.isResource(priorToLastToken)) {
                resource.setType(priorToLastToken);
                resource.setValues(this.tokenizeValues(lastToken));
                foundParts.add(lastToken);
                foundParts.add(priorToLastToken);
            }
        }
        this.removeSublist(tokenList, foundParts);
        return resource;
    }

    private List findOptions(List tokenList) throws MalformedCommandException {
        if (tokenList == null) {
            throw new MalformedCommandException("error.validation.nullCommand");
        }
        ArrayList<Option> options = new ArrayList<Option>();
        ArrayList<String> foundParts = new ArrayList<String>();
        if (!tokenList.isEmpty()) {
            Option option = null;
            boolean optionValuesSet = false;
            for (int i = 0; i < tokenList.size(); ++i) {
                String token = (String)tokenList.get(i);
                if (token.startsWith("-")) {
                    option = new Option();
                    String name = token.substring(token.indexOf("-"));
                    option.setName(name);
                    options.add(option);
                    foundParts.add(token);
                    optionValuesSet = false;
                    continue;
                }
                if (option == null || optionValuesSet) continue;
                option.setValues(this.tokenizeValues(token));
                foundParts.add(token);
                optionValuesSet = true;
            }
            this.removeSublist(tokenList, foundParts);
        }
        return options;
    }

    private boolean isResource(String type) {
        return this.repository.isResourceTypeSupported(type);
    }

    private List tokenizeValues(String commaSeparatedList) {
        ArrayList<String> tokenized = new ArrayList<String>();
        if (commaSeparatedList == null) {
            return tokenized;
        }
        if (commaSeparatedList.indexOf(",") < 0) {
            tokenized.add(commaSeparatedList);
        } else {
            StringTokenizer st = new StringTokenizer(commaSeparatedList, ",");
            while (st.hasMoreTokens()) {
                tokenized.add(st.nextToken());
            }
        }
        return tokenized;
    }

    private void applyFilters(List tokens) {
        if (this.filters != null) {
            for (int i = 0; i < this.filters.size(); ++i) {
                SpecialCaseFilter filter = (SpecialCaseFilter)this.filters.get(i);
                filter.filter(tokens);
            }
        }
    }

    private void initialize() throws Exception {
        Configuration conf = Configuration.getInstance();
        Element filterElems = conf.getSubconfiguration(FILTER_CONFIGURATION);
        List filterElements = XMLUtils.listNamedChildElements((Element)filterElems, (String)"filter");
        if (filterElements != null) {
            for (int i = 0; i < filterElements.size(); ++i) {
                Element filterElem = (Element)filterElements.get(i);
                String filterClass = XMLUtils.getElementValue((Element)filterElem);
                SpecialCaseFilter filter = (SpecialCaseFilter)ClassLoaderUtils.instantiateClass((String)filterClass);
                this.filters.add(filter);
            }
        }
    }

    private void removeSublist(List target, List toRemove) {
        if (toRemove == null || target == null) {
            return;
        }
        for (int i = 0; i < toRemove.size(); ++i) {
            Object o = toRemove.get(i);
            int index = target.lastIndexOf(o);
            target.remove(index);
        }
    }
}

