/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.server;

import com.sun.netstorage.array.mgmt.cfg.cli.core.ResourceLocator;
import com.sun.netstorage.array.mgmt.cfg.cli.server.LocaleAware;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import java.util.Locale;

public class ErrorBean
implements LocaleAware {
    private String localizableErrorMessage;
    private String resource;
    private String returnCode;
    private String[] resources;

    public ErrorBean() {
    }

    public ErrorBean(String label, ConfigMgmtException cme, String returnCode) {
        this.resource = label + ": ";
        this.localizableErrorMessage = cme.getExceptionKey();
        this.returnCode = returnCode;
    }

    public ErrorBean(String label, ConfigMgmtException cme) {
        this(label, cme, "100");
    }

    public ErrorBean(String resource, String message, String returnCode) {
        this.localizableErrorMessage = message;
        this.resource = resource;
        this.returnCode = returnCode;
    }

    public ErrorBean(String resource, String message) {
        this(resource, message, "100");
    }

    public ErrorBean(String[] resources, String message, String returnCode) {
        this.localizableErrorMessage = message;
        this.resources = resources;
        this.returnCode = returnCode;
    }

    public ErrorBean(String[] resources, String message) {
        this(resources, message, "100");
    }

    public String getLocalizableErrorMessage() {
        return this.localizableErrorMessage;
    }

    public void setLocalizableErrorMessage(String localizableErrorMessage) {
        this.localizableErrorMessage = localizableErrorMessage;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String[] getResources() {
        return this.resources;
    }

    public void setResources(String[] resources) {
        this.resources = resources;
    }

    public String getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(String returnCode) {
        this.returnCode = returnCode;
    }

    public String toString() {
        return this.toString(Locale.getDefault());
    }

    public String toString(Locale locale) {
        String result = "";
        if (this.getResources() != null) {
            result = ResourceLocator.getString(this.getLocalizableErrorMessage(), this.getResources(), locale);
        } else {
            if (this.getResource() != null) {
                result = this.getResource();
            }
            result = result + ResourceLocator.getString(this.getLocalizableErrorMessage(), locale);
        }
        return result;
    }
}

