/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.server;

import com.sun.netstorage.array.mgmt.cfg.cli.server.Configuration;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ConfigurationException;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Specification;
import com.sun.netstorage.array.mgmt.cfg.cli.server.specification.CommandOptionSpec;
import com.sun.netstorage.array.mgmt.cfg.cli.server.specification.CommandSpec;
import com.sun.netstorage.array.mgmt.cfg.cli.server.specification.OptionListSpec;
import com.sun.netstorage.array.mgmt.cfg.cli.server.specification.ResourceSpec;
import com.sun.netstorage.array.mgmt.cfg.util.XMLUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.w3c.dom.Element;

public class CommandSpecRepository {
    public static final String COMMAND_SPEC_CONFIGURATION = "/cli/command-specifications";
    private static CommandSpecRepository _instance;
    private static StringComparator stringComparator;
    private TreeMap _supportedResourceTypes = new TreeMap(stringComparator);
    private TreeMap _supportedCommands = new TreeMap(stringComparator);
    private HashMap _commandSpecMap = new HashMap();
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$cli$server$CommandSpecRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommandSpecRepository getInstance() throws Exception {
        if (_instance == null) {
            Class clazz = class$com$sun$netstorage$array$mgmt$cfg$cli$server$CommandSpecRepository == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$server$CommandSpecRepository = CommandSpecRepository.class$("com.sun.netstorage.array.mgmt.cfg.cli.server.CommandSpecRepository")) : class$com$sun$netstorage$array$mgmt$cfg$cli$server$CommandSpecRepository;
            synchronized (clazz) {
                if (_instance == null) {
                    _instance = new CommandSpecRepository();
                }
            }
        }
        return _instance;
    }

    public Specification getSpecForCommand(ParsedCommandLine command) throws Exception {
        if (command == null || command.getCommandName() == null || command.getResource() == null) {
            throw new ConfigurationException("error.general.commandSpecNotFound");
        }
        CmdRscPair key = new CmdRscPair(command.getCommandName(), command.getResource().getType());
        CommandSpec spec = (CommandSpec)this._commandSpecMap.get(key);
        if (spec == null) {
            throw new ConfigurationException("error.general.commandSpecNotFound");
        }
        return spec;
    }

    public List getAllSpecsForCommandName(String commandName) {
        ArrayList allSpecs = new ArrayList();
        Iterator resourceIter = this._supportedResourceTypes.keySet().iterator();
        while (resourceIter.hasNext()) {
            String resource = (String)resourceIter.next();
            Object spec = this._commandSpecMap.get(new CmdRscPair(commandName, resource));
            if (spec == null) continue;
            allSpecs.add(spec);
        }
        return allSpecs;
    }

    public boolean isResourceTypeSupported(String type) {
        return this._supportedResourceTypes.containsKey(type);
    }

    public boolean isCommandSupported(String name) {
        return this._supportedCommands.containsKey(name);
    }

    public List getKnownCommands() {
        return new ArrayList(this._supportedCommands.keySet());
    }

    public List getKnownResourceTypes() {
        return new ArrayList(this._supportedResourceTypes.keySet());
    }

    private CommandSpecRepository() throws Exception {
        this.initialize();
    }

    private void initialize() throws Exception {
        Element root = Configuration.getInstance().getSubconfiguration(COMMAND_SPEC_CONFIGURATION);
        List commandSpecElementList = XMLUtils.listNamedChildElements((Element)root, (String)"command-spec");
        if (commandSpecElementList != null) {
            Iterator iter = commandSpecElementList.iterator();
            while (iter.hasNext()) {
                Element specElement = (Element)iter.next();
                CommandSpec spec = this.buildCommandSpec(specElement);
                this._supportedCommands.put(spec.getCommandName(), spec.getCommandName());
                this._supportedResourceTypes.put(spec.getResourceSpec().getResourceType(), spec.getResourceSpec().getResourceType());
                CmdRscPair key = new CmdRscPair(spec.getCommandName(), spec.getResourceSpec().getResourceType());
                this._commandSpecMap.put(key, spec);
            }
        } else {
            throw new ConfigurationException();
        }
    }

    private CommandSpec buildCommandSpec(Element commandSpecElement) throws Exception {
        List optionListList;
        CommandSpec cmdSpec = new CommandSpec();
        cmdSpec.setCommandName(XMLUtils.getElementValue((Element)commandSpecElement, (String)"command-name"));
        cmdSpec.setCommandProcessor(XMLUtils.getElementValue((Element)commandSpecElement, (String)"processor"));
        String preprocessorClassPath = XMLUtils.getElementValue((Element)commandSpecElement, (String)"pre-processor");
        if (preprocessorClassPath != null && preprocessorClassPath.trim().length() > 0) {
            cmdSpec.setCommandPreprocessor(preprocessorClassPath.trim());
        }
        if (null != (optionListList = XMLUtils.listNamedChildElements((Element)commandSpecElement, (String)"optionList"))) {
            int optionListCount = 0;
            Iterator listIter = optionListList.iterator();
            while (listIter.hasNext()) {
                Element optionListSpecElement = (Element)listIter.next();
                String listName = XMLUtils.getElementValue((Element)optionListSpecElement, (String)"/list-name");
                if (null == listName || listName.trim().length() == 0) {
                    listName = "OptionList" + String.valueOf(++optionListCount);
                }
                OptionListSpec listSpec = new OptionListSpec(listName);
                String listPreprocessorClassPath = XMLUtils.getElementValue((Element)optionListSpecElement, (String)"pre-processor");
                if (null != listPreprocessorClassPath && listPreprocessorClassPath.trim().length() > 0) {
                    listSpec.setPreprocessorClassPath(listPreprocessorClassPath.trim());
                } else if (cmdSpec.hasPreprocessor()) {
                    listSpec.setPreprocessorClassPath(cmdSpec.getCommandPreprocessor());
                }
                String listProcessorClassPath = XMLUtils.getElementValue((Element)optionListSpecElement, (String)"processor");
                if (null != listProcessorClassPath && listProcessorClassPath.trim().length() > 0) {
                    listSpec.setProcessorClassPath(listProcessorClassPath);
                } else {
                    listSpec.setProcessorClassPath(cmdSpec.getCommandProcessor());
                }
                List optionElementList = XMLUtils.listNamedChildElements((Element)optionListSpecElement, (String)"option");
                if (optionElementList != null) {
                    Iterator iter = optionElementList.iterator();
                    while (iter.hasNext()) {
                        Element optionElement = (Element)iter.next();
                        listSpec.addOptionSpec(this.buildOptionSpec(optionElement));
                    }
                }
                cmdSpec.addOptionListSpec(listSpec);
            }
        }
        Element resourceSpec = XMLUtils.findElement((Element)commandSpecElement, (String)"resource");
        cmdSpec.setResourceSpec(this.buildResourceSpec(resourceSpec));
        return cmdSpec;
    }

    private CommandOptionSpec buildOptionSpec(Element option) throws Exception {
        CommandOptionSpec spec = new CommandOptionSpec();
        spec.setShortName(XMLUtils.getElementValue((Element)option, (String)"/short"));
        spec.setLongName(XMLUtils.getElementValue((Element)option, (String)"/long"));
        spec.setValueType(XMLUtils.getElementValue((Element)option, (String)"/type"));
        spec.setListAllowed(Boolean.valueOf(XMLUtils.getElementValue((Element)option, (String)"/value-list-allowed")));
        spec.setRequired(Boolean.valueOf(XMLUtils.getElementValue((Element)option, (String)"/optional")) == false);
        spec.setNeedsToHaveValue(XMLUtils.getElementValue((Element)option, (String)"/has-value"));
        spec.setDisplayName(XMLUtils.getElementValue((Element)option, (String)"/display-name"));
        List allowedValues = XMLUtils.listNamedChildElements((Element)option, (String)"/valueList/value");
        if (allowedValues != null) {
            for (int i = 0; i < allowedValues.size(); ++i) {
                spec.addAllowedValue(XMLUtils.getElementValue((Element)((Element)allowedValues.get(i))));
            }
        }
        return spec;
    }

    private ResourceSpec buildResourceSpec(Element resourceBlock) throws Exception {
        ResourceSpec spec = new ResourceSpec();
        spec.setResourceType(XMLUtils.getElementValue((Element)resourceBlock, (String)"/type"));
        spec.setValueType(XMLUtils.getElementValue((Element)resourceBlock, (String)"/value-type"));
        spec.setNeedsToHaveValue(XMLUtils.getElementValue((Element)resourceBlock, (String)"/has-value"));
        if (!spec.getNeedsToHaveValue().equals("never")) {
            spec.setListValueAllowed(Boolean.valueOf(XMLUtils.getElementValue((Element)resourceBlock, (String)"/value-list-allowed")));
            spec.setDisplayName(XMLUtils.getElementValue((Element)resourceBlock, (String)"/display-name"));
            List allowedValues = XMLUtils.listNamedChildElements((Element)resourceBlock, (String)"/valueList/value");
            if (allowedValues != null) {
                for (int i = 0; i < allowedValues.size(); ++i) {
                    spec.addAllowedValue(XMLUtils.getElementValue((Element)((Element)allowedValues.get(i))));
                }
            }
        }
        return spec;
    }

    public HashMap getCommandSpecMap() {
        return this._commandSpecMap;
    }

    public List getAllSpecs() {
        ArrayList allSpecs = new ArrayList();
        Iterator keys = this._commandSpecMap.keySet().iterator();
        while (keys.hasNext()) {
            allSpecs.add(this._commandSpecMap.get(keys.next()));
        }
        return allSpecs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        stringComparator = new StringComparator();
    }

    private static class StringComparator
    implements Comparator {
        private StringComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return s1.compareTo(s2);
        }
    }

    private static class CmdRscPair {
        private String commandName;
        private String resourceType;

        public CmdRscPair(String commandName, String resourceName) {
            this.commandName = commandName;
            this.resourceType = resourceName;
        }

        public String getCommandName() {
            return this.commandName;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof CmdRscPair)) {
                return false;
            }
            CmdRscPair other = (CmdRscPair)o;
            boolean equals = true;
            if (this.commandName != null) {
                if (!this.commandName.equals(other.commandName)) {
                    equals = false;
                }
            } else if (other.commandName != null) {
                return false;
            }
            if (this.resourceType != null) {
                if (!this.resourceType.equals(other.resourceType)) {
                    equals = false;
                }
            } else if (other.resourceType != null) {
                return false;
            }
            return equals;
        }

        public int hashCode() {
            int hashCode = 0;
            if (this.commandName != null) {
                hashCode += this.commandName.hashCode();
            }
            if (this.resourceType != null) {
                hashCode += this.resourceType.hashCode();
            }
            return hashCode;
        }
    }
}

