/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.server;

import com.sun.netstorage.array.mgmt.cfg.bui.common.SEExceptionHelper;
import com.sun.netstorage.array.mgmt.cfg.bui.utilities.LocalizationUtil;
import com.sun.netstorage.array.mgmt.cfg.cli.core.HelpProcessor;
import com.sun.netstorage.array.mgmt.cfg.cli.core.ResourceLocator;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CLIException;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandParser;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandParserFactory;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandPreprocessor;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandProcessor;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandSpecRepository;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ErrorBean;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.cli.server.specification.CommandSpec;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ArrayStatusNotOkException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.DSPMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.MultipleMembershipNotAllowed;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ZeroCIMInstanceReturnedException;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.util.ClassLoaderUtils;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpSession;
import javax.wbem.cim.CIMException;
import org.apache.soap.Constants;
import org.apache.soap.rpc.SOAPContext;

public class CLI {
    private boolean testMode;
    private static final String DOUBLE_NULL_KEY = "cli.system.error.doubleNullKey";
    private static final Map ERROR_MAP = new HashMap();
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$cli$server$CLI;

    public CommandResult processCommand(SOAPContext context, String commandLine, String argLocale) throws Exception {
        String METHOD_NAME = "processCommand";
        Trace.methodBegin((Object)this, (String)"processCommand");
        Locale locale = new Locale(argLocale);
        ResourceBundle rb = this.getResourceBundle(locale);
        CommandResult result = new CommandResult();
        ParsedCommandLine pcl = null;
        try {
            try {
                CommandSpec spec = null;
                CommandParserFactory parserFactory = CommandParserFactory.getInstance();
                CommandSpecRepository specRepository = CommandSpecRepository.getInstance();
                boolean userInputPhase = this.isUserInputPhase(context);
                if (userInputPhase) {
                    pcl = this.getPclFromSession(context);
                    spec = this.getSpecFromSession(context);
                } else {
                    if (Trace.isTraceEnabled((Object)this)) {
                        Trace.verbose((Object)this, (String)"processCommand", (String)(" Command line is \n" + commandLine));
                    }
                    CommandParser parser = parserFactory.getParser();
                    pcl = new ParsedCommandLine();
                    parser.parseCommand(commandLine, pcl);
                    spec = (CommandSpec)specRepository.getSpecForCommand(pcl);
                    spec.satisfiedBy(pcl);
                }
                boolean furtherProcessingAllowed = true;
                if (pcl.hasPreprocessorClassPath()) {
                    CommandPreprocessor preprocessor = this.loadPreprocessor(pcl);
                    furtherProcessingAllowed = preprocessor.preprocess(context, result, userInputPhase, spec, pcl, locale, commandLine);
                }
                if (furtherProcessingAllowed) {
                    CommandProcessor processor = this.loadProcessor(pcl);
                    result = processor.execute(pcl, locale, context);
                }
            }
            catch (CLIException e) {
                HelpProcessor helpProcessor = new HelpProcessor();
                result = helpProcessor.executeHelp(pcl, locale, context, e.localize(locale));
            }
            catch (ItemNotFoundException e) {
                result.setErrorId("15");
                if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$server$CLI == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$server$CLI = CLI.class$("com.sun.netstorage.array.mgmt.cfg.cli.server.CLI")) : class$com$sun$netstorage$array$mgmt$cfg$cli$server$CLI))) {
                    Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$server$CLI == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$server$CLI = CLI.class$("com.sun.netstorage.array.mgmt.cfg.cli.server.CLI")) : class$com$sun$netstorage$array$mgmt$cfg$cli$server$CLI), (String)"processCommand", (String)("e.message " + e.getMessage()));
                }
                result.setResult(new ErrorBean(e.getMessage(), "error.resourceNotFound").toString(locale));
            }
            catch (SEItemNotFoundException e) {
                result.setErrorId("15");
                if (Trace.isTraceEnabled((Object)(class$com$sun$netstorage$array$mgmt$cfg$cli$server$CLI == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$server$CLI = CLI.class$("com.sun.netstorage.array.mgmt.cfg.cli.server.CLI")) : class$com$sun$netstorage$array$mgmt$cfg$cli$server$CLI))) {
                    Trace.verbose((Class)(class$com$sun$netstorage$array$mgmt$cfg$cli$server$CLI == null ? (class$com$sun$netstorage$array$mgmt$cfg$cli$server$CLI = CLI.class$("com.sun.netstorage.array.mgmt.cfg.cli.server.CLI")) : class$com$sun$netstorage$array$mgmt$cfg$cli$server$CLI), (String)"processCommand", (String)("e.message " + e.getMessage()));
                }
                result.setResult(new ErrorBean(e.getItemName(), "error.resourceNotFound").toString(locale));
            }
            catch (CIMException e) {
                Trace.verbose((Object)this, (String)"processCommand", (Throwable)e);
                result.setErrorId("50");
                result.setResult(e.getDescription());
            }
            catch (BadParameterException e) {
                this.processBadParameterException(locale, result, e);
            }
            catch (UnauthorizedException e) {
                this.processUnauthorizedException(context, rb, result, e, locale);
            }
            catch (ArrayStatusNotOkException e) {
                this.processArrayHealthStatusException(locale, rb, result, e);
            }
            catch (MultipleMembershipNotAllowed e) {
                result = this.processMultipleMembershipNotAllowed(rb, e);
            }
            catch (DSPMgmtException e) {
                Trace.verbose((Object)this, (String)"processCommand", (Throwable)e);
                result = this.processDSPMgmtException(rb, e);
            }
            catch (ZeroCIMInstanceReturnedException e) {
                Trace.verbose((Object)this, (String)"processCommand", (Throwable)e);
                result = this.processConfigMgmtException(rb, (ConfigMgmtException)((Object)e));
            }
            catch (ConfigMgmtException e) {
                Trace.verbose((Object)this, (String)"processCommand", (Throwable)e);
                result = this.processConfigMgmtException(rb, e);
            }
            catch (Throwable e) {
                this.processThrowableException(rb, result, e);
            }
        }
        catch (Exception e) {
            this.processThrowableException(rb, result, e);
        }
        return result;
    }

    private void processBadParameterException(Locale locale, CommandResult result, BadParameterException e) {
        result.setErrorId("30");
        ErrorBean eb = null;
        eb = e.getMsgParams() != null ? new ErrorBean(e.getMsgParams(), e.getMessage()) : new ErrorBean(e.getBadParameter(), e.getMessage());
        result.setResult(eb.toString(locale));
    }

    private void processThrowableException(ResourceBundle rb, CommandResult result, Throwable e) {
        String METHOD_NAME = "processThrowableException";
        Trace.error((Object)this, (String)"processThrowableException", (Throwable)e);
        try {
            result.setErrorId("75");
            try {
                result.setResult(rb.getString("error.systemError"));
            }
            catch (MissingResourceException mre) {
                String bundlePath = "com.sun.netstorage.array.mgmt.cfg.cli.ini.CLIResource";
                ResourceBundle rb1 = ResourceBundle.getBundle(bundlePath, rb.getLocale());
                result.setResult(rb1.getString("error.systemError"));
            }
        }
        catch (MissingResourceException mre1) {
            result.setResult("error.systemError");
        }
    }

    private void processArrayHealthStatusException(Locale locale, ResourceBundle rb, CommandResult result, ArrayStatusNotOkException e) {
        result.setErrorId("55");
        String bundlePath = "com.sun.netstorage.array.mgmt.cfg.cli.ini.CLIResource";
        ResourceBundle rb1 = ResourceBundle.getBundle(bundlePath, locale);
        String asnok = rb1.getString("error.general.arrayStatusNotOk");
        String ahs = null;
        try {
            ahs = rb1.getString("t4.status." + e.getMessage());
        }
        catch (MissingResourceException mre) {
            try {
                ahs = rb.getString("t4.status." + e.getMessage());
            }
            catch (MissingResourceException mre1) {
                ahs = rb1.getString("t4.status.unknown");
            }
        }
        result.setResult(asnok + ahs);
    }

    private void processUnauthorizedException(SOAPContext context, ResourceBundle rb, CommandResult result, UnauthorizedException e, Locale locale) {
        HttpSession session = (HttpSession)context.getProperty(Constants.BAG_HTTPSESSION);
        ConfigContext client = (ConfigContext)session.getAttribute("ConfigContext");
        String message = "error.user.session.userNotLoggedIn";
        ErrorBean eb = new ErrorBean();
        String subject = null;
        if (client != null) {
            message = e.getMessage();
            subject = client.getUser() + ": ";
            eb.setResource(subject);
        }
        eb.setLocalizableErrorMessage(message);
        result.setErrorId("101");
        result.setResult(new ErrorBean(subject, message).toString(locale));
    }

    protected boolean isUserInputPhase(SOAPContext context) {
        if (this.isTestMode()) {
            return false;
        }
        HttpSession session = (HttpSession)context.getProperty(Constants.BAG_HTTPSESSION);
        return session.getAttribute("user.input.phase") != null;
    }

    private ParsedCommandLine getPclFromSession(SOAPContext context) {
        HttpSession session = (HttpSession)context.getProperty(Constants.BAG_HTTPSESSION);
        return (ParsedCommandLine)session.getAttribute("cli.interactive.pcl");
    }

    private CommandSpec getSpecFromSession(SOAPContext context) {
        HttpSession session = (HttpSession)context.getProperty(Constants.BAG_HTTPSESSION);
        return (CommandSpec)session.getAttribute("cli.interactive.spec");
    }

    private CommandProcessor loadProcessor(ParsedCommandLine pcl) throws Exception {
        CommandProcessor processor = (CommandProcessor)ClassLoaderUtils.instantiateClass((String)pcl.getProcessorClassPath());
        return processor;
    }

    private CommandPreprocessor loadPreprocessor(ParsedCommandLine pcl) throws Exception {
        CommandPreprocessor preprocessor = (CommandPreprocessor)ClassLoaderUtils.instantiateClass((String)pcl.getPreprocessorClassPath());
        return preprocessor;
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        String bundlePath = (String)Repository.getRepository().getProperty((Object)"CLI-Resource-Bundle");
        if (bundlePath == null) {
            bundlePath = "com.sun.netstorage.array.mgmt.cfg.cli.ini.CLIResource";
        }
        ResourceBundle rb = ResourceBundle.getBundle(bundlePath, locale);
        return rb;
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    private CommandResult processMultipleMembershipNotAllowed(ResourceBundle rb, MultipleMembershipNotAllowed mme) {
        String[] badVols = mme.getSubstitutions();
        CommandResult cr = new CommandResult();
        cr.setErrorId("50");
        String res = "";
        String msg = "volume.already.group.member";
        try {
            msg = rb.getString(msg);
        }
        catch (MissingResourceException mre) {
            String bundlePath = "com.sun.netstorage.array.mgmt.cfg.cli.ini.CLIResource";
            ResourceBundle rb1 = ResourceBundle.getBundle(bundlePath, rb.getLocale());
            msg = rb1.getString(msg);
        }
        for (int i = 0; i < badVols.length; ++i) {
            res = res + badVols[i] + msg + "\n";
        }
        cr.setResult(res);
        return cr;
    }

    private void logInsufficientPriviledges(ParsedCommandLine pcl, ConfigMgmtException e, SOAPContext context) {
        ConfigMgmtException cme;
        Exception embeddedExc;
        if (e instanceof ConfigMgmtException && (embeddedExc = (cme = e).getEmbededException()) instanceof CIMException && "CIM_ERR_ACCESS_DENIED".equals(embeddedExc.getMessage())) {
            HttpSession session = (HttpSession)context.getProperty(Constants.BAG_HTTPSESSION);
            ConfigContext client = (ConfigContext)session.getAttribute("ConfigContext");
            String message = "AUTH_INSUFFICIENT_PRIVELEDGES";
            String user = client.getUser();
            String command = pcl.getCommandName() + " " + pcl.getResource().getType();
            LogAPI.staticLog((String)message, (String[])new String[]{user, command}, (String[])new String[0]);
        }
    }

    private CommandResult processConfigMgmtException(ResourceBundle rb, ConfigMgmtException e) {
        String METHOD_NAME = "processConfigMgmtException";
        Trace.methodBegin((Object)this, (String)"processConfigMgmtException");
        CommandResult result = new CommandResult();
        if (Repository.getRepository().getConfigInteger() == 4 || Repository.getRepository().getConfigInteger() == 5) {
            ArrayList errors = (ArrayList)SEExceptionHelper.parseConfigMgmtException(e, null);
            StringBuffer results = new StringBuffer();
            results.append((String)errors.get(0));
            for (int i = 1; i < errors.size(); ++i) {
                results.append("\n");
                results.append((String)errors.get(i));
            }
            result.setResult(results.toString());
        } else {
            String exceptionKey = e.getExceptionKey();
            String errorKey = null;
            if (exceptionKey != null) {
                Trace.verbose((Object)this, (String)"processConfigMgmtException", (String)("lookup key: " + exceptionKey));
                errorKey = (String)ERROR_MAP.get(exceptionKey);
            }
            if (errorKey == null) {
                errorKey = exceptionKey;
            }
            if (errorKey != null) {
                String localizedString = ResourceLocator.getString(errorKey, e.getSubstitutions(), rb.getLocale());
                if (localizedString != null && !errorKey.equals(localizedString)) {
                    result.setResult(localizedString);
                } else {
                    Trace.verbose((Object)this, (String)"processConfigMgmtException", (String)("resource lookup failed: " + errorKey));
                    String msg = e.getMessage();
                    if (msg != null) {
                        result.setResult(msg);
                    } else {
                        this.setApplicationError(rb, result);
                    }
                }
            } else {
                this.setApplicationError(rb, result);
            }
        }
        result.setErrorId("50");
        return result;
    }

    private void setApplicationError(ResourceBundle rb, CommandResult result) {
        try {
            result.setResult(rb.getString("error.applicationError"));
        }
        catch (MissingResourceException mre2) {
            String bundlePath = "com.sun.netstorage.array.mgmt.cfg.cli.ini.CLIResource";
            ResourceBundle rb1 = ResourceBundle.getBundle(bundlePath, rb.getLocale());
            result.setResult(rb1.getString("error.applicationError"));
        }
    }

    private CommandResult processDSPMgmtException(ResourceBundle rb, DSPMgmtException e) {
        String METHOD_NAME = "processDSPMgmtException";
        Trace.methodBegin((Object)this, (String)"processDSPMgmtException");
        CommandResult result = new CommandResult();
        MethodCallStatus mcs = e.getMcs();
        if (mcs != null && mcs.getReturnCode() != 0) {
            result.setResult(LocalizationUtil.processMCS(mcs));
        } else {
            Trace.verbose((Object)this, (String)"processDSPMgmtException", (String)"mcs null");
        }
        result.setErrorId("50");
        return result;
    }

    private String getLocalizedArrayHealthStatus(Locale locale, String healthCode) {
        String localized = this.getResourceBundle(locale).getString("t4.status.unknown");
        try {
            localized = this.getResourceBundle(locale).getString("t4.status." + healthCode);
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"getLocalizedArrayHealthStatus", (String)("Unknown array health status: " + healthCode));
        }
        return localized;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ERROR_MAP.put("CIM_ERR_ACCESS_DENIED", "error.authorization.notEnoughPrivilegies");
        ERROR_MAP.put("CIM_ERR_ACCESS_DENIED", "error.authorization.notEnoughPrivilegies");
        ERROR_MAP.put("BOL_MGR_NOT_THERE", "error.bolMgr.notThere");
        ERROR_MAP.put("VOLUME_MAPPING_EXCEPTION", "error.volume.mapping");
        ERROR_MAP.put("VOLUME_SNAPPING_EXCEPTION", "error.parameter.mismatch");
        ERROR_MAP.put("VOLUME_DELETION_EXCEPTION", "error.volume.delete");
        ERROR_MAP.put("MCS_RET", "error.mcs");
        ERROR_MAP.put("ZERO_CIM_INSTANCE_RETURNED", "error.objectNotFound");
        ERROR_MAP.put("error.objectNotFound", "error.objectNotFound");
        ERROR_MAP.put("UNABLE_TO_CONNECT_TO_CIMOM", "error.login.failed.UNABLE_TO_CONNECT_TO_CIMOM");
        ERROR_MAP.put("max.initiators.reached", "max.initiators.reached");
        ERROR_MAP.put("INVALID_STORAGE_ARRAY_PASSWORD_EXCEPTION", "arrayregistration.CannotValidatePassword");
        ERROR_MAP.put("array.already.exists", "arrayregistration.ArrayAlreadyExists");
        ERROR_MAP.put("error.pool.create.number_of_disks_no_match_profile", "error.pool.create.number_of_disks_no_match_profile");
        ERROR_MAP.put("error.pool.create.profile_not_eligible", "error.pool.create.profile_not_eligible");
        ERROR_MAP.put("t4.error.cannotApplyNewProfile", "t4.error.cannotApplyNewProfile");
        ERROR_MAP.put("T4_MODIFY_FAIL", "t4.save.error");
        ERROR_MAP.put("T4_MODIFY_HOT_SPARE_FAIL", "arrayhotsparepool.save.error");
        ERROR_MAP.put("error.pool.create.2", "error.pool.create.2");
        ERROR_MAP.put("error.pool.create.3", "error.pool.create.3");
        ERROR_MAP.put("error.pool.create.4", "error.pool.create.4");
        ERROR_MAP.put("error.pool.create.5", "error.pool.create.5");
        ERROR_MAP.put("storage.mgmt.profile.error.rl0_nd14.dhs", "storage.mgmt.profile.error.rl0_nd14.dhs");
        ERROR_MAP.put("storage.mgmt.profile.error.nd14.dhs", "storage.mgmt.profile.error.nd14.dhs");
        ERROR_MAP.put("storage.mgmt.profile.error.rl0.dhs", "storage.mgmt.profile.error.rl0.dhs");
        ERROR_MAP.put("storage.mgmt.profile.error.rl5.nd2", "storage.mgmt.profile.error.rl5.nd2");
    }
}

