/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.core;

import com.sun.netstorage.array.mgmt.cfg.cli.core.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageDataServicesFactory;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageVolumeCopyInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.soap.rpc.SOAPContext;

public abstract class VolumeCopyProcessor
extends CommandProcessorBase {
    protected ManageVolumeCopyInterface _mvci = null;
    protected SearchFilter _filter = null;

    protected void initializeManager(SOAPContext argContext) throws UnauthorizedException, ConfigMgmtException, SEItemNotFoundException {
        this._mvci = ManageDataServicesFactory.getVolumeCopyManager((ConfigContext)super.getConfigContext(argContext), (Scope)this._scope, (SearchFilter)this._filter);
    }

    protected ManagerInterface getManager() {
        return this._mvci;
    }

    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext argCtx) throws UnauthorizedException, ConfigMgmtException, SEItemNotFoundException {
        String METHOD_NAME = "doList";
        Trace.methodBegin((Object)this, (String)"doList");
        this.checkListPermission(argCtx);
        this.setScope(pcl);
        this.initializeManager(argCtx);
        Option option = null;
        List sourceList = new ArrayList();
        List targetList = new ArrayList();
        option = pcl.getOptionByName("-s", "--source-volume");
        if (null != option) {
            sourceList = option.getValues();
        }
        if (null != (option = pcl.getOptionByName("-t", "--target-volume"))) {
            targetList = option.getValues();
        }
        List props = null;
        props = sourceList.isEmpty() && targetList.isEmpty() ? this.list(null) : this.list(sourceList, targetList);
        CommandResult result = new CommandResult();
        this.processResults(locale, result, props);
        return result;
    }

    protected CommandResult doDelete(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws UnauthorizedException, ConfigMgmtException, SEItemNotFoundException {
        String METHOD_NAME = "doDelete";
        Trace.methodBegin((Object)this, (String)"doDelete");
        this.checkDeletePermission(argContext);
        this.setScope(pcl);
        this.initializeManager(argContext);
        String sourceVolume = pcl.getOptionByName("-s", "--source-volume").getFirstValue();
        String targetVolume = pcl.getOptionByName("-t", "--target-volume").getFirstValue();
        List errors = this.delete(sourceVolume, targetVolume);
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    protected CommandResult doModify(Locale locale, ParsedCommandLine pcl, SOAPContext argCtx) throws UnauthorizedException, ConfigMgmtException, SEItemNotFoundException {
        String METHOD_NAME = "doModify";
        Trace.methodBegin((Object)this, (String)"doModify");
        this.checkModifyPermission(argCtx);
        this.setScope(pcl);
        this.initializeManager(argCtx);
        String sourceVolume = pcl.getOptionByName("-s", "--source-volume").getFirstValue();
        String targetVolume = pcl.getOptionByName("-t", "--target-volume").getFirstValue();
        List errors = this.modify(sourceVolume, targetVolume, pcl);
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    protected abstract List list(List var1, List var2) throws ConfigMgmtException;

    protected abstract List delete(String var1, String var2) throws ConfigMgmtException, UnauthorizedException;

    protected abstract List modify(String var1, String var2, ParsedCommandLine var3) throws ConfigMgmtException, UnauthorizedException;

    protected static interface CLIOption {
        public static final String SOURCE_SHORT = "-s";
        public static final String SOURCE_LONG = "--source-volume";
        public static final String TARGET_SHORT = "-t";
        public static final String TARGET_LONG = "--target-volume";
        public static final String PRIORITY_SHORT = "-p";
        public static final String PRIORITY_LONG = "--priority";
        public static final String READONLY_SHORT = "-r";
        public static final String READONLY_LONG = "--readonly";
    }
}

