/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.core;

import com.sun.netstorage.array.mgmt.cfg.admin.business.UserInterface;
import com.sun.netstorage.array.mgmt.cfg.admin.business.UserRoleAdminFactory;
import com.sun.netstorage.array.mgmt.cfg.admin.business.UserRoleAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.cli.core.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.util.NameBasedComparator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.soap.rpc.SOAPContext;

public abstract class UserRoleProcessor
extends CommandProcessorBase {
    public static final NameBasedComparator USER_ROLE_COMPARATOR = new NameBasedComparator(){

        public boolean isEqual(Object role, Object candidate) {
            UserInterface user = (UserInterface)candidate;
            return role != null && role.equals(user.getRole().toString());
        }
    };
    protected UserRoleAdminInterface _uai = null;

    protected ManagerInterface getManager() {
        return this._uai;
    }

    protected void initializeManager(SOAPContext argCtx) throws UnauthorizedException, ConfigMgmtException, SEItemNotFoundException {
        this._uai = UserRoleAdminFactory.getManager((ConfigContext)this.getConfigContext(argCtx));
    }

    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext argCtx) throws UnauthorizedException, ConfigMgmtException, SEItemNotFoundException, Exception {
        String METHOD_NAME = "doList";
        Trace.methodBegin((Object)this, (String)"doList");
        this.checkListPermission(argCtx);
        this.setScope(pcl);
        this.initializeManager(argCtx);
        List props = this.list(pcl.getResource().getValues(), USER_ROLE_COMPARATOR);
        CommandResult result = new CommandResult();
        this.processResults(locale, result, props);
        return result;
    }

    protected CommandResult doRemove(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws UnauthorizedException, ConfigMgmtException, SEItemNotFoundException {
        String METHOD_NAME = "doRemove";
        Trace.methodBegin((Object)this, (String)"doRemove");
        this.checkRemovePermission(argContext);
        List usernames = null;
        List options = pcl.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            if (!"-u".equals(option.getName()) && !"--username".equals(option.getName())) continue;
            usernames = option.getValues();
        }
        this.setScope(pcl);
        this.initializeManager(argContext);
        List errors = this.delete(usernames);
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    protected CommandResult doAdd(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws UnauthorizedException, ConfigMgmtException, SEItemNotFoundException, Exception {
        String METHOD_NAME = "doAdd";
        this.checkAddPermission(argContext);
        this.setScope(pcl);
        this.initializeManager(argContext);
        Properties props = this.getAddProperties(pcl);
        List errors = this.create(props);
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    protected abstract Properties getAddProperties(ParsedCommandLine var1);
}

