/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.core;

import com.sun.netstorage.array.mgmt.cfg.cli.core.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.core.Exec;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Resource;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.soap.rpc.SOAPContext;

public class StoradeProcessor
extends CommandProcessorBase {
    String RASADMIN = "/opt/SUNWstade/bin/ras_admin";
    String CONFIG = "/opt/SUNWstade/sysbin/config_solution";
    String SYSADMIN = "/opt/SUNWstade/sysbin/sys_admin";
    String REVISION = "/opt/SUNWstade/bin/ras_patchlist";
    String REVISION_DOWN = "/opt/SUNWstade/bin/ras_patchdowngrade";
    String REVISION_UPGRADE = "/opt/SUNWstade/bin/ras_upgrade";
    String REVISION_DOWNGRADE = "/opt/SUNWstade/bin/ras_downgrade";
    String BASE_STORADE_URL = "http://localhost:7654";
    String ARGS = "&args=";
    String COMMAND_QUERY = "/rashttp?GO=Client::Sscs::run&command=";

    public String encodeArgs(String args) {
        String encodedargs = URLEncoder.encode(args);
        return encodedargs;
    }

    public URL getURL(String encodedargs) {
        URL url = null;
        try {
            url = new URL(this.BASE_STORADE_URL + this.COMMAND_QUERY + this.RASADMIN + this.ARGS + encodedargs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult cr = new CommandResult();
        String args = this.getArgs(pcl, cr);
        Resource res = pcl.getResource();
        CommandResult result = new CommandResult();
        if (res.getType().equals("alarms")) {
            String command = " alert_list" + args;
            String buffer = this.execURL(command, this.RASADMIN);
            cr.setResult(command + "\n" + buffer.toString());
        } else if (res.getType().equals("alarm")) {
            if (this.findOption(args, "-a")) {
                args = this.replaceOption(args, "-a", "");
                String command = " alert_list" + args;
                String buffer = this.execURL(command, this.RASADMIN);
                buffer = this.runWithAdvisor(buffer);
                cr.setResult(command + "\n" + buffer.toString());
            } else {
                String command = " alert_list" + args;
                String buffer = this.execURL(command, this.RASADMIN);
                cr.setResult(command + "\n" + buffer.toString());
            }
        } else if (res.getType().equals("advisor")) {
            String command = " advisor" + args;
            String buffer = this.execURL(command, this.RASADMIN);
            cr.setResult(command + "\n" + buffer.toString());
        } else if (res.getType().equals("devices")) {
            String command = " device_list" + args;
            String buffer = this.execURL(command, this.RASADMIN);
            cr.setResult(command + "\n" + buffer.toString());
        } else if (res.getType().equals("device")) {
            String command = " device_detail" + args;
            String buffer = this.execURL(command, this.RASADMIN);
            cr.setResult(command + "\n" + buffer.toString());
        } else if (res.getType().equals("notification")) {
            String command = " email_list " + args;
            String buffer = this.execURL(command, this.RASADMIN);
            command = " provider_list " + args;
            buffer = buffer + "\n" + this.execURL(command, this.RASADMIN);
            cr.setResult(command + "\n" + buffer.toString());
        } else if (res.getType().equals("site")) {
            String command = " site_info " + args;
            String buffer = this.execURL(command, this.RASADMIN);
            cr.setResult(command + "\n" + buffer.toString());
        } else if (res.getType().equals("ethers")) {
            String command = " ethers_list " + args;
            String buffer = this.execURL(command, this.RASADMIN);
            cr.setResult(command + "\n" + buffer.toString());
        } else if (res.getType().equals("revision")) {
            if (this.findOption(args, "-u")) {
                String command = " -S storade " + args;
                String buffer = this.execURL(command, this.REVISION_DOWN);
                cr.setResult(command + "\n" + buffer.toString());
            } else {
                String command = " -S storade ";
                String buffer = this.execURL(command, this.REVISION);
                cr.setResult(command + "\n" + buffer.toString());
            }
        }
        return cr;
    }

    protected CommandResult doAdd(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult cr = new CommandResult();
        String args = this.getArgs(pcl, cr);
        Resource res = pcl.getResource();
        CommandResult result = new CommandResult();
        if (res.getType().equals("notification")) {
            if (args.startsWith(" -e")) {
                String command = " email_add" + args;
                String buffer = this.execURL(command, this.RASADMIN);
                cr.setResult(command + "\n" + buffer.toString());
            } else {
                String command;
                String firstOption = res.getFirstValue();
                if ("local_email".equalsIgnoreCase(firstOption)) {
                    cr.setResult("\nUsage : sscs add -e <email_address> notification local_email");
                    return cr;
                }
                if ("sae".equalsIgnoreCase(firstOption)) {
                    if (args == null || !args.startsWith(" -i")) {
                        cr.setResult("\nUsage : sscs add -i <ip_address> notification sae");
                        return cr;
                    }
                    command = " provider_on -p " + firstOption + args;
                } else if ("trap".equalsIgnoreCase(firstOption)) {
                    if (args == null || !args.startsWith(" -i")) {
                        cr.setResult("\nUsage : sscs add -i <ip_address> -t <trap_level> -l <warning|error|down> notification trap\n\t -t trap number for trap provider. Valid numbers are 1 through 5.\n\t -l warning:error:down trap level for trap provider.");
                        return cr;
                    }
                    command = " provider_on -p " + firstOption + args;
                } else {
                    command = " provider_on -p " + firstOption;
                }
                String buffer = this.execURL(command, this.RASADMIN);
                cr.setResult(command + "\n" + buffer.toString());
            }
        } else if (res.getType().equals("ethers")) {
            String command = " ethers_add" + args;
            String buffer = this.execURL(command, this.RASADMIN);
            cr.setResult(command + "\n" + buffer.toString());
        }
        return cr;
    }

    protected CommandResult doRemove(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult cr = new CommandResult();
        String args = this.getArgs(pcl, cr);
        Resource res = pcl.getResource();
        CommandResult result = new CommandResult();
        if (res.getType().equals("notification")) {
            if (args.startsWith(" -e")) {
                String command = " email_delete" + args;
                String buffer = this.execURL(command, this.RASADMIN);
                cr.setResult(command + "\n" + buffer.toString());
            } else {
                String command;
                String firstOption = res.getFirstValue();
                if ("local_email".equalsIgnoreCase(firstOption)) {
                    cr.setResult("\nUsage : sscs remove -e <email_address> notification local_email");
                    return cr;
                }
                if ("trap".equalsIgnoreCase(firstOption)) {
                    if (args == null || !args.startsWith(" -t")) {
                        cr.setResult("\nUsage : sscs remove -t <trap_number> notification trap\n\t -t trap number for trap provider. Valid numbers are 1 through 5.");
                        return cr;
                    }
                    command = " provider_off -p " + firstOption + args;
                } else {
                    command = " provider_off -p " + firstOption;
                }
                String buffer = this.execURL(command, this.RASADMIN);
                cr.setResult(command + "\n" + buffer.toString());
            }
        } else if (res.getType().equals("alarm")) {
            String command = " alert_delete" + args;
            String buffer = this.execURL(command, this.RASADMIN);
            cr.setResult(command + "\n" + buffer.toString());
        } else if (res.getType().equals("ethers")) {
            String command = " ethers_delete" + args;
            String buffer = this.execURL(command, this.RASADMIN);
            cr.setResult(command + "\n" + buffer.toString());
        } else if (res.getType().equals("revision")) {
            String command = " -S storade -U -b";
            String buffer = this.execURL(command, this.REVISION_DOWNGRADE);
            cr.setResult(command + "\n" + buffer.toString());
        }
        return cr;
    }

    protected CommandResult doModify(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult cr = new CommandResult();
        String args = this.getArgs(pcl, cr);
        Resource res = pcl.getResource();
        CommandResult result = new CommandResult();
        if (res.getType().equals("countrycode")) {
            String command = " set_countrycode" + args;
            String buffer = this.execURL(command, this.SYSADMIN);
            cr.setResult(command + "\n" + buffer.toString());
        } else if (res.getType().equals("site")) {
            String command = " site_info_upd" + args;
            String buffer = this.execURL(command, this.RASADMIN);
            command = " site_info";
            buffer = "Site info. updated ! \n" + this.execURL(command, this.RASADMIN);
            cr.setResult(command + "\n" + buffer.toString());
        } else if (res.getType().equals("inventory")) {
            String command = args;
            String buffer = this.execURL(command, this.CONFIG);
            cr.setResult(command + "\n" + buffer.toString());
        } else if (res.getType().equals("revision")) {
            String command = " -S storade " + args;
            String buffer = this.execURL(command, this.REVISION_UPGRADE);
            cr.setResult(command + "\n" + buffer.toString());
        }
        return cr;
    }

    protected String getArgs(ParsedCommandLine pcl, CommandResult cr1) {
        List options = pcl.getOptions();
        StringBuffer args = new StringBuffer("");
        for (int i = 0; i < options.size(); ++i) {
            Option option = (Option)options.get(i);
            String optionName = this.stripToShortName(option.getName());
            args.append(" " + optionName);
            if (option.getFirstValue() == null) continue;
            args.append(" " + option.getFirstValue());
        }
        return args.toString();
    }

    protected boolean findOption(String originalString, String oldStr) {
        StringTokenizer strToken = new StringTokenizer(originalString, " ");
        while (strToken.hasMoreTokens()) {
            String currentToken = strToken.nextToken();
            if (!oldStr.equalsIgnoreCase(currentToken)) continue;
            return true;
        }
        return false;
    }

    protected String replaceOption(String originalString, String oldStr, String newStr) {
        StringTokenizer strToken = new StringTokenizer(originalString, " ");
        StringBuffer returnString = new StringBuffer();
        while (strToken.hasMoreTokens()) {
            String currentToken = strToken.nextToken();
            if (oldStr.equalsIgnoreCase(currentToken)) {
                returnString.append(newStr);
                continue;
            }
            returnString.append(" " + currentToken);
        }
        return returnString.toString();
    }

    private String runWithAdvisor(String originalString) {
        StringTokenizer strToken = new StringTokenizer(originalString, "\n");
        String eventCode = null;
        StringBuffer newstring = new StringBuffer();
        while (strToken.hasMoreTokens()) {
            String currentToken = strToken.nextToken();
            if (currentToken.startsWith("Event Code")) {
                eventCode = currentToken.substring(currentToken.indexOf(":") + 1, currentToken.length());
                String command = " advisor -e " + eventCode.trim();
                String newbuf = this.execURL(command, this.RASADMIN);
                if (newbuf == null) continue;
                newstring.append("\nSERVICE ADVISOR\n" + newbuf);
                continue;
            }
            newstring.append(currentToken + "\n");
        }
        return newstring.toString();
    }

    protected String stripToShortName(String optionName) {
        if (optionName.startsWith("--")) {
            char firstChar = optionName.charAt(2);
            return "-" + firstChar;
        }
        return optionName;
    }

    protected String exec(String commandLine) {
        String output;
        try {
            output = Exec.exec(commandLine).toString();
        }
        catch (SecurityException se) {
            return se.getMessage();
        }
        catch (NullPointerException npe) {
            return npe.getMessage();
        }
        catch (IllegalArgumentException iae) {
            return iae.getMessage();
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return output;
    }

    protected String execURL(String command, String commandName) {
        String output;
        try {
            String enc_Args = this.encodeArgs(command);
            String querystring = this.COMMAND_QUERY + commandName + this.ARGS + enc_Args;
            URL url = this.getURL(enc_Args);
            output = url.toString() + "\n" + Exec.executeURL(url, querystring).toString();
        }
        catch (SecurityException se) {
            return se.getMessage();
        }
        catch (NullPointerException npe) {
            return npe.getMessage();
        }
        catch (IllegalArgumentException iae) {
            return iae.getMessage();
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return output;
    }
}

