/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.core;

import com.sun.netstorage.array.mgmt.cfg.cli.core.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.core.ProfileImportProps;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ErrorBean;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageProfilesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageProfilesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ProfileInterface;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.MenuData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.soap.rpc.SOAPContext;

public abstract class ProfileProcessor
extends CommandProcessorBase {
    protected ManageProfilesInterface _mpi = null;

    protected ManagerInterface getManager() {
        return this._mpi;
    }

    protected void initializeManager(SOAPContext argCtx) throws UnauthorizedException, ConfigMgmtException, SEItemNotFoundException {
        this._mpi = ManageProfilesFactory.getManager((ConfigContext)this.getConfigContext(argCtx), (Scope)this._scope, null);
    }

    protected CommandResult doExport(Locale locale, ParsedCommandLine pcl, SOAPContext argCtx) throws ConfigMgmtException, UnauthorizedException, SEItemNotFoundException {
        String METHOD_NAME = "doExport";
        Trace.methodBegin((Object)this, (String)"doExport");
        this.checkExportPermission(argCtx);
        this.setScope(pcl);
        this.initializeManager(argCtx);
        List profiles = this.export(pcl);
        CommandResult result = new CommandResult();
        this.processResults(locale, result, profiles);
        return result;
    }

    protected boolean checkExportPermission(SOAPContext argContext) throws UnauthorizedException, ConfigMgmtException {
        String METHOD_NAME = "checkExportPermission";
        Trace.methodBegin((Object)this, (String)"checkExportPermission");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        return true;
    }

    protected boolean checkImportPermission(SOAPContext argContext) throws UnauthorizedException, ConfigMgmtException {
        String METHOD_NAME = "checkImportPermission";
        Trace.methodBegin((Object)this, (String)"checkImportPermission");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        return true;
    }

    public abstract List export(ParsedCommandLine var1) throws SEItemNotFoundException, ConfigMgmtException, UnauthorizedException;

    protected CommandResult doImport(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws ConfigMgmtException, UnauthorizedException, SEItemNotFoundException {
        String METHOD_NAME = "doImport";
        Trace.methodBegin((Object)this, (String)"doImport");
        this.checkImportPermission(argContext);
        this.setScope(pcl);
        this.initializeManager(argContext);
        List profiles = this.importXml(locale, pcl);
        CommandResult result = new CommandResult();
        this.processResults(locale, result, profiles);
        return result;
    }

    public List importXml(Locale locale, ParsedCommandLine pcl) throws UnauthorizedException, ConfigMgmtException {
        int i;
        String METHOD_NAME = "importXml";
        Trace.methodBegin((Object)this, (String)"importXml");
        List profileNames = pcl.getResource().getValues();
        boolean force = false;
        boolean do_list = false;
        String theXml = null;
        String theXmlContents = null;
        List options = pcl.getOptions();
        for (int i2 = 0; i2 < options.size(); ++i2) {
            Option option = (Option)options.get(i2);
            Trace.verbose((Object)this, (String)"importXml", (String)("option: " + option.getName()));
            if ("-x".equals(option.getName()) || "--xml".equals(option.getName())) {
                theXml = option.getFirstValue();
                continue;
            }
            if ("-f".equals(option.getName()) || "--force".equals(option.getName())) {
                force = true;
                continue;
            }
            if ("-L".equals(option.getName()) || "--list".equals(option.getName())) {
                do_list = true;
                continue;
            }
            if (!option.getName().equals("cli.interactive.optionName")) continue;
            theXmlContents = option.getFirstValue();
        }
        ArrayList<ErrorBean> result = null;
        ArrayList<ProfileInterface> theProfiles = null;
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        ArrayList<ProfileInterface> allProfiles = null;
        if (theXmlContents == null) {
            errors.add(new ErrorBean(theXml, "error.profile.invalidUrl"));
            return errors;
        }
        Object errorMsg = null;
        allProfiles = this._mpi.getXmlContentsForImport(theXmlContents);
        if (profileNames == null || profileNames.size() == 0) {
            theProfiles = allProfiles;
        } else {
            theProfiles = new ArrayList<ProfileInterface>();
            for (i = 0; i < profileNames.size(); ++i) {
                boolean foundit = false;
                String thisName = (String)profileNames.get(i);
                for (int j = 0; j < allProfiles.size(); ++j) {
                    ProfileInterface prof = (ProfileInterface)allProfiles.get(j);
                    if (!prof.getName().equals(thisName)) continue;
                    theProfiles.add(prof);
                    foundit = true;
                }
                if (!foundit) {
                    errors.add(new ErrorBean(thisName, "error.objectNotFound"));
                }
                foundit = false;
            }
        }
        if (do_list) {
            result = this.createProfileImportPropsList(theProfiles);
        } else {
            result = new ArrayList<ErrorBean>();
            for (i = 0; i < theProfiles.size(); ++i) {
                ProfileInterface thisProf = (ProfileInterface)theProfiles.get(i);
                try {
                    String resultString = null;
                    if (thisProf.getImportStatus() == 0) {
                        this._mpi.importProfile(thisProf);
                        resultString = "profile.import.new.success";
                    } else if (thisProf.getImportStatus() == 3) {
                        if (force) {
                            this._mpi.importProfile(thisProf);
                            resultString = "profile.import.conflict.success";
                        } else {
                            resultString = "profile.import.conflict.failure";
                        }
                    } else if (thisProf.getImportStatus() == 2) {
                        if (force) {
                            this._mpi.importProfile(thisProf);
                            resultString = "profile.import.duplicate.success";
                        } else {
                            resultString = "profile.import.duplicate.failure";
                        }
                    } else {
                        resultString = thisProf.getImportStatus() == 1 ? "profile.import.inuse.failure" : (thisProf.getImportStatus() == 4 ? "profile.import.exists.failure" : "profile.import.unknown.failure");
                    }
                    result.add(new ErrorBean(thisProf.getName(), resultString));
                    continue;
                }
                catch (ConfigMgmtException cme) {
                    String exceptionKey = cme.getExceptionKey();
                    if (exceptionKey.equals("NOT_ALL_ARRAYS_HEALTHY")) {
                        errors.add(new ErrorBean(thisProf.getName(), "error.profile.notAllArraysHealthy"));
                        continue;
                    }
                    Trace.error((Object)this, (ConfigMgmtException)cme);
                    throw cme;
                }
            }
        }
        if (errors != null && errors.size() > 0) {
            result.addAll(errors);
        }
        return result;
    }

    protected List createProfileImportPropsList(List profiles) throws UnauthorizedException, ConfigMgmtException {
        ArrayList<ProfileImportProps> result = new ArrayList<ProfileImportProps>();
        if (profiles != null) {
            Iterator iter = profiles.iterator();
            while (iter.hasNext()) {
                ProfileInterface profile = (ProfileInterface)iter.next();
                ProfileImportProps props = new ProfileImportProps();
                props.setName(profile.getName());
                props.setStatus(profile.getImportStatus());
                result.add(props);
            }
        }
        return result;
    }
}

