/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.core;

import com.sun.netstorage.array.mgmt.cfg.access.business.ManageHostGroupsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageHostGroupsInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageHostsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageHostsInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageMappingsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageMappingsInterface;
import com.sun.netstorage.array.mgmt.cfg.cli.core.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ErrorBean;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.LogicalObjectManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.core.ManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageDataServicesFactory;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageSnapShotServicesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVolumesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVolumesInterface;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.MenuData;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.soap.rpc.SOAPContext;

public abstract class MappingProcessor
extends CommandProcessorBase {
    protected final String MAPPING_NAME_PROPERTY = "MappingProcessor mapping-name";
    protected ManageHostsInterface _mhi = null;
    protected ManageMappingsInterface _mmi = null;
    protected ManageHostGroupsInterface _mhgi = null;
    protected ManageVolumesInterface _mvi = null;
    protected ManageSnapShotServicesInterface _msssi = null;

    protected ManagerInterface getManager() {
        return this._mmi;
    }

    protected void initializeManager(SOAPContext argCtx) throws UnauthorizedException, ConfigMgmtException, SEItemNotFoundException {
        String METHOD_NAME = "initializeManager";
        Trace.methodBegin((Object)this, (String)"initializeManager");
        this._mmi = ManageMappingsFactory.getManager((ConfigContext)this.getConfigContext(argCtx), (Scope)this._scope, null);
        this._mvi = ManageVolumesFactory.getManager((ConfigContext)this.getConfigContext(argCtx), (Scope)this._scope, null);
        this._msssi = ManageDataServicesFactory.getSnapShotServicesManager((ConfigContext)this.getConfigContext(argCtx), (Scope)this._scope, null);
        this._mhi = ManageHostsFactory.getManager((ConfigContext)this.getConfigContext(argCtx), (Scope)this._scope, null);
        this._mhgi = ManageHostGroupsFactory.getManager((ConfigContext)this.getConfigContext(argCtx), (Scope)this._scope, null);
    }

    protected CommandResult doMap(Locale locale, ParsedCommandLine pcl, SOAPContext argCtx) throws UnauthorizedException, ConfigMgmtException, SEItemNotFoundException, Exception {
        String METHOD_NAME = "doMap";
        Trace.methodBegin((Object)this, (String)"doMap");
        this.checkMapPermission(argCtx);
        this.setScope(pcl);
        this.initializeManager(argCtx);
        ArrayList getPropErrors = new ArrayList();
        List propsList = this.getMapProperties(pcl, getPropErrors);
        List errors = this.map(propsList);
        errors.addAll(getPropErrors);
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    protected boolean checkMapPermission(SOAPContext argContext) throws UnauthorizedException, ConfigMgmtException {
        String METHOD_NAME = "checkMapPermission";
        Trace.methodBegin((Object)this, (String)"checkMapPermission");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        return true;
    }

    protected abstract List getMapProperties(ParsedCommandLine var1, List var2) throws SEItemNotFoundException, ConfigMgmtException, UnauthorizedException;

    protected List map(List propsList) throws SEItemNotFoundException, ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "map";
        Trace.methodBegin((Object)this, (String)"map");
        LogicalObjectManagerInterface mgr = (LogicalObjectManagerInterface)this.getManager();
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        for (int i = 0; i < propsList.size(); ++i) {
            Properties props = (Properties)propsList.get(i);
            String mappingName = props.getProperty("MappingProcessor mapping-name");
            props.remove("MappingProcessor mapping-name");
            try {
                mgr.create(props);
                continue;
            }
            catch (ConfigMgmtException cme) {
                Trace.verbose((Object)this, (String)"map", (String)("key: " + cme.getExceptionKey()));
                Trace.verbose((Object)this, (String)"map", (String)("msg: " + cme.getExceptionMsg()));
                errors.add(new ErrorBean(mappingName, cme));
            }
        }
        return errors;
    }

    protected CommandResult doUnmap(Locale locale, ParsedCommandLine pcl, SOAPContext argCtx) throws UnauthorizedException, ConfigMgmtException, SEItemNotFoundException {
        String METHOD_NAME = "doUnmap";
        Trace.methodBegin((Object)this, (String)"doUnmap");
        this.checkMapPermission(argCtx);
        this.setScope(pcl);
        this.initializeManager(argCtx);
        List errors = this.unmap(pcl);
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    protected abstract List unmap(ParsedCommandLine var1) throws UnauthorizedException, ConfigMgmtException, SEItemNotFoundException;
}

