/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.core;

import com.sun.management.services.authentication.CliAuthenticator;
import com.sun.management.services.authentication.LoginData;
import com.sun.management.services.authentication.PasswordCredential;
import com.sun.management.services.authentication.UserDataObject;
import com.sun.management.services.common.ConsoleException;
import com.sun.netstorage.array.mgmt.cfg.bui.login.Login;
import com.sun.netstorage.array.mgmt.cfg.cli.core.ArrayKeyMap;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandProcessor;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.InvalidCredentials;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.ActiveUserInfo;
import com.sun.netstorage.mgmt.dm.util.authorization.AuthorizationUtility;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.soap.Constants;
import org.apache.soap.rpc.SOAPContext;

public class LoginProcessor
extends Login
implements CommandProcessor {
    public static String METHOD_NAME;

    public void initCLIUserSession(SOAPContext argCtx, String argUser, String argPass, boolean argForce, String sscsVersion, CommandResult cr, ResourceBundle rb, Locale loc) throws ConfigMgmtException {
        String latestClientVersion;
        METHOD_NAME = "initCLIUserSession";
        Trace.methodBegin((Object)this, (String)METHOD_NAME);
        String loginResultMsg = null;
        String string = latestClientVersion = Repository.getRepository().getProperty((Object)"sscs.version") == null ? "" : (String)Repository.getRepository().getProperty((Object)"sscs.version");
        if (!latestClientVersion.equals(sscsVersion)) {
            Trace.verbose((Object)this, (String)"initCLIUserSession", (String)"Old client detected");
            if (sscsVersion == null) {
                loginResultMsg = rb.getString("newer.client.available");
                MessageFormat mf = new MessageFormat(loginResultMsg);
                loginResultMsg = mf.format(new String[]{latestClientVersion}) + "\n\n";
            } else {
                loginResultMsg = rb.getString("client.version.unexpected");
                String[] versions = new String[]{latestClientVersion, sscsVersion};
                MessageFormat mf1 = new MessageFormat(loginResultMsg);
                loginResultMsg = mf1.format(versions) + "\n\n";
            }
        }
        HttpSession session = (HttpSession)argCtx.getProperty(Constants.BAG_HTTPSESSION);
        Trace.verbose((Object)this, (String)METHOD_NAME, (String)("SESSION maxinactiveInterval ORIG: " + session.getMaxInactiveInterval()));
        session.setMaxInactiveInterval(3600);
        Trace.verbose((Object)this, (String)METHOD_NAME, (String)("SESSION maxinactiveInterval NEW: " + session.getMaxInactiveInterval()));
        Repository rep = Repository.getRepository();
        String userRole = AuthorizationUtility.getInstance().getRole(argUser);
        userRole = userRole == null ? (userRole = argUser) : userRole;
        ActiveUserInfo aui = (ActiveUserInfo)((Object)rep.getProperty((Object)userRole));
        Object configContext = null;
        HttpServletRequest req = (HttpServletRequest)argCtx.getProperty(Constants.BAG_HTTPSERVLETREQUEST);
        try {
            if ("OZ".equals((String)rep.getProperty((Object)"array-type"))) {
                try {
                    UserDataObject data = new UserDataObject();
                    data.setUser(argUser);
                    data.setUserCredential(new PasswordCredential(argPass));
                    CliAuthenticator auth = new CliAuthenticator();
                    Subject subj = auth.cliLogin(req, (LoginData)data);
                }
                catch (ConsoleException ce) {
                    throw new UnauthorizedException("error.login.noaccess");
                }
            }
            configContext = super.initUserSession(argUser, argPass, loc);
            Trace.verbose((Object)this, (String)"initCLIUserSession", (String)("au: " + argUser));
            if (!AuthorizationUtility.getInstance().checkAuthName(argUser, this.getClass().getName())) {
                throw new UnauthorizedException("error.login.noaccess");
            }
        }
        catch (InvalidCredentials ie) {
            Trace.verbose((Object)this, (String)"initCLIUserSession", (Throwable)ie);
            loginResultMsg = loginResultMsg + rb.getString("error.login.failed." + ie.getExceptionKey());
            cr.setResult(loginResultMsg);
            cr.setErrorId("100");
            return;
        }
        catch (ConfigMgmtException cme) {
            Trace.verbose((Object)this, (String)"initCLIUserSession", (Throwable)cme);
            loginResultMsg = loginResultMsg + rb.getString("error.login.failed." + cme.getExceptionKey());
            cr.setResult(loginResultMsg);
            cr.setErrorId("100");
            return;
        }
        catch (UnauthorizedException ue) {
            Trace.verbose((Object)this, (String)"initCLIUserSession", (Throwable)ue);
            loginResultMsg = rb.getString(ue.getMessage());
            cr.setResult(loginResultMsg);
            cr.setErrorId("100");
            return;
        }
        String action = "";
        if (argForce) {
            action = "force";
        }
        if (!this.canEstablishAccess(aui, argUser, userRole, action)) {
            cr.setResult(rb.getString("login.UserAlreadyLoggedIn"));
            cr.setErrorId("100");
            if (!"OZ".equals((String)rep.getProperty((Object)"array-type"))) {
                try {
                    ((ConfigContext)configContext).getClient().close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            return;
        }
        aui = new ActiveUserInfo();
        aui.ipaddress = req.getRemoteAddr();
        aui.sessionId = session.getId();
        aui.clientType = "admin.users.list.clienttype.cli";
        aui.username = argUser;
        aui.role = userRole;
        aui.configContext = (ConfigContext)configContext;
        rep.setProperty((Object)argUser, (Object)aui);
        rep.setProperty((Object)session.getId(), (Object)aui);
        session.setAttribute("ConfigContext", configContext);
        ArrayKeyMap keyMap = new ArrayKeyMap((ConfigContext)configContext);
        session.setAttribute("ArrayKeyMap", (Object)keyMap);
        ArrayList au = (ArrayList)rep.getProperty((Object)"ActiveUsersListProperty");
        if (au != null) {
            au.add(session.getId());
            Trace.verbose((Object)this, (String)"initCLIUserSession", (String)("add [" + aui.username + "] to active users list"));
            Trace.verbose((Object)this, (String)"initCLIUserSession", (String)("there are now " + au.size() + " active users"));
        } else {
            Trace.verbose((Object)this, (String)"initCLIUserSession", (String)"Active users list property not found!! (SNH)");
        }
        if (loginResultMsg != null) {
            cr.setResult(loginResultMsg);
        }
        Trace.verbose((Object)this, (String)METHOD_NAME, (String)"Method end.");
    }

    public void exit(SOAPContext argCtx) {
        METHOD_NAME = "exit";
        Trace.methodBegin((Object)this, (String)METHOD_NAME);
        try {
            HttpSession session = (HttpSession)argCtx.getProperty(Constants.BAG_HTTPSESSION);
            if (session != null) {
                session.invalidate();
            }
        }
        catch (Exception e) {
            Trace.verbose((Object)this, (String)"Exception invalidating session", (Throwable)e);
        }
    }

    private CommandResult doLogin(ParsedCommandLine pcl, Locale locale, SOAPContext argCtx, ResourceBundle rb) throws UnauthorizedException, ConfigMgmtException {
        String METHOD_NAME = "doLogin";
        Trace.methodBegin((Object)this, (String)"doLogin");
        CommandResult cr = new CommandResult();
        List options = pcl.getOptions();
        String username = null;
        String password = null;
        String sscsVersion = "2.1.4";
        boolean force = false;
        Trace.verbose((Object)this, (String)"doLogin", (String)"Get login options");
        for (int i = 0; i < options.size(); ++i) {
            Option clo = (Option)options.get(i);
            Trace.verbose((Object)this, (String)"doLogin", (String)clo.getName());
            if (clo.getName().equals("-f") || clo.getName().equals("--force")) {
                force = true;
                continue;
            }
            if (clo.getName().equals("-u") || clo.getName().equals("--username")) {
                username = clo.getFirstValue();
                continue;
            }
            if (clo.getName().equals("--password")) {
                password = clo.getFirstValue();
                continue;
            }
            if (!clo.getName().equals("--sscsversion")) continue;
            sscsVersion = clo.getFirstValue();
        }
        HttpSession session = (HttpSession)argCtx.getProperty(Constants.BAG_HTTPSESSION);
        session.setAttribute("sscs.version", (Object)sscsVersion);
        if (username == null || password == null) {
            if (username == null) {
                Trace.verbose((Object)this, (String)"doLogin", (String)"Request username");
                cr.setErrorId("777");
                cr.setResult(rb.getString("login.EnterUsername"));
                session.setAttribute("cli.interactive.optionName", (Object)"--username");
            } else if (password == null) {
                Trace.verbose((Object)this, (String)"doLogin", (String)"Request password");
                cr.setErrorId("888");
                cr.setResult(rb.getString("login.EnterPassword"));
                session.setAttribute("cli.interactive.optionName", (Object)"--password");
            }
            return cr;
        }
        session.removeAttribute("cli.interactive.optionName");
        session.removeAttribute("user.input.phase");
        session.removeAttribute("cli.interactive.spec");
        session.removeAttribute("cli.interactive.pcl");
        this.initCLIUserSession(argCtx, username, password, force, sscsVersion, cr, rb, locale);
        return cr;
    }

    public CommandResult execute(ParsedCommandLine pcl, Locale locale, SOAPContext argCtx) {
        String METHOD_NAME = "execute";
        Trace.methodBegin((Object)this, (String)"execute");
        ResourceBundle rb = ResourceBundle.getBundle("com.sun.netstorage.array.mgmt.cfg.cli.ini.CLIResource", locale);
        String result = "";
        String mName = pcl.getResource().getFirstValue();
        CommandResult cr = new CommandResult();
        if (pcl.getCommandName().equals("login")) {
            try {
                cr = this.doLogin(pcl, locale, argCtx, rb);
            }
            catch (Exception ue) {
                Trace.verbose((Object)this, (String)"execute", (Throwable)ue);
                cr.setErrorId("100");
                cr.setResult(rb.getString("cli.system.error"));
            }
        } else {
            this.exit(argCtx);
        }
        return cr;
    }
}

