/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.core;

import com.sun.netstorage.array.mgmt.cfg.cli.core.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ValidationException;
import com.sun.netstorage.array.mgmt.cfg.cli.server.validator.date.DateParser;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.logger.SOAPLogClient;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.soap.rpc.SOAPContext;

public class LogProcessor
extends CommandProcessorBase {
    private static final int ALL_LOG_ENTRIES = -1;

    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws UnauthorizedException, ParseException, ValidationException {
        String METHOD_NAME = "doList";
        Trace.methodBegin((Object)this, (String)"doList");
        int tail = -1;
        String startDate = null;
        String finishDate = null;
        List options = pcl.getOptions();
        if (options != null && options.size() > 0) {
            for (int i = 0; i < options.size(); ++i) {
                Option option = (Option)options.get(i);
                if ("-t".equals(option.getName()) || "--tail".equals(option.getName())) {
                    tail = Integer.parseInt(option.getFirstValue());
                    continue;
                }
                if ("-s".equals(option.getName()) || "--start".equals(option.getName())) {
                    startDate = option.getFirstValue();
                    continue;
                }
                if (!"-f".equals(option.getName()) && !"--finish".equals(option.getName())) continue;
                finishDate = option.getFirstValue();
            }
        }
        List entries = this.listLog(argContext, locale.toString(), startDate, finishDate, tail);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < entries.size(); ++i) {
            sb.append((String)entries.get(i) + "\n");
        }
        CommandResult result = new CommandResult();
        result.setResult(sb.toString());
        return result;
    }

    public List listLog(SOAPContext argContext, String argLocale, String start, String finish, int tail) throws ParseException, ValidationException, UnauthorizedException {
        String METHOD_NAME = "listLog";
        Trace.methodBegin((Object)this, (String)"listLog");
        Trace.verbose((Object)this, (String)"listLog", (String)("Start: " + start + " Finish:" + finish + " Tail:" + tail));
        ConfigContext client = this.getConfigContext(argContext);
        int severity = -1;
        List result = this.getLogEvents(argLocale);
        if (result.isEmpty()) {
            return result;
        }
        Date serverDate = null;
        TimeZone timezone = null;
        Locale locale = new Locale(argLocale);
        serverDate = Calendar.getInstance().getTime();
        timezone = TimeZone.getDefault();
        result = this.formatLogEntries(result, locale, timezone, true);
        if (start != null || finish != null) {
            String firstLogEntry = (String)result.get(0);
            String lastLogEntry = null;
            lastLogEntry = result.size() > 0 ? (String)result.get(result.size() - 1) : firstLogEntry;
            if (start != null || finish != null) {
                Date startDate = this.makeDate(start, timezone, locale, serverDate, firstLogEntry);
                Date finishDate = this.makeDate(finish, timezone, locale, serverDate, lastLogEntry);
                result = this.getEntriesForDateRange(result, locale, startDate, finishDate, timezone);
            }
        }
        result = this.getTail(tail, result);
        return result;
    }

    private Date makeDate(String dateString, TimeZone timezone, Locale locale, Date serverDate, String firstLogEntry) throws ParseException, ValidationException {
        Date date;
        DateParser parser = DateParser.getInstance();
        if (dateString != null) {
            Calendar calendar = Calendar.getInstance(timezone, locale);
            calendar.setTime(serverDate);
            date = parser.parseDate(dateString, calendar).getTime();
        } else {
            date = this.parseLogEventRecordDate(this.parseLogEventRecordDateString(firstLogEntry), 1, 2, locale, timezone);
        }
        return date;
    }

    private String parseLogEventRecordDateString(String record) {
        return record.substring(0, record.lastIndexOf(":"));
    }

    private List getEntriesForDateRange(List logList, Locale locale, Date startDate, Date finishDate, TimeZone timezone) throws ParseException {
        Vector logEntriesWithinRange = new Vector();
        for (int i = 0; i < logList.size(); ++i) {
            String currDateStr = this.parseLogEventRecordDateString((String)logList.get(i));
            Date currDate = this.parseLogEventRecordDate(currDateStr, 1, 2, locale, timezone);
            if (currDate.getTime() < startDate.getTime() || currDate.getTime() > finishDate.getTime()) continue;
            logEntriesWithinRange.add(logList.get(i));
        }
        return logEntriesWithinRange;
    }

    private List getTail(int tail, List theList) {
        int tailStart;
        if (tail <= 0 || tail >= theList.size()) {
            return theList;
        }
        Vector requestedRecords = new Vector();
        for (int i = tailStart = theList.size() - tail; i < theList.size(); ++i) {
            requestedRecords.add(theList.get(i));
        }
        return requestedRecords;
    }

    private Date parseLogEventRecordDate(String date, int dateStyle, int timeStyle, Locale locale, TimeZone timezone) throws ParseException {
        DateFormat df = DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
        df.setTimeZone(timezone);
        return df.parse(date);
    }

    public List getLogEvents(String locale) {
        String METHOD_NAME = "getLogEvents";
        Trace.methodBegin((Object)this, (String)"getLogEvents");
        SOAPLogClient logClient = new SOAPLogClient();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 9; i > 0; --i) {
            String[] entries = logClient.translate(i, locale);
            Trace.verbose((Object)this, (String)"getLogEvents", (String)("from file " + i + ", obtained number of records: " + entries.length));
            for (int j = 0; j < entries.length; ++j) {
                list.add(entries[j]);
            }
        }
        return list;
    }

    public List formatLogEntries(List result, Locale locale, TimeZone timezone, boolean returnShort) {
        Vector<String> formatted = new Vector<String>();
        for (int i = 0; i < result.size(); ++i) {
            String firstToken;
            String row = (String)result.get(i);
            StringTokenizer st = new StringTokenizer(row, "|");
            String timeZoneDate = firstToken = st.nextToken();
            String secondToken = st.nextToken();
            String thirdToken = st.nextToken();
            if (!TimeZone.getDefault().hasSameRules(timezone)) {
                try {
                    Date timeZoneDateObj = Convert.stringToDateTime((String)firstToken, (TimeZone)TimeZone.getDefault(), (int)1, (Locale)locale);
                    timeZoneDate = Convert.dateTimeToString((Date)timeZoneDateObj, (TimeZone)timezone, (int)1, (Locale)locale);
                }
                catch (ParseException pe) {
                    // empty catch block
                }
            }
            if (returnShort) {
                formatted.add(timeZoneDate + ":" + thirdToken);
                continue;
            }
            formatted.add(timeZoneDate + "|" + secondToken + "|" + thirdToken);
        }
        return formatted;
    }
}

