/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.core;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ListFormatter {
    private ArrayList namesList = null;
    private ArrayList valuesList = null;
    private String defaultBundle = null;
    private Locale locale = null;
    private int minPadding = -1;
    private int maxNameLength = -1;
    private ResourceBundle _resource = null;

    public ListFormatter(String aBundlePath, Locale aLocale, int aPaddingValue) {
        this.defaultBundle = aBundlePath;
        this.minPadding = aPaddingValue;
        this.locale = aLocale;
        this.namesList = new ArrayList();
        this.valuesList = new ArrayList();
        this.maxNameLength = 0;
        this._resource = ResourceBundle.getBundle(this.defaultBundle, this.locale);
    }

    public void addLine(String aKey, String aValue) {
        this.addLine(aKey, aValue, this.defaultBundle);
    }

    public void addLine(String aKey, int aValue) {
        this.addLine(aKey, Integer.toString(aValue), this.defaultBundle);
    }

    public void addLine(String aKey, boolean aValue) {
        this.addLine(aKey, Boolean.toString(aValue), this.defaultBundle);
    }

    public void addLine(String aKey, String aValue, String aBundlePath) {
        String name = this.getResourceString(aBundlePath, this.locale, aKey);
        if (name.length() > this.maxNameLength) {
            this.maxNameLength = name.length();
        }
        this.namesList.add(name);
        this.valuesList.add(aValue);
    }

    public String getList() {
        StringWriter writer = new StringWriter();
        for (int i = 0; i < this.namesList.size(); ++i) {
            String value;
            String name = (String)this.namesList.get(i);
            try {
                value = (String)this.valuesList.get(i);
            }
            catch (IndexOutOfBoundsException iobe) {
                value = " ";
            }
            writer.write(name);
            int padCount = this.minPadding + (this.maxNameLength - name.length());
            for (int j = 0; j < padCount; ++j) {
                writer.write(" ");
            }
            writer.write(value == null ? " " : value);
            writer.write(System.getProperty("line.separator"));
        }
        return writer.toString();
    }

    public String getResourceString(String bundle, Locale locale, String key) {
        String localized = null;
        try {
            localized = this._resource.getString(key);
        }
        catch (MissingResourceException mre) {
            localized = key;
        }
        return localized;
    }
}

