/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.core;

import com.sun.netstorage.array.mgmt.cfg.bui.utilities.LocalizationUtil;
import com.sun.netstorage.array.mgmt.cfg.cli.core.ResourceLocator;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandProcessor;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandSpecRepository;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Resource;
import com.sun.netstorage.array.mgmt.cfg.cli.server.specification.CommandSpec;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.soap.rpc.SOAPContext;

public class HelpProcessor
implements CommandProcessor {
    CommandSpecRepository repository;

    public CommandResult execute(ParsedCommandLine pcl, Locale locale, SOAPContext argCtx) throws Exception {
        String METHOD_NAME = "execute";
        Trace.methodBegin((Object)this, (String)"execute");
        this.repository = CommandSpecRepository.getInstance();
        CommandResult cr = new CommandResult();
        String help = this.getGeneralHelp(locale);
        List options = pcl.getOptions();
        if (options != null && !options.isEmpty()) {
            String command = null;
            String resource = null;
            for (int i = 0; i < options.size(); ++i) {
                Option o = (Option)options.get(i);
                String name = o.getName();
                if (name.startsWith("-c")) {
                    command = (String)o.getValues().get(0);
                    continue;
                }
                if (!name.startsWith("-r")) continue;
                resource = (String)o.getValues().get(0);
            }
            if (command != null) {
                Trace.verbose((Object)this, (String)"execute", (String)"command is non-null");
                if (resource != null) {
                    Trace.verbose((Object)this, (String)"execute", (String)"command is non-null");
                    help = this.getHelpForCommandAndResource(locale, command, resource);
                } else {
                    help = this.getHelpForCommand(locale, command);
                }
            }
        }
        CommandSpec spec = (CommandSpec)this.repository.getSpecForCommand(pcl);
        Trace.verbose((Object)this, (String)"execute", (String)("setting result: " + help));
        cr.setResult(help);
        return cr;
    }

    public CommandResult executeHelp(ParsedCommandLine pcl, Locale locale, SOAPContext argCtx, String option) throws Exception {
        String METHOD_NAME = "executeHelp";
        Trace.methodBegin((Object)this, (String)"executeHelp");
        this.repository = CommandSpecRepository.getInstance();
        ResourceBundle resourceLocal = ResourceBundle.getBundle("com.sun.netstorage.array.mgmt.cfg.cli.ini.CLIResource", locale);
        CommandResult cr = new CommandResult();
        String help = null;
        String command = null;
        String resource = null;
        String message = null;
        StringBuffer resMsg = new StringBuffer();
        if (pcl == null || pcl.getCommandName() == null) {
            Trace.verbose((Object)this, (String)"executeHelp", (String)"pcl or cmd or res is null");
            message = option == null ? LocalizationUtil.localizeString(resourceLocal, "error.parsing.commands_msg") : option;
            help = this.getGeneralHelp(locale);
            resMsg.append(message).append("\n").append(help);
            cr.setResult(resMsg.toString());
            cr.setErrorId("25");
            return cr;
        }
        command = pcl.getCommandName();
        if (pcl.getResource() != null) {
            resource = pcl.getResource().getType();
        }
        if (command != null) {
            Trace.verbose((Object)this, (String)"executeHelp", (String)"command non-null");
            if (resource != null && !resource.equalsIgnoreCase("none")) {
                Trace.verbose((Object)this, (String)"executeHelp", (String)"resource non-null");
                if (option != null && (option.endsWith(LocalizationUtil.localizeString(resourceLocal, "error.validation.requiredOptionMissing")) || option.endsWith(LocalizationUtil.localizeString(resourceLocal, "error.validation.invalidDateFormat")) || option.endsWith(LocalizationUtil.localizeString(resourceLocal, "error.validation.invalidIpFormat")) || option.endsWith(LocalizationUtil.localizeString(resourceLocal, "error.validation.invalidNetmaskFormat")) || option.endsWith(LocalizationUtil.localizeString(resourceLocal, "error.validation.invalidEmailAddressFormat")) || option.endsWith(LocalizationUtil.localizeString(resourceLocal, "error.validation.invalidEmailAddressFormat")) || option.endsWith(LocalizationUtil.localizeString(resourceLocal, "error.validation.optionListValuesNotAllowed")) || option.endsWith(LocalizationUtil.localizeString(resourceLocal, "error.general.validatorNotFound")) || option.endsWith(LocalizationUtil.localizeString(resourceLocal, "error.validation.illegalResourceValue")) || option.endsWith(LocalizationUtil.localizeString(resourceLocal, "error.validation.illegalOptionValue")) || option.endsWith(LocalizationUtil.localizeString(resourceLocal, "error.validation.unknownOption")) || option.endsWith(LocalizationUtil.localizeString(resourceLocal, "error.validation.missingOptionValue")) || option.endsWith(LocalizationUtil.localizeString(resourceLocal, "error.validation.resourceValueNotAllowed")) || option.equals(LocalizationUtil.localizeString(resourceLocal, "error.validation.missingResourceValue")))) {
                    message = option + "\n";
                    Trace.verbose((Object)this, (String)"executeHelp", (String)("setting message1: " + message));
                } else {
                    message = option + "\n";
                    Trace.verbose((Object)this, (String)"executeHelp", (String)("setting message2: " + message));
                }
                Trace.verbose((Object)this, (String)"executeHelp", (String)"pre setting help");
                try {
                    help = this.getHelpForCommandAndResource(locale, command, resource);
                }
                catch (Exception e) {
                    message = LocalizationUtil.localizeString(resourceLocal, "error.parsing.resources_msg");
                    help = this.getHelpForCommand(locale, command);
                }
                Trace.verbose((Object)this, (String)"executeHelp", (String)("setting help: " + help));
            } else {
                message = LocalizationUtil.localizeString(resourceLocal, "error.parsing.resources_msg");
                help = this.getHelpForCommand(locale, command);
                Trace.verbose((Object)this, (String)"executeHelp", (String)("setting both: " + message + "," + help));
            }
        }
        Trace.verbose((Object)this, (String)"executeHelp", (String)("setting resMsg: " + message + "," + help));
        resMsg.append(message).append(help);
        cr.setResult(resMsg.toString());
        cr.setErrorId("25");
        return cr;
    }

    private String getGeneralHelp(Locale locale) {
        StringBuffer sb = new StringBuffer();
        List knownCommands = this.repository.getKnownCommands();
        for (int i = 0; i < knownCommands.size(); ++i) {
            sb.append(knownCommands.get(i)).append("\t").append("\n");
        }
        return sb.toString();
    }

    private String getHelpForCommand(Locale locale, String commandName) {
        String METHOD_NAME = "getHelpForCommand";
        Trace.methodBegin((Object)this, (String)"getHelpForCommand");
        StringBuffer sb = new StringBuffer();
        sb.append(commandName).append("\n");
        List knownSpecs = this.repository.getAllSpecsForCommandName(commandName);
        for (int i = 0; i < knownSpecs.size(); ++i) {
            sb.append("\t");
            sb.append(((CommandSpec)knownSpecs.get(i)).getResourceSpec().getResourceType());
            sb.append("\n");
        }
        sb.append("\n").append(ResourceLocator.getManPage(commandName, locale));
        sb.append("\n");
        return sb.toString();
    }

    private String getHelpForCommandAndResource(Locale locale, String commandName, String resourceName) throws Exception {
        String METHOD_NAME = "getHelpForCommandAndResource";
        Trace.methodBegin((Object)this, (String)"getHelpForCommandAndResource");
        Trace.verbose((Object)this, (String)"getHelpForCommandAndResource", (String)("command: " + commandName));
        Trace.verbose((Object)this, (String)"getHelpForCommandAndResource", (String)("resource: " + resourceName));
        ParsedCommandLine pcl = new ParsedCommandLine();
        pcl.setCommandName(commandName);
        Resource res = new Resource();
        res.setType(resourceName);
        pcl.setResource(res);
        CommandSpec spec = null;
        spec = (CommandSpec)this.repository.getSpecForCommand(pcl);
        return spec.usage(locale, true) + "\n" + ResourceLocator.getManPage(commandName, resourceName, locale) + "\n";
    }
}

