/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.core;

import com.sun.netstorage.array.mgmt.cfg.cli.core.ArrayKeyMap;
import com.sun.netstorage.array.mgmt.cfg.cli.core.BaseProps;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandProcessor;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ErrorBean;
import com.sun.netstorage.array.mgmt.cfg.cli.server.LocaleAware;
import com.sun.netstorage.array.mgmt.cfg.cli.server.Option;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.CoreManagedObjectInterface;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.LogicalObjectManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.core.ManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.ActiveUserInfo;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.MenuData;
import com.sun.netstorage.array.mgmt.cfg.util.Comparators;
import com.sun.netstorage.array.mgmt.cfg.util.FilterUtil;
import com.sun.netstorage.array.mgmt.cfg.util.FilteringResult;
import com.sun.netstorage.array.mgmt.cfg.util.NameBasedComparator;
import com.sun.netstorage.mgmt.dm.util.authorization.AuthorizationUtility;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.servlet.http.HttpSession;
import org.apache.soap.Constants;
import org.apache.soap.rpc.SOAPContext;

public class CommandProcessorBase
implements CommandProcessor {
    private static final String NOT_IMPLEMENTED = "error.methodNotImplemented";
    public static final String COMMON_RESOURCE_BUNDLE = "com.sun.netstorage.array.mgmt.cfg.cli.ini.CLIResource";
    private SOAPContext sOAPContext = null;
    private Locale locale = null;
    protected Scope _scope = null;
    protected String _arrayKey = null;
    protected String _arrayName = null;

    protected Locale getLocale() {
        return this.locale;
    }

    protected SOAPContext getSOAPContext() {
        return this.sOAPContext;
    }

    public void setSOAPContext(SOAPContext val) {
        this.sOAPContext = val;
    }

    public CommandResult execute(ParsedCommandLine pcl, Locale locale, SOAPContext argCtx) throws Exception {
        String METHOD_NAME = "execute";
        Trace.methodBegin((Object)this, (String)"execute");
        this.sOAPContext = argCtx;
        this.locale = locale;
        CommandResult cr = null;
        String subcommand = pcl.getCommandName();
        if (subcommand.equals("add")) {
            cr = this.doAdd(locale, pcl, argCtx);
        } else if (subcommand.equals("create")) {
            cr = this.doCreate(locale, pcl, argCtx);
        } else if (subcommand.equals("delete")) {
            cr = this.doDelete(locale, pcl, argCtx);
        } else if (subcommand.equals("export")) {
            cr = this.doExport(locale, pcl, argCtx);
        } else if (subcommand.equals("fail")) {
            cr = this.doFail(locale, pcl, argCtx);
        } else if (subcommand.equals("import")) {
            cr = this.doImport(locale, pcl, argCtx);
        } else if (subcommand.equals("list")) {
            cr = this.doList(locale, pcl, argCtx);
        } else if (subcommand.equals("map")) {
            cr = this.doMap(locale, pcl, argCtx);
        } else if (subcommand.equals("modify")) {
            cr = this.doModify(locale, pcl, argCtx);
        } else if (subcommand.equals("offline")) {
            cr = this.doOffline(locale, pcl, argCtx);
        } else if (subcommand.equals("online")) {
            cr = this.doOnline(locale, pcl, argCtx);
        } else if (subcommand.equals("reconstruct")) {
            cr = this.doReconstruct(locale, pcl, argCtx);
        } else if (subcommand.equals("revive")) {
            cr = this.doRevive(locale, pcl, argCtx);
        } else if (subcommand.equals("reset")) {
            cr = this.doReset(locale, pcl, argCtx);
        } else if (subcommand.equals("remove")) {
            cr = this.doRemove(locale, pcl, argCtx);
        } else if (subcommand.equals("snapshot")) {
            cr = this.doSnapshot(locale, pcl, argCtx);
        } else if (subcommand.equals("unmap")) {
            cr = this.doUnmap(locale, pcl, argCtx);
        }
        if (cr == null) {
            cr.setResult(new ErrorBean(subcommand, NOT_IMPLEMENTED).toString(locale));
            cr.setErrorId("100");
        }
        return cr;
    }

    protected ResourceBundle getCommonResourceBundle(Locale locale) {
        return ResourceBundle.getBundle(COMMON_RESOURCE_BUNDLE, locale);
    }

    protected ManagerInterface getManager() {
        String METHOD_NAME = "empty getManager";
        Trace.methodBegin((Object)this, (String)"empty getManager");
        return null;
    }

    protected void initializeManager(SOAPContext argContext) throws UnauthorizedException, ConfigMgmtException, SEItemNotFoundException {
        String METHOD_NAME = "empty initializeManager";
        Trace.methodBegin((Object)this, (String)"empty initializeManager");
    }

    protected void setScope(ParsedCommandLine pcl) throws UnauthorizedException, ConfigMgmtException, SEItemNotFoundException {
        String METHOD_NAME = "setScope";
        Trace.methodBegin((Object)this, (String)"setScope");
        Option arrayOption = pcl.getOptionByName("-a", "--array");
        if (arrayOption != null) {
            String array = arrayOption.getFirstValue();
            this.setScope(array);
        }
    }

    public void setScope(String array) throws ConfigMgmtException, UnauthorizedException, SEItemNotFoundException {
        if (array != null) {
            this._scope = new Scope();
            this._arrayName = array;
            ArrayKeyMap map = this.getArrayKeys(this.getSOAPContext());
            try {
                this._arrayKey = map.getKey(array);
            }
            catch (SEItemNotFoundException e) {
                HttpSession session = (HttpSession)this.sOAPContext.getProperty(Constants.BAG_HTTPSESSION);
                session.removeAttribute("cli.interactive.optionName");
                session.removeAttribute("user.input.phase");
                session.removeAttribute("cli.interactive.spec");
                session.removeAttribute("cli.interactive.pcl");
                throw e;
            }
            this._scope.setAttribute("array", (Object)this._arrayKey);
        }
    }

    protected CommandResult doCreate(Locale locale, ParsedCommandLine pcl, SOAPContext argCtx) throws UnauthorizedException, ConfigMgmtException, SEItemNotFoundException, Exception {
        String METHOD_NAME = "doCreate";
        Trace.methodBegin((Object)this, (String)"doCreate");
        this.checkCreatePermission(argCtx);
        this.setScope(pcl);
        this.initializeManager(argCtx);
        Properties props = this.getCreateProperties(pcl);
        List errors = this.create(props);
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    protected boolean checkCreatePermission(SOAPContext argContext) throws UnauthorizedException, ConfigMgmtException {
        String METHOD_NAME = "default checkCreatePermission";
        Trace.methodBegin((Object)this, (String)"default checkCreatePermission");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        return true;
    }

    protected Properties getCreateProperties(ParsedCommandLine pcl) throws Exception {
        String METHOD_NAME = "empty getCreateProperties";
        Trace.methodBegin((Object)this, (String)"empty getCreateProperties");
        return new Properties();
    }

    protected List create(Properties props) throws UnauthorizedException, ConfigMgmtException, SEItemNotFoundException {
        String METHOD_NAME = "create";
        Trace.methodBegin((Object)this, (String)"create");
        ArrayList errors = new ArrayList();
        LogicalObjectManagerInterface mgr = (LogicalObjectManagerInterface)this.getManager();
        mgr.create(props);
        return errors;
    }

    protected CommandResult doDelete(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws UnauthorizedException, ConfigMgmtException, SEItemNotFoundException {
        String METHOD_NAME = "doDelete";
        Trace.methodBegin((Object)this, (String)"doDelete");
        this.checkDeletePermission(argContext);
        this.setScope(pcl);
        this.initializeManager(argContext);
        List errors = this.delete(pcl.getResource().getValues());
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    protected boolean checkDeletePermission(SOAPContext argContext) throws UnauthorizedException, ConfigMgmtException {
        String METHOD_NAME = "default checkDeletePermission";
        Trace.methodBegin((Object)this, (String)"default checkDeletePermission");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        return true;
    }

    protected List delete(List names) throws ConfigMgmtException {
        return this.delete(names, Comparators.CORE_MANAGED_OBJECT_COMPARATOR);
    }

    protected List delete(List names, NameBasedComparator comparator) throws ConfigMgmtException {
        String METHOD_NAME = "delete";
        Trace.methodBegin((Object)this, (String)"delete");
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        LogicalObjectManagerInterface mgr = (LogicalObjectManagerInterface)this.getManager();
        FilteringResult fr = FilterUtil.filterNamedObjects((List)names, (List)mgr.getItemList(), (NameBasedComparator)comparator);
        Iterator notFoundIter = fr.getNotFoundItems().iterator();
        while (notFoundIter.hasNext()) {
            String notFoundName = (String)notFoundIter.next();
            errors.add(new ErrorBean(notFoundName, "error.objectNotFound"));
        }
        List objectsToDelete = fr.getFoundItems();
        ArrayList<String> keysToDelete = new ArrayList<String>();
        for (int i = 0; i < objectsToDelete.size(); ++i) {
            CoreManagedObjectInterface obj = (CoreManagedObjectInterface)objectsToDelete.get(i);
            keysToDelete.add(obj.getKeyAsString());
        }
        this.delete(mgr, objectsToDelete, keysToDelete, errors);
        return errors;
    }

    protected void delete(LogicalObjectManagerInterface mgr, List objectsToDelete, List keysToDelete, List errors) throws ConfigMgmtException {
        String METHOD_NAME = "delete";
        Trace.verbose((Object)this, (String)"delete", (String)("delete " + keysToDelete.size()));
        if (keysToDelete.size() != 0) {
            MethodCallStatus mcs = mgr.delete(keysToDelete);
            if (mcs == null) {
                Trace.verbose((Object)this, (String)"delete", (String)"mgr.delete not implemented");
                return;
            }
            this.handleMCS(mcs, objectsToDelete, errors);
        } else {
            Trace.verbose((Object)this, (String)"delete", (String)"Nothing to be deleted");
        }
    }

    protected void handleMCS(MethodCallStatus mcs, List objects, List errors) {
        String METHOD = "handleMCS";
        List eds = mcs.getErrorDescList();
        for (int i = 0; i < eds.size(); ++i) {
            CoreManagedObjectInterface obj;
            ErrorDescriptor ed;
            int objectSize = 0;
            if (objects != null) {
                objectSize = objects.size();
            }
            if ((ed = (ErrorDescriptor)eds.get(i)).getErrorCode() == ErrorDescriptor.ERROR_SUCCESS) continue;
            Trace.verbose((Object)this, (String)"handleMCS", (String)ed.getMsg());
            String theObject = null;
            String[] params = ed.getI18nParams();
            if (params != null && params.length > 0 && params[0] != null) {
                theObject = params[0];
            } else if (objectSize == 1) {
                Trace.verbose((Object)this, (String)"handleMCS", (String)"BOL failed to set MCS object");
                obj = (CoreManagedObjectInterface)objects.get(0);
                theObject = obj.getName();
            } else if (objectSize > i) {
                Trace.verbose((Object)this, (String)"handleMCS", (String)"BOL failed to set MCS object");
                obj = (CoreManagedObjectInterface)objects.get(i);
                theObject = obj.getName();
            }
            errors.add(new ErrorBean(theObject, "error.reason." + ed.getErrorCode()));
        }
    }

    protected CommandResult doAdd(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        result.setResult(new ErrorBean("doAdd", NOT_IMPLEMENTED).toString(locale));
        return result;
    }

    protected boolean checkAddPermission(SOAPContext argContext) throws UnauthorizedException, ConfigMgmtException {
        String METHOD_NAME = "default checkAddPermission";
        Trace.methodBegin((Object)this, (String)"default checkAddPermission");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        return true;
    }

    protected CommandResult doRemove(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        result.setResult(new ErrorBean("doRemove", NOT_IMPLEMENTED).toString(locale));
        return result;
    }

    protected CommandResult doReset(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        result.setResult(new ErrorBean("doReset", NOT_IMPLEMENTED).toString(locale));
        return result;
    }

    protected CommandResult doFail(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        result.setResult(new ErrorBean("doFail", NOT_IMPLEMENTED).toString(locale));
        return result;
    }

    protected CommandResult doRevive(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        result.setResult(new ErrorBean("doRevive", NOT_IMPLEMENTED).toString(locale));
        return result;
    }

    protected CommandResult doReconstruct(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        result.setResult(new ErrorBean("doReconstruct", NOT_IMPLEMENTED).toString(locale));
        return result;
    }

    protected CommandResult doOffline(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        result.setResult(new ErrorBean("doOffline", NOT_IMPLEMENTED).toString(locale));
        return result;
    }

    protected CommandResult doOnline(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        result.setResult(new ErrorBean("doOnline", NOT_IMPLEMENTED).toString(locale));
        return result;
    }

    protected boolean checkRemovePermission(SOAPContext argContext) throws UnauthorizedException, ConfigMgmtException {
        String METHOD_NAME = "default checkRemovePermission";
        Trace.methodBegin((Object)this, (String)"default checkRemovePermission");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        return true;
    }

    protected CommandResult doMap(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        result.setResult(new ErrorBean("doMap", NOT_IMPLEMENTED).toString(locale));
        return result;
    }

    protected CommandResult doUnmap(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        result.setResult(new ErrorBean("doUnmap", NOT_IMPLEMENTED).toString(locale));
        return result;
    }

    protected CommandResult doSnapshot(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        result.setResult(new ErrorBean("doSnapshot", NOT_IMPLEMENTED).toString(locale));
        return result;
    }

    protected CommandResult doModify(Locale locale, ParsedCommandLine pcl, SOAPContext argCtx) throws UnauthorizedException, ConfigMgmtException, SEItemNotFoundException, Exception {
        String METHOD_NAME = "doModify";
        Trace.methodBegin((Object)this, (String)"doModify");
        this.checkModifyPermission(argCtx);
        this.setScope(pcl);
        this.initializeManager(argCtx);
        Properties props = this.getModifyProperties(pcl);
        List errors = this.modify(pcl.getResource().getFirstValue(), props);
        CommandResult result = new CommandResult();
        this.processResults(locale, result, errors);
        return result;
    }

    protected boolean checkModifyPermission(SOAPContext argContext) throws UnauthorizedException, ConfigMgmtException {
        String METHOD_NAME = "default checkModifyPermission";
        Trace.methodBegin((Object)this, (String)"default checkModifyPermission");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        return true;
    }

    protected Properties getModifyProperties(ParsedCommandLine pcl) throws Exception {
        String METHOD_NAME = "empty getModifyProperties";
        Trace.methodBegin((Object)this, (String)"empty getModifyProperties");
        return new Properties();
    }

    protected List modify(String name, Properties props) throws SEItemNotFoundException, ConfigMgmtException, UnauthorizedException {
        String METHOD_NAME = "modify";
        Trace.methodBegin((Object)this, (String)"modify");
        ArrayList errors = new ArrayList();
        ManagerInterface mgr = this.getManager();
        List allObjects = mgr.getItemList();
        CoreManagedObjectInterface obj = null;
        boolean found = false;
        for (int j = 0; j < allObjects.size(); ++j) {
            obj = (CoreManagedObjectInterface)allObjects.get(j);
            if (!obj.getName().equals(name)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new SEItemNotFoundException(name);
        }
        mgr.modify((Object)obj.getKeyAsString(), props);
        return errors;
    }

    protected CommandResult doList(Locale locale, ParsedCommandLine pcl, SOAPContext argCtx) throws UnauthorizedException, ConfigMgmtException, SEItemNotFoundException, Exception {
        String METHOD_NAME = "doList";
        Trace.methodBegin((Object)this, (String)"doList");
        this.checkListPermission(argCtx);
        this.setScope(pcl);
        this.initializeManager(argCtx);
        List props = this.list(pcl.getResource().getValues());
        CommandResult result = new CommandResult();
        this.processResults(locale, result, props);
        return result;
    }

    protected boolean checkListPermission(SOAPContext argContext) throws UnauthorizedException, ConfigMgmtException {
        String METHOD_NAME = "default checkListPermission";
        Trace.methodBegin((Object)this, (String)"default checkListPermission");
        return true;
    }

    protected List list(List names) throws ConfigMgmtException {
        return this.list(names, Comparators.CORE_MANAGED_OBJECT_COMPARATOR);
    }

    protected List list(List names, NameBasedComparator comparator) throws ConfigMgmtException {
        String METHOD_NAME = "list";
        Trace.methodBegin((Object)this, (String)"list");
        ArrayList<LocaleAware> result = new ArrayList<LocaleAware>();
        List objectsToList = null;
        ArrayList allObjects = this.getManager().getItemList();
        if (null == allObjects) {
            allObjects = new ArrayList();
        }
        boolean showDetails = false;
        if (names == null || names.isEmpty()) {
            objectsToList = allObjects;
        } else {
            showDetails = true;
            FilteringResult fr = FilterUtil.filterNamedObjects((List)names, allObjects, (NameBasedComparator)comparator);
            objectsToList = fr.getFoundItems();
            Iterator notFoundIter = fr.getNotFoundItems().iterator();
            while (notFoundIter.hasNext()) {
                String notFoundName = (String)notFoundIter.next();
                result.add(new ErrorBean(notFoundName, "error.objectNotFound"));
            }
        }
        for (int i = 0; i < objectsToList.size(); ++i) {
            CoreManagedObjectInterface obj = (CoreManagedObjectInterface)objectsToList.get(i);
            result.add(this.buildProps(obj, showDetails));
        }
        return result;
    }

    protected LocaleAware buildProps(CoreManagedObjectInterface obj, boolean showDetails) {
        BaseProps props = new BaseProps();
        props.setName(obj.getName());
        props.setShowDetails(false);
        return props;
    }

    protected CommandResult doExport(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        result.setResult(new ErrorBean("doExport", NOT_IMPLEMENTED).toString(locale));
        return result;
    }

    protected CommandResult doImport(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws Exception {
        CommandResult result = new CommandResult();
        result.setResult(new ErrorBean("doImport", NOT_IMPLEMENTED).toString(locale));
        return result;
    }

    protected void processResults(Locale locale, CommandResult result, List toProcess) {
        StringBuffer sb = new StringBuffer();
        boolean hasErrors = false;
        for (int i = 0; i < toProcess.size(); ++i) {
            Object bean = toProcess.get(i);
            if (bean instanceof ErrorBean) {
                hasErrors = true;
            }
            sb.append(((LocaleAware)bean).toString(locale)).append("\n");
        }
        result.setResult(sb.toString());
        if (hasErrors) {
            result.setErrorId("100");
        }
    }

    protected ArrayKeyMap getArrayKeys(SOAPContext context) throws UnauthorizedException {
        ActiveUserInfo aui;
        HttpSession session = (HttpSession)context.getProperty(Constants.BAG_HTTPSESSION);
        ArrayKeyMap theMap = (ArrayKeyMap)session.getAttribute("ArrayKeyMap");
        String sessionId = session.getId();
        Repository rep = Repository.getRepository();
        ActiveUserInfo activeUserInfo = aui = rep.getProperty((Object)sessionId) == null ? new ActiveUserInfo() : (ActiveUserInfo)((Object)rep.getProperty((Object)sessionId));
        if (aui.isLoggedOff) {
            theMap = null;
            session.invalidate();
            throw new UnauthorizedException("error.user.session.userForcedOut");
        }
        if (theMap == null) {
            throw new UnauthorizedException("error.user.session.userNotLoggedIn");
        }
        return theMap;
    }

    protected ConfigContext getConfigContext(SOAPContext context) throws UnauthorizedException {
        ActiveUserInfo aui;
        if (context == null) {
            return null;
        }
        HttpSession session = (HttpSession)context.getProperty(Constants.BAG_HTTPSESSION);
        ConfigContext client = (ConfigContext)session.getAttribute("ConfigContext");
        String sessionId = session.getId();
        Repository rep = Repository.getRepository();
        ActiveUserInfo activeUserInfo = aui = rep.getProperty((Object)sessionId) == null ? new ActiveUserInfo() : (ActiveUserInfo)((Object)rep.getProperty((Object)sessionId));
        if (aui.isLoggedOff) {
            client = null;
            session.invalidate();
            throw new UnauthorizedException("error.user.session.userForcedOut");
        }
        if (client == null) {
            throw new UnauthorizedException("error.user.session.userNotLoggedIn");
        }
        return client;
    }

    protected void checkIfReadOnly(SOAPContext argContext, String pageIdentifier) throws ConfigMgmtException, UnauthorizedException {
        ConfigContext context = this.getConfigContext(argContext);
        HttpSession session = (HttpSession)argContext.getProperty(Constants.BAG_HTTPSESSION);
        Repository rep = Repository.getRepository();
        ActiveUserInfo aui = (ActiveUserInfo)((Object)rep.getProperty((Object)session.getId()));
        if (!AuthorizationUtility.getInstance().checkAuthName(aui.username, pageIdentifier)) {
            session.removeAttribute("cli.interactive.optionName");
            session.removeAttribute("user.input.phase");
            session.removeAttribute("cli.interactive.spec");
            session.removeAttribute("cli.interactive.pcl");
            throw new UnauthorizedException("error.authorization.notEnoughPrivilegies");
        }
    }

    protected static CoreManagedObjectInterface findObject(String name, ManagerInterface mgr) throws SEItemNotFoundException, ConfigMgmtException {
        CoreManagedObjectInterface obj = null;
        SearchFilter sf = new SearchFilter("name", name);
        List allObjects = mgr.getItemList();
        for (int i = 0; i < allObjects.size(); ++i) {
            obj = (CoreManagedObjectInterface)allObjects.get(i);
            if (!name.equals(obj.getName())) continue;
            return obj;
        }
        throw new SEItemNotFoundException(name);
    }

    protected CoreManagedObjectInterface findObject(String name, ManagerInterface mgr, Scope s) throws SEItemNotFoundException, ConfigMgmtException, UnauthorizedException {
        CoreManagedObjectInterface obj = null;
        SearchFilter sf = new SearchFilter("name", name);
        mgr.init(this.getConfigContext(this.sOAPContext), s, sf);
        List allObjects = mgr.getItemList();
        for (int i = 0; i < allObjects.size(); ++i) {
            obj = (CoreManagedObjectInterface)allObjects.get(i);
            if (!name.equals(obj.getName())) continue;
            return obj;
        }
        throw new SEItemNotFoundException(name);
    }
}

