/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.core;

import com.sun.netstorage.array.mgmt.cfg.cli.core.CommandProcessorBase;
import com.sun.netstorage.array.mgmt.cfg.cli.server.CommandResult;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ErrorBean;
import com.sun.netstorage.array.mgmt.cfg.cli.server.ParsedCommandLine;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.ManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.UnauthorizedException;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageArraysFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageArraysInterface;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.MenuData;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.soap.rpc.SOAPContext;

public abstract class ArrayProcessor
extends CommandProcessorBase {
    protected ManageArraysInterface _mai = null;
    protected static final int NAME_TYPE_WWN = 0;
    protected static final int NAME_TYPE_NAME = 1;
    protected int _nameType = 1;
    protected boolean _modifyPassword = false;

    protected ManagerInterface getManager() {
        return this._mai;
    }

    protected void initializeManager(SOAPContext argCtx) throws UnauthorizedException, ConfigMgmtException, SEItemNotFoundException {
        this._mai = this._scope != null ? ManageArraysFactory.getManager((ConfigContext)this.getConfigContext(argCtx), (Scope)this._scope, null) : ManageArraysFactory.getManager((ConfigContext)this.getConfigContext(argCtx));
    }

    protected CommandResult doModify(Locale locale, ParsedCommandLine pcl, SOAPContext argCtx) throws UnauthorizedException, ConfigMgmtException, SEItemNotFoundException, Exception {
        String METHOD_NAME = "doModify";
        Trace.methodBegin((Object)this, (String)"doModify");
        this.checkModifyPermission(argCtx);
        this.setScope(pcl);
        this.initializeManager(argCtx);
        Properties props = this.getModifyProperties(pcl);
        CommandResult result = null;
        if (!this._modifyPassword) {
            result = new CommandResult();
            List errors = this.modify(pcl.getResource().getFirstValue(), props);
            this.processResults(locale, result, errors);
        } else {
            result = this.modifyPassword(pcl, props);
        }
        return result;
    }

    protected CommandResult doImport(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws ConfigMgmtException, SEItemNotFoundException, UnauthorizedException {
        String METHOD_NAME = "doImport";
        Trace.methodBegin((Object)this, (String)"doImport");
        CommandResult result = new CommandResult();
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        this.setScope(pcl);
        this.initializeManager(argContext);
        MethodCallStatus mcs = this.importArray(pcl);
        ArrayList<ErrorBean> errors = new ArrayList<ErrorBean>();
        List eds = mcs.getErrorDescList();
        if (null != eds && 0 != eds.size()) {
            for (int i = 0; i < eds.size(); ++i) {
                ErrorDescriptor ed = (ErrorDescriptor)eds.get(i);
                if (ed.getErrorCode() == ErrorDescriptor.ERROR_SUCCESS) continue;
                String theObject = null;
                String[] params = ed.getI18nParams();
                theObject = params != null && params.length > 0 && params[0] != null ? params[0] : this._arrayName;
                Trace.verbose((Object)this, (String)"doImport", (String)ed.getMsg());
                errors.add(new ErrorBean(theObject + ": ", ed.getI18nkey()));
            }
        }
        this.processResults(locale, result, errors);
        return result;
    }

    protected CommandResult doExport(Locale locale, ParsedCommandLine pcl, SOAPContext argContext) throws ConfigMgmtException, SEItemNotFoundException, UnauthorizedException {
        String METHOD_NAME = "doExport";
        Trace.methodBegin((Object)this, (String)"doExport");
        this.checkIfReadOnly(argContext, MenuData.STORAGE_MGMT_MENU);
        this.setScope(pcl);
        this.initializeManager(argContext);
        CommandResult result = this.exportArray();
        Trace.verbose((Object)this, (String)"doExport", (String)"done");
        return result;
    }

    protected abstract MethodCallStatus importArray(ParsedCommandLine var1) throws ConfigMgmtException;

    protected abstract CommandResult exportArray() throws ConfigMgmtException;

    protected abstract CommandResult modifyPassword(ParsedCommandLine var1, Properties var2) throws ConfigMgmtException, SEItemNotFoundException, UnauthorizedException;
}

