/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.cli.core;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class AgentCommand {
    public static final String GET = "GET";
    public static final String PUT = "PUT";
    public static final String POST = "POST";
    public static final String FORMAT_XML = "xml";
    public static final String FORMAT_TAB = "tab";
    public static final int DEFAULT_TIMEOUT = 60;
    private String commandName;
    private Properties props = new Properties();

    public AgentCommand(String commandName) {
        this.commandName = commandName;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getCommandData() {
        StringBuffer sb = new StringBuffer(this.getCommandName());
        AgentCommand.addProps(this.props, sb);
        return sb.toString();
    }

    public String getType() {
        return GET;
    }

    public void setFormat(String format) {
        this.setProperty("format", format);
    }

    public int getTimeout() {
        return 60;
    }

    public void setProperty(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            return;
        }
        this.props.setProperty(name, value);
    }

    public void addProperties(Properties p) {
        TreeMap<Object, Object> t = new TreeMap<Object, Object>(p);
        Set<Map.Entry<Object, Object>> s = t.entrySet();
        Iterator<Map.Entry<Object, Object>> iter = s.iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            this.setProperty(key, value);
        }
    }

    protected static void addProps(Properties p, StringBuffer sb) {
        if (p == null) {
            return;
        }
        TreeMap<Object, Object> t = new TreeMap<Object, Object>(p);
        Set<Map.Entry<Object, Object>> s = t.entrySet();
        Iterator<Map.Entry<Object, Object>> iter = s.iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            try {
                value = URLEncoder.encode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
            sb.append("&");
            sb.append(key);
            sb.append("=");
            sb.append(value);
        }
    }
}

